; $Id$
;###############################################################################
;
; NAME:
;  REF_BACKGROUND
;
; PURPOSE:
;  Implementation of a sloping line background function for use in fitting
;  data in RAINS.
;
; CATEGORY:
;  DAVE, Data Analysis, RAINS, surface fitting
;
; AUTHOR:
;   Robert M. Dimeo, Ph.D.
;   NIST Center for Neutron Research
;   100 Bureau Drive
;   Gaithersburg, MD 20899
;   Phone: (301) 975-8135
;   E-mail: robert.dimeo@nist.gov
;   http://www.ncnr.nist.gov/staff/dimeo
;
; LICENSE:
;  The software in this file is written by an employee of
;  National Institute of Standards and Technology
;  as part of the DAVE software project.
;
;  The DAVE software package is not subject to copyright protection
;  and is in the public domain. It should be considered as an
;  experimental neutron scattering data reduction, visualization, and
;  analysis system. As such, the authors assume no responsibility
;  whatsoever for its use, and make no guarantees, expressed or
;  implied, about its quality, reliability, or any other
;  characteristic. The use of certain trade names or commercial
;  products does not imply any endorsement of a particular product,
;  nor does it imply that the named product is necessarily the best
;  product for the stated purpose. We would appreciate acknowledgment
;  if the DAVE software is used of if the code in this file is
;  included in another product.
;
;###############################################################################
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
function ref_background,xvals,parms,							$
                    	parmnames = parmnames,					$
                    	single_parmnames = single_parmnames,	$
                    	multi_parmnames = multi_parmnames,		$
                    	qty = qty,								$
                    	init_guess = init_guess,				$
                    	step = step,							$
                    	all_y = all_y,							$
                    	res_ptr = res_ptr,						$
                    	_Extra = extra
; all_y = 1: 3 parameters define the background for all of the ny y-values
; all_y = 0: 3*ny parameters define the background for all of the ny y-values
if n_elements(all_y) eq 0 then all_y = 1	; default is to have only
											; three parameters define the
											; gaussian for all of the y-values
if (n_params() eq 0) or (n_params() eq 1) then begin
  case all_y of
  0:	begin
  			offsetstr = 'offset:'+strtrim(string(indgen(extra.ny)),2)
  			slopestr = 'slope:'+strtrim(string(indgen(extra.ny)),2)
  			parmnames = [offsetstr,slopestr]
  			single_parmnames = ''
  			multi_parmnames = ['offset:','slope:']
 		end
  1:	begin
  			parmnames = ['offset','slope']
  			single_parmnames = parmnames
  			multi_parmnames = ''
  		end
  else:
  endcase
	if arg_present(init_guess) then begin
		bg = min(qty,dim = 1)
		if all_y eq 0 then begin
			init_guess = [bg,dblarr(extra.ny)]
		endif else begin
			init_guess = [(moment(bg))[0],0.]
		endelse
	endif
	if arg_present(step) then begin
		if all_y eq 0 then step = dblarr(2*extra.ny) else step = [0D,0D]
	endif
  return,-1
endif

nx = extra.nx & ny = extra.ny
x = xvals[0:nx-1] & y = xvals[nx:nx+ny-1]
ux = 1+bytarr(nx) & uy = 1+bytarr(ny)
if all_y eq 1 then begin
	offset = (parms[0])#uy
	slope = (parms[1])#uy
endif else begin
	offset = parms[0:ny-1]
	slope = parms[ny:2*ny-1]
endelse

yout = ux#offset+x#slope

return,yout
end