;$Id$
; Written by J.R.D. Copley.
;###############################################################################
; LICENSE:
;  The software in this file is written by an employee of 
;  National Institute of Standards and Technology 
;  as part of the DAVE software project.
;
;  The DAVE software package is not subject to copyright protection
;  and is in the public domain. It should be considered as an
;  experimental neutron scattering data reduction, visualization, and
;  analysis system. As such, the authors assume no responsibility
;  whatsoever for its use, and make no guarantees, expressed or
;  implied, about its quality, reliability, or any other
;  characteristic. The use of certain trade names or commercial
;  products does not imply any endorsement of a particular product,
;  nor does it imply that the named product is necessarily the best
;  product for the stated purpose. We would appreciate acknowledgment
;  if the DAVE software is used or if the code in this file is
;  included in another product.
;
;###############################################################################
;************************************************************************************************
pro quicklook6_cleanup,tlb
;************************************************************************************************
;
compile_opt strictarr
;
widget_control,tlb,get_uvalue=pState
ptr_free,pState
end


;************************************************************************************************
pro quicklook6_quit,event
;************************************************************************************************
;
compile_opt strictarr
;
widget_control,event.top,/destroy
end


;************************************************************************************************
pro quicklook6_makewidget,path,instrument,infilenames,nfiles,nlines,nlabels,fileinfo,$
	labels,files,butt,searchstring=searchstring,searchitem=searchitem,$
	getnext=getnext,restricted=restricted,satisfied_indices=satisfied_indices,$
	showfiles=showfiles,$
;	choice,schoice,$
	tlb,$
	group_leader = group_leader,$
;	notify_ids = notify_ids,$
	register_name = register_name
;************************************************************************************************
;
compile_opt strictarr

; Basic error Handler
if (n_elements(!debug) && (!debug eq 0)) then begin
    catch, catchError
    if (catchError ne 0) then begin
        ;;print, 'Error handled!'
        eTitle = 'quicklook6_makewidget: Error encountered'
        eMsg = 'An error or unusual condition was encountered!'
        eMsg = [eMsg,'Please, report the following to the DAVE team:']
        eMsg = [eMsg,!error_state.msg]
;    eMsg = [eMsg,'Function/module name: calledfunc()',!error_state.msg]
        void = dialog_message(/error,eMsg,title=eTitle,dialog_parent=group_leader)
        catch, /cancel
        widget_control,tlbmessage,/destroy
        return
    endif
endif
;
;
extra=''
;
if (restricted lt 0) then begin
;
; Navigate to starting directory, either ...summaryfiles or ...summaryfiles/dcs (or hfbs...)
	;cwd=sourceroot()
        ;if (stregex(path,/boolean,'^[A-Z a-z]*$')) then path=cwd+"summaryfiles"+!delimiter+path
	if (stregex(path,/boolean,'^[A-Z a-z]*$')) then path=!DAVE_SUMMARYFILES_DIR+path
;
	case getnext of
;
;	Use summary file(s) associated with chosen directory(ies).
		0: begin
;			path="C:\DAVE_CVS\DAVE\PROGRAMS\summaryfiles\DCS\"
			infilenames=dialog_pickfile(title="Please select one or more summary files",$
				path=path,filter="*filesummary*",get_path=path,/multiple)
		end
;
; Use summary file associated with previous directory.
		-1: begin
			filenames=file_search(path,"*filesummary*")
			indices=where(filenames lt infilenames[0],count)
			if (count gt 0) then begin
				filenames=filenames[indices]
				filenames=filenames[sort(filenames)]
				infilenames=filenames[count-1]
			endif else begin
				res=dialog_message(["This is the first file.","Click on the ''Quit'' button to exit"],/information)
			endelse
		end
;
; Use summary file associated with following directory.
		1: begin
			filenames=file_search(path,"*filesummary*")
			indices=where(filenames gt infilenames[0],count)
			if (count gt 0) then begin
				filenames=filenames[indices]
				filenames=filenames[sort(filenames)]
				infilenames=filenames[0]
			endif else begin
				res=dialog_message(["This is the last file.","Click on the ''Quit'' button to exit"],/information)
			endelse
		end
;
;	Revert to previous selection of summary file(s) associated with chosen directory(ies).
		2:
;
		else:
	endcase
;
;	Having chosen the summary file(s), open it or them and store the contents.
	if (infilenames[0] eq "") then return
	infilenames=infilenames[sort(infilenames)]
	ninfilenames=n_elements(infilenames)
;
	directory=strmid(infilenames[0],strpos(infilenames[0],'200'),6)
;
	tlbmessage=widget_base(title=" ",/base_align_center,/col)
	void=widget_label(tlbmessage,value="Please wait while file",font="TimesRoman*24")
	void=widget_label(tlbmessage,value="information is loaded.",font="TimesRoman*24")
	void=widget_label(tlbmessage,value="Loading directory "+directory,font="TimesRoman*24")
	centertlb,tlbmessage
	widget_control,tlbmessage,/realize
;
; Restore instrument,labels,shortform_files,fileinfo from first file.
	restore,infilenames[0]
;
; Number of items.
	nlabels=n_elements(labels)
;
	if (ninfilenames eq 1) then begin
;
;	Case of a single summary file.
		directories=' directory '+directory
	endif else begin
;
;	More than one summary file.
		sff=shortform_files
		finfo_old=fileinfo
		directories=' directories '+directory
		for k=1,ninfilenames-1 do begin
			directory=strmid(infilenames[k],strpos(infilenames[k],'200'),6)
			widget_control,void,set_value="Loading directory "+directory
			restore,infilenames[k]
			sff=[sff,shortform_files]
			finfo_new=create_struct(labels[0],[finfo_old.(0),fileinfo.(0)])
			for m=1,nlabels-1 do begin
				finfo_new=create_struct(finfo_new,labels[m],[finfo_old.(m),fileinfo.(m)])
			endfor
			finfo_old=finfo_new
			directories=directories+", "+directory
		endfor
		shortform_files=sff
		fileinfo=finfo_new
	endelse
	showfiles=intarr(n_elements(shortform_files))+1
;
	widget_control,tlbmessage,/destroy
;
endif else begin
;
;	This code is executed when a restricted range or restricted set of files was chosen.
; Restricted range.
	if (restricted eq 0) then begin
		maxindex=max(satisfied_indices)
		minindex=min(satisfied_indices)
		range=minindex+indgen(maxindex-minindex+1)
		directories=' restricted range '
		extra='  ('+strcompress(string(n_elements(satisfied_indices)),/remove_all)+' satisfy search)'
	endif
	;
	; Restricted files.
	if (restricted eq 1) then begin
		range=satisfied_indices
		directories=' restricted files '
	endif
;
;
	shortform_files=files[range]
	finfo_new=create_struct(labels[0],[fileinfo.(0)[range]])
	nlabels=n_elements(labels)
	for m=1,nlabels-1 do begin
		finfo_new=create_struct(finfo_new,labels[m],[fileinfo.(m)[range]])
	endfor
	fileinfo=finfo_new
	showfiles=showfiles[range]
;	widget_control,tlbmessage,/destroy
endelse
;
; Maximum number of lines in information display box.
; This is 1 more than the maximum number of displayable items.
nlines=nlabels+1;
files=shortform_files
nfiles=n_elements(files)
butt=lonarr(nfiles)
;
; Start to generate the widget.
tlbtit='Summary of '+instrument+directories+"  ("+$
	strcompress(string(nfiles),/remove_all)+" files)"
tlb=widget_base(/row,title=tlbtit+extra,group_leader=group_leader); (",/tlb_frame_attr" removed)
	column=widget_base(tlb,/col,/frame)
		infobase=widget_base(column,/row)
			firstbase=widget_base(infobase,/col)
				sumbase=widget_base(firstbase,/col,/frame)
					dirbase=widget_base(sumbase,/row)
						select=widget_button(dirbase,value="Open new summary file(s)",$
							tooltip="Click to open one or more summary files")
						revert=widget_button(dirbase,value="Revert",$
							tooltip="Revert to the previous selection of summary files")
					selbase=widget_base(sumbase,/row)
						selprv=widget_button(selbase,value="Prev. summary",$
							tooltip="Click to open the chronologically previous summary file")
						selnex=widget_button(selbase,value="Next summary",$
							tooltip="Click to open the chronologically following summary file")
				resbase=widget_base(firstbase,/row,/align_center)
					rngbase=widget_base(resbase,/col)
						rngbeg=widget_combobox(rngbase,value=files);strmid(files,2))
						rngend=widget_combobox(rngbase,value=files);strmid(files,2))
					butbase=widget_base(resbase,/col)
						rnguse=widget_button(butbase,value="Restrict range",$
							tooltip="Click to restrict the displayed files to those within the specified range")
						filuse=widget_button(butbase,value="Restrict files",$
							tooltip="Click to restrict the displayed files to those that are highlighted")
			  srchbase=widget_base(firstbase,/col,/frame)
					void=widget_label(srchbase,value='1st search item and string')
					srchitem=widget_combobox(srchbase,value=labels)
					srchtext=widget_text(srchbase,/editable,/all_events,value=searchstring[0])
					void=widget_label(srchbase,value='2nd search item and string')
					srchitem2=widget_combobox(srchbase,value=labels)
					srchtext2=widget_text(srchbase,/editable,/all_events,value=searchstring[1])
					srchctrl=widget_base(srchbase,/row,/align_center)
						srchmode=widget_button(srchctrl,value="AND/OR",$
							tooltip="Click to toggle between searching ''AND'' and searching ''OR''")
						search=widget_button(srchctrl,value="Search AND",$
							tooltip="Click to perform the search")
						clearsearch=widget_button(srchctrl,value="Reset",$
							tooltip="Click to reset the search parameters")
			  done=widget_button(firstbase,value='Quit',/frame); NB this line changed
			labeling=widget_text(infobase,xsize=max(strlen(labels)>strlen("File name")),$
				ysize=(1+nlabels)<nlines)
			info=widget_text(infobase,xsize=1000,ysize=(1+nlabels)<nlines)
;
; Do some geometry calculations in order to set the widths of items in the top left section (infobase).
geom1=widget_info(srchctrl,/geometry)
geom2=widget_info(srchitem,/geometry)
geom3=widget_info(srchtext,/geometry)
maxxsize=1.0*(geom1.xsize>geom2.xsize>geom3.xsize)
widget_control,srchitem,xsize=maxxsize
widget_control,srchtext,scr_xsize=maxxsize
widget_control,srchitem2,xsize=maxxsize
widget_control,srchtext2,scr_xsize=maxxsize
widget_control,selprv,scr_xsize=maxxsize/2
widget_control,selnex,scr_xsize=maxxsize/2
;
; Set the width of the infobase.
xysize=get_screen_size()
widget_control,infobase,scr_xsize=xysize[0]*0.9
;
; Now start working on the lower half of the tlb, the "filebase".
; First create a non-scrollable filebase, and then ...
		filebase=widget_base(column,/row,/frame,/context_events)
;
; generate a temporary base and some labels in order to determine the number of pixels in
; the y direction, per label. Having got the answer, destroy the temporary base and proceed.
; Don't bother if the total number of files is very small.
			geom3=widget_info(infobase,/geometry)
			if (nfiles lt 12) then begin
				number=nfiles
			endif else begin
				tempbase=widget_base(filebase,/col)
				for k=0,11 do begin
					butt[k]=widget_label(tempbase,value=files[k],/tracking_events)
					if (k eq 1) then geom1a=widget_info(tempbase,/geometry)
					if (k eq 11) then begin
						geom1b=widget_info(tempbase,/geometry)
						dysize=0.1*(geom1b.ysize-geom1a.ysize)
					endif
				endfor
				number=fix((xysize[1]*0.8-geom3.ysize)/dysize)
;
;	This statement added so y-scrolling is not necessary, even under Linux.
				number=number-1
				widget_control,tempbase,/destroy
			endelse
;
;	Also destroy the filebase and then ...
		widget_control,filebase,/destroy
;
;	make a new one that is scrollable and of the right size.
		geom2=widget_info(infobase,/geometry)
		filebase=widget_base(column,/row,/frame,/scroll,/context_events,$
			scr_xsize=xysize[0]*0.9,scr_ysize=xysize[1]*0.8-geom2.scr_ysize+xysize[1]*0.025)
;
; Create a label widget for each file.
			ncols=fix(nfiles/number)+1
			base=lonarr(ncols)
			for j=0,ncols-1 do begin
				base[j]=widget_base(filebase,/col,/context_events)
				ks=j*number
				ke=((j+1)*number-1) < (nfiles-1)
				for k=ks,ke do begin
					butt[k]=widget_label(base[j],value=files[k],/tracking_events,sensitive=showfiles[k])
				endfor
			endfor
;
; Set the width of the "info" text widget (not the "infobase" base).
geom1=widget_info(infobase,/geometry)
geom2=widget_info(firstbase,/geometry)
geom3=widget_info(labeling,/geometry)
widget_control,info,scr_xsize=geom1.scr_xsize-geom2.scr_xsize-geom3.scr_xsize-12
;
centertlb,tlb
geom=widget_info(tlb,/geometry)
widget_control,tlb,yoffset=0.25*geom.yoffset
;
widget_control,srchitem,set_combobox_select=searchitem[0]
widget_control,srchitem2,set_combobox_select=searchitem[1]
;
filebeg=0
fileend=nfiles-1
widget_control,rngbeg,set_combobox_select=filebeg
widget_control,rngend,set_combobox_select=fileend
;
widget_control,tlb,/realize
;
state={$
	group_leader:group_leader,$
	tlbtit:tlbtit,$
	path:path,$
	infilenames:infilenames,$
	instrument:instrument,$
	select:select,$
	revert:revert,$
	selprv:selprv,$
	selnex:selnex,$
	rngbeg:rngbeg,$
	rngend:rngend,$
	filebeg:filebeg,$
	fileend:fileend,$
	rnguse:rnguse,$
	filuse:filuse,$
	done:done,$
;	clearitems:clearitems,$
;	checkitems:checkitems,$
	labeling:labeling,$
	info:info,$
	nlabels:nlabels,$
;	choice:choice,$
;	schoice:schoice,$
;	chosen:chosen,$
	labels:labels,$
	fileinfo:fileinfo,$
	files:files,$
	nfiles:nfiles,$
	showfiles:showfiles,$
	sensitize:0,$
;	prefix:prefix,$
	butt:butt,$
	nlines:nlines,$
;	numdef:numdef,$
	column:column,$
	infobase:infobase,$
	filebase:filebase,$
	base:base,$
	srchtext:srchtext,$
	srchitem:srchitem,$
	searchstring:searchstring[0],$
	searchitemnumber:searchitem[0],$
	srchtext2:srchtext2,$
	srchitem2:srchitem2,$
	searchstring2:searchstring[1],$
	searchitemnumber2:searchitem[1],$
	srchmode:srchmode,$
	search:search,$
	clearsearch:clearsearch,$
;	notify_ids:notify_ids,  $              ; for non-modal widget
	register_name:register_name,$
	searchand:1}
;
pstate=ptr_new(state)
widget_control,tlb,set_uvalue=pstate
;
; added register_name variable to the call to xmanager.
xmanager,register_name,tlb,/no_block,cleanup='quicklook6_cleanup',$
	event_handler="quicklook6_handler"
;
end


;************************************************************************************************
pro quicklook6_handler,event
;************************************************************************************************
;
compile_opt strictarr
;
; Basic error Handler
if (n_elements(!debug) && (!debug eq 0)) then begin
    catch, catchError
    if (catchError ne 0) then begin
        ;;print, 'Error handled!'
        eTitle = 'quicklook6_handler: Error encountered'
        eMsg = 'An error or unusual condition was encountered!'
        eMsg = [eMsg,'Please, report the following to the DAVE team:']
        eMsg = [eMsg,!error_state.msg]
;    eMsg = [eMsg,'Function/module name: calledfunc()',!error_state.msg]
        void = dialog_message(/error,eMsg,title=eTitle,dialog_parent=event.top)
        catch, /cancel
        return
    endif
endif

widget_control,event.top,get_uvalue=pState
;
; Handle the "Quit" button.
if (event.id eq (*pstate).done) then begin
	quicklook6_quit,event
	return
endif
;
; Handle the "New file or files" button.
if (event.id eq (*pstate).select) then begin
	path=(*pState).path
	group_leader=(*pState).group_leader
	infilenames=(*pState).infilenames
	; 2 following lines added (several places)
;	notify_ids=(*pState).notify_ids
	register_name=(*pState).register_name
	quicklook6_quit,event
	quicklook6_makewidget,path,instrument,infilenames,nfiles,nlines,nlabels,fileinfo,$
		labels,files,butt,searchstring=strarr(2),searchitem=[0,1],getnext=0,restricted=-1,$
		tlb,$
		group_leader=group_leader,$
;		notify_ids=notify_ids,$
		register_name=register_name
	;
	; Following line added (several places)
	if (not widget_info(tlb,/valid_id)) then return
	widget_control,tlb,get_uvalue=pState
	(*pState).infilenames=infilenames
	widget_control,tlb,set_uvalue=pState
	ninfilenames=n_elements(infilenames)
	if (ninfilenames eq 1) then begin
		widget_control,(*pState).selprv,sensitive=1
		widget_control,(*pState).selnex,sensitive=1
	endif else begin
		widget_control,(*pState).selprv,sensitive=0
		widget_control,(*pState).selnex,sensitive=0
	endelse
	return
endif
;
; Handle the "Revert" button.
if (event.id eq (*pstate).revert) then begin
	path=(*pState).path
	group_leader=(*pState).group_leader
	infilenames=(*pState).infilenames
;	notify_ids=(*pState).notify_ids
	register_name=(*pState).register_name
	quicklook6_quit,event
	quicklook6_makewidget,path,instrument,infilenames,nfiles,nlines,nlabels,fileinfo,$
		labels,files,butt,searchstring=strarr(2),searchitem=[0,1],getnext=2,restricted=-1,$
		tlb,$
		group_leader=group_leader,$
;		notify_ids=notify_ids,$
		register_name=register_name
;
	if (not widget_info(tlb,/valid_id)) then return
	widget_control,tlb,get_uvalue=pState
	(*pState).infilenames=infilenames
	widget_control,tlb,set_uvalue=pState
	ninfilenames=n_elements(infilenames)
	if (ninfilenames eq 1) then begin
		widget_control,(*pState).selprv,sensitive=1
		widget_control,(*pState).selnex,sensitive=1
	endif else begin
		widget_control,(*pState).selprv,sensitive=0
		widget_control,(*pState).selnex,sensitive=0
	endelse
	return
endif
;
; Handle the "Prev file" button.
if (event.id eq (*pstate).selprv) then begin
	path=(*pState).path
	group_leader=(*pState).group_leader
	infilenames=(*pState).infilenames
	searchstring=[(*pState).searchstring,(*pState).searchstring2]
	searchitem=[(*pState).searchitemnumber,(*pState).searchitemnumber2]
;	notify_ids=(*pState).notify_ids
	register_name=(*pState).register_name
	quicklook6_quit,event
	quicklook6_makewidget,path,instrument,infilenames,nfiles,nlines,nlabels,fileinfo,$
		labels,files,butt,searchstring=searchstring,searchitem=searchitem,getnext=-1,restricted=-1,$
		tlb,$
		group_leader=group_leader,$
;		notify_ids=notify_ids,$
		register_name=register_name
;
	if (not widget_info(tlb,/valid_id)) then return
	if (n_elements(tlb) eq 1) then begin
		widget_control,tlb,get_uvalue=pState
		(*pState).infilenames=infilenames
		widget_control,tlb,set_uvalue=pState
	endif
	return
endif
;
; Handle the "Next file" button.
if (event.id eq (*pstate).selnex) then begin
	path=(*pState).path
	group_leader=(*pState).group_leader
	infilenames=(*pState).infilenames
	searchstring=[(*pState).searchstring,(*pState).searchstring2]
	searchitem=[(*pState).searchitemnumber,(*pState).searchitemnumber2]
;	notify_ids=(*pState).notify_ids
	register_name=(*pState).register_name
	quicklook6_quit,event
	quicklook6_makewidget,path,instrument,infilenames,nfiles,nlines,nlabels,fileinfo,$
		labels,files,butt,searchstring=searchstring,searchitem=searchitem,getnext=1,restricted=-1,$
		tlb,$
		group_leader=group_leader,$
;		notify_ids=notify_ids,$
		register_name=register_name
;
	if (not widget_info(tlb,/valid_id)) then return
	if (n_elements(tlb) eq 1) then begin
		widget_control,tlb,get_uvalue=pState
		(*pState).infilenames=infilenames
		widget_control,tlb,set_uvalue=pState
	endif
	return
endif
;
; Handle the droplists that define the range.
if (event.id eq (*pstate).rngbeg) then begin
	(*pState).filebeg=event.index
endif
;
if (event.id eq (*pstate).rngend) then begin
	(*pState).fileend=event.index
endif
;
; Handle the "Restrict files" and "Restrict range" buttons.
restricted=-1
if (event.id eq (*pstate).rnguse) then restricted=0
if (event.id eq (*pstate).filuse) then restricted=1
if (restricted ge 0) then begin
	indices=(*pState).filebeg+indgen((*pState).fileend-(*pState).filebeg+1)
	satisfied=where((*pState).showfiles[indices] eq 1,count)
	if (count gt 0) then begin
		satisfied_indices=indices[satisfied]
		path=(*pState).path
		group_leader=(*pState).group_leader
		instrument=(*pState).instrument
		infilenames=(*pState).infilenames
		searchstring=[(*pState).searchstring,(*pState).searchstring2]
		searchitem=[(*pState).searchitemnumber,(*pState).searchitemnumber2]
		labels=(*pState).labels
		fileinfo=(*pState).fileinfo
		files=(*pState).files
		showfiles=(*pState).showfiles
;		notify_ids=(*pState).notify_ids
		register_name=(*pState).register_name
		quicklook6_quit,event
		quicklook6_makewidget,path,instrument,infilenames,nfiles,nlines,nlabels,fileinfo,$
			labels,files,butt,searchstring=searchstring,searchitem=searchitem,getnext=-1,$
			restricted=restricted,satisfied_indices=satisfied_indices,showfiles=showfiles,$
		tlb,$
		group_leader=group_leader,$
;		notify_ids=notify_ids,$
		register_name=register_name
;
		if (not widget_info(tlb,/valid_id)) then return
		if (widget_info(tlb,/valid_id)) then begin
			widget_control,tlb,get_uvalue=pState
			(*pState).infilenames=infilenames
			widget_control,tlb,set_uvalue=pState
		endif
		return
	endif
endif
;
; Handle the droplists that define search items.
if (event.id eq (*pState).srchitem) then begin
	(*pState).searchitemnumber=event.index
endif
;
if (event.id eq (*pState).srchitem2) then begin
	(*pState).searchitemnumber2=event.index
endif
;
; Handle the text widgets where the search strings are inserted.
; Hitting carriage return implies that a search is to be performed.
dosearch=0
if (event.id eq (*pState).srchtext) then begin
	widget_control,(*pState).srchtext,get_value=temp
	(*pState).searchstring='*'+temp+'*'
		if (event.type eq 0) then if (event.ch eq 10b) then dosearch=1
endif
;
if (event.id eq (*pState).srchtext2) then begin
	widget_control,(*pState).srchtext2,get_value=temp
	(*pState).searchstring2='*'+temp+'*'
		if (event.type eq 0) then if (event.ch eq 10b) then dosearch=1
endif
;
; Toggle between the two search modes.
if (event.id eq (*pState).srchmode) then begin
	(*pState).searchand=1-(*pState).searchand
	if ((*pState).searchand) then label="Search AND" else label="Search OR"
	widget_control,(*pState).search,set_value=label
endif
;
; Do the search and sensitize the file names that satisfy the search.
if (dosearch or event.id eq (*pstate).search) then begin
; Handle the AND search mode
	if ((*pState).searchand) then begin
		if ((*pState).searchstring ne '') then begin
			res=strmatch((*pState).fileinfo.((*pState).searchitemnumber),(*pState).searchstring,/fold_case)
		endif else res=bytarr((*pState).nfiles)+1
		if ((*pState).searchstring2 ne '') then begin
			res2=strmatch((*pState).fileinfo.((*pState).searchitemnumber2),(*pState).searchstring2,/fold_case)
		endif else res2=bytarr((*pState).nfiles)+1
		nindices=where(res ne 0 and res2 ne 0,count)
	endif else begin
; Handle the OR search mode.
		if ((*pState).searchstring ne '') then begin
			res=strmatch((*pState).fileinfo.((*pState).searchitemnumber),(*pState).searchstring,/fold_case)
		endif else res=bytarr((*pState).nfiles)
		if ((*pState).searchstring2 ne '') then begin
			res2=strmatch((*pState).fileinfo.((*pState).searchitemnumber2),(*pState).searchstring2,/fold_case)
		endif else res2=bytarr((*pState).nfiles)
		nindices=where(res ne 0 or res2 ne 0,count)
	endelse
; Set the new file label sensitivities.
	widget_control,(*pState).filebase,map=0
	for k=0,(*pState).nfiles-1 do widget_control,(*pState).butt[k],sensitive=0
	(*pState).showfiles=bytarr((*pState).nfiles)
	if (count gt 0) then begin
		offbutt=(*pState).butt[nindices]
		for k=0,n_elements(offbutt)-1 do widget_control,offbutt[k],sensitive=1
		(*pState).showfiles[nindices]=1
	endif
	widget_control,(*pState).filebase,map=1
	if (count gt 0) then begin
		(*pState).filebeg=nindices[0]
		(*pState).fileend=nindices[n_elements(nindices)-1]
		widget_control,(*pState).rngbeg,set_combobox_select=(*pState).filebeg
		widget_control,(*pState).rngend,set_combobox_select=(*pState).fileend
	endif
	extra='  ('+strcompress(string(count),/remove_all)+' satisfy search)'
	widget_control,event.top,base_set_title=(*pState).tlbtit+extra
endif
;
if (tag_names(event,/structure_name) eq 'WIDGET_CONTEXT') then begin
	(*pState).sensitize=1-(*pState).sensitize
	if ((*pState).sensitize) then begin
		for k=0,(*pState).nfiles-1 do widget_control,(*pState).butt[k],/sensitive
	endif else begin
		indices=where((*pState).showfiles eq 0)
		if (indices[0] ge 0) then begin
			offbutt=(*pState).butt[indices]
			for k=0,n_elements(offbutt)-1 do widget_control,offbutt[k],sensitive=0
		endif
	endelse
endif
;
; Handle the "Clear search" button.
if (event.id eq (*pstate).clearsearch) then begin
	for k=0,(*pState).nfiles-1 do widget_control,(*pState).butt[k],/sensitive
	(*pState).showfiles=bytarr((*pState).nfiles)+1
	widget_control,(*pState).srchtext,set_value=''
	widget_control,(*pState).srchtext2,set_value=''
	widget_control,(*pState).rngbeg,set_combobox_select=0
	widget_control,(*pState).rngend,set_combobox_select=(*pState).nfiles-1
	widget_control,event.top,base_set_title=(*pState).tlbtit
endif
;
nlabels=(*pState).nlabels
;
; Display item labels.
info=' File name'
for m=0,nlabels-1 do info=[info,' '+strcompress((*pState).labels[m])]
widget_control,(*pState).labeling,set_value=info
;
; Display item information for the file label where the cursor is placed.
if (tag_names(event,/structure_name) eq 'WIDGET_TRACKING') then begin
	if (event.enter eq 0) then begin
		widget_control,(*pState).info,set_value=''
	endif else begin
		for k=0,(*pState).nfiles-1 do begin
			if (event.id eq (*pstate).butt[k]) then begin
				info=' '+(*pState).files[k]+'.dcs.gz'
				for m=0,nlabels-1 do info=[info,strcompress(string((*pState).fileinfo.(m)[k]))]
				widget_control,(*pState).info,set_value=info
			endif
		endfor
	endelse
endif
;
widget_control,event.top,set_uvalue=pState
;
end



;************************************************************************************************
pro quicklook6,path,$
	group_leader = group_leader,$
	register_name = register_name, $
	_EXTRA=etc
;************************************************************************************************
;
compile_opt strictarr
;
;
;;;;;;;added following 4 lines for non-modal widget action
if n_elements(group_leader) eq 0 then group_leader = 0L
;if n_elements(notify_ids) eq 0 then notify_ids = [0L,0L]
if n_elements(register_name) eq 0 then register_name = 'quicklook6'
if xregistered(register_name) then return
;
;
defsysv,'!operating_system',!VERSION.OS_FAMILY,1
defsysv,'!windows',(!operating_system eq "Windows"),1
defsysv,'!unix',(!operating_system eq "unix"),1
defsysv,'!macos',(!operating_system eq "MacOS"),1
if (!windows) then defsysv,'!delimiter',"\"
if (!unix) then defsysv,'!delimiter',"/"
if (!macos) then defsysv,'!delimiter',":"
;
path = ''
;
quicklook6_makewidget,path,searchstring=strarr(2),searchitem=[0,1],getnext=0,$
	restricted=-1,$
	group_leader=group_leader,$
;	notify_ids=notify_ids,$
	register_name=register_name
;
end
