; $Id$
;###############################################################################
;
; NAME:
;  PAN_KWW
;
; PURPOSE:
;  Stretched exponential decay for use in fitting data in PAN.
;
; CATEGORY:
;  DAVE, Data Analysis, PAN
;
; AUTHOR:
;   Robert M. Dimeo, Ph.D.
;   NIST Center for Neutron Research
;   100 Bureau Drive
;   Gaithersburg, MD 20899
;   Phone: (301) 975-8135
;   E-mail: robert.dimeo@nist.gov
;   http://www.ncnr.nist.gov/staff/dimeo
;
; LICENSE:
;  The software in this file is written by an employee of
;  National Institute of Standards and Technology
;  as part of the DAVE software project.
;
;  The DAVE software package is not subject to copyright protection
;  and is in the public domain. It should be considered as an
;  experimental neutron scattering data reduction, visualization, and
;  analysis system. As such, the authors assume no responsibility
;  whatsoever for its use, and make no guarantees, expressed or
;  implied, about its quality, reliability, or any other
;  characteristic. The use of certain trade names or commercial
;  products does not imply any endorsement of a particular product,
;  nor does it imply that the named product is necessarily the best
;  product for the stated purpose. We would appreciate acknowledgment
;  if the DAVE software is used or if the code in this file is
;  included in another product.
;
;###############################################################################
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
function pan_kww,  x,parms,$
                    	parmnames = parmnames, $
                    	canDraw = canDraw, $
                    	drawMessage = drawMessage, $
                    	func_dataHash=func_dataHash,twoDimFlag=twoDimFlag, $
                    	changesecond=changesecond, changefirst=changefirst, xMouseClick=xMouseClick, yMouseClick=yMouseClick, xrange=xrange, $
                    	_Extra = extra

canDraw = 1
twoDimFlag = 0
if n_params() eq 0 then begin
  parmnames = ['amplitude','decay constant','stretching exponent']
  return,-1
endif
drawMessage = strarr(4)
drawMessage[0:1] = ['Hold left mouse button down','and drag function max value and decay constant']
drawMessage[2:3] = ['Hold left mouse button down','and drag to change the decay constant']

if (Keyword_set(changefirst)) then begin
  ; user is initializing the function graphically
  ; this block of code is executed when the mouse is first release at the location for the function centroid
  ; translate the position into suitable parameters.
  ;Print,'###Changefirst called within function...' 
  parms[2] = 0.8
  parms[0] = yMouseClick
  parms[1] = 0.1*(xrange[1] - xrange[0])
endif

if (Keyword_set(changesecond)) then begin
  ; user is initializing the function graphically
  ; this block of code is executed when the mouse is move to define the function width
  ; translate the position into suitable parameters.
  ;Print,'###Changesecond called within function...'
  A0 = parms[0]
  parms[1] = Abs(xMouseclick)/(Alog(A0) - Alog(yMouseclick))  ; solve for the decay constant, assuming the mouse click is on the decay curve
endif



amp = parms[0] & lambda = parms[1] & beta = parms[2]
yout = amp*exp(-((x/lambda)^beta))
neg = where(x lt 0.,count_zero)
if count_zero gt 0 then yout[neg] = 0.0

return,yout
end