; $Id$
;###############################################################################
;
; NAME:
;  pan_ft_kww_new
;
; PURPOSE:
;  PROVIDE A FUNCTION FOR QENS DATA, testing
;
; CATEGORY:
;  DAVE, Data Analysis, PAN, curve fitting
;
; AUTHOR:
;  Richard Tumanjong Azuah
;  NIST Center for Neutron Research
;  azuah@nist.gov; (301) 9755604
;  June 2016
;
; LICENSE:
;  The software in this file is written by an employee of
;  National Institute of Standards and Technology
;  as part of the DAVE software project.
;
;  The DAVE software package is not subject to copyright protection
;  and is in the public domain. It should be considered as an
;  experimental neutron scattering data reduction, visualization, and
;  analysis system. As such, the authors assume no responsibility
;  whatsoever for its use, and make no guarantees, expressed or
;  implied, about its quality, reliability, or any other
;  characteristic. The use of certain trade names or commercial
;  products does not imply any endorsement of a particular product,
;  nor does it imply that the named product is necessarily the best
;  product for the stated purpose. We would appreciate acknowledgment
;  if the DAVE software is used of if the code in this file is
;  included in another product.
;
;###############################################################################
function pan_ft_kww_new,x,parms, parmnames=parmnames, $
                 canDraw=canDraw, $
                 _Extra=extra

if n_params() eq 0 then begin
    parmnames = ['Area','x0','tau','beta']
    return,-1
endif
canDraw=0

hbar=0.6528
n = N_elements(x)
calc = fltarr(n)
for i=0,n-1 do begin
  etc = {omega:(x[i] - parms[1])/hbar,tau:parms[2],beta:parms[3]}
  calc[i] = parms[0]/!pi/hbar * Qpint1d('stretched_exp',0.0D,!values.d_infinity,functargs=etc,status=status,nfev=nfev)
endfor
if (n eq 1) then calc = calc[0]

return, calc

end

;
;; $Id$
;;###############################################################################
;;
;; NAME:
;;  pan_ft_kww_new
;;
;; PURPOSE:
;;  Defines the cosine of the stretched exponential function
;;
;; CATEGORY:
;;  DAVE, Data Analysis, PAN, curve fitting
;;
;; AUTHOR:
;  Richard Tumanjong Azuah
;  NIST Center for Neutron Research
;  azuah@nist.gov; (301) 9755604
;;
;;
;;###############################################################################
function stretched_exp, time, tau=tau, beta=beta, omega=omega
compile_opt idl2

; expect tau, beta, omega to be scaler
; time may be scaler or vector
nT = N_elements(time)
if (nT eq 0) then return, 0.0
if (n_elements(tau) eq 0 || n_elements(beta) eq 0 || n_elements(omega) eq 0 ) then return, omega*0.0

if (tau eq 0.0) then return, 0.0
index = where(time ge 0.0, nValid)
calc = time*0.0
if (nValid gt 0) then calc[index] = cos(omega*time[index])*exp(-(time/tau)^beta)

return, calc

end


;;###############################################################################
pro test_ft_kww_new, plot=plot, parms=parms
compile_opt idl2

if (n_elements(parms) ne 4) then parms = [1.0,0.0,1.0,0.5]
omega = (findgen(81) - 30) * 0.5
void = pan_ft_kww_new(parmnames=pnames)
tic
calc = pan_ft_kww_new(omega,parms)
toc
if (keyword_set(plot)) then begin
  title = ['$\int_0^{\inf}dt cos(\omega t)exp(-(t/\tau)^{\beta})$',strjoin(pnames,'; '),strjoin(string(parms,format='(F5.3)'),'; ')]
  p = plot(omega,calc,title=title,sym=0,linestyle=0)
endif
end
