; $Id$
;###############################################################################
;
; NAME:
;  PAN_FT_KWW
;
; PURPOSE:
;  PROVIDE A FUNCTION FOR QENS DATA, testing
;
; CATEGORY:
;  DAVE, Data Analysis, PAN, curve fitting
;
; AUTHOR:
;   Antonio Faraone, Ph.D.
;   NIST Center for Neutron Research
;   100 Bureau Drive
;   Gaithersburg, MD 20899
;   Phone: (301) 975-5254
;   E-mail: antonio.faraone@nist.gov
;
; LICENSE:
;  The software in this file is written by an employee of
;  National Institute of Standards and Technology
;  as part of the DAVE software project.
;
;  The DAVE software package is not subject to copyright protection
;  and is in the public domain. It should be considered as an
;  experimental neutron scattering data reduction, visualization, and
;  analysis system. As such, the authors assume no responsibility
;  whatsoever for its use, and make no guarantees, expressed or
;  implied, about its quality, reliability, or any other
;  characteristic. The use of certain trade names or commercial
;  products does not imply any endorsement of a particular product,
;  nor does it imply that the named product is necessarily the best
;  product for the stated purpose. We would appreciate acknowledgment
;  if the DAVE software is used of if the code in this file is
;  included in another product.
;
;###############################################################################
function pan_ft_kww,x,parms, parmnames=parmnames, $
                canDraw=canDraw, $
                func_dataHash=func_dataHash,twoDimFlag=twoDimFlag, $
                changesecond=changesecond, changefirst=changefirst, xMouseClick=xMouseClick, yMouseClick=yMouseClick, xrange=xrange, $
                _Extra = extra

canDraw = 0
twoDimFlag = 0

if n_params() eq 0 then begin
    parmnames = ['Area','x0','tau','beta']
    return,-1
endif
canDraw=0

npts = n_elements(x)

amp=parms[0]
x0=parms[1]
tau=parms[2]*1D
beta=parms[3]*1D
hbar=0.6582   ; hbar = 1.054572e-34 J.s = 6.58212e-16 eV.s | meV.ps | ueV.ns
i = dcomplex(0.0,1.0)

tauscale=1D-2
; step=1D-2
; timerange=15D
; smallesttime=10D
step=2D-2
timerange=10D
smallesttime=5D
approximation=5e-3

yout=fltarr(npts)

energy=x-x0

fmax=tau/beta*gamma(1/beta)

      tau_KWW=complex(tau)
      beta_KWW=complex(beta)
      
      ;NEED ALPHA IN TERMS OF BETA
      alpha = ((dindgen(11001))/10000.0)   ;WILL THIS BE PRECICE ENOUGH???
      gamtemp = (1 - 0.812*(1.0 - alpha)^0.387)
      diff =   abs((alpha*gamtemp)^(1.0/1.23) - beta_KWW)  ;SOLVE FOR alpha "GRAPHICALLY"
      mindiff = min(diff,minindex)
        
      alpha0 = alpha[minindex]
;      print,'alph0=',alpha0
      gam = 1 - 0.812*(1.0 - alpha0)^0.387  ;eq. 4
;      print,'gamma=',gam
      
      ;NOW CALCULATE tau_HN FROM THE FIT PARAMETER, tau_KWW --- eq. 5.2
      tau_HN = tau_KWW*(10.0^(2.6*sqrt(1.0 - beta_KWW)*exp(-3.0*beta_KWW)))
;      print,'tau_HN,tau_KWW=',tau_HN,tau
      y_PL=(-1/energy)*imaginary((1.0/((1.0 + (i*(tau_HN/hbar)*energy)^alpha0)^(gam))))

;y_PL=(1+beta)/2*(abs(energy))^(-1)*(abs(energy)*tau/hbar)^(-beta)*(gamma(1/beta)/beta)^(-beta/2)
yout=y_PL

energy_center=where(y_PL/fmax gt approximation,cenergy_center)
energy_wings=where(y_PL/fmax le approximation,cenergy_wings)
;print,energy_center
;print,'factor'

n0=where(energy eq 0.,nc0)

if (cenergy_center gt 1) then begin

      maxe=max(abs(energy(energy_center)),maxenergy)

      taufactor=tau/tauscale
      npoints=timerange/step
      n=findgen(npoints)*step-smallesttime
      t=10D^n
      n1=n+step
      t1=10D^n1
      nt=n_elements(t)
      
      KWW=exp(-(((t+t1)/2)/tauscale)^beta)
      ;KWW=exp(-(((t+t1)/2)/tau)^beta)
      KWWprime=-beta*KWW*(((t+t1)/2)/tauscale)^(-1+beta)/tauscale
      ;KWWprime=-beta*KWW*(((t+t1)/2)/tau)^(-1+beta)/tau
      KWWdoubleprime=(1-beta)*beta*KWW*(((t+t1)/2)/tauscale)^(-2+beta)/tauscale^2+beta^2*KWW*(((t+t1)/2)/tauscale)^(-2+2*beta)/(tauscale^2)
      ;KWWdoubleprime=(1-beta)*beta*KWW*(((t+t1)/2)/tau)^(-2+beta)/tau^2+beta^2*KWW*(((t+t1)/2)/tau)^(-2+2*beta)/tau^2
      
      nenergy_minus=where(energy(energy_center) lt 0.,nc_energy_minus)
      nenergy_plus=where(energy(energy_center) gt 0.,nc_energy_plus)
      
      if (nc_energy_minus gt 0) then begin
      
          x_minus=energy(energy_center(nenergy_minus))
      
          matrix_minus=((sin(taufactor*(x_minus)#t1/hbar)-sin(taufactor*(x_minus)#t/hbar))*((taufactor*(x_minus))^(-1)#KWW)- $
                        (2*cos(taufactor*(x_minus)#t/hbar)-2*cos(taufactor*(x_minus)#t1/hbar)+ $
                        taufactor*(x_minus)#(t-t1)/hbar*(sin(taufactor*(x_minus)#t/hbar)+sin(taufactor*(x_minus)#t1/hbar)))* $
                        (0.5*(taufactor*(x_minus))^(-2)#KWWprime)+ $
                        (4*taufactor*(x_minus)#(-t+t1)/hbar*(cos(taufactor*(x_minus)#t/hbar)+cos(taufactor*(x_minus)#t1/hbar))+ $
                        (8-(taufactor*(x_minus)#(-t+t1)/hbar)^2)*(sin(taufactor*(x_minus)#t/hbar)-sin(taufactor*(x_minus)#t1/hbar)))* $
                        ((2*taufactor*(x_minus))^(-3)#KWWdoubleprime))
      
          yout(energy_center(nenergy_minus))=taufactor*total(matrix_minus,2)+t(0)
      
      endif
      
      if (nc_energy_plus gt 0) then begin
      
          x_plus=energy(energy_center(nenergy_plus))
      
          matrix_plus=((sin(taufactor*(x_plus)#t1/hbar)-sin(taufactor*(x_plus)#t/hbar))*((taufactor*(x_plus))^(-1)#KWW)- $
                        (2*cos(taufactor*(x_plus)#t/hbar)-2*cos(taufactor*(x_plus)#t1/hbar)+ $
                        taufactor*(x_plus)#(t-t1)/hbar*(sin(taufactor*(x_plus)#t/hbar)+sin(taufactor*(x_plus)#t1/hbar)))* $
                        (0.5*(taufactor*(x_plus))^(-2)#KWWprime)+ $
                        (4*taufactor*(x_plus)#(-t+t1)/hbar*(cos(taufactor*(x_plus)#t/hbar)+cos(taufactor*(x_plus)#t1/hbar))+ $
                        (8-(taufactor*(x_plus)#(-t+t1)/hbar)^2)*(sin(taufactor*(x_plus)#t/hbar)-sin(taufactor*(x_plus)#t1/hbar)))* $
                        ((2*taufactor*(x_plus))^(-3)#KWWdoubleprime))
      
          yout(energy_center(nenergy_plus))=taufactor*total(matrix_plus,2)+t(0)
      
      endif
      
      
      ;dummy_minus=intarr(n_elements(x_minus))
      ;dummy_minus(*)=1
      
      ;matrix_minus=hbar*(sin(taufactor*(x_minus-x0)#t1/hbar)-sin(taufactor*(x_minus-x0)#t/hbar))*((taufactor*(x_minus-x0))^(-1)#KWW)
      ;matrix_plus=hbar*(sin(taufactor*(x_plus-x0)#t1/hbar)-sin(taufactor*(x_plus-x0)#t/hbar))*((taufactor*(x_plus-x0))^(-1)#KWW)
      
      ;matrix_minus=hbar*(sin((x_minus-x0)#t1/hbar)-sin((x_minus-x0)#t/hbar))*((x_minus-x0)^(-1)#KWW)
      ;matrix_plus=hbar*(sin((x_plus-x0)#t1/hbar)-sin((x_plus-x0)#t/hbar))*((x_plus-x0)^(-1)#KWW)
      
      ;matrix_minus=hbar*((sin(taufactor*(x_minus-x0)#t1/hbar)-sin(taufactor*(x_minus-x0)#t/hbar))*((taufactor*(x_minus-x0))^(-1)#KWW)- $
      ;                  (2*cos(taufactor*(x_minus-x0)#t/hbar)-2*cos(taufactor*(x_minus-x0)#t1/hbar)+ $
      ;                  taufactor*(x_minus-x0)#(t-t1)/hbar*(sin(taufactor*(x_minus-x0)#t/hbar)+sin(taufactor*(x_minus-x0)#t1/hbar)))*(0.5*(taufactor*(x_minus-x0))^(-2)#KWWprime))
      ;matrix_plus=hbar*((sin(taufactor*(x_plus-x0)#t1/hbar)-sin(taufactor*(x_plus-x0)#t/hbar))*((taufactor*(x_plus-x0))^(-1)#KWW)- $
      ;                  (2*cos(taufactor*(x_plus-x0)#t/hbar)-2*cos(taufactor*(x_plus-x0)#t1/hbar)+ $
      ;                  taufactor*(x_plus-x0)#(t-t1)/hbar*(sin(taufactor*(x_plus-x0)#t/hbar)+sin(taufactor*(x_plus-x0)#t1/hbar)))*(0.5*(taufactor*(x_plus-x0))^(-2)#KWWprime))
      
      ;matrix_minus=hbar*((sin((x_minus-x0)#t1/hbar)-sin((x_minus-x0)#t/hbar))*((x_minus-x0)^(-1)#KWW)- $
      ;                  (2*cos((x_minus-x0)#t/hbar)-2*cos((x_minus-x0)#t1/hbar)+ $
      ;                  (x_minus-x0)#(t-t1)/hbar*(sin((x_minus-x0)#t/hbar)+sin((x_minus-x0)#t1/hbar)))*(0.5*(x_minus-x0)^(-2)#KWWprime)+ $
      ;                  (4*(x_minus-x0)#(-t+t1)/hbar*(cos((x_minus-x0)#t/hbar)+cos((x_minus-x0)#t1/hbar))+ $
      ;                  (8-((x_minus-x0)#(-t+t1)/hbar)^2)*(sin((x_minus-x0)#t/hbar)-sin((x_minus-x0)#t1/hbar)))*((2*(x_minus-x0))^(-3)#KWWdoubleprime))
      ;matrix_plus=hbar*((sin((x_plus-x0)#t1/hbar)-sin((x_plus-x0)#t/hbar))*((x_plus-x0)^(-1)#KWW)- $
      ;                  (2*cos((x_plus-x0)#t/hbar)-2*cos((x_plus-x0)#t1/hbar)+ $
      ;                  (x_plus-x0)#(t-t1)/hbar*(sin((x_plus-x0)#t/hbar)+sin((x_plus-x0)#t1/hbar)))*(0.5*(x_plus-x0)^(-2)#KWWprime)+ $
      ;                  (4*(x_plus-x0)#(-t+t1)/hbar*(cos((x_plus-x0)#t/hbar)+cos((x_plus-x0)#t1/hbar))+ $
      ;                  (8-((x_plus-x0)#(-t+t1)/hbar)^2)*(sin((x_plus-x0)#t/hbar)-sin((x_plus-x0)#t1/hbar)))*((2*(x_plus-x0))^(-3)#KWWdoubleprime))
      
      ;matrix_minus=hbar*(sin((x_minus-x0)#t1/hbar)-sin((x_minus-x0)#t/hbar))*((x_minus-x0)^(-1)#KWW)
      ;matrix_plus=hbar*(sin((x_plus-x0)#t1/hbar)-sin((x_plus-x0)#t/hbar))*((x_plus-x0)^(-1)#KWW)
            
      if (cenergy_wings gt 0) then yout(energy_wings)=yout(energy_center(maxenergy))*yout(energy_wings)/y_PL(energy_center(maxenergy))
      ;    
      ;    accuracy=100
      ;    step=0.001
      ;
      ;    z_temp=findgen(accuracy*100)
      ;    z=transpose([-sort(-z_temp)*step,z_temp(1:accuracy*100-1)*step])
      ;    z1=transpose([-sort(-z_temp(0:accuracy*100-1))*step,z_temp(1:accuracy*100-1)* $
      ;       step,z_temp(1:accuracy*100-1)*step+step])
      ;
      ;
      ;    dummy=intarr(n_elements(x))
      ;    dummy(*)=1
      ;
      ;;   matrix=cos((omega-x0)#exp(x))*(dummy#(exp(x)*step*exp(-(exp(x)/tau)^beta)))
      ;    matrix=(cos((x-x0)#exp(z)/hbar)* $
      ;        (dummy#(exp(-(res_sigma^2*(exp(z))^2/(2*hbar^2)))*exp(z)*exp(-(exp(z)/tau)^beta)))+ $
      ;        cos((x-x0)#exp(z1)/hbar)* $
      ;       (dummy#(exp(-(res_sigma^2*(exp(z1))^2/(2*hbar^2)))*exp(z1)*exp(-(exp(z1)/tau)^beta))))*step/2
      ;
      ;    yout=Amp/(!pi)*total(matrix,2)/hbar
      
      ;yout=(yout+t(0))

endif

if (nc0 gt 0) then yout(n0)=tau/beta*gamma(1/beta)/hbar

yout=Amp/(!pi)*yout

;print,systime(/seconds)-t0time


return,yout



end

;
;; $Id$
;;###############################################################################
;;
;; NAME:
;;  PAN_FT_KWW
;;
;; PURPOSE:
;;  PROVIDE A FUNCTION FOR QENS DATA
;;
;; CATEGORY:
;;  DAVE, Data Analysis, PAN, curve fitting
;;
;; AUTHOR:
;;   Antonio Faraone, Ph.D.
;;   NIST Center for Neutron Research
;;   100 Bureau Drive
;;   Gaithersburg, MD 20899
;;   Phone: (301) 975-5254
;;   E-mail: antonio.faraone@nist.gov
;;
;; LICENSE:
;;  The software in this file is written by an employee of
;;  National Institute of Standards and Technology
;;  as part of the DAVE software project.
;;
;;  The DAVE software package is not subject to copyright protection
;;  and is in the public domain. It should be considered as an
;;  experimental neutron scattering data reduction, visualization, and
;;  analysis system. As such, the authors assume no responsibility
;;  whatsoever for its use, and make no guarantees, expressed or
;;  implied, about its quality, reliability, or any other
;;  characteristic. The use of certain trade names or commercial
;;  products does not imply any endorsement of a particular product,
;;  nor does it imply that the named product is necessarily the best
;;  product for the stated purpose. We would appreciate acknowledgment
;;  if the DAVE software is used of if the code in this file is
;;  included in another product.
;;
;;###############################################################################
;function pan_ft_kww,x,parms, parmnames=parmnames, $
;                 canDraw=canDraw, $
;                 _Extra=extra
;
;
;if n_params() eq 0 then begin
;    parmnames = ['Area','x0','tau','beta','res_sigma']
;    return,-1
;endif
;canDraw=0
;
;npts = n_elements(x)
;
;amp=parms[0]
;x0=parms[1]
;tau=parms[2]
;beta=parms[3]
;res_sigma=parms[4]
;hbar=0.6528
;
;    accuracy=100
;    step=0.001
;
;    z_temp=findgen(accuracy*100)
;    z=transpose([-sort(-z_temp)*step,z_temp(1:accuracy*100-1)*step])
;    z1=transpose([-sort(-z_temp(0:accuracy*100-1))*step,z_temp(1:accuracy*100-1)* $
;       step,z_temp(1:accuracy*100-1)*step+step])
;
;
;    dummy=intarr(n_elements(x))
;    dummy(*)=1
;
;;   matrix=cos((omega-x0)#exp(x))*(dummy#(exp(x)*step*exp(-(exp(x)/tau)^beta)))
;    matrix=(cos((x-x0)#exp(z)/hbar)* $
;        (dummy#(exp(-(res_sigma^2*(exp(z))^2/(2*hbar^2)))*exp(z)*exp(-(exp(z)/tau)^beta)))+ $
;        cos((x-x0)#exp(z1)/hbar)* $
;       (dummy#(exp(-(res_sigma^2*(exp(z1))^2/(2*hbar^2)))*exp(z1)*exp(-(exp(z1)/tau)^beta))))*step/2
;
;    yout=Amp/(!pi)*total(matrix,2)/hbar
;return,yout
;
;
;
;end


;;###############################################################################
pro Test_ft_kww, plot=plot, parms=parms
  compile_opt idl2

  if (N_elements(parms) ne 4) then parms = [1.0,0.0,1.0,0.5]
  omega = (Findgen(61) - 30) * 0.5
  void = Pan_ft_kww_new(parmnames=pnames)
  Tic
  calc = Pan_ft_kww(omega,parms)
  Toc
  if (Keyword_set(plot)) then begin
    title = ['FT_KWW',Strjoin(pnames,'; '),Strjoin(String(parms,format='(F5.3)'),'; ')]
    p = Plot(omega,calc,title=title,sym=0,linestyle=0)
  endif
end
