; $Id$
;###############################################################################
;
; NAME:
;  PAN_DO_THE_MACRO
;
; PURPOSE:
;  Executes a scripted IDL sequence of commands for use in fitting
;  data with a user-defined function.
;
; CATEGORY:
;  DAVE, Data Analysis, PAN
;
; AUTHOR:
;   Robert M. Dimeo, Ph.D.
;   NIST Center for Neutron Research
;   100 Bureau Drive
;   Gaithersburg, MD 20899
;   Phone: (301) 975-8135
;   E-mail: robert.dimeo@nist.gov
;   http://www.ncnr.nist.gov/staff/dimeo
;
; LICENSE:
;  The software in this file is written by an employee of
;  National Institute of Standards and Technology
;  as part of the DAVE software project.
;
;  The DAVE software package is not subject to copyright protection
;  and is in the public domain. It should be considered as an
;  experimental neutron scattering data reduction, visualization, and
;  analysis system. As such, the authors assume no responsibility
;  whatsoever for its use, and make no guarantees, expressed or
;  implied, about its quality, reliability, or any other
;  characteristic. The use of certain trade names or commercial
;  products does not imply any endorsement of a particular product,
;  nor does it imply that the named product is necessarily the best
;  product for the stated purpose. We would appreciate acknowledgment
;  if the DAVE software is used of if the code in this file is
;  included in another product.
;
;###############################################################################
function pan_do_the_macro,_macro_lines_,$
                            qgroup=qgroup,$
                            qvals=qvals,groupNumber=groupNumber, group_leader=group_leader

; don't allow an empty string
temp_macro = (N_elements(_macro_lines_) gt 0)? Strjoin(_macro_lines_,/single) : Strtrim(_macro_lines_,2)
if (temp_macro eq '') then Return, 0

_nlines_ = n_elements(_macro_lines_)

;GET ALL THE VARIABLE NAMES FOR THIS LEVEL
this_level = routine_names(/level)
main_level = 1

; What are the variable names in the current level?
old_current = routine_names(variables=this_level)

; What are the variable names in the main level?
old_main = routine_names(variables=main_level)

; Get out all of the old $MAIN$ variables and
; put them in the current level....
n_old_main = n_elements(old_main)

if old_main[0] eq "" then begin
	n_old_main = 0
endif else begin
	; put the main level variables in the current level
	for _i = 0,n_old_main-1 do begin
    if n_elements(routine_names(old_main[_i],fetch = main_level)) gt 0 then begin
	    value  = routine_names(old_main[_i], fetch = main_level)
	    dummy  = routine_names(old_main[_i], value, store = this_level)
    endif
	endfor;_i
endelse


for _i = 0,_nlines_-1 do begin
  before_execute = routine_names(variables = this_level)
  r = execute(_macro_lines_[_i],1)
  after_execute = routine_names(variables = this_level)
  if r ne 1 then begin
    if (n_elements(group_leader) eq 0) then group_leader=0L
    title = 'User macro definition'
    msg = 'Error en_countered while evaluating the user macro:'
    msg = [msg,' ',!error_state.msg]
  	void = dialog_message(msg,/error,title=title,dialog_parent=group_leader)
  	return,0
  endif
  ; are there any new variables introduced due to execute at this level?
	n_before = n_elements(before_execute)
	n_after = n_elements(after_execute)
	_counter = 0L
	new_var = []
	if n_before ne n_after then begin
		for _ii = 0,n_after-1 do begin
			whereok = where(before_execute eq after_execute[_ii],count)
			if count eq 0 then begin
				new_var = [new_var,after_execute[_ii]]
				_counter = _counter+1L
			endif
		endfor;_ii
    ; Promote new variables from this level to the $MAIN$ level
		for _ii = 0,_counter-1 do begin
      if n_elements(routine_names(new_var[_ii],fetch = this_level)) gt 0 then begin
        value  = routine_names(new_var[_ii], fetch = this_level)
        dummy  = routine_names(new_var[_ii], value, store = main_level)
      endif
		endfor;_ii
	endif;n_before ne n_after

  ; are there any of the same variables in the $MAIN$ level and in the
  ; current level?  If so then replace $MAIN$ level variables with
  ; those from the current level.
  new_main = routine_names(variables = main_level)
  new_current = routine_names(variables = this_level)
	_counter = 0L
	new_var = []
	for _ii = 0,n_elements(new_main)-1 do begin
		whereok = where(new_current eq new_main[_ii],count)
		if count ne 0 then begin
			new_var = [new_var,new_current[whereok[0]]]
			_counter = _counter+1L
		endif
	endfor;_ii

	; get the value from this level
	for _ii = 0,_counter-1 do begin
    if n_elements(routine_names(new_var[_ii],fetch = this_level)) gt 0 then begin
      value  = routine_names(new_var[_ii], fetch=this_level)
      ; put the value and variable name into the $MAIN$ level
      dummy  = routine_names(new_var[_ii], value, store = main_level)
    endif
	endfor;_ii
endfor;_i

return,1
end;pan_do_the_macro
