; $Id$
;###############################################################################
;
; NAME:
;  Pan_linear_2D
;
; PURPOSE:
;  Linear background (constant and slope) in 2D for use in fitting data in PAN.
;
; CATEGORY:
;  DAVE, Data Analysis, PAN
;
; AUTHOR:
;  Richard Tumanjong Azuah
;  NIST Center for Neutron Research
;  azuah@nist.gov; (301) 9755604
;
; LICENSE:
;  The software in this file is written by an employee of
;  National Institute of Standards and Technology
;  as part of the DAVE software project.
;
;  The DAVE software package is not subject to copyright protection
;  and is in the public domain. It should be considered as an
;  experimental neutron scattering data reduction, visualization, and
;  analysis system. As such, the authors assume no responsibility
;  whatsoever for its use, and make no guarantees, expressed or
;  implied, about its quality, reliability, or any other
;  characteristic. The use of certain trade names or commercial
;  products does not imply any endorsement of a particular product,
;  nor does it imply that the named product is necessarily the best
;  product for the stated purpose. We would appreciate acknowledgment
;  if the DAVE software is used of if the code in this file is
;  included in another product.
;
;###############################################################################
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
function Pan_linear_2D,x,parms,$
  parmnames=parmnames, single_parmnames=single_parmnames, multi_parmnames=multi_parmnames,    $
  canDraw=canDraw, drawMessage=drawMessage, xrange=xrange,  $
  func_dataHash=func_dataHash,twoDimFlag=twoDimFlag, initParms=initParms, $
  qvals=qvals,xVals=xVals,yVals=yVals,groupNumber=groupNumber,qGroup=qGroup, $
  changesecond=changesecond, changefirst=changefirst, xMouseClick=xMouseClick, yMouseClick=yMouseClick, $
  resPtr=resPtr, resLimit=rLimit,resolutionRequiredFlag=resolutionRequiredFlag, extConvolFlag=extConvolFlag, $
  _Extra = extra

nx = isa(x)? n_elements(x) : n_elements(xvals)
nq = n_elements(qvals)
ux = 1+bytarr(nx)
uq = 1+bytarr(nq)

canDraw = 1
twoDimFlag = 1
resolutionRequiredFlag = 0   ; does function require a resolution function to be defined 0=>No, 1=>Yes

extConvolFlag = 0           ; does function require external convolution? 0=>No, 1=>Yes
                            ; if set to No, it implies a convolution is performed within this function when a resolution function is present
                            ; Also set to No, if you DO NOT wish any external convolution to be performed at all

if N_params() eq 0 then begin
  twoDimFlag = 1
  ; Evalute areas
  parmnames = []
  parmnames = [parmnames,'Offset'+Strtrim(String(Indgen(nq)+1),2)]
  parmnames = [parmnames,'Slope'+Strtrim(String(Indgen(nq)+1),2)]

  single_parmnames = ''
  multi_parmnames = ['Offset','Slope']

  ;    if (isa(xVals) && isa(yVals)) then begin
  ;      ; Analyse the data, if present to determine initial guess parameters
  ;      
  ;      ; Estimate initial guess values for the
  ;      if (Isa(yVals)) then begin
  ;        ; Analyse the data, if present to determine initial guess parameters
  ;        initparms = Fltarr(2*nq) +0.0
  ;        if (yVals.ndim eq 1) then begin
  ;          ymin = yVals.Sort()
  ;          bg = (N_elements(ymin) gt 5)? Mean(ymin[0:4]) : ymin[0]
  ;          for i = 0,nq -1 do initparms[2*i] = bg      ; assign the offset the same for all Q values
  ;                                                      ; by default the slope is 0.0
  ;        endif else begin
  ;          for i = 0,nq-1 do begin
  ;            ymin = yVals[*,i].Sort()
  ;            bg = (N_elements(ymin) gt 5)? Mean(ymin[0:4]) : ymin[0]
  ;            initparms[2*i] = bg ; assign the offset, by default the slope is 0.0
  ;          endfor
  ;        endelse
  ;      endif
  ;    endif

  Return,-1
endif
drawMessage = Strarr(4)
drawMessage[0:1] = ['Hold left mouse button down','and drag vertically to set background constant']
drawMessage[2:3] = ['Hold left mouse button down','and drag vertically to set background slope']

np = N_elements(parms)
ngroups = Fix(np/2)
index = Indgen(ngroups)

if (Keyword_set(changefirst)) then begin
  ; user is initializing the function graphically
  ; this block of code is executed when the mouse is first release at the location for the function centroid
  ; translate the position into suitable parameters.
  ;Print,'###Changefirst called within function...'
  parms[index] = yMouseClick
  parms[index+nq] = 0.0
  func_dataHash['ymax'] = yMouseClick
endif

if (Keyword_set(changesecond)) then begin
  ; user is initializing the function graphically
  ; this block of code is executed when the mouse is move to define the function width
  ; translate the position into suitable parameters.
  ;Print,'###Changesecond called within function...'
  offset = func_dataHash['ymax']
  slope = (yMouseClick-offset)/(xMouseClick - 0.0)
  parms[index+nq] = slope
endif

yout = ux#parms[index] + x#parms[index+nq] 

Return,yout
end