; $Id$
;###############################################################################
;
; NAME:
;  Pan_constant_2D
;
; PURPOSE:
;  Flat background in 2D for use in fitting data in PAN.
;
; CATEGORY:
;  DAVE, Data Analysis, PAN
;
; AUTHOR:
;  Richard Tumanjong Azuah
;  NIST Center for Neutron Research
;  azuah@nist.gov; (301) 9755604
;
; LICENSE:
;  The software in this file is written by an employee of
;  National Institute of Standards and Technology
;  as part of the DAVE software project.
;
;  The DAVE software package is not subject to copyright protection
;  and is in the public domain. It should be considered as an
;  experimental neutron scattering data reduction, visualization, and
;  analysis system. As such, the authors assume no responsibility
;  whatsoever for its use, and make no guarantees, expressed or
;  implied, about its quality, reliability, or any other
;  characteristic. The use of certain trade names or commercial
;  products does not imply any endorsement of a particular product,
;  nor does it imply that the named product is necessarily the best
;  product for the stated purpose. We would appreciate acknowledgment
;  if the DAVE software is used of if the code in this file is
;  included in another product.
;
;###############################################################################
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
function Pan_constant_2D,x,parms,$
  parmnames=parmnames, single_parmnames=single_parmnames, multi_parmnames=multi_parmnames,    $
  canDraw=canDraw, drawMessage=drawMessage, xrange=xrange,  $
  func_dataHash=func_dataHash,twoDimFlag=twoDimFlag, initParms=initParms, $
  qvals=qvals,xVals=xVals,yVals=yVals,groupNumber=groupNumber,qGroup=qGroup, $
  changesecond=changesecond, changefirst=changefirst, xMouseClick=xMouseClick, yMouseClick=yMouseClick, $
  resPtr=resPtr, resLimit=rLimit,resolutionRequiredFlag=resolutionRequiredFlag, extConvolFlag=extConvolFlag, $
  _Extra = extra

nx = isa(x)? n_elements(x) : n_elements(xvals)
nq = n_elements(qvals)
ux = 1+bytarr(nx)
uq = 1+bytarr(nq)

canDraw = 1
;canDraw = 0
twoDimFlag = 1
resolutionRequiredFlag = 0   ; does function require a resolution function to be defined 0=>No, 1=>Yes

extConvolFlag = 0           ; does function require external convolution? 0=>No, 1=>Yes
                            ; if set to No, it implies a convolution is performed within this function when a resolution function is present
                            ; Also set to No, if you DO NOT wish any external convolution to be performed at all

if N_params() eq 0 then begin
  parmnames = 'Offset'+strtrim(string(indgen(nq)),2)

  single_parmnames = ''
  multi_parmnames = ['Offset']
  
  ; Estimate initial guess values for the 
  ; This is used if canDraw is set to 0
  if (isa(yVals)) then begin
    ; Analyse the data, if present to determine initial guess parameters
    if (yVals.ndim eq 1) then begin
      ymin = yVals.sort()
      bg = (N_elements(ymin) gt 5)? mean(ymin[0:4]) : ymin[0]

      initparms = Fltarr(nq) + bg
    endif else begin
      initparms = fltarr(nq)
      for i = 0,nq-1 do begin
        ymin = yVals[*,i].sort()
        bg = (N_elements(ymin) gt 5)? Mean(ymin[0:4]) : ymin[0]
        initparms[i] = bg
      endfor
    endelse
  endif

  Return,-1
endif
drawMessage = Strarr(4)
drawMessage[0:1] = ['Hold left mouse button down','and drag vertically to set background constant']
drawMessage[2:3] = ['Hold left mouse button down','and click anywhere to finish']

if (Keyword_set(changefirst)) then begin
  ; user is initializing the function graphically
  ; this block of code is executed when the mouse is first release at the location for the function centroid
  ; translate the position into suitable parameters.
  ;Print,'###Changefirst called within function...'
  parms[*] = yMouseClick
endif

if (Keyword_set(changesecond)) then begin
  ; user is initializing the function graphically
  ; this block of code is executed when the mouse is move to define the function width
  ; translate the position into suitable parameters.
  ;Print,'###Changesecond called within function...'

endif


;yout = fltarr(n_elements(x),nq)
;for i=0, nq-1 do begin
;  yout[*,i]= x*0.0 + parms[i]
;endfor

; Vectorize
yout = ux#parms

Return,yout
end