; $Id$
;###############################################################################
;
; NAME:
;  GETRESLIMIT
;
; PURPOSE:
;  Dialog for user to enter the limits of the resolution function.
;
; CATEGORY:
;  DAVE, Data Analysis, PAN, curve fitting
;
; AUTHOR:
;   Robert M. Dimeo, Ph.D.
;   NIST Center for Neutron Research
;   100 Bureau Drive
;   Gaithersburg, MD 20899
;   Phone: (301) 975-8135
;   E-mail: robert.dimeo@nist.gov
;   http://www.ncnr.nist.gov/staff/dimeo
;
; LICENSE:
;  The software in this file is written by an employee of
;  National Institute of Standards and Technology
;  as part of the DAVE software project.
;
;  The DAVE software package is not subject to copyright protection
;  and is in the public domain. It should be considered as an
;  experimental neutron scattering data reduction, visualization, and
;  analysis system. As such, the authors assume no responsibility
;  whatsoever for its use, and make no guarantees, expressed or
;  implied, about its quality, reliability, or any other
;  characteristic. The use of certain trade names or commercial
;  products does not imply any endorsement of a particular product,
;  nor does it imply that the named product is necessarily the best
;  product for the stated purpose. We would appreciate acknowledgment
;  if the DAVE software is used of if the code in this file is
;  included in another product.
;
;###############################################################################
pro getResLimit_event,event
widget_control,event.top,get_uvalue = pState
thisEvent = tag_names(event,/structure)

if thisEvent eq 'WIDGET_BUTTON' then begin

  widget_control,(*pState).limitID,get_value = val
  val = float(val[0])
  (*pState).value = val
  widget_control,event.top,/destroy

endif

return
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
function getResLimit,xvals,limitVal,group_leader = group_leader
; Widget definition module
if n_elements(group_leader) ne 0 then begin
  tlb = widget_base(group_leader = group_leader,/tlb_frame_attr, /col,/modal)
endif else begin
  tlb = widget_base(/tlb_frame_attr, /col)
endelse

limitVal = (n_elements(limitVal) gt 0)? limitVal : 0.9*max(xvals)

limitID = cw_field(tlb,title = 'Resolution function domain limit', $
        value = strtrim(string(limitVal),2),/string,xsize = 15)
void = widget_button(tlb,value = 'Accept and Quit')

widget_control,tlb,/realize
state = {limitID:limitID,value:limitVal}
pState = ptr_new(state,/no_copy)
widget_control,tlb,set_uvalue = pState

xmanager,'getResLimit',tlb
value = (*pState).value
ptr_free,pState

return,value
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
