; $Id$
;###############################################################################
;
; NAME:
;  GETPARMSFROMEXPR
;
; PURPOSE:
;  Parses out parameters from a string expression and returns an array
;  of parameters.
;
; CATEGORY:
;  DAVE, Data Analysis, PAN, curve fitting
;
; AUTHOR:
;   Robert M. Dimeo, Ph.D.
;   NIST Center for Neutron Research
;   100 Bureau Drive
;   Gaithersburg, MD 20899
;   Phone: (301) 975-8135
;   E-mail: robert.dimeo@nist.gov
;   http://www.ncnr.nist.gov/staff/dimeo
;
; LICENSE:
;  The software in this file is written by an employee of
;  National Institute of Standards and Technology
;  as part of the DAVE software project.
;
;  The DAVE software package is not subject to copyright protection
;  and is in the public domain. It should be considered as an
;  experimental neutron scattering data reduction, visualization, and
;  analysis system. As such, the authors assume no responsibility
;  whatsoever for its use, and make no guarantees, expressed or
;  implied, about its quality, reliability, or any other
;  characteristic. The use of certain trade names or commercial
;  products does not imply any endorsement of a particular product,
;  nor does it imply that the named product is necessarily the best
;  product for the stated purpose. We would appreciate acknowledgment
;  if the DAVE software is used of if the code in this file is
;  included in another product.
;
;###############################################################################
function getparmsfromexpr,	expr,	$
							search_string = search_string,	$
							startloc = startloc,			$
							endloc = endloc
; Determine each occurence of the string combination 'p[.]' where
; the . represents a number beginning with zero.  The output here
; is a string array of parameters.
if n_elements(search_string) eq 0 then search_string = 'p['
len = strlen(expr)
first = strpos(expr,search_string)
if first eq (-1) then return,(-1)
startloc = first
last = strpos(expr,']')
endloc = last
if last eq (-1) then return,(-1)
parms = strmid(expr,first,last-first+1)

while (first ne (-1)) and (last ne (-1)) do begin
  nextPos = last+1
  first = strpos(expr,search_string,nextPos)
  last = strpos(expr,']',nextPos)
  if (first ne (-1)) and (last ne (-1)) then begin
    newParm = strmid(expr,first,last-first+1)
    parms = [parms,newParm]
    startloc = [startloc,first]
  	endloc = [endloc,last]
  endif
endwhile

; Now that we have the complete array, determine the unique
; members and sort them.
nparms = n_elements(parms)
index = intarr(nparms)
for i = 0,nparms-1 do begin
  last = strpos(parms[i],']')
  number = fix(strmid(parms[i],2,last-2+1))
  index[i] = number
endfor
isort = sort(index)
parms = parms[isort]
output = parms[uniq(parms,sort(parms))]
startloc = startloc[uniq(startloc)]
endloc = endloc[uniq(endloc)]
return,output
end