; +
; NAME:
;
;  HC_LORENTZIAN
;
; PURPOSE:
;
;  Procedure that defines a Lorentzian lineshape
;  for use in the Honeycomb lattice diffusion analysis.
;
; AUTHOR:
;
;  Robert Dimeo
;  National Institute of Standards and Technology
;  Center for Neutron Research
;  100 Bureau Drive, Mail Stop 8562
;  Gaithersburg, MD 20899
;  Tel: (301) 975-8135
;  Email: robert.dimeo@nist.gov
;
; CATEGORY:
;
;  Data analysis
;
; REQUIREMENTS
;
;  IDL 6.0 or higher
;
; ADDITIONAL REQUIRED PROGRAMS
;
;  None
;
; MODIFICATION HISTORY:
;
;  Writing began -- 6/21/04 (RMD)
; -
; *************************************************** ;
function hc_lorentzian,x,area,center,fwhm
gam = 0.5*fwhm
ylor = gam*(area/!dpi)/((x-center)^2+gam^2)
return,ylor
end