; $Id$
;###############################################################################
; LICENSE:
;  The software in this file is written by an employee of 
;  National Institute of Standards and Technology 
;  as part of the DAVE software project.
;
;  The DAVE software package is not subject to copyright protection
;  and is in the public domain. It should be considered as an
;  experimental neutron scattering data reduction, visualization, and
;  analysis system. As such, the authors assume no responsibility
;  whatsoever for its use, and make no guarantees, expressed or
;  implied, about its quality, reliability, or any other
;  characteristic. The use of certain trade names or commercial
;  products does not imply any endorsement of a particular product,
;  nor does it imply that the named product is necessarily the best
;  product for the stated purpose. We would appreciate acknowledgment
;  if the DAVE software is used of if the code in this file is
;  included in another product.
;
;###############################################################################
;************************************************************************************************
;
; These procedures are used by the program "annsca" (q.v.)
;
;************************************************************************************************
function annsca_get_kvals,plotwhat,ckn
;
compile_opt strictarr
;
case plotwhat of
	0: begin
		ks=0
		ke=ckn[0]-1
	end
	1: begin
		ks=ckn[0]
		ke=ckn[2]-1
	end
	2: begin
		ks=ckn[2]
		ke=ckn[3]-1
	end
	3: begin
		ks=ckn[3]
		ke=ckn[4]-1
	end
endcase
return,[ks,ke]
end


;************************************************************************************************
pro annsca_2Plotter,event,redraw=redraw
;************************************************************************************************
;
compile_opt strictarr
;
widget_control,event.top,get_uvalue = pState
if (n_elements(*(*pState).ssfPtr) eq 0) then begin
	res=dialog_message("There is nothing to plot.",/information)
	return
endif
;
wset,(*pState).winPix
if (keyword_set(redraw)) then redraw=1 else redraw=0
annsca_Plot,event,redraw=redraw
wset,(*pState).winVis
device,copy = [0,0,(*pState).winxsize,(*pState).winysize,0,0,(*pState).winPix]
widget_control,event.top,set_uvalue = pState
end


;************************************************************************************************
pro annsca_2Printer,event
;************************************************************************************************
;
compile_opt strictarr
;
widget_control,event.top,get_uvalue = pState
if (n_elements(*(*pState).ssfPtr) eq 0) then begin
	res=dialog_message("There is no plot to be printed.",/information)
	return
endif
;
thisDevice = !d.name
device_keywords = PSConfig(Cancel=canceled,group_leader = event.top,$
    DefaultSetup="Centered (Landscape)")
if canceled ne 1 then begin
  SET_PLOT, 'PS'
  DEVICE, _Extra = device_keywords
  annsca_Plot,event,/redraw
  DEVICE, /CLOSE_FILE
  set_plot,thisDevice
endif
return
end


;************************************************************************************************
pro annsca_Plot,event,redraw=redraw
;************************************************************************************************
;
compile_opt strictarr
;
widget_control,event.top,get_uvalue = pState
;
;!x.margin = [10,3]
;!y.margin = [4,2]
;
if (n_elements(*(*pState).ssfPtr) eq 0) then begin
	res=dialog_message("Nothing found to plot in ANNSCA_PLOT",/information)
	return
endif
;
if ((*pState).plotting_geometry eq 1) then begin
	(*pState).plotting_geometry=0
	(*pState).autoscale=1
endif
;
case (*pState).calctype of
	0: prefix="Num: "
	1: prefix="   "
	2: prefix="MC-A: "
	3: prefix="MC-B: "
endcase
;
case (*pState).plotwhat of
	0: ytitle="Self shielding factors"
	1: ytitle="Individual scattering fractions"
	2: ytitle="Summed scattering fractions"
	3: ytitle="Double scattering/single scattering"
endcase
;
symsize=1.333
;
if ((*pState).show_lgnd) then topmargin=20 else topmargin=2
;
; The following code is executed if the results of a new calculation are to be plotted,
;	either as a new plot or as an addition to an existing plot.
if (not redraw) then begin
;
; Define the number of plots.
	if ((*pState).overplot and (*pState).n_plots ge 1) then begin
		(*pState).n_plots=(*pState).n_plots+1
	endif else begin
		(*pState).n_plots=1
	endelse
;
;	Define the abscissa.
	absciss = *(*pState).phiPtr
	nabsc=n_elements(absciss)
;
; Define ordinates.
	ordinate = *(*pState).ssfPtr
	nann=(*pState).nann
	kn=[nann,nann,0,1,0]
	ordinate = [ordinate,*(*pState).ttotalPtr]
	if (n_elements(*(*pState).ttotal2Ptr) eq 0) then begin
		total1=total(ordinate[nann:2*nann-1,*],1)
		ordinate=[ordinate,reform(total1,1,nabsc)]
	endif else begin
		ordinate=[ordinate,reform(*(*pState).ttotal2Ptr,nann^2,nabsc)]
		kn[2]=nann^2
		total1=total(ordinate[nann:2*nann-1,*],1)
		total2=total(ordinate[2*nann:2*nann-1+nann^2,*],1)
		ordinate=[ordinate,reform(total1,1,nabsc),reform(total2,1,nabsc)]
		kn[3]=2
		ordinate=[ordinate,reform(total2,1,nabsc)/reform(total1,1,nabsc)]
		kn[4]=1
	endelse
	ckn=fix(total(kn,/cumulative))
;
;	Define errors.
	if ((*pState).calcType eq 0 or (*pState).calcType eq 3) then begin
		error=0
	endif else begin
		error=*(*pState).esfPtr
		error=[error,*(*pState).etotalPtr]
		if (n_elements(*(*pState).etotal2Ptr) eq 0) then begin
			total1=sqrt(total(error[nann:2*nann-1,*]^2,1))
			error=[error,reform(total1,1,nabsc)]
		endif else begin
			error=[error,reform(*(*pState).ttotal2Ptr,nann^2,nabsc)]
			total1=sqrt(total(error[nann:2*nann-1,*]^2,1))
			total2=sqrt(total(error[2*nann:2*nann-1+nann^2,*]^2,1))
			error=[error,reform(total1,1,nabsc),reform(total2,1,nabsc)]
		endelse
	endelse
;
	if ((*pState).n_plots eq (*pState).max_n_plots) then begin
		res=dialog_message([$
			"The maximum number of overplots is"+strcompress((*pState).max_n_plots),$
			"If you add any more plots you will exceed this number ",$
			"and you will not see these plots if you try to zoom or ",$
			"autoscale. Nor will you be able to view their legends."])
	endif
;
	if ((*pState).n_plots le (*pState).max_n_plots) then begin
		(*(*pState).storeplotPtr[(*pState).n_plots-1])=$
			{absciss:absciss,ordinate:ordinate,error:error,ckn:ckn,$
			comment:prefix+(*pState).prob_comment}
	endif
;
	kv=annsca_get_kvals((*pState).plotwhat,ckn)
;
	if ((*pState).autoscale eq 1) then begin
	  (*pState).xlo = min(absciss)
	  (*pState).xhi = max(absciss)
	  (*pState).ylo = 0.0
	  (*pState).yhi = 1.2*max(ordinate[kv[0]:kv[1],*])
	endif
;
	if (not (*pState).overplot) then begin
		!x=(*pState).bangx
		!y=(*pState).bangy
		!p=(*pState).bangp
		if ((*pState).autoscale eq 1 and (*pState).n_plots eq 1) then begin
			plot,absciss,absciss,ymargin=[4,topmargin],$
;			plot,absciss,ordinate[kv[0],*],ymargin=[4,topmargin],$
				xstyle=1,xrange=[(*pState).xlo,(*pState).xhi],$
				ystyle=1,yrange=[(*pState).ylo,(*pState).yhi],$
			  xtitle='!32!4h!3 (degrees)',ytitle=ytitle,$
			  psym=-dave_selsym((*pState).n_plots+4),symsize=symsize,$
			  /nodata,color=1,background=0,$
			  xticklen=1.0,yticklen=1.0,xticks=6,xminor=3
		endif else begin
			plot,absciss,absciss,ymargin=[4,topmargin],$
;			plot,absciss,ordinate[kv[0],*],ymargin=[4,topmargin],$
				xstyle=1,xrange=[(*pState).xlo,(*pState).xhi],$
				ystyle=1,yrange=[(*pState).ylo,(*pState).yhi],$
			  xtitle='!32!4h!3 (degrees)',ytitle=ytitle,$
			  psym=-dave_selsym((*pState).n_plots+4),symsize=symsize,$
			  /nodata,color=1,background=0,$
			  xticklen=1.0,yticklen=1.0
		endelse
		(*pState).bangx=!x
		(*pState).bangy=!y
		(*pState).bangp=!p
	endif
;
	if (kv[0] le kv[1]) then begin
		for k=kv[0],kv[1] do begin
			if ((*pState).show_zero or ((*pState).show_zero eq 0 and max(ordinate[k,*]) gt 0.0)) then begin
				oplot,absciss,ordinate[k,*],psym=-dave_selsym((*pState).n_plots+4),$
					color=2+k,symsize=symsize
;				if (size(error,/n_dimensions) eq 2) then begin
;				  errplot,absciss,ordinate[k,*]-error[k,*],ordinate[k,*]+error[k,*],width = 0.0,color=2+k
;				endif
			endif
		endfor
	endif
endif
;
; The following code is executed if an existing plot is being redrawn (zoomed or autoscaled),
;	or if the type of plot has been changed).
if (redraw) then begin
;
	maxnplots=(*pState).n_plots < (*pState).max_n_plots
	if ((*pState).autoscale eq 1) then begin
	  (*pState).xlo=10000.0
		(*pState).xhi=-10000.0
	  (*pState).ylo=0.0
		(*pState).yhi=0.0
	  for j=0,maxnplots-1 do begin
		  (*pState).xlo=min((*(*pState).storeplotPtr[j]).absciss) < (*pState).xlo
		  (*pState).xhi=max((*(*pState).storeplotPtr[j]).absciss) > (*pState).xhi
			ckn=(*(*pState).storeplotPtr[j]).ckn
			kv=annsca_get_kvals((*pState).plotwhat,ckn)
			if (kv[0] le kv[1]) then begin
		  	(*pState).yhi=max((*(*pState).storeplotPtr[j]).ordinate[kv[0]:kv[1],*]) > (*pState).yhi
		  endif
		endfor
		(*pState).yhi=1.2*(*pState).yhi
	endif
;
	absciss=(*(*pState).storeplotPtr[0]).absciss
	ordinate=(*(*pState).storeplotPtr[0]).ordinate
	error=(*(*pState).storeplotPtr[0]).error
	ckn=(*(*pState).storeplotPtr[0]).ckn
;
	kv=annsca_get_kvals((*pState).plotwhat,ckn)
;
	!x=(*pState).bangx
	!y=(*pState).bangy
	!p=(*pState).bangp
	if ((*pState).autoscale eq 1 and (*pState).n_plots eq 1) then begin
		plot,absciss,absciss,ymargin=[4,topmargin],$
;		plot,absciss,ordinate[kv[0],*],ymargin=[4,topmargin],$
			xstyle=1,xrange=[(*pState).xlo,(*pState).xhi],$
			ystyle=1,yrange=[(*pState).ylo,(*pState).yhi],$
		  xtitle='!32!4h!3 (degrees)',ytitle=ytitle,$
		  psym=-8,/nodata,color=1,background=0,symsize=symsize,$
		  xticklen=1.0,yticklen=1.0,xticks=6,xminor=3
	endif else begin
		plot,absciss,absciss,ymargin=[4,topmargin],$
;		plot,absciss,ordinate[kv[0],*],ymargin=[4,topmargin],$
			xstyle=1,xrange=[(*pState).xlo,(*pState).xhi],$
			ystyle=1,yrange=[(*pState).ylo,(*pState).yhi],$
		  xtitle='!32!4h!3 (degrees)',ytitle=ytitle,$
		  psym=-8,/nodata,color=1,background=0,symsize=symsize,$
		  xticklen=1.0,yticklen=1.0
	endelse
	(*pState).bangx=!x
	(*pState).bangy=!y
	(*pState).bangp=!p
;
	for j=0,maxnplots-1 do begin
		absciss=(*(*pState).storeplotPtr[j]).absciss
		ordinate=(*(*pState).storeplotPtr[j]).ordinate
		error=(*(*pState).storeplotPtr[j]).error
		ckn=(*(*pState).storeplotPtr[j]).ckn
		kv=annsca_get_kvals((*pState).plotwhat,ckn)
;
		if (kv[0] le kv[1]) then begin
			for k=kv[0],kv[1] do begin
				if ((*pState).show_zero or ((*pState).show_zero eq 0 and max(ordinate[k,*]) gt 0.0)) then begin
					oplot,absciss,ordinate[k,*],psym=-dave_selsym(j+5),color=2+k,$
						symsize=symsize
;					if (size(error,/n_dimensions) eq 2) then begin
;				  	errplot,absciss,ordinate[k,*]-error[k,*],ordinate[k,*]+error[k,*],width = 0.0,color=2+k
;					endif
				endif
			endfor
		endif
	endfor
endif
;
plot_legend=(*pState).show_lgnd
if (plot_legend) then begin
	maxnplots=(*pState).n_plots < (*pState).max_n_plots
	position=[0.05,0.975]
	corners=[0,0,0,0]
	for j=0,maxnplots-1 do begin
		ckn=(*(*pState).storeplotPtr[j]).ckn
		nann=ckn[0]
		labels="SSF"+strcompress((indgen(nann)+1),/remove_all)
		labels=[labels,"S"+strcompress((indgen(nann)+1),/remove_all)]
		if (ckn[2] gt ckn[1]) then begin
			for m=0,nann-1 do begin
				number=strcompress((m+1),/remove_all)
				labels=[labels,"S"+number+strcompress((indgen(nann)+1),/remove_all)]
			endfor
			labels=[labels,"S.S.","D.S."]
		endif else begin
			labels=[labels,"S.S."]
		endelse
		if (ckn[4] gt ckn[3]) then labels=[labels,"Ratio"]
		kv=annsca_get_kvals((*pState).plotwhat,ckn)
		if (kv[0] le kv[1]) then begin
			nkv=kv[1]-kv[0]+1
			shit=bytarr(nkv)
			ordinate=(*(*pState).storeplotPtr[j]).ordinate
			for k=kv[0],kv[1] do begin
				if ((*pState).show_zero or ((*pState).show_zero eq 0 and max(ordinate[k,*]) gt 0.0)) then begin
					shit[k-kv[0]]=1
				endif
			endfor
			range=where(shit)
			items=labels[kv[0]:kv[1]]
			psyms=intarr(nkv)-dave_selsym(j+5)
			colors=2+kv[0]+indgen(nkv)
			textcolors=colors
;
			box=0
			position[1]=position[1]-(corners[3]-corners[1])
			comment=(*(*pState).storeplotPtr[j]).comment
			legend,comment,textcolors=1,charsize=1.0,position=position,$
				spacing=2,pspacing=0.0,/vertical,margin=0.2,corners=corners
			if (box) then begin
				x1=corners[0]
				y1=corners[1]
				x2=corners[2]
				y2=corners[3]
				plots,[x1,x1,x2,x2,x1],[y1,y2,y2,y1,y1],color=1,/norm
			endif
;
			box=0
			position[1]=position[1]-(corners[3]-corners[1])
			items=items[range]
			psyms=psyms[range]
			colors=colors[range]
			textcolors=textcolors[range]
			legend,items,psym=psyms,$
				color=colors,textcolors=textcolors*0+1,charsize=1.0,position=position,$
				spacing=2,pspacing=0.5,/horizontal,margin=0.2,corners=corners
			if (box) then begin
				x1=corners[0]
				y1=corners[1]
				x2=corners[2]
				y2=corners[3]
				plots,[x1,x1,x2,x2,x1],[y1,y2,y2,y1,y1],color=1,/norm
			endif
		endif
	endfor
endif

widget_control,(*pState).butt_oplot,/sensitive
widget_control,event.top,set_uvalue = pState
;
return
end
