; $Id$
;###############################################################################
; LICENSE:
;  The software in this file is written by an employee of 
;  National Institute of Standards and Technology 
;  as part of the DAVE software project.
;
;  The DAVE software package is not subject to copyright protection
;  and is in the public domain. It should be considered as an
;  experimental neutron scattering data reduction, visualization, and
;  analysis system. As such, the authors assume no responsibility
;  whatsoever for its use, and make no guarantees, expressed or
;  implied, about its quality, reliability, or any other
;  characteristic. The use of certain trade names or commercial
;  products does not imply any endorsement of a particular product,
;  nor does it imply that the named product is necessarily the best
;  product for the stated purpose. We would appreciate acknowledgment
;  if the DAVE software is used or if the code in this file is
;  included in another product.
;
;###############################################################################
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro DTCleanup,tlb
widget_control,tlb,get_uvalue = pState,/no_copy
wdelete,(*pState).winPix
ptr_free,(*pState).imgPtr
return
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro doneDTGetPoints,event
widget_control,event.top,/destroy
return
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro DTPlot,event
widget_control,event.top,get_uvalue = pState,/no_copy
if (*(*pState).dataPtr)[0] eq -999 then begin
  widget_control,event.top,set_uvalue = pState,/no_copy
  return
endif
wset,(*pState).winPix
loadct,0,/silent
tvImage,*(*pState).imgPtr,position = (*pState).imgPosition
colors = hfbs_getcolor(start = 1,/load)
datanew = *(*pState).dataPtr
plot,[datanew[0,*]],[datanew[1,*]],xrange = [0.0,(*pState).winxsize],$
	       yrange = [0.0,(*pState).winysize],xstyle = 5,ystyle = 5,$
	       psym = 8,color = colors.red,/noerase,xmargin = [0,0],ymargin = [0,0]
wset, (*pState).winVis
device, copy = [0,0,(*pState).winxsize,(*pState).winysize,0,0,(*pState).winPix]

widget_control,event.top,set_uvalue = pState,/no_copy
return
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro DTGetPointsWinDraw,event
widget_control,event.top,get_uvalue = pState,/no_copy
case event.type of
0: begin  ; button press
	(*pState).mouse = event.press
	if (*pState).mouse eq 4 then begin	; right click to remove last point
;	  if (*(*pState).dataPtr)[0] ne -999 then begin
	  if n_elements((*(*pState).dataPtr)) gt 2 then begin
	    dataold = *(*pState).dataPtr
	    xold = dataold[0,*]
	    yold = dataold[1,*]
        npts = n_elements(xold)
	    datanew = fltarr(2,npts-1)
	    datanew[0,0:npts-2] = xold[0:npts-2]
	    datanew[1,0:npts-2] = yold[0:npts-2]
	    *(*pState).dataPtr = datanew
	    newpts = npts-1
	    if newpts eq 0 then begin
	      *(*pState).dataPtr = -999
	      newpts = 0
	    endif
	  endif else begin
	    *(*pState).dataPtr =-999
	    newpts = 0
	  endelse
	endif else begin
	  if n_elements((*(*pState).dataPtr)) eq 1 then begin
	    datanew = fltarr(2,1)
	    datanew[0,0] = event.x
	    datanew[1,0] = event.y
        *(*pState).dataPtr = datanew
        newpts = 1
	  endif else begin
	    dataold = *(*pState).dataPtr
	    xold = dataold[0,*]
	    yold = dataold[1,*]
        npts = n_elements(xold)
	    datanew = fltarr(2,npts+1)
	    datanew[0,0:npts] = [xold[*],event.x]
	    datanew[1,0:npts] = [yold[*],event.y]
	    *(*pState).dataPtr = datanew
	    newpts = npts+1
	  endelse
    endelse
    if newpts gt 0 then begin
      widget_control,event.top,set_uvalue = pState,/no_copy
      DTPlot,event
      widget_control,event.top,get_uvalue = pState,/no_copy
    endif
  end
else:
endcase
widget_control,event.top,set_uvalue = pState,/no_copy
return
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro DTGetPoints_event,event
return
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
function DTGetPoints,group_leader = group_leader,imgPtr,limPtr
tlb = widget_base(group_leader = group_leader,/modal,/col,$
                    title = 'Click on desired data points',$
                    /base_align_bottom,/base_align_center)

dimensions = GET_SCREEN_SIZE(RESOLUTION=resolution)
winXsize = 0.90*dimensions[0]
winYsize = 0.85*dimensions[1]
win1 = widget_draw(tlb,xsize = winxsize,ysize = winysize,$
         /button_events,event_pro = 'DTGetPointsWinDraw')

buttonBase = widget_base(tlb,/row,/base_align_center)

void = widget_button(buttonBase,value = 'Finished',$
                     event_pro = 'doneDTGetPoints')
centertlb,tlb
widget_control,tlb,/realize

widget_control,win1,get_value = winVis
imgPosition = [0.0,0.0,1.0,1.0]
loadct,0,/silent
window,/free,/pixmap,xsize = winxsize,ysize = winysize
winPix = !d.window
imgSize = size(*imgPtr)
if imgSize[0] eq 3 then begin
  newImg = congrid(*imgPtr,3,winxsize,winysize)
endif else begin
  newImg = congrid(*imgPtr,winxsize,winysize)
endelse

wset,winPix
tvImage,newImg,position = imgPosition

wset,winVis
device,copy = [0,0,winxsize,winysize,0,0,winPix]

; Define the plotting symbol..a filled circle
theta = findgen(30)/29.*360.
scale = 1.0
xsym = cos(theta * !dtor) * scale
ysym = sin(theta * !dtor) * scale
usersym, xsym,ysym,/fill
dataPtr = ptr_new(/allocate_heap)
*dataPtr = -999
imgPtr = ptr_new(/allocate_heap)
*imgPtr = newImg
state = {winxsize:winxsize,$
         winysize:winysize,$
         imgPtr:imgPtr,$
         winVis:winVis,$
         winPix:winPix,$
         imgPosition:imgPosition,$
         xlo:0.0,$
         ylo:0.0,$
         xhi:0.0,$
         yhi:0.0,$
         xp1:0.0,$
         xp2:0.0,$
         yp1:0.0,$
         yp2:0.0,$
         xLim:[0.0,0.0],$
         yLim:[0.0,0.0],$
         getPoints:0,$
         dataPtr:dataPtr,$
         mouse:0}
pState = ptr_new(state)
widget_control,tlb,set_uvalue = pState
xmanager,'DTGetPoints',tlb,/no_block,cleanup = 'DTCleanup'
return,state.dataPtr
end