; $Id$
;###############################################################################
; LICENSE:
;  The software in this file is written by an employee of
;  National Institute of Standards and Technology
;  as part of the DAVE software project.
;
;  The DAVE software package is not subject to copyright protection
;  and is in the public domain. It should be considered as an
;  experimental neutron scattering data reduction, visualization, and
;  analysis system. As such, the authors assume no responsibility
;  whatsoever for its use, and make no guarantees, expressed or
;  implied, about its quality, reliability, or any other
;  characteristic. The use of certain trade names or commercial
;  products does not imply any endorsement of a particular product,
;  nor does it imply that the named product is necessarily the best
;  product for the stated purpose. We would appreciate acknowledgment
;  if the DAVE software is used of if the code in this file is
;  included in another product.
;
;###############################################################################
; Written by J.R.D. Copley.
;************************************************************************************************
pro readAtWeights,atwts,labels,getfromWeb=getfromWeb
;************************************************************************************************
;
compile_opt strictarr
;
;
if (keyword_set(getfromWeb)) then begin
; Attempt to read atomic weights file from the Web.
	destination = 'physics.nist.gov'
	source = destination+'/cgi-bin/Compositions/stand_alone.pl?ele=&ascii=ascii2&isotype=some'
	cmd = 'GET http://'+source
	socket, unit, destination, 80, /get_lun, error=error
	if (error eq 0) then begin
		printf, unit, cmd
	endif else begin
		message=['Unsuccessful attempt to read atomic weights from the Web.',$
			'File name '+strmid(cmd,4),!error_state.msg,$
			' ','Do you wish to specify a file containing atomic weights?']
		res=dialog_message(message,/question)
		if (res eq "No") then begin
			getfromWeb=-99
			return
		endif else begin
			inputfile=dialog_pickfile(file='AtomicWeights.dat')
;			inputfile=dialog_pickfile(file='C:\dave_cvs\dave\programs\auxiliary\AtomicWeights.dat')
			if (inputfile eq '') then begin
				getfromWeb=-100
				return
			endif
			openr,unit,inputfile,/get_lun
		endelse
	endelse
endif else begin
;
; Alternatively read in Atomic Weights file (from http://physics.nist.gov/PhysRefData/Compositions/).
  defsysv,'!DAVE_AUXILIARY_DIR',exists=exists
  if (exists) then begin
	  inputfile = !DAVE_AUXILIARY_DIR+'AtomicWeights.dat'
	endif else begin
		message=['Unable to determine default atomic weights file name.',$
			' ','Do you wish to specify a file containing atomic weights?']
		res=dialog_message(message,/question)
		if (res eq "No") then begin
			getfromWeb=-98
			return
		endif else begin
			inputfile=dialog_pickfile(file='AtomicWeights.dat')
;			inputfile=dialog_pickfile(file='C:\dave_cvs\dave\programs\auxiliary\AtomicWeights.dat')
			if (inputfile eq '') then begin
				getfromWeb=-100
				return
			endif
		endelse
  endelse
	openr,unit,inputfile,/get_lun
endelse
;
; Determine number of information entries.  Stop at Cm.
content=''
contents=''
nentries=0
nelements=0
match_string='Atomic Number ='
atno0=' 0'
while (not eof(unit)) do begin
	readf,unit,content
	if (strpos(content,match_string) ne -1) then begin
		atno=strmid(content,strpos(content,'=')+1)
		if (atno eq ' 97') then break
		if (atno ne atno0) then begin
			atno0=atno
			nelements=nelements+1
		endif
		contents=[contents,content]
		readf,unit,content
		contents=[contents,content]
		readf,unit,content
		contents=[contents,content]
		readf,unit,content
		contents=[contents,content]
		readf,unit,content
		contents=[contents,content]
		readf,unit,content
		contents=[contents,content]
		readf,unit,content
		contents=[contents,content]
		readf,unit,content
		contents=[contents,content]
		nentries=nentries+1
	endif
endwhile
free_lun,unit
;print,'There are',nelements,' elements.'
;print,'There are',nentries,' information entries.'
;
; Read each entry and extract atomic number, atomic symbol, mass number, isotopic mass and elemental mass.
; Replace letters D and T with H.
; Remove square brackets around elemental masses of high mass number elements.
; Remove parentheses representing errors.
;
nlines=nelements+nentries
atwts={$
	atno:strarr(nlines),$; e.g. 1
	atsym:strarr(nlines),$; e.g. H
	msno:strarr(nlines),$; e.g. 1
	isosym:strarr(nlines),$; e.g. 1H
	isomass:strarr(nlines),$; e.g. 1.0078250321(4)
	isoconc:strarr(nlines),$; e.g. 99.9885(70) or 100 or blank
	atmass:strarr(nlines)}; e.g. 1.00794(7) or [210]
;
atno0=0
j=0
format='(f9.3)'
for k=0,nentries-1 do begin
	content=contents[k*8+1]
	atno=strmid(content,strpos(content,'=')+1)
	if (atno eq ' 97') then break
	atwts.atno[j]=atno
;
	content=contents[k*8+2]
	atsym=strmid(content,strpos(content,'=')+1)
	if (atsym eq ' D' or atsym eq ' T') then atsym=' H'
	atwts.atsym[j]=atsym
;
	content=contents[k*8+3]
	msno=strmid(content,strpos(content,'=')+1)
	atwts.msno[j]=msno
;
	atwts.isosym[j]=strcompress(msno)+strtrim(atsym,2)
;
	content=contents[k*8+4]
	isomass=strmid(content,strpos(content,'=')+1)
	atwts.isomass[j]=string(float(isomass),format=format)
;
	content=contents[k*8+5]
	isoconc=strmid(content,strpos(content,'=')+1)
	if (strcompress(isoconc) eq '' or strcompress(isoconc) eq ' ') then isoconc='0.0'
	atwts.isoconc[j]=string(float(isoconc),format=format)
;
	content=contents[k*8+6]
	atmass=strmid(content,strpos(content,'=')+1)
	pos1=strpos(atmass,'[')+1
	pos2=strpos(atmass,']')
	if (pos1 ne 0) then atmass=' '+strmid(atmass,pos1,pos2-pos1)
	atwts.atmass[j]=string(float(atmass),format=format)
;
	for m=4,6 do begin
		pos=strpos(atwts.(m)[j],'(')
		if (pos ne -1) then atwts.(m)[j]=strmid(atwts.(m)[j],0,pos)
	endfor
	if (atno ne atno0) then begin
		j=j+1
		atwts.atno[j]=atwts.atno[j-1]
		atwts.atsym[j]=atwts.atsym[j-1]
		atwts.msno[j]=atwts.msno[j-1]
		atwts.isosym[j]=atwts.isosym[j-1]
		atwts.isomass[j]=atwts.isomass[j-1]
		atwts.isoconc[j]=atwts.isoconc[j-1]
		atwts.atmass[j]=atwts.atmass[j-1]
		atwts.msno[j-1]='0'
		atwts.isosym[j-1]=' nat-'+strtrim(atwts.atsym[j-1],2)
		atwts.isomass[j-1]=atwts.atmass[j-1]
		atwts.isoconc[j-1]='100.0'
		atno0=atno
	endif
	j=j+1
endfor
free_lun,unit
;
labels=['At No','At Symb.','Mass No','Symbol','Isomass','Abund','At Mass']
;
end
