pro loadStressData, group_leader = group_leader, workDir=workDir, dataDir=dataDir, _EXTRA=etc

catch, theError
if (theError ne 0) then begin
   catch, cancel
   status = fstat(lun)
   if (status.open) then free_lun, lun, /force
   
   msg = 'File I/O error'
   void = dialog_message(msg,/error,dialog_parent=group_leader)

   return
endif

title = 'Select stress data file to read'
filters = ['*.txt']
filename = dialog_pickfile(filter=filters,dialog_parent=group_leader $
             ,/must_exist,path=workDir,title=title)
if (filename eq '') then return

openr, lun, filename, /get_lun

n = file_lines(filename)
if (n le 2) then return

buf = strarr(n)
readf, lun, buf
status = fstat(lun)
if (status.open) then free_lun, lun, /force

data = fltarr(n,4)
label = ['I','dI','X','Y']
unit   = ['','','','']
instrument = 'Stress Data'

toks = strtrim(strsplit(buf[0],/extract,',',count=ntoks),2)
if (ntoks eq 4) then label = [toks[2],toks[3],toks[0:1]]

j = 0
for i=1,n-1 do begin
   toks = strsplit(buf[i],/extract,',',count=ntoks)
   if (ntoks eq 4) then begin
      toks = float(toks)
      err = toks[3]
      if (err le 0.0) then err = 1.0
      data[j++,*] = [toks[2],toks[3],toks[0:1]]
   endif
endfor

data = data[0:j-1,*]

dataPtr = ptr_new({data:temporary(data),label:label,unit:unit,instrument:instrument,is_uniq:[0,0,1,1]})
;obj_mslice = obj_new('dcs_mslice',dataPtr=dataPtr)
;or 
dcs_mslice,dataPtr=dataPtr,obj_mslice=obj_mslice $
            ,group_leader = group_leader, workDir=workDir $
            ,dataDir=dataDir, _EXTRA=etc
 
;obj_mslice->reset_data,data=data,label=label,/no_copy
;help,data

end