


;$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$
pro readBT1Test_readHeader, lun,mon,prf,base,npts,DRSF,DRZA,data,$
                            lambda,Tstart,Tinc,H,ndet,M4start,M4step,M4end

  ;READ THE HEADER
  line = ''
  for i = 0,16 do begin
    ;print,i
    readf,lun,line
    ;print,'line'+string(i)
    ;print,line
    segs = strsplit(line,/extract)

    ;GET npts, prf, mon, base
    if i eq 0 then begin
      mon = float(segs[10])
      prf = float(segs[11])
      base = segs[12]
      npts = fix(segs[13])
      ;print,'mon,prf,base,npts=',mon,prf,base,npts
      
      DRSF = findgen(npts)
      DRZA = findgen(npts)
      ;NOW I NEED AN ARRAY OF STRUCTURES, ONE FOR EACH DETECTOR
      ;THEN INTERPOLATE THEM ONTO THE REGULAR ARRAY OF TTH VALUES
      ;COMMON TO ALL OF THE DETECTORS
      s = {  tth:fltarr(npts),$
             tth_interp:fltarr(npts),$
             Iunscaled  :fltarr(npts),$
             I  :fltarr(npts),$  ;DATA AT INTERPOLATED X VALUES
             sI :fltarr(npts),$  ;UNCERTAINTIES AT INTERPOLATED X VALUES
             DRSF:1.0,$
             DRZA:1.0,$
             mon:1.0,$
             prf:1.0,$
             base:'NEUT',$
             npts:0,$
             wavelength:1.5403,$
             T      :fltarr(npts),$
             C      :fltarr(npts),$
             N      :fltarr(npts),$
             H      :fltarr(npts),$
             index  :findgen(npts),$
             M4     :fltarr(npts),$
             nptsActual:0}

    endif;line 1

    ;GET lambda,tstart, H, ndet 
    if i eq 3 then begin
print,'segs=',segs
      lambda = float(segs[7])
      Tstart = float(segs[8])
      Tinc = float(segs[9])
      H = float(segs[10])
      ndet = fix(segs[11])
      ;print,'npts,lambda,Tstart,Tinc,H,ndet=',npts,lambda,Tstart,Tinc,H,ndet

      ;CREATE ARRAYS FOR THE RDRSF AND DRZA
      drsf = fltarr(ndet)
      drza = fltarr(ndet)
      ;CREATE AN ARRAY OF STRUCTURES
      data = replicate(s,ndet)

    endif;line 4

    ;GET M4 Start, step, end
    if i eq 6 then begin
      M4start = float(segs[1])
      M4step  = float(segs[2])
      M4end   = float(segs[3])
      ;print,'M4start,step,end=',m4start,m4step,m4end
    endif;line 7

    ;GET THE Detector Relative Scale Factors
    if i eq 7 then begin
      
      ;READ IN THE drsf DIRECTLY INTO NUMERICAL FORMAT SO THE LINE NUMBERS ARE NOT AN ISSUE
      readf,lun,drsf
      i = 10  ;SET i TO THE VALUE OF THE EXPECTED POSITION IN CASE THE FORMAT 
              ;OR NUMBER OF DETECTORS SHIFTS THE LINE NUMBERS ON ME 
    endif;line 8ff

    ;GET THE Detector Relative Zero Angles
    if i eq 11 then begin
      ;READ IN THE drza DIRECTLY INTO NUMERICAL FORMAT SO THE LINE NUMBERS ARE NOT AN ISSUE
      readf,lun,drza
      i = 14  ;SET i TO THE VALUE OF THE EXPECTED POSITION IN CASE THE FORMAT 
              ;OR NUMBER OF DETECTORS SHIFTS THE LINE NUMBERS ON ME 
    endif;line 13ff



  endfor;i
end;readBT1Test_readHeader

;$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$
pro readBT1Test_setDRSF_DRZA,data,drsf,drza,M4Start,M4Step,npts,ndet

  catch,es
  if es ne 0 then  begin
    print,'In readBT1Test_setDRSF_DRZA:'
    print,'  Error status:    ',es
    print,'  Error message:   ',!error_state.msg
    print,'  DATA NOT SET!!!!!'
    catch,/cancel
    return
  endif;CATCH


  if n_elements(ndet) eq 0 then ndet = n_elements(data)

  
  ;DRZA IN CENTI-DEGREES
  DRZAFactor = 0.01

  ;PUT THE SF AND RA INTO THE DATA STRUCTURES
  for i = 0,ndet-1 do begin
  
    ;STORE THE SCALE FACTORS AND OFFSETS IN THE DATA STRUCTURES
    data[i].drsf = drsf[i]
    data[i].drza = drza[i]
    
    
    ;SET THE ACTUAL 2THETA VALUES
    data[i].tth = M4start + i*5.0  + findgen(npts)*M4Step - drza[i]*DRZAFactor

    ;SET THE 2THETA VALUES FOR INTERPOLATION
    data[i].tth_Interp = M4start + i*5.0 + findgen(npts)*M4Step
  endfor;i

end;readBT1Test_setDRSF_DRZA


;$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$
pro readBT1Test_InterpolateData,data,ndet

  ;NOW INTERPOLATE THE POINTS AND GET OUT
  for k=0,ndet-1 do begin

    x0   = data[k].TTH
    xnew = data[k].TTH_interp
    y    = data[k].Iunscaled
    ynew = interpol(y,x0,xnew,/spline)
    data[k].I = ynew*data[k].drsf
    data[k].sI = sqrt(ynew)*data[k].drsf

    ;WHERE DO I SCALE BY MONITOR AND PREFACTOR??????????????????????????????????????????????????????
    ;STORE THEM AND PROVIDE THEM TO THE FINAL COMBINATION METHOD - WHICH WILL HANDLE A SINGLE FILE.

    ;ALSO, HOW DO I SCALE OVERLAPPING POINTS?
    ;ONCE THE INTERPOLATION IS COMPLETE, THERE SHOULD BE COMMON X AXES. 
  endfor;k

end;readBT1Test_InterpolateData

;$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$
pro readBT1Test_ReadData,lun,data,npts,ndet,nptsActual,H

  ;SET H since the field is available only once in the file.
  if n_elements(H) eq 0 then H = 0.0

  line = ''
;  AN ARRAY OF FLOATS  
  a = fltarr(ndet)

  for j = 0,npts-1 do begin

    
    ;READ IN THE POINT INFO LINES AND EXTRACT INFORMATION
    readf,lun,line
    if (stregex(line,'Stat Fail:',/fold_case,/boolean)) then readf,lun,line ; Occassinally, there is an extra line in the datafile to report
                                                                            ; an error. When this is present, simply discard it and
                                                                            ; read the next line.
    segs = strsplit(line,'=',/extract)
    ;print,segs
    ssegs = strsplit(segs[1],/extract)
    ;print,'ssegs[0]=',ssegs[0]
    ;print,'line=',line
    M4 = float(ssegs[0])

    ssegs = strsplit(segs[2],/extract)
    T = float(ssegs[0])
    ;print,M4,T

    ssegs = strsplit(segs[3],/extract)
    C = float(ssegs[0])
    ;print,M4,T

    ssegs = strsplit(segs[4],/extract)
    N = float(ssegs[0])
    ;print,'j,M4,T,N,npts=',j,M4,T,N,npts

    ;READ THE SECOND LINE WITH 4 VALUES (WHAT ARE THESE, THE "N" VALUES?)
    readf,lun,line
    ;print,line  
      
    ;NOW READ THE COUNTS
    readf,lun,a
    ;print,a

    ;UPDATE CURRENT nPtsActual FOR THE TOTAL NUMBER OF POINTS ACTUALLY COLLECTED
    nptsActual = j+1

    ;Place DATA in THE ARRAY
    data[*].Iunscaled[j] = a
    data[*].T[j] = T
    data[*].C[j] = C
    data[*].N[j] = N
    data[*].H[j] = H
    data[*].M4[j] = M4
    data[*].nptsActual = nptsActual ; <== makes no sense! Why have a running update?
;    for k=0,ndet-1 do begin
;      data[k].Iunscaled[j]  = a[k];*data[k].drsf
;      ;data[k].sI[j] = sqrt(a[k])*data[k].drsf
;      data[k].T[j] = T
;      data[k].C[j] = C
;      data[k].N[j] = N
;      data[k].H[j] = H
;      data[k].M4[j] = M4
;      data[k].nPtsActual = nptsActual
;    endfor;k
  endfor;j
end;readBT1Test_readData

;$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$
pro readBT1Test_GetXValues,data,ndet,xcommon

  ;GET ALL THE X VALUES
  xcommon = data[0].TTH_interp
  for i=1,ndet-1 do begin
    ;GET THE TTH_INTERP
    x1 = data[i].TTH_interp

    ;CHECK FOR THE OVERLAP  
    for j=0,n_elements(x1)-1 do begin

      ;wh = where(x1[j] eq xcommon,count)
      wh = where(abs(x1[j] - xcommon) lt 0.0001,count)
      ;APPEND THE x VALUE IF NOT ALREAD IN THE ARRAY
      if count eq 0 then begin
        xcommon = [xcommon,x1[j]]
      endif
    endfor;j
    ;void = dialog_message('continue?',/question)
  endfor;i

end;readBT1Test_GetXValues

;$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$
pro readBT1Test_MergeDetectors, data,ndet,xcommon,nptsActual,$
                                IAll,sIAll,Tave,Cave,Nave,Have
;print,'readBT1Test_MergeDetectors'  
  ;NOW CALCULATE THE AVERAGES FOR EACH OF THE AVAILABLE POINTS.
  Iall  = fltarr(n_elements(xcommon))
  sIall = fltarr(n_elements(xcommon))
  for i=0,n_elements(xcommon)-1 do begin
    x1 = xcommon[i]
    n = 0.0
    tot = 0.0
    stot = 0.0
    for j=0,ndet-1 do begin
      wh = where(abs(data[j].TTH_interp - x1) le 0.0001,count)
      if count ne 0 then begin
        tot += data[j].I[wh[0]]
        stot += data[j].I[wh[0]];=(sqrt(data[j].I[wh[0]]))^2
        n++
      endif 
    endfor;j
    Iall[i] = tot/n
    sIall[i] = sqrt(stot)/n
  endfor;i
  Tave = total(data[0].T[*])/float(nptsActual)
  Cave = total(data[0].C[*])/float(nptsActual)
  Nave = total(data[0].N[*])/float(nptsActual)
  Have = total(data[0].H[*])/float(nptsActual)

end;readBT1Test_MergeDetectors


;$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$
pro readBT1Test_SelectYValue,Tave,Cave,Nave,Have,myIndex,$
                             yval,ylabel,yunits,$
                             tVar=tVar,nVar=nVar,hVar=hVar,cVar=cVar,indexVar=indexVar

  if n_elements(tVar) eq 0 then tVar = 0
  if n_elements(hVar) eq 0 then hVar = 0
  if n_elements(nVar) eq 0 then nVar = 0
  if n_elements(cVar) eq 0 then cVar = 0
  if n_elements(indexVar) eq 0 then indexVar = 0
;  print,'readBT1Test_SelectYValue    myIndex=',indexVar,myIndex,Tave,Cave,Nave,Have

  ;IF NO Y VALUES CHOSEN THEN USE A DEFAULT INDEX NUMBER.
  if tVar eq 0 and $
     nVar eq 0 and $
     hVar eq 0 and $
     cVar eq 0 and $
     indexVar eq 0 then indexVar = 1

  if indexVar eq 1 then begin
    yval = myIndex
    ylabel = 'Index'
    yunits = 'Index'
    return
  endif
  
  if (tVar) then begin
    yVal = Tave
    yLabel = 'Temperature'
    yunits = 'K'
    return
  endif
  
  if (hVar) then begin
    yVal = Have
    yLabel = 'H Field'
    yunits = 'mT'
    return
  endif

  if (cVar) then begin
    yVal = Cave
    yLabel = 'C'
    yunits = ''
    return
  endif

end;readBT1Test_GetYValue

function readBT1Test_ConvertOneBT1File_PROCESS_DATA,davePtr,data,ndet,xcommon,nptsActual,$
                                                    IAll,sIAll,TAve,CAve,NAve,MyIndex,$
                                                    yVal,yLabel,yUnits,$
                                                    tVar=tVar,nVar=nVar,hVar=hVar,cVar=cVar,$
                                                    indexVar=indexVar
  ;THIS WILL BE CALLED FROM THE CATCH STATEMENT IN THE CASE OF AN ERROR
  ;OR FROM THE SUCCESSFUL BRANCH.
  readBT1Test_InterpolateData,data,ndet
  readBT1Test_GetXValues,data,ndet,xcommon
  readBT1Test_MergeDetectors, data,ndet,xcommon,nptsActual,$
                              IAll,sIAll,Tave,Cave,Nave,Have
  ;help,Iall,sIall,xcommon,Tave,Cave,Nave,Have
  readBT1Test_SelectYValue,Tave,Cave,Nave,Have,myIndex,$
                           yval,ylabel,yunits,$
                           tVar=tVar,nVar=nVar,hVar=hVar,cVar=cVar,indexVar=indexVar
  ;LRK - 08/17/09
  ;INITIALIZE POINTER SO WE ARE NOT OVERWRITING A POINTER THAT WAS PASSED IN.
  davePtr = ptr_new()
  ret = create_dave_pointer(daveptr,$
                            instrument='BT1',$
                            qty = Iall,$
                            QTUnits = 'Counts',$
                            QTLabel = 'Intensity',$
                            err = sIall,$
                            xvals = xcommon,$
                            xunits = '$\deg$',$
                            xlabel = '2$\theta$',$
                            yvals = yval,$;Tave,$
                            ylabel = ylabel,$;'Temperature',$
                            yunits = yunits, $
                            specificStr = {T:Tave,C:Cave,N:Nave,H:Have,myIndex:myIndex})
;  (*(*daveptr).datastrptr).commonstr.yunits = yunits
;  (*(*daveptr).datastrptr).commonstr.ylabel = ylabel
;  *(*(*daveptr).datastrptr).commonstr.treatmentptr = treatment

  return,1
end;readBT1Test_ConvertOneBT1File_PROCESS_DATA

;function readBT1Test_convertGSASFiles,fn,workdir=workdir,$
;                                     defaultoutputfile=defaultoutputfile,$
;                                     threeColASCII=threeColASCII,$
;                                     davetool=davetool
;;  fn = 'C:\Documents and Settings\kneller\Desktop\DAVECode061808\dave_devel\programs\modules\TAS\crs_combine\Data\pawel\Al6kb004.gsas'
;  if n_elements(threeColASCII) eq 0 then threeColASCII = 0
;  if n_elements(defaultoutputfile) eq 0 then defaultoutputfile = 1
;
;  s = ''
;;  print,n_elements(fn)
;
;  for i=0,n_elements(fn)-1 do begin
;  
;            openr,lun,fn[i],/get_lun
;
;
;;GET THE HEADER          
;            readf,lun,s
;          ;  print,s
;            comment = s
;          ;  print,'Comment = '+comment
;          
;            readf,lun,s
;          ;  print,s
;            segs = strsplit(s,':',/extract)
;          ;  print,segs[1]
;            instrumentFile = segs[1]
;          ;  print,'Instrument file = '+instrumentFile
;
;            readf,lun,s
;            segs = strsplit(s,/extract)
;          ;  print,segs
;          
;            bank = fix(segs[1])
;            npts = fix(segs[2])
;            dnw1 = fix(segs[3])
;            astart = double(segs[5])/100.0
;            astep  = double(segs[6])/100.0
;            dnw2 = fix(segs[7])
;            dnw3 = fix(segs[8])
;            type = strupcase(segs[9])
;;GET THE DATA          
;            if type eq 'ESD' then begin
;              data = dblarr(2*npts)
;            endif else begin
;              ;'STD' DATA
;              data = dblarr(npts)
;            endelse
;          
;            readf,lun,data
;            free_lun,lun
;          
;            tth = astart + findgen(npts) * astep
;          
;            if type eq 'ESD' then begin
;              qty = data[2*indgen(npts)]
;              err = data[2*indgen(npts)+1]
;            endif else begin
;              ;'STD' DATA
;              qty = data
;              err = sqrt(data)
;            endelse
;          
;
;;CREATE THE DAVEPTR            
;
;            duh = create_dave_pointer(davePtr,instrument='BT1/GSAS',$
;                                               qty=qty,$
;                                               err=err,$
;                                               QTUnits='Counts',$
;                                               QTLabel='Intensity',$
;                                               xLabel='Two Theta',$
;                                               xunits='Degrees',$
;                                               xvals=tth,$
;                                               yvals=0.0,$
;                                               ylabel='',$
;                                               yunits='',$
;                                               specificStr={comment:comment,instrumentFile:instrumentFile})
;
;;ADD TO DAVETool IF AVAILABLE
;            if obj_valid(DAVETool) gt 0 then begin
;              DAVETool->AddDavePtrToDataManager, davePtr, file_basename(fn[i])
;            endif
;
;;NOW WRITE TO ASCII OR DAVE FILE
;        ;NOW FOR WRITING THE FILES:
;            if threeColASCII eq 0 then begin
;              
;    
;              if defaultoutputfile eq 1 then begin
;                filename = file_basename(fn[i])
;                readbt1Test_addDotDave,filename
;                filename = workdir+path_sep()+filename
;              endif else begin
;            
;                filename = dialog_pickfile(/write,$
;                                      title='BT-1 DAVE export file'+file_basename(fn[i])+': ',$
;                                      path=workdir,$
;                                      /overwrite_prompt,$
;                                      dialog_parent=parent,$
;                                      filter='*.dave')
;              endelse                              
;    
;              if filename ne '' then begin
;                readbt1Test_addDotDave,filename
;                testfile = file_info(filename)
;                save,filename=filename,davePtr
;                void = dialog_message('Wrote: '+filename,/info)
;              endif
;            endif else begin ;threeColASCII 
;    
;    
;              if defaultoutputfile eq 1 then begin
;                filename = file_basename(fn[i])
;;print,filename
;                readbt1Test_addDotTXT,filename
;;print,filename
;                txtfilename = workdir+path_sep()+filename
;              endif else begin
;            
;      
;                txtfilename = dialog_pickfile(/write,$
;                                    title='BT-1 ASCII export file'+file_basename(fn[i])+': ',$
;                                    path=workdir,$
;                                    /overwrite_prompt,$
;                                    dialog_parent=parent,$
;                                    filter='*.txt')
;              endelse
;              if txtfilename ne '' then begin
;                readbt1Test_addDotTXT,txtfilename
;                testfile = file_info(txtfilename)
;                readbt1Test_writeASCII,davePtr,txtfilename
;                void = dialog_message('Wrote: '+txtfilename,/info)
;              endif;txtfilename
;            endelse;threeColASCII
;
;
;  endfor;i
;
;
;  ;save,davePtr,filename=ofn
;  return,1
;end;readBT1Test_convertGSASFiles

;$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$
function readBT1Test_ConvertOneBT1File,davePtr,fn = fn,data=data,tVar=tVar,nVar=nVar,hVar=hVar,cVar=cVar,indexVar=indexVar,myIndex=myIndex
  if n_elements(myIndex) eq 0 then myIndex = 0
  ;print,'readBT1Test_ConvertOneBT1File    myIndex=',myIndex

  ;_________________________________________________________________
  ;CATCH STATEMENT : NOTE THAT THIS HAS TO COMPLETE HE CREATION OF 
  ;                  THE DAVE POINTER, BUT THE CREATION PROCESS HAS TO
  ;                  BE IDENTICAL TO THE CREATION PROCESS WITHOUT THE 
  ;                  HANDLED ERROR.  THAT MEANS THAT THE PROCESS HAS TO 
  ;                  OCCUR IN TWO PLACES!!!!! 
  ;_________________________________________________________________
  ;
  catch,es
  if es ne 0 then  begin    
    print,'Error status:    ',es
    print,'Error message:   ',!error_state.msg
    print,'ERROR HANDLED'
    catch,/cancel
    free_lun,lun
    duh = readBT1Test_ConvertOneBT1File_PROCESS_DATA(davePtr,data,ndet,xcommon,nptsActual,$
                                                     IAll,sIAll,TAve,CAve,NAve,MyIndex,$
                                                     yVal,yLabel,yUnits,$
                                                     tVar=tVar,nVar=nVar,hVar=hVar,cVar=cVar,$
                                                     indexVar=indexVar)
    return,0
  endif;CATCH
  ;_________________________________________________________________


  if n_elements(fn) eq 0 then begin
    fn = dialog_pickfile(filter='*.bt1',path = '\\Charlotte\icp data\bt1\200806\spoulton\')
  ;  print,fn
  ;fn = '\\Charlotte\icp data\bt1\200806\spoulton\MoOPO058.bt1'
  endif
  nlines = file_lines(fn)

  line = ''

  openr,lun,fn,/get_lun
  
  readBT1Test_readHeader, lun,mon,prf,base,npts,DRSF,DRZA,data,$
                          lambda,Tstart,Tinc,H,ndet,M4start,M4step,M4end

  readBT1Test_setDRSF_DRZA,data,drsf,drza,M4Start,M4Step,npts,ndet

  readBT1Test_ReadData,lun,data,npts,ndet,nptsActual,H

  free_lun,lun
;print,'readBT1Test_ConvertOneBT1File    tVar,nVar,hVar,cVar,indexVar,myIndex=',tVar,nVar,hVar,cVar,indexVar,myIndex
  duh = readBT1Test_ConvertOneBT1File_PROCESS_DATA(davePtr,data,ndet,xcommon,nptsActual,$
                                                   IAll,sIAll,TAve,CAve,NAve,MyIndex,$
                                                   yVal,yLabel,yUnits,$
                                                   tVar=tVar,nVar=nVar,hVar=hVar,cVar=cVar,$
                                                   indexVar=indexVar)

;  
;  help,(*(*(*davePtr).dataStrPtr).specificPtr).T
;  help,(*(*(*davePtr).dataStrPtr).specificPtr).C
;  help,(*(*(*davePtr).dataStrPtr).specificPtr).N
;  help,(*(*(*davePtr).dataStrPtr).specificPtr).H
;  
;  window,0
;  plot,xvals,qtyvals;,yrange=[0,3400],xrange=[0,1400];,xrange=[40,70],yrange=[0,200]
;  for i = 0,ndet-1 do begin
;    color = 200L + (i mod 2)*55L + (i mod 3)*255L*256L; + (i mod 4)*255L*256L*256L
;    oplot,data[i].TTH_Interp,data[i].I,color = color
;    ;print,i,color
;  endfor;i
;  ;print,max(xvals)
;;  void = dialog_message('continue?',/question) 
;;  oplot,xvals
  
  return,1
end;readBT1Test_ConvertOneBT1File

;$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$
function readbt1Test_getExt,s,iext=iext,len=len
        iext = strpos(s,'.',/reverse_search)

        if iext ne -1 then begin
            len  = strlen(s)
            ext  = strmid(s,iext+1,len-iext)
        endif else begin
            ext = ''
        endelse
        return,ext

end;readbt1Test_getExt

;$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$
pro readbt1Test_addDotDave,ofn

        ext = readbt1Test_getExt(ofn,iext=iext,len=len)
        if ext ne 'dave' then begin
            if iext gt 0 then begin
                sublen=len-iext
                ;print,'ofn before=',ofn

                ;void = dialog_message('BEFORE strendsub call')
                ofn = strendsub(ofn,'.dave',sublen)
                ;void = dialog_message('AFTER strendsub call')

                ;print,'ofn after=',ofn
            endif else begin
                ofn = ofn+'.dave'
            endelse
        endif

end;readbt1Test_addDotDave
;$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$
pro readbt1Test_addDotTXT,ofn

        ext = readbt1Test_getExt(ofn,iext=iext,len=len)
        if ext ne 'txt' then begin
            if iext gt 0 then begin
                sublen=len-iext
                ;print,'ofn before=',ofn

                ;void = dialog_message('BEFORE strendsub call')
                ofn = strendsub(ofn,'.txt',sublen)
                ;void = dialog_message('AFTER strendsub call')

                ;print,'ofn after=',ofn
            endif else begin
                ofn = ofn+'.txt'
            endelse
        endif

end;readbt1Test_addDotTXT

pro readbt1Test_writeASCII,davePtr,filename

  ;FOR THIS FIRST PASS ASSUME 1d DATA
  tth = (*((*(*davePtr).datastrptr).commonstr).histptr).x
  qty = (*((*(*davePtr).datastrptr).commonstr).histptr).qty
  err = (*((*(*davePtr).datastrptr).commonstr).histptr).err
  npts = n_elements(tth)

  openw,lun,filename,/get_lun
  for i=0,npts-1 do begin
    printf,lun,tth[i],qty[i],err[i],format='(3g15.7)'
  endfor;i

  free_lun,lun

end;readbt1Test_writeASCII



;$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$
pro readBT1Test_CombineDavePtr,pArr,CombinedDAVEPtr, fileArr

  catch,es
  if es ne 0 then begin

    print,"readBT1Test_CombineDavePtr:  DATA DIDN'T COMBINE!"
    catch,/cancel
    return
  endif

  ;print,'readBT1Test_CombineDavePtr'

  ny = n_elements(pArr)

  if ny eq 1 then begin
    ;THIS WILL TAKE CARE OF 1D ARRAYS WITHOUT DEALING WITH THEM DIRECTLY
    CombinedDAVEPtr = pArr[0]
  endif else begin
  
                ;ORDER ARRAY BY Y VALUE - IF ALL THE SAME (e.g. Index = 0) THEN ALPHABETIZE
              ;  help,(xvals = (*((*(*davePtr).dataStrPtr).commonstr).histptr).x)
              ;  help,(*((*(*davePtr).dataStrPtr).commonstr).histptr).y
              ;  help,(qtyvals = (*((*(*davePtr).dataStrPtr).commonstr).histptr).QTY)
              ;  help,(*((*(*davePtr).dataStrPtr).commonstr).histptr).ERR
                y = fltarr(ny)
                for i = 0, ny-1 do begin
                  dPtr = pArr[i]
                  y[i] = (*((*(*dPtr).dataStrPtr).commonstr).histptr).y
                endfor;i

                ;SORT THE DAVEPtr's BASED ON THE YVALUES.
                ;THE ASSUMPTION IS THAT THEY DO NOT COME INTO THE METHOD IN ORDER.
                sorty = sort(y)
;print,'y=',y
;print,'sort(y) =',sorty
                pArr = pArr[sorty]
               
                ;CHECK FOR GOOD DATA 
                ;CHECK THAT ALL DATA HAVE THE SAME NUMBER OF POINTS.  IF NOT
                ;TRY TO MATCH RANGES TO THE DATA WITH THE MOST POINTS.
                ;
                ;TRYING TO FILL IN COMPLETE RANGE IS DOABLE, BUT WILL PROBABLY 
                ;RESULT IN A CRAPPY APPEARANCE GIVEN THE PURPOSE OF VISUALIZATION FOR
                ;BT1.

                ;GET THE npts FOR THE ORDERED ARRAY
                npts = fltarr(ny)
                for i = 0, ny-1 do begin
                  dPtr = pArr[i]
                  npts[i] = n_elements((*((*(*dPtr).dataStrPtr).commonstr).histptr).x)
                endfor;i
;                print,'npts=',npts
              
                ;NOW I HAVE AN ARRAY OF POINTERS ORDERED BY Y VALUE, AND I KNOW HOW MANY 
                ;X VALUES ARE IN EACH POINTER.
                ;
                ;UNLESS I AM GOING TO MAKE A COMPLETE SET OF X VALUES, I HAVE TO 
                ;MAKE AN ASSUMPTION ABOUT WHICH SET OF X VALUES TO USE.
                ;
                ;ASSUME THAT THE LONGEST SET IS THE COMPLETE ONE. 
              
                nmax = max(npts,maxindex,min=nmin)
;                print,'nmax,nmin=',nmax,nmin
                if nmax ne nmin then begin
                  void = dialog_message(['readBT1Test_CombineDavePtr:  Data sets have different numbers of points.',$
                                         'readBT1Test_CombineDavePtr:  Combined results may not be correct.'])
                endif

                ;CREATE SINGLE X,Y,QTY ERR ARRAYS
                dPtr = pArr[maxindex]
                x = (*((*(*dPtr).dataStrPtr).commonstr).histptr).x
                nx = n_elements(x)

                QTY = fltarr(nx,ny)
                ERR = fltarr(nx,ny)
                t = fltarr(ny)  
                c = fltarr(ny)
                n = fltarr(ny)
                h = fltarr(ny)
                myindex = fltarr(ny)

                ;COMBINE THE ORDERED ARRAYS
                for i = 0,ny-1 do begin
;print,i
                  dPtr = pArr[i]
;        help,pArr[i],dptr
                  t[i] = (*(*(*dPtr).dataStrPtr).specificPtr).t
                  c[i] = (*(*(*dPtr).dataStrPtr).specificPtr).c
                  n[i] = (*(*(*dPtr).dataStrPtr).specificPtr).n
                  h[i] = (*(*(*dPtr).dataStrPtr).specificPtr).h
                  myindex[i] = (*(*(*dPtr).dataStrPtr).specificPtr).myIndex
              
                  if npts[i] eq nx then begin
;print,'npts[i] eq nx'
;help,dptr
                    xvals = x
                    QTY[*,i] = (*((*(*dPtr).dataStrPtr).commonstr).histptr).qty
                    ERR[*,i] = (*((*(*dPtr).dataStrPtr).commonstr).histptr).err
                  endif else begin
                    ;IF THE NUMBER OF POINTS IS NOT THE SAME, THEN I HAVE TO 
                    ;TRY TO PLACE THEM IN THE RIGHT PLACE HERE.
                    ;FIRST PASS, PUT THE IN THE LOWEST X VALUE POSITIONS
;print,'npts[i] ne nx'
;help,dptr
                    xvals = (*((*(*dPtr).dataStrPtr).commonstr).histptr).x
;                    print,'min(xvals),max(xvals)=',min(xvals),max(xvals)


;LRK - 08/17/09
;THIS NEXT STATEMENT SHOVES EVERYTHING TO THE LEFT!!!!!
;IS THAT WHAT WE WANT???????

                    QTY[0:npts[i]-1,i] = (*((*(*dPtr).dataStrPtr).commonstr).histptr).qty
                    ERR[0:npts[i]-1,i] = (*((*(*dPtr).dataStrPtr).commonstr).histptr).err

                  endelse
                endfor;i

                specificStr = {T:t,C:c,N:n,H:h}
                xlabel = ((*(*dPtr).dataStrPtr).commonstr).xlabel  
                ylabel = ((*(*dPtr).dataStrPtr).commonstr).ylabel
                xtype = ((*(*dPtr).dataStrPtr).commonstr).xtype  
                ytype = ((*(*dPtr).dataStrPtr).commonstr).ytype
                xunits = ((*(*dPtr).dataStrPtr).commonstr).xunits 
                yunits = ((*(*dPtr).dataStrPtr).commonstr).yunits
                histlabel = ((*(*dPtr).dataStrPtr).commonstr).histlabel
                histunits = ((*(*dPtr).dataStrPtr).commonstr).histunits
                instrument =  ((*(*dPtr).dataStrPtr).commonstr).instrument
yval = y
                ;CREATE DAVE PTR
                ret = create_dave_pointer(CombinedDAVEPtr,$
                                          instrument=instrument,$
                                          qty = QTY,$
                                          QTUnits = histunits,$
                                          QTLabel = histlabel,$
                                          err = ERR,$
                                          xvals = xvals,$
                                          xunits = xunits,$
                                          xlabel = xlabel,$
                                          yvals = yval,$;Tave,$
                                          ylabel = ylabel,$;'Temperature',$
                                          yunits = yunits, $
                                          specificStr = specificStr)
                if (ptr_valid(CombinedDAVEPtr)) then begin
                  treatment = *(*(*CombinedDAVEPtr).datastrptr).commonstr.treatmentptr
                  line = "___________________________________________________________________________________'
                  treatment = [treatment,line,'Data from the following datasets were combined:', fileArr]
                  *(*(*CombinedDAVEPtr).datastrptr).commonstr.treatmentptr = treatment                  
                endif

  endelse
end;readBT1Test_CombineDavePtr


;$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$
;pro readBT1Test,combine=combine,t=t,n=n,h=h,c=c,index=index,davePtr=davePtr,nodavewrite=nodavewrite
pro readBT1Test,combine=combine,t=t,h=h,index=Index,nodavewrite=nodavewrite,$
               datadir=datadir,workdir=workdir,davePtr=davePtr,files=files,$
               ASCII3Col=ASCII3Col,parent=parent,$
               writeCombinedFile=writeCombinedFile,$
               defaultoutputfile=defaultoutputfile,$
               davetool=davetool;,c=xc,n=xn

  ;FLAG TO CHOOSE WHETHER TO COMBINE RESULTS IN TO A SINGLE FILE
  if n_elements(combine) eq 0 then combine = 0
  if n_elements(nodavewrite) eq 0 then nodavewrite = 0
  if n_elements(writeCombinedFile) eq 0 then writeCombinedFile=0
  if n_elements(ASCII3Col) eq 0 then ASCII3Col = 0
  if n_elements(defaultoutputfile) eq 0 then defaultoutputfile = 1
  threeColASCII = ASCII3Col
  if threeColASCII eq 1 then combine = 0  ;CAN ONLY COMBINE GROUPS FOR DAVE OUTPUT
  ;print,'readBT1Test'
  ;help,davetool

  

  ;IF COMBINE EQ 0 AND THERE ARE MULTIPLE FILES, THEN CREATE ONE DAVE PTR
  ;PER FILE AND SEND TO DATA MANAGER.

  ;FLAG TO CHOOSE WHICH VARIABLE WILL BE USED AS THE Y VALUE IN THE FINAL DAVE FILE  
  if n_elements(t) eq 0 then t = 0
  if n_elements(n) eq 0 then n = 0
  if n_elements(h) eq 0 then h = 0  
  if n_elements(c) eq 0 then c = 0
  if n_elements(index) eq 0 then index = 0  
;print,'readBT1Test: t,n,h,c,index=',t,n,h,c,index
  ;IF NO Y VALUES CHOSEN THEN USE A DEFAULT INDEX NUMBER.
  if t eq 0 and $
     n eq 0 and $
     h eq 0 and $
     c eq 0 and $
     index eq 0 then index = 1

  if n_elements(files) eq 0 then begin
    fn = dialog_pickfile(filter='*.bt1',path = datadir,/multi)
          ;'\\Charlotte\icp data\bt1\200806\spoulton\',/multi)
  ;fn = '\\Charlotte\icp data\bt1\200806\spoulton\MoOPO058.bt1'
  endif else begin
    fn = files
  endelse

  if fn[0] ne '' then begin
    if n_elements(fn) eq 1 then begin   ;SINGLE FILE


      duh = readBT1Test_ConvertOneBT1File(davePtr,fn=fn[0],tVar=t,nVar=n,hVar=h,cVar=c,indexVar=index,myIndex = 0)
      ;print,fn[0],readBT1Test_ConvertOneBT1File(davePtr,fn=fn[0],tVar=t,nVar=n,hVar=h,cVar=c,indexVar=index,myIndex = 0)
      ;help,davePtr

      if nodavewrite eq 0 then begin


        ;NEED WORKDIR AND 
        if threeColASCII eq 0 then begin
          

          if defaultoutputfile eq 1 then begin
            filename = file_basename(fn[0])
            readbt1Test_addDotDave,filename
            filename = workdir+path_sep()+filename
          endif else begin
        
            filename = dialog_pickfile(/write,$
                                  title='Select DAVE export file for '+file_basename(fn[0])+': ',$
                                  path=workdir,$
                                  /overwrite_prompt,$
                                  dialog_parent=parent,$
                                  filter='*.dave')
          endelse                              

          if filename ne '' then begin
            readbt1Test_addDotDave,filename
            testfile = file_info(filename)
            save,filename=filename,davePtr
            void = dialog_message('Wrote: '+filename,/info)
          endif
        endif else begin ;threeColASCII 


          if defaultoutputfile eq 1 then begin
            filename = file_basename(fn[0])
            readbt1Test_addDotTXT,filename
            txtfilename = workdir+path_sep()+filename
          endif else begin
        
  
            txtfilename = dialog_pickfile(/write,$
                                title='Select ASCII export file for '+file_basename(fn[0])+': ',$
                                path=workdir,$
                                /overwrite_prompt,$
                                dialog_parent=parent,$
                                filter='*.txt')
          endelse
          if txtfilename ne '' then begin
            readbt1Test_addDotTXT,txtfilename
            testfile = file_info(txtfilename)
            readbt1Test_writeASCII,davePtr,txtfilename
            void = dialog_message('Wrote: '+txtfilename,/info)
          endif;txtfilename
        endelse;threeColASCII

      endif;nodavewrite


      if obj_valid(DAVETool) gt 0 then begin
        DAVETool->AddDavePtrToDataManager, davePtr, file_basename(fn[0])
      endif      


    endif else begin                    ;MULTIPLE FILES    
      pArr = ptrarr(n_elements(fn))
      fileArr = []

      ;ALPHABETIZE THE FILENAMES
      fn = fn[sort(fn)]

      ;READ THE DATA
      for i = 0,n_elements(fn)-1 do begin
;LRK - 08/17/09
;davePtr IS INITIALIZED IN THE NEXT CALL SO WE ARE NOT OVERWRITING A POINTER THAT WAS PASSED IN.
;BUT WE MUST BE CAREFUL NOT TO LOSE THE POINTER BY SENDING IN A davePtr VARIABLE.
        duh = readBT1Test_ConvertOneBT1File(davePtr,fn=fn[i],tVar=t,nVar=n,hVar=h,cVar=c,indexVar=index,myIndex=i)
        ;print,i,fn[i],readBT1Test_ConvertOneBT1File(davePtr,fn=fn[i],tVar=t,nVar=n,hVar=h,cVar=c,indexVar=index,myIndex=i)
;help,davePtr
        pArr[i] = davePtr
        fileArr = [fileArr,fn[i]]
      endfor;i
      
      if combine eq 1 then begin
        readBT1Test_CombineDavePtr,pArr,ComboDAVEPtr, fileArr
        ;WRITE FILE FIRST SINCE ADDING TO DAVE DATA MANAGER SEEMS TO KILL THE POINTER SOMETIMES.
        if writeCombinedFile eq 1 then begin
          ;NEED WORKDIR AND 
          filename = dialog_pickfile(/write,$
                              title='Select DAVE Combined Data Export File:',$
                              path=workdir,$
                              /overwrite_prompt,$
                              dialog_parent=parent,$
                              filter='*.dave')
          if filename ne '' then begin
            readbt1Test_addDotDave,filename
            testfile = file_info(filename)
            save,filename=filename,ComboDAVEPtr
            void = dialog_message('Wrote: '+filename,/info,dialog_parent=parent)
          endif
        endif;writecombinedfile


        if obj_valid(DAVETool) gt 0 then begin
          DAVETool->AddDavePtrToDataManager, ComboDAVEPtr, file_basename(fn[0])+'etc. Combined BT1 Data'
        endif      

        ;if nodavewrite eq 0 then begin
        
      endif else begin
        ;WRITE EACH DAVEPTR TO ITS OWN FILE AND/OR SEND EACH ONE TO THE DAVE DATA MANAGER
        for i=0,n_elements(pArr)-1 do begin
          readBT1Test_CombineDavePtr,pArr[i],DAVEPtr
          if obj_valid(DAVETool) gt 0 then begin
            ;DAVETool->AddDavePtrToDataManager, pArr[i], fn[i]
            DAVETool->AddDavePtrToDataManager, DAVEPtr, file_basename(fn[i])
          endif      
          
          if nodavewrite eq 0 then begin
;
;            ;NEED WORKDIR AND 
;            filename = dialog_pickfile(/write,$
;                                title='BT-1 DAVE export file:',$
;                                path=workdir,$
;                                /overwrite_prompt,$
;                                filter='*.dave')
;            if filename ne '' then begin
;              readbt1Test_addDotDave,filename
;              testfile = file_info(filename)
;              save,filename=filename,DAVEptr
;      
;              void = dialog_message('Wrote: '+filename,/info)
;            endif



                    ;NEED WORKDIR AND 
                    if threeColASCII eq 0 then begin
                      if defaultoutputfile eq 1 then begin
                        filename = file_basename(fn[i])
                        readbt1Test_addDotDave,filename
                        filename = workdir+path_sep()+filename
                      endif else begin
                    

                        filename = dialog_pickfile(/write,$
                                            title='Select DAVE export file for '+file_basename(fn[i])+': ',$
                                            path=workdir,$
                                            /overwrite_prompt,$
                                            dialog_parent=parent,$
                                            filter='*.dave')
                      endelse
                      if filename ne '' then begin
                        readbt1Test_addDotDave,filename
                        testfile = file_info(filename)
                        save,filename=filename,davePtr
                        void = dialog_message('Wrote: '+filename,/info,dialog_parent=parent)
                      endif
                    endif else begin ;threeColASCII
                      if defaultoutputfile eq 1 then begin
                        txtfilename = file_basename(fn[i])
                        readbt1Test_addDotDave,txtfilename
                        txtfilename = workdir+path_sep()+txtfilename
                      endif else begin
                        txtfilename = dialog_pickfile(/write,$
                                            title='Select ASCII export file for '+file_basename(fn[i])+': ',$
                                            path=workdir,$
                                            /overwrite_prompt,$
                                            dialog_parent=parent,$
                                            filter='*.txt')
                      endelse
                      if txtfilename ne '' then begin
                        readbt1Test_addDotTXT,txtfilename  ;NEEDED BECAUSE THE FILENAME MAY HAVE BEEN ENTERED
                        testfile = file_info(txtfilename)
                        readbt1Test_writeASCII,davePtr,txtfilename
                        void = dialog_message('Wrote: '+txtfilename,/info,dialog_parent=parent)

                      endif;txtfilename
                    endelse;threeColASCII




          endif;nodavewrite
        endfor;i
      endelse
    endelse
    return
  endif else begin
    return
  endelse

end;readBT1Test


