; $Id$
;###############################################################################
;
; NAME:
;  TAS_REDUCTION_PREFS
;
; PURPOSE:
;  Dialog for TAS data reduction preferences.
;
; CATEGORY:
;  DAVE, TAS, Data Reduction
;
; AUTHOR:
;   Robert M. Dimeo, Ph.D.
;   NIST Center for Neutron Research
;   100 Bureau Drive
;   Gaithersburg, MD 20899
;   Phone: (301) 975-8135
;   E-mail: robert.dimeo@nist.gov
;   http://www.ncnr.nist.gov/staff/dimeo
;
; LICENSE:
;  The software in this file is written by an employee of
;  National Institute of Standards and Technology
;  as part of the DAVE software project.
;
;  The DAVE software package is not subject to copyright protection
;  and is in the public domain. It should be considered as an
;  experimental neutron scattering data reduction, visualization, and
;  analysis system. As such, the authors assume no responsibility
;  whatsoever for its use, and make no guarantees, expressed or
;  implied, about its quality, reliability, or any other
;  characteristic. The use of certain trade names or commercial
;  products does not imply any endorsement of a particular product,
;  nor does it imply that the named product is necessarily the best
;  product for the stated purpose. We would appreciate acknowledgment
;  if the DAVE software is used of if the code in this file is
;  included in another product.
;
;###############################################################################
; +
;
; -
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
function tas_convert_interp,num
case num of
0: result = 'BINNING'
1: result = 'LINEAR'
2: result = 'SPLINE'
else: result = 'BINNING'
endcase
return,result
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro tas_reduction_get_values,event
widget_control,event.top,get_uvalue = pstate
fbg = widget_info(event.top,find_by_uname = 'FBG')
fbg_value = widget_info(event.top,find_by_uname = 'FBG_VALUE')
scale = widget_info(event.top,find_by_uname = 'SCALE')
scale_val = widget_info(event.top,find_by_uname = 'SCALE_VALUE')
menu_1 = widget_info(event.top,find_by_uname = 'CHOICES_TWO')
fbg_setting = widget_info(fbg,/button_set)
widget_control,fbg_value,get_value = fbg_val
fbg_val = float(fbg_val)
scale_setting = widget_info(scale,/button_set)
widget_control,scale_val,get_value = scale_val
scale_val = float(scale_val)
button_names = (*pstate).button_names

menu1_buttons = *(*pstate).menu1_ptr
n = n_elements(menu1_buttons)
menu_vals = bytarr(n)
menu_vals = widget_info(menu1_buttons,/button_set)
(*(*pstate).pref_ptr).det_bal = menu_vals[0]
(*(*pstate).pref_ptr).mon_cor = menu_vals[1]
(*(*pstate).pref_ptr).res_cor = menu_vals[2]
(*(*pstate).pref_ptr).mon_norm = menu_vals[3]
(*(*pstate).pref_ptr).time_norm = menu_vals[4]
(*(*pstate).pref_ptr).sum_signal = menu_vals[5]
(*(*pstate).pref_ptr).sum_bg = menu_vals[6]
(*(*pstate).pref_ptr).diff = menu_vals[7]
(*(*pstate).pref_ptr).save_int = menu_vals[8]

widget_control,menu_1,get_value = menu_1_vals
(*(*pstate).pref_ptr).interp = tas_convert_interp(menu_1_vals[0])
(*(*pstate).pref_ptr).linear_interp = menu_1_vals[0]
(*(*pstate).pref_ptr).fbg = fbg_setting
(*(*pstate).pref_ptr).fbg_val = fbg_val
(*(*pstate).pref_ptr).scale = scale_setting
(*(*pstate).pref_ptr).scale_val = scale_val

end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro tas_reduction_set_values,event
widget_control,event.top,get_uvalue = pstate
fbg = widget_info(event.top,find_by_uname = 'FBG')
fbg_value = widget_info(event.top,find_by_uname = 'FBG_VALUE')

scale = widget_info(event.top,find_by_uname = 'SCALE')
scale_val = widget_info(event.top,find_by_uname = 'SCALE_VALUE')
menu_1 = widget_info(event.top,find_by_uname = 'CHOICES_TWO')
button_names = (*pstate).button_names

menu_array =   [(*(*pstate).pref_ptr).det_bal,(*(*pstate).pref_ptr).mon_cor,  $
               (*(*pstate).pref_ptr).res_cor,  $
               (*(*pstate).pref_ptr).mon_norm, $
               (*(*pstate).pref_ptr).time_norm, $
               (*(*pstate).pref_ptr).sum_signal,(*(*pstate).pref_ptr).sum_bg,  $
               (*(*pstate).pref_ptr).diff,(*(*pstate).pref_ptr).save_int]
n = n_elements(menu_array)

widget_control,fbg,set_button = (*(*pstate).pref_ptr).fbg
widget_control,fbg_value,set_value = $
   strtrim(string((*(*pstate).pref_ptr).fbg_val),2)
widget_control,scale,set_button = (*(*pstate).pref_ptr).scale
widget_control,scale_val,set_value = $
   strtrim(string((*(*pstate).pref_ptr).scale_val),2)
for i = 0,n-1 do widget_control,(*(*pstate).menu1_ptr)[i],set_button = menu_array[i]
widget_control,menu_1,set_value = (*(*pstate).pref_ptr).linear_interp
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro tas_reduction_send_info,event
widget_control,event.top,get_uvalue = pstate
notify_ids = (*pstate).notify_ids
prefs = (*pstate).pref_ptr
if (*pstate).notify_ids[0] eq 0L then return
info =   {tas_red_pref_event,    $
          id:notify_ids[0],      $
          top:notify_ids[1],     $
          handler:0L,            $
          prefs:prefs}
if widget_info(notify_ids[0],/valid_id) then begin
  widget_control,notify_ids[0],send_event = info
endif
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro tas_reduction_cleanup,tlb
widget_control,tlb,get_uvalue = pstate
ptr_free,(*pstate).menu1_ptr,(*pstate).pref_ptr
ptr_free,pstate
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro tas_reduction_save_config,event
widget_control,event.top,get_uvalue = pstate
filename = dialog_pickfile(dialog_parent = event.top, /write,  $
            title = 'Save the reduction preferences',          $
            filter = '*.tas_prefs')
if filename eq '' then return
filename = filename + '.tas_prefs'
prefs = (*(*pstate).pref_ptr)
save,prefs,filename = filename
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro tas_reduction_restore_config,event
widget_control,event.top,get_uvalue = pstate
filename = dialog_pickfile(dialog_parent = event.top, /read,  $
            title = 'Select reduction preferences file',          $
            filter = '*.tas_prefs')
if filename eq '' then return
restore,filename
(*(*pstate).pref_ptr) = prefs
tas_reduction_set_values,event
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro tas_reduction_check_fbg,event
widget_control,event.top,get_uvalue = pstate
id = widget_info(event.top,find_by_uname = 'FBG')
set = widget_info(id,/button_set)

menu_buttons = *(*pstate).menu1_ptr
n = n_elements(menu_buttons)
boi = ['RESOLUTION CORRECTION', 'DETAILED BALANCE', 'MONITOR CORRECTION', $
      'MONITOR NORMALIZATION']
for i = 0,n-1 do begin
   widget_control,menu_buttons[i],get_value = value
   match_index = where(boi eq strupcase(value),count_match)
   if count_match gt 0 then begin
      ; If FBG is checked then sensitize the menu item
      if set then begin
         widget_control,menu_buttons[i],sensitive = 1
      endif else begin
         widget_control,menu_buttons[i],sensitive = 0,set_button = 0
      endelse
   endif
endfor
tas_reduction_get_values,event
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro tas_reduction_handle_fbg,event
widget_control,event.top,get_uvalue = pstate
print,widget_info(event.id,/uname)
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro tas_red_event,event
widget_control,event.top,get_uvalue = pstate
uname = widget_info(event.id,/uname)
case uname of
'SAVE_CONFIG': $
   begin
      tas_reduction_get_values,event
      tas_reduction_save_config,event
   end
'RESTORE_CONFIG': $
   begin
      tas_reduction_restore_config,event
   end
;'FBG':  tas_reduction_check_fbg,event
'DISMISS':  widget_control,event.top,/destroy
'APPLY': $
   begin
      tas_reduction_get_values,event
      tas_reduction_send_info,event
   end
'FBG':      tas_reduction_check_fbg,event
else:       tas_reduction_get_values,event
endcase
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro tas_reduction_prefs,   group_leader = group_leader,  $
                           notify_ids = notify_ids,      $
                           pinit_values = pinit_values,  $
                           prefs_dir = prefs_dir,        $
                           register_name = register_name
if n_elements(register_name) eq 0 then $
   register_name = 'tas_reduction_preferences'
if xregistered(register_name) then return
; Check for which parameters were passed in
if n_elements(group_leader) eq 0 then group_leader = 0L
if n_elements(notify_ids) eq 0 then notify_ids = [0L,0L]
if n_elements(prefs_dir) eq 0 then begin
   cd,current = prefs_dir
endif
if n_elements(*pinit_values) eq 0 then begin
   ; Set up the defaults for the widget
   fbg = 1
   fbg_val = 0.0
   det_bal = 1
   mon_cor = 1
   res_cor = 1
   scale = 1
   scale_val = 1.0
   save_int = 1
   sum_signal = 1
   sum_bg = 1
   diff = 1
   linear_interp = 0
   interp = 'BINNING'
   mon_norm = 1
   time_norm = 0
   init_values =  {  fbg:fbg,                      $
                     fbg_val:fbg_val,              $
                     det_bal:det_bal,              $
                     mon_cor:mon_cor,              $
                     mon_norm:mon_norm,            $
                     time_norm:time_norm,          $
                     res_cor:res_cor,              $
                     scale:scale,                  $
                     scale_val:scale_val,          $
                     save_int:save_int,            $
                     sum_signal:sum_signal,        $
                     sum_bg:sum_bg,                $
                     diff:diff,                    $
                     interp:interp,                $
                     linear_interp:linear_interp   }
endif else begin
   init_values = *pinit_values
endelse

; Widget definition module
title = 'Reduction Preferences'
tlb = widget_base(group_leader = group_leader,/col, title = title,   $
   tlb_frame_attr = 9)

base1 = widget_base(tlb,/row)
base1_a = widget_base(base1,/row,/nonexclusive)
fbg = widget_button(base1_a,value = 'Fast Background Subtraction',  $
   uname = 'FBG')
fbg_value = cw_field(base1,title = 'CTS/MIN',value = '0.0',uname = 'FBG_VALUE')

base2 = widget_base(tlb,/row)
base2_a = widget_base(base2,/row,/nonexclusive)
scale = widget_button(base2_a,value = 'Overall scale factor',  $
   uname = 'SCALE')
scale_value = cw_field(base2,title = 'Scale value',value = '1.0', $
   uname = 'SCALE_VALUE')

button_names = [  'Detailed balance','Monitor correction','Resolution correction',   $
                  'Monitor normalization','Normalize to Counting time','Sum signal files',   $
                  'Sum background files', $
                  'Difference of signal and background sums',  $
                  'Save intermediate steps']
menu_array =   [init_values.det_bal,init_values.mon_cor,init_values.res_cor, $
               init_values.mon_norm,init_values.time_norm, $
               init_values.sum_signal,init_values.sum_bg,  $
               init_values.diff,init_values.save_int]
nbuttons = n_elements(button_names)
menu_base1 = lonarr(nbuttons)
menu1_buttons = lonarr(nbuttons)
for i = 0,nbuttons-1 do begin
   menu_base1[i] = widget_base(tlb,/nonexclusive,/col)
   menu1_buttons[i] = widget_button(menu_base1[i],value = button_names[i],uname = 'CHOICES_ONE')
endfor
menu1_ptr = ptr_new(menu1_buttons)

;menu = cw_bgroup(tlb,/col,button_names,/nonexclusive,  $
;   uname = 'CHOICES_ONE')
button_names_a = ['If necessary use data binning',          $
                  'If necessary use linear interpolation',  $
                  'If necessary use cubic interpolation'    ]
menu_1 = cw_bgroup(tlb,/col,button_names_a,/exclusive,      $
   uname = 'CHOICES_TWO',/frame,label_top = 'Subtraction interpolation method')
quit_base = widget_base(tlb,/row)
void = widget_button(quit_base,value = 'RESTORE PREFS',uname = 'RESTORE_CONFIG')
void = widget_button(quit_base,value = 'SAVE PREFS',uname = 'SAVE_CONFIG')
void = widget_button(quit_base,value = 'REDUCE',uname = 'APPLY')
void = widget_button(quit_base,value = 'DISMISS',uname = 'DISMISS')

widget_control,tlb,/realize
; Now set the buttons to their initial values
widget_control,fbg,set_button = init_values.fbg
widget_control,fbg_value,set_value = strtrim(string(init_values.fbg_val),2)
widget_control,scale,set_button = init_values.scale
widget_control,scale_value,set_value = strtrim(string(init_values.scale_val),2)

;widget_control,menu,set_value = menu_array
for i = 0,nbuttons-1 do widget_control,menu1_buttons[i],set_button = menu_array[i]

;if init_values.linear_interp eq 1 then interp_val = 1 else interp_val = 0
widget_control,menu_1,set_value = init_values.linear_interp;interp_val
pref_ptr = ptr_new(init_values)
state =  {  pref_ptr:pref_ptr,            $
            group_leader:group_leader,    $
            menu1_ptr:menu1_ptr,          $
            prefs_dir:prefs_dir,          $
            button_names:button_names,    $
            notify_ids:notify_ids         }

pstate = ptr_new(state,/no_copy)
widget_control,tlb,set_uvalue = pstate

pevent = {event,id:fbg,top:tlb,handler:0L}
tas_reduction_check_fbg,pevent

xmanager,register_name,tlb,event_handler = 'tas_red_event',/no_block, $
   cleanup = 'tas_reduction_cleanup'
end
