function DAVE_parse_hdf, filename=filename $
  ,header=header $
  ,headText = headerText $
  ,dattaText = dattaText $
  ,indep_var_pos=indep_var_pos $
  ,dep_var_pos=dep_var_pos $
  ;;,plot_indep_var = plot_indep_var $
  ,lattice=lattice $
  ,lattUnits=latticeUnits $
  ,fixedEType=fixedEType $
  ,fixedEValue=fixedEValue $
  ,dSpaceM=dSpaceM $
  ,dSpaceA=dSpaceA $
  ,orientation=orientation $
  ,sdesc=sdesc $
  ,anaPkgStr=anaPkgStr $
  ,errmsg = errmsg $
  ,DetEffkeyVals=DetEffkeyVals $
  ,PSD_DOI_only=PSD_DOI_only $ ; set to specify that only datasets in which PSD was detector-of-interest should be processed
  ,dep_var = dep_var $
  ,indep_var = indep_var $
  ,coltitles = colTitles $
  ,colUnits = colUnits $
  ,quaternion=quaternion $
  ,dspace_MUnits=dspaceMUnits $
  ,dspace_AUnits=dspaceAUnits $
  ,primaryDetector=primaryDetector 

compile_opt idl2

errmsg = ''
Catch,the_error
if the_error ne 0 then begin
  Catch,/cancel
  errmsg = !error_state.msg
  !QUIET = 0
  Return,0B
endif

; ensure filename is an hdf5 file before continuing
if (~H5f_is_hdf5(filename)) then begin
  errmsg = filename + " has unexpected format. It is not an HDF5 file!"
  return, 0
endif

handle=0L
hdlerror=0

status = Nxopen(filename,'NXACC_READ',handle)
if (~status) then begin
  errmsg = 'Could not open nexus file: '+filename
  return, 0
endif

nEntry = H5G_GET_nmembers(handle.ivid, '/')
if (nEntry lt 1) then begin
  errmsg = filename + " contains no entries"
  Return, 0 
endif
entryIndex = 0
group_name = '/'
entryName = H5G_GET_member_name(handle.ivid, group_name, entryIndex)

; open the main NXentry group
if (~Nxopengroup(handle,entryName,'NXentry')) then begin
  errmsg = "Cannot open " + entryName
  Return, 0  
endif

;===========================================================================
; Sample information: lattice parameter, orientation, Quaternion,
status = Nxopengroup(handle,'sample','NXcollection')     ; Open Sample group
status = DaveNXopenGetCloseData(handle,'unit_cell_a',data=sampA)
status = Davenxopengetclosedata(handle,'unit_cell_b',data=sampB)
status = Davenxopengetclosedata(handle,'unit_cell_c',data=sampC)
status = Davenxopengetclosedata(handle,'unit_cell_alpha',data=sampAlpha)
status = Davenxopengetclosedata(handle,'unit_cell_beta',data=sampBeta)
status = Davenxopengetclosedata(handle,'unit_cell_gamma',data=sampGamma)
lattice = [sampA,sampB,sampC,sampAlpha,sampBeta,sampGamma]

status = Davenxopengetclosedata(handle,'orientation',data=sampOrientQuaternion)

; TODO what if using orientation vectors? Where are the scattering plane/orientation vectors
status = Nxclosegroup(handle)      ; close Sample group


;===========================================================================
; Instrument Group: - monochromator/Analyzer d-spacing
status = Nxopengroup(handle,'instrument','NXcollection')
status = Nxopengroup(handle,'SD','NXdetector')
status = Davenxopengetclosedata(handle,'data',data=sdData,attrNames='long_name',attrData=sdAttr)
status = Nxclosegroup(handle) ; SD Detector


status = Nxopengroup(handle,'monochromator','NXcollection')
status = Davenxopengetclosedata(handle,'dspacing',data=dspaceM,attrNames='units',attrData=dspaceUnits)
status = Davenxopengetclosedata(handle,'energy',data=Ei,attrNames=['error','units'],attrData=EiAttrs)
status = Davenxopengetclosedata(handle,'material',data=monoMaterial)
status = Davenxopengetclosedata(handle,'rotation_angle',data=mono2theta)
status = Nxclosegroup(handle) ; monochromator

status = Nxopengroup(handle,'analyzer','NXcollection')
status = Davenxopengetclosedata(handle,'dspacing',data=dspaceA)
status = Davenxopengetclosedata(handle,'energy',data=Ef)
status = Davenxopengetclosedata(handle,'material',data=anaMaterial)
status = Davenxopengetclosedata(handle,'rotation_angle',data=ana2theta)
status = Nxclosegroup(handle) ; analyzer

status = Nxclosegroup(handle) ; instrument



; open DAS_logs group
status = Nxopengroup(handle,'DAS_logs','NXcollection')

status = Nxopengroup(handle,'Q','NXcollection')
status = NXopendata(handle,'mag')
status = NXgetdata(handle,Qmag)
status = NXclosedata(handle)
status = Nxopendata(handle,'H')
status = Nxgetdata(handle,QH)
status = Nxclosedata(handle)
status = Nxopendata(handle,'K')
status = Nxgetdata(handle,QK)
status = Nxclosedata(handle)
status = Nxopendata(handle,'L')
status = Nxgetdata(handle,QL)
status = Nxclosedata(handle)
status = Nxclosegroup(handle)     ; Q

status = Nxopengroup(handle,'et','NXcollection')
status = Nxopendata(handle,'deltaE')
status = Nxgetdata(handle,deltaE)
;if (H5A_get_num_attrs(handle.iCurrentSDS) gt 0) then $
;  status = nxgetattr(handle,'units',energyUnits,attr_type) else $
;  energyUnits = ''
;print,'Units of energy is ',energyUnits
status = Nxclosedata(handle)
status = Nxopendata(handle,'fixedEnergyMode')
status = Nxgetdata(handle,fixedEMode)
status = Nxclosedata(handle)
status = Nxclosegroup(handle)     ; et

status = Nxopengroup(handle,'trajectoryData','NXcollection')

status = Nxclosegroup(handle)     ; trajectoryData
;status = Nxopendata(handle,'xAxis')
;status = Nxgetdata(handle,QL)
;status = Nxclosedata(handle)


status = Nxclosegroup(handle)     ; DAS_logs

status = NXclosegroup(handle)     ; NXentry
status = Nxclose(handle)          ; file

end


