; $Id$
;###############################################################################
;
;
;  inherits cwo_drawplot_class
;  This is the class that defines the scattering plane for TAS Scan Mapper.  
;  It inherits cow_drawplot_class, which is the superclass of all these container/plot objects.
;
;
;CLASS NAME:
;    Spurion2_drawplot_class__define,class
;
;PURPOSE:
;
;CATEGORY:
;
;
;SUPERCLASSES:
;    idl_container
;
;METHODS:
;    setCircleSymbol
;    Spurion2_drawplot_class_event
;    Spurion2_drawplot_class::handleContextMenu
;    Spurion2_drawplot_class::event
;    Spurion2_drawplot_class::handleMouseEvents
;    Spurion2_drawplot_class::reportRanges
;    Spurion2_drawplot_class::updateContextSetList
;    Spurion2_drawplot_class::copyWindow
;    Spurion2_drawplot_class::setWindow
;    Spurion2_drawplot_class::draw
;    Spurion2_drawplot_class::defaultDraw
;    Spurion2_drawplot_class::getColorImage
;    Spurion2_drawplot_class::writejpg
;    Spurion2_drawplot_class::writePS
;    Spurion2_drawplot_class::printWindow
;    Spurion2_drawplot_class::showMode
;    Spurion2_drawplot_class::getDataRange
;    Spurion2_drawplot_class::legend
;    Spurion2_drawplot_class::oplot
;    Spurion2_drawplot_class::print
;    Spurion2_drawplot_class::setDataRange
;    Spurion2_drawplot_class::setZoomRange
;    Spurion2_drawplot_class::setxlog
;    Spurion2_drawplot_class::setylog
;    Spurion2_drawplot_class::range
;    Spurion2_drawplot_class::zoombox
;    Spurion2_drawplot_class::createContextMenu
;    Spurion2_drawplot_class::add
;    Spurion2_drawplot_class::setData
;    Spurion2_drawplot_class::clearData
;    Spurion2_drawplot_class::hideData
;    Spurion2_drawplot_class::resize
;    Spurion2_drawplot_class::setProperty
;    Spurion2_drawplot_class::getProperty
;    Spurion2_drawplot_class_realize
;    Spurion2_drawplot_class::realize
;    Spurion2_drawplot_class_cleanup
;    Spurion2_drawplot_class::cleanup
;    Spurion2_drawplot_class::setvalues
;    Spurion2_drawplot_class_set_value
;    Spurion2_drawplot_class_get_value
;    Spurion2_drawplot_class::init
;    Spurion2_drawplot_class__define
;    run_Spurion2_drawplot_event
;    run_Spurion2_drawplot
;    Spurion2_drawplot
;
;
; AUTHOR:
; Larry Kneller
; NIST Center for Neutron Research
; 100 Bureau Drive, Gaithersburg, MD 20899
; United States
; kneller@nist.gov  301-975-8839
; Thu May 18 15:20:57 2006
;
; LICENSE:
; The software in this file is written by an employee of
; National Institute of Standards and Technology
; as part of the DAVE software project.
;
; The DAVE software package is not subject to copyright protection
; and is in the public domain. It should be considered as an
; experimental neutron scattering data reduction, visualization, and
; analysis system. As such, the authors assume no responsibility
; whatsoever for its use, and make no guarantees, expressed or
; implied, about its quality, reliability, or any other
; characteristic. The use of certain trade names or commercial
; products does not imply any endorsement of a particular product,
; nor does it imply that the named product is necessarily the best
; product for the stated purpose. We would appreciate acknowledgment
; if the DAVE software is used or if the code in this file is
; included in another product.
;
;###############################################################################



;###############################################
;EVENT HANDLING METHODS
;###############################################
;###############################################################################
;
;NAME:
;        Spurion2_drawplot_class_event
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;RETURN VALUE:
;
;###############################################################################
function Spurion2_drawplot_class_event,event

    catch, catchError
    if (catchError ne 0) then begin
        ;;print, 'Error handled!'
        eTitle = 'Spurion2_drawplot_class: Error encountered'
        eMsg = 'An error or unusual condition was encountered!'
        eMsg = [eMsg,'Please, report the following to the DAVE team:']
        eMsg = [eMsg,!error_state.msg]
        void = dialog_message(/error,eMsg,title=eTitle,dialog_parent=event.top)
        catch, /cancel
        return,-1
    endif



    widget_control,widget_info(event.handler,/child),get_uvalue=self
    event = self->event(event)
    return,event
end;Spurion2_drawplot_class_event



;###############################################################################
;
;NAME:
;        Spurion2_drawplot_class::handleContextMenu
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro Spurion2_drawplot_class::handleContextMenu,event


        uname = widget_info(event.id,/uname)
;        print,uname
;        print,'Spurion2_drawplot_class::handleContextMenu'
;        print,self.contextmenu
        parent  = widget_info(event.id,/parent)
;        print,parent
        zoommode = widget_info(parent,find_by_uname='ZOOMMODE')
        positionmode = widget_info(parent,find_by_uname='POSITIONMODE')
        StartStopmode = widget_info(parent,find_by_uname='START_ENDMODE')
        regionmode = widget_info(parent,find_by_uname='REGIONMODE')
        logxmode = widget_info(parent,find_by_uname='LOGXMODE')
        logymode = widget_info(parent,find_by_uname='LOGYMODE')


print,'uname=',uname
;print,self.winvis
        case uname of
        'UNZOOM':begin
            ;UNZOOM FLAG
            self.zoomflag = 0


            ;RESTORE RANGES TO THE UNZOOMED VALUES
            self.zoomxrange = self.xrange
            self.zoomyrange = self.yrange
        end;UNZOOM
        'PRINTJPG':begin
            self->draw,/printwin,/jpg
        end;PRINTJPG
        'PRINTPS':begin
            self->draw,/printwin,/ps
        end;PRINTPS
        'PRINTDEFAULTPRINTER':begin
            self->draw,/printwin,/defaultPrinter
        end;PRINTDEFAULT
        'HIDEMODELABEL':begin
            self.hidemodelabel = (self.hidemodelabel eq 1 ? 0 : 1)
        end;HIDEMODELABEL
        'ZOOMMODE':begin
            ;RUBBER BAND BOX ZOOMING
            widget_control,zoommode,set_value='[X] Zoom'
            widget_control,positionmode,set_value='[_] Position'
            widget_control,StartStopmode,set_value='[_] Start/End'
            widget_control,regionmode,set_value='[_] Region'
            self.zoom_selectmode = 0
        end;ZOOMMODE
        'POSITIONMODE':begin
            ;REFLECTS POSTION ON PLOT WHILE MOUSE IS DRAGGED
            widget_control,zoommode,set_value='[_] Zoom'
            widget_control,positionmode,set_value='[X] Position'
            widget_control,StartStopmode,set_value='[_] Start/End'
            widget_control,regionmode,set_value='[_] Region'
            self.zoom_selectmode = 1
        end;POSITIONMODE
        'START_ENDMODE':begin
            ;SET START POINT ON MOUSE PRESS AND DRAW LINE FROM THERE TO
            ;CURRENT MOUSE POSITION ON DRAG
            widget_control,zoommode,set_value='[_] Zoom'
            widget_control,positionmode,set_value='[_] Position'
            widget_control,StartStopmode,set_value='[X] Start/End'
            widget_control,regionmode,set_value='[_] Region'
            self.zoom_selectmode = 2
        end;START_ENDMODE
        'REGIONMODE':begin
            ;RUBBER BAND BOX REGION SELECTION
            widget_control,zoommode,set_value='[_] Zoom'
            widget_control,positionmode,set_value='[_] Position'
            widget_control,StartStopmode,set_value='[_] Start/End'
            widget_control,regionmode,set_value='[X] Region'
            self.zoom_selectmode = 3
        end;REGIONMODE
        'LOGXMODE':begin
            self.xlog = (self.xlog eq 1 ? 0 : 1)
            char = (self.xlog eq 1 ? 'X' : '_')
            widget_control,logxmode,set_value='['+char+'] log(x)'
        end;LOGXMODE
        'LOGYMODE':begin
            self.ylog = (self.ylog eq 1 ? 0 : 1)
            char = (self.ylog eq 1 ? 'X' : '_')
            widget_control,logymode,set_value='['+char+'] log(y)'
        end;LOGYMODE
        'DATASETHIDE':begin
            print,'Data Set Hide'
            widget_control,event.id,get_uvalue=dat
            dat->toggleHide
        end;DATASETHIDE
        else:;OTHERS???
        endcase


end;handleContextMenu


;###############################################################################
;
;NAME:
;        Spurion2_drawplot_class::event
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;RETURN VALUE:
;
;###############################################################################
function Spurion2_drawplot_class::event,event


;NEED TO LOOK FOR BUTTON EVENTS, THEN


;NEED TO LOOK FOR contextMenu EVENTS HERE AND HANDLE IF NECESSARY.
;IF NOT NECESSARY, FINISH THIS METHOD . . . MONDAY!!!!!!


    etype = tag_names(event,/structure_name)


    case etype of
    'WIDGET_BUTTON':begin


        self->handleContextMenu,event
        self.leftmousepressed = 0
        self.zoomboxflag = 0
        event.id = self.tlb
        xrange=self.zoomxrange
        yrange=self.zoomyrange
        xbeg = double('nan')
        xend = double('nan')
        ybeg = double('nan')
        yend = double('nan')
        event = {id:self.tlb,top:self.parent,handler:self.parent,$
                    xbeg:xbeg,xend:xend,ybeg:ybeg,yend:yend,$
                    xrange:xrange,yrange:yrange}


        ;return,-1
    end;
;    else:begin
;        event = self->handleMouseEvents(event)
;    end;else
;    endcase
    'WIDGET_TRACKING':begin
        self.mouseinwindow = event.enter

    end;WIDGET_TRACKING
    'WIDGET_DRAW':begin
        self.mouseinwindow = 1
        case event.key of
        0:event = self->handleMouseEvents(event)
        else:event = self->handleKeyboardEvents(event)
        endcase
    end;WIDGET_DRAW
    else:begin
    end;else
    endcase
    ;print,'self.mouseinwindow=',self.mouseinwindow


    self->draw
    return,event
end;Spurion2_drawplot_class::event


;###############################################################################
;
;NAME:
;        Spurion2_drawplot_class::handleMouseEvents
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;RETURN VALUE:
;
;###############################################################################
function Spurion2_drawplot_class::handleMouseEvents,event



        !x = *self.xptr
        !y = *self.yptr
        pcoord = convert_coord(self.pressxy,/device,/to_data)
        rcoord = convert_coord(self.releasexy,/device,/to_data)


        xbeg = pcoord[0]  ;double('nan')
        xend = rcoord[0];double('nan')
        ybeg = pcoord[1]  ;double('nan')
        yend = rcoord[1];double('nan')


        zoom = 0    ;FLAGS TO TELL IF RELEASE EVENT IS ZOOM OR SELECT OR NEITHER.
        select = 0




        ;ZOOMING EVENTS
        ;GET LEFT PRESS POINT
        if event.press eq 1 then begin


            switch self.zoom_selectmode of
            0:
            1:
            2:
            3: begin
                self.leftmousepressed = 1
                self.zoomboxflag = 1
                self.pressxy = [event.x,event.y]


                pcoord = convert_coord(self.pressxy,/device,/to_data)
                rcoord = pcoord


                xbeg = pcoord[0]  ;double('nan')
                xend = rcoord[0];double('nan')
                ybeg = pcoord[1]  ;double('nan')
                yend = rcoord[1];double('nan')


                break
            end;3
            else:
            endswitch
        endif


        ;GET LEFT RELEASE POINT AND SET NEW RANGE VALUES
        if event.release eq 1 then begin


            self.leftmousepressed = 0
            self.zoomboxflag = 0
            case self.zoom_selectmode of
            0:begin
        ;        self.zoomboxflag = 0
                self.releasexy = [event.x,event.y]
                xend = self.releasexy[0]
                yend = self.releasexy[1]

                if self.pressxy[0] ne self.releasexy[0] or $
                    self.pressxy[1] ne self.releasexy[1] then begin
                        self->setZoomRange

                        self.zoomflag = 1
                    zoom=1
                    select=0
                endif
            end;0
            1:begin
                ;POSITION MODE
        ;        self.zoomboxflag = 0
                self.releasexy = [event.x,event.y]

                rcoord = convert_coord(self.releasexy,/device,/to_data)
                xend = rcoord[0];double('nan')
                yend = rcoord[1];double('nan')
                zoom=0
                select=0
            end;1
            2:begin
                ;START/END
        ;        self.zoomboxflag = 0
                self.releasexy = [event.x,event.y]
                rcoord = convert_coord(self.releasexy,/device,/to_data)
                xend = rcoord[0];double('nan')
                yend = rcoord[1];double('nan')
                zoom=0
                select = 1
            end;2

            3:begin
                ;REGION
        ;        self.zoomboxflag = 0
                self.releasexy = [event.x,event.y]
                rcoord = convert_coord(self.releasexy,/device,/to_data)
                xend = rcoord[0];double('nan')
                yend = rcoord[1];double('nan')
                zoom=0
                select = 1
            end;3
            else:begin
                zoom=0
                select=0
            endelse
            endcase



        endif


;        if event.release eq 4 then begin
;
;            ;widget_displaycontextmenu, self.tlb, event.x, event.y, self.contextMenu
;
;            ;UNZOOM FLAG
;            self.zoomflag = 0
;
;            ;RESTORE RANGES TO THE UNZOOMED VALUES
;            self.zoomxrange = self.xrange
;            self.zoomyrange = self.yrange
;        endif


        if event.press eq 4 then begin
            geom = widget_info(self.tlb,/geometry)
            self->updateContextSetList
            widget_displaycontextmenu,  self.tlb,$
                                        event.x,$
                                        geom.ysize - event.y, $
                                        self.contextMenu



            return,-1
        endif



        ;GET MOUSE POSITION ON DRAG WITH LEFT MOUSE BUTTON PRESSED
        if self.leftmousepressed eq 1 then begin
            self.mousexy = [event.x,event.y]
;            xend = self.mousexy[0]
;            yend = self.mousexy[1]
            rcoord = convert_coord(self.mousexy,/device,/to_data)
            xend = rcoord[0];double('nan')
            yend = rcoord[1];double('nan')


        endif



        xrange=self.zoomxrange
        yrange=self.zoomyrange



    if self.leftmousepressed eq 0 and $
            self.rightmousepressed eq 0 and $
                event.release eq 0 then begin


        ;SWALLOW MOTION EVENTS WHEN NO BUTTON PRESSED/RELEASED.
        return,-1
    endif else begin
        event = {id:self.tlb,top:self.parent,handler:self.parent,$
                    xbeg:xbeg,xend:xend,ybeg:ybeg,yend:yend,$
                    xrange:xrange,yrange:yrange,zoom:zoom,select:select}
        return,event
    endelse


end;handleMouseEvents



;#################################################
;DRAWING METHODS
;#################################################


;###############################################################################
;
;NAME:
;        Spurion2_drawplot_class::draw
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro Spurion2_drawplot_class::draw,$
                        a,b,c,alpha,beta,gamma,o1,o2,$
                        printwin=printwin,$
                       defaultPrinter=defaultPrinter,$
                        ps=ps,jpg=jpg,printdir=printdir,$
                        _Ref_Extra=extra;,position=position,_Extra=extra
;help,/traceback

;    print,'Spurion2_drawplot_class::draw'
;    help,extra
;    print,tag_names(extra)
;    print,extra.(0)


catch,es
if es ne 0 then begin
    void = dialog_message('Problem at Spurion2_drawplot_class::draw')
    catch,/cancel
    return
endif

    ;SET USER SYMBOL HERE IN CASE IT WAS CHANGED ELSEWHERE
    setCircleSymbol

    if n_elements(printwin) eq 0 then printwin = 0
    if n_elements(jpg) eq 0 then jpg = 0
    if n_elements(ps) eq 0 then ps = 0
    if n_elements(position) eq 4 then begin
	    self.position = position;self.position
    endif

    device,get_decomposed=dc
    device,decomposed=1

;if n_elements(a) eq 0 then a = 2*!PI
;if n_elements(b) eq 0 then b = 2*!PI
;if n_elements(c) eq 0 then c = 2*!PI
;
;if n_elements(alpha) eq 0 then alpha = 90
;if n_elements(beta) eq 0 then beta = 90
;if n_elements(gamma) eq 0 then gamma = 90
;
;o1 = [1.0,0,0]
;o2 = [0.0,1,1]
;help,a,b,c,alpha,beta,gamma
        a = self.abc[0]
        b = self.abc[1]
        c = self.abc[2]

        alpha = self.abg[0]
        beta  = self.abg[1]
        gamma = self.abg[2]

        o1 = self.o1
        o2 = self.o2


        win = self->setwindow() ;THE PRINT METHOD SHOULD CHANGE THE WINDOW TO 'PS'
                                ;AND THEN CHANGE IT BACK AT THE END OF PRINTING.
                                ;setWindow and copyWindow FUNCTIONALITY SHOULE BE
                                ;SET UP TO MAKE THE PRINT PROCESS WORK OUT.



        if win ne 0 then begin
            if self.zoomboxflag eq 0 then begin
                        black = 0L
                        red = 255L & green = 256L*red & blue = 256L*green
                        white = red + green + blue

                        xrange = self.zoomxrange
                        yrange = self.zoomyrange

                        if self.zoomflag eq 1 then begin
                            xstyle = 1
                            ystyle = 1
                        endif else begin
                            xstyle = 0
                            ystyle = 0
                        endelse

                        xaxisstyle = 4
                        yaxisstyle = 4




                ;THIS PLOT TO A VIRTUAL WINDOW IS NECESSARY TO GET THE EXACT RANGES THAT WILL
                ;BE USED IN THE FINAL PLOT.


                ;FIRST DO A DUMMY PLOT WITH THE EXACT AXES FOR 1/A UNITS.
                ;THIS IS NECESSARY BECAUSE IF EXACT RANGES ARE NOT BEING ENFORCED,
                ;I WANT THE DEFAULT RANGES IDL WOULD APPLY TO MY DATA.

                !p.font = -1
                        ;SET THE AXIS RANGES FOR THIS PLOT
                        if min(xrange) ne max(xrange) $
                            and min(yrange) ne max(yrange) then begin


                                ;HERE IS ORIGIN OF THE PROBLEM. x,ystyle eq 4 SUPPRESSES THE ENTIRE
                                ;AXIS, WHILE 1 FORCES THE EXACT RANGE.  I WANT TO FORCE THE EXACT RANGE
                                ;FOR THE LEFT AND TOP AXES THEN CALCULATE THE PRINCIPLE AXES FROM THAT.
                                ;INSTEAD I MUST REVERSE THIS PROCESS AND USE x,ystyle = 1

                                plot,xrange,yrange,/nodata,background=white,$
                                    xrange = xrange,$;self.zoomxrange,$
                                    yrange = yrange,$;self.zoomyrange,$
                                    xstyle = xstyle,$;xaxisstyle,
                                    ystyle = ystyle,$;yaxisstyle,$
                                    color = black,$
                                    ;title=self.title,$
                                    xtitle=self.xtitle,$
                                    ytitle=self.ytitle,$
                                    xlog = self.xlog,$
                                    ylog = self.ylog,$
                                    position = self.position,$
                                    font=font,$
                                    xticks=4

                        endif else begin
                                plot,xrange,yrange,/nodata,background=white,$
                                    xstyle=xaxisstyle,ystyle=yaxisstyle,$
                                    color = black,$
                                    ;title=self.title,$
                                    xtitle=self.xtitle,$
                                    ytitle=self.ytitle,$
                                    xlog = self.xlog,$
                                    ylog = self.ylog,$
                                    font=font,$
                                    position = self.position
                        endelse

                ;########################################################################
                ;030507
                ;RESET THE AXIS POINTERS TO THE RLU AXES, BUT THIS SETTING OF THE RANGES SHOULD REMAIN
                ;SINCE IT IS USED TO SYNC THE RLU AND 1/Ang AXES.

                    ;RELEASE AXIS POINTERS FOR WINDOW
                    ptr_free,self.xptr
                    ptr_free,self.yptr

                    ;RESET AXIS POINTERS BASED ON PLOT RANGE
                    self.xptr = ptr_new(!x)           ;MUST SET THESE HERE TO ASSIGN
                    self.yptr = ptr_new(!y)           ;POINTERS TO PROPER AXES!!!
                ;########################################################################
                    xrange = !x.crange
                    yrange = !y.crange
                ;print,xrange
                ;print,yrange


                ;NOW SCALE THE DATA TO RLU AND DO AN EXAXT PLOT WITH THOSE AXES.
                ;THIS SHOULD ERASE THE OLD PLOT.


                ;STEP ONE, PLOT WITH THE EXACT RANGE AND GET THE RANGES BEFORE NOW.

                ;STEP TWO, CALCULATE THE RANGES FOR THE





                ;##############################
                ;SET UP ALTERNATE AXES
                ;##############################

                    val = recip_lattice(a,b,c,alpha,beta,gamma)
                    b1    = val.b123.b1
                    b2    = val.b123.b2
                    b3    = val.b123.b3

                ;THE FOLLOWING SETS THE AXES ALONG o1,o2
                    o1vec = (o1[0]*b1 + o1[1]*b2 + o1[2]*b3)
                    o2vec = (o2[0]*b1 + o2[1]*b2 + o2[2]*b3)


                    mago1vec = sqrt(dotp(o1vec,o1vec))
                    mago2vec = sqrt(dotp(o2vec,o2vec))

                    ;CREATE UNIT VECTORS ALONG THE o1,o2 DIRECTIONS ---  THIS SHOULD NOT BE USED IN
                    xhat_o1 = o1vec/mago1vec                            ;GENERAL SINCE THEY ARE ALONG
                    yhat_o2 = o2vec/mago2vec                            ;THE ORIENTATION VECTOR DIRECTIONS
                                                                        ;AND MAY NOT BE ORTHOGONAL.

                    xhat = xhat_o1
                    xhat = xhat/sqrt(dotp(xhat,xhat))
                    zhat = crossp(xhat_o1,yhat_o2)
                    zhat = zhat/sqrt(dotp(zhat,zhat))
                    yhat = crossp(zhat,xhat)
                    yhat = yhat/sqrt(dotp(yhat,yhat))

                ;    xtitle = 'X ['+angstrom()+'^-1]  || ['+ $
                    xtitle = 'X [1/Ang]  || ['+ $
                                strtrim(string(o1[0],format='(f4.1)'),2)+','+ $
                                strtrim(string(o1[1],format='(f4.1)'),2)+','+ $
                                strtrim(string(o1[2],format='(f4.1)'),2)+']';o1[0]*b1+o1[1]*b2+o1[2]*b3'
                    ;ytitle = 'Y ['+angstrom()+'^-1]  || Z x X';perp o1.[b1,b2,b3],coplanar w/o1.[b1,b2,b3]&o2.[b1,b2,b3]'
                ;    ytitle = 'Y ['+angstrom()+'^-1]  || '+ $
                    ytitle = 'Y [1/Ang]  || ['+ $
                                strtrim(string(yhat[0],format='(f5.2)'),2)+','+ $
                                strtrim(string(yhat[1],format='(f5.2)'),2)+','+ $
                                strtrim(string(yhat[2],format='(f5.2)'),2)+']'

                    overalltitle = 'Plane perp to Z = O1 x O2'


                    xtitle0 = 'X [rlu]  || ['+ $
                                strtrim(string(o1[0],format='(f4.1)'),2)+','+ $
                                strtrim(string(o1[1],format='(f4.1)'),2)+','+ $
                                strtrim(string(o1[2],format='(f4.1)'),2)+']'
                ;    ytitle0 = 'Y [rlu]  || Z x X'


                    ytitle0 = 'Y [rlu]  || ['+ $
                                strtrim(string(yhat[0],format='(f5.2)'),2)+','+ $
                                strtrim(string(yhat[1],format='(f5.2)'),2)+','+ $
                                strtrim(string(yhat[2],format='(f5.2)'),2)+']'
                    ;THESE AXES ARE THE PRIMARY AXES IN spurion
                    ;THEY ARE IN UNITS OF hkl, i.e. DIMENSIONLESS!!!
                    xscale = mago1vec


                    ;GET ANGLE OF o2 WRT X AXIS
                    o2theta = acos(dotp(o2vec,xhat)/mago2vec)
                    ;CALCULATE THE COMPONENT OF o2 ALONG Y
                    yscale  = mago2vec/sin(o2theta)
                ;    print,'In Spurion2_drawplot_class::draw yscale=',yscale
                    ;CREATE ALTERNATE Y AXIS

                ;print,'xscale,yscale=',xscale,yscale


                ;FIRST DO THE PLOT IN RLU WITH NORMAL AXES
                !p.font = -1
                        ;SET THE AXIS RANGES FOR THIS PLOT
                        plot,xrange,yrange,/nodata,background=white,$
                            xrange = xrange/xscale,$;self.zoomxrange,$
                            yrange = yrange/yscale,$;self.zoomyrange,$
                            xstyle=1,$
                            ystyle=1,$
                            color = black,$
                            ;title=self.title,$
                            xtitle=xtitle0,$;self.xtitle,$
                            ytitle=ytitle0,$;self.ytitle,$
                            xlog = self.xlog,$
                            ylog = self.ylog,$
                            position = self.position,$
                            font=font;,xticks=4

                ;;;;;;########################################################################
                ;;;;;;030507
                ;;;;;;SET THE AXIS SCALE HERE.
                ;;;;;    ;RELEASE AXIS POINTERS FOR WINDOW
                ;;;;;    ptr_free,self.xptr
                ;;;;;    ptr_free,self.yptr
                ;;;;;
                ;;;;;    ;RESET AXIS POINTERS BASED ON PLOT RANGE
                ;;;;;    self.xptr = ptr_new(!x)           ;MUST SET THESE HERE TO ASSIGN
                ;;;;;    self.yptr = ptr_new(!y)           ;POINTERS TO PROPER AXES!!!
                ;;;;;;########################################################################

                ;            xyouts,0.1,0.98,'TEST FILE NAME',color=black,/normal,charsize=1.25
                            if self.title ne '' then begin
                                xyouts,0.1,0.95,self.title,color=black,/normal,charsize=1.25
                            endif
                            if self.bigtitle ne '' then begin
                                ;xyouts,0.1,0.98,'TEST FILE NAME',color=black,/normal,charsize=1.25
                                xyouts,0.2,0.97,self.bigtitle,color=black,/normal,charsize=1.25
                            endif

                ;NOW COVER THE ALTERNATE AXES
                    AXIS, XAXIS=1, XRANGE = XRANGE/xscale, XSTYLE = 1, $
                          XTITLE = xtitle0,color=white;,xcharsize=1.0

                    AXIS, YAXIS=1, YRANGE = YRANGE/yscale, YSTYLE = 1, $
                          YTITLE = ytitle0,color=white;,ycharsize=1.0


                ;FINALLY, PLACE THE ALTERNATE AXIS WITH 1/A UNITS.
                    AXIS, XAXIS=1, XRANGE = xrange,$;!x.crange,
                          XSTYLE = 1, $
                          XTITLE = xtitle,color=0L,xcharsize=1.0;0.75
                    AXIS, YAXIS=1, YRANGE = yrange,$;!y.crange,
                          YSTYLE = 1, $
                          YTITLE = ytitle,color=0L,ycharsize=1.0;0.65


                    thick = 2

                    !x = *self.xptr
                    !y = *self.yptr

            ;############################################################

                    ;OPLOT THE DATA
                    self->oplot,xscale=1.0,$;xscale,$
                                yscale=1.0,$;yscale,$
                                win,_strict_Extra=extra


                    self->showMode,win
                    self->saveWindow

        endif else begin
            geom = widget_info(self.draw,/geometry)
            device,copy=[0,0,geom.xsize,geom.ysize,0,0,self.winsav]
        endelse

;PERHAPS WANT A ZOOMBOX v. SELECTBOX OPTION.
        self->zoombox,win

        self->copywindow
        if printwin eq 1 then self->printWindow,jpg=jpg,ps=ps,printdir=printdir,defaultPrinter=defaultPrinter
        

    endif

    device,decomposed = dc
end;Spurion2_drawplot_class::draw


;###############################################################################
;
;NAME:
;        Spurion2_drawplot_class::showMode
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro Spurion2_drawplot_class::showMode,win


        ;SHOW THE CURRENT MODE IN THE LOWER LEFTHAND CORNER OF THE PLOT


    if self.hidemodelabel eq 0 then begin
        wset,win
        device,get_decomposed=dc
        device,decomposed=1


        mode = ['ZOOM','POSITION','START/END','REGION']
        s = 'MODE = '+mode[self.zoom_selectmode]
        xyouts,0.0,0.0,s,/normal,color=0L,charsize=.75
        device,decomposed=dc
    endif


end;showMode

;###############################################################################
;
;NAME:
;        Spurion2_drawplot_class::getDataRange
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro Spurion2_drawplot_class::getDataRange,xmin=xin,xmax=xmax,ymin=ymin,ymax=ymax



    self->getInvAng2RLU,xscale,yscale

    count = self->count()   ;inherited from idl_container


    if count gt 0 then begin
        ref = self->get(position=0)
        xvals = ref->xrange()
        yvals = ref->yrange()


        for i=1,count-1 do begin
            ref = self->get(position=i)
            xvals = [xvals,ref->xrange()]
            yvals = [yvals,ref->yrange()]
        endfor;i
        xmin = min(xvals);*xscale
        xmax = max(xvals);*xscale
        ymin = min(yvals);*yscale
        ymax = max(yvals);*yscale


        self.xrange = [xmin,xmax]
        self.yrange = [ymin,ymax]

;print,'Spurion2_drawplot_class::getDataRange:',self.xrange,self.yrange,xscale,yscale
    endif else begin
        self.xrange = [0,1]
        self.yrange = [0,1]
        self.zoomxrange = [0,1]
        self.zoomyrange = [0,1]
    endelse

end;Spurion2_drawplot_class::getDataRange

pro Spurion2_drawplot_class::updateDataRanges,xmin=xmin,xmax=xmax,ymin=ymin,ymax=ymax,$
                                        xlog=xlog,ylog=ylog
;print,'Spurion2_drawplot_class::updateDataRanges'
    self->getInvAng2RLU,xscale,yscale

    if n_elements(xlog) eq 1 then self->setxlog,xlog
    if n_elements(ylog) eq 1 then self->setylog,ylog
    self->setDataRange,xmin=xmin,xmax=xmax,ymin=ymin,ymax=ymax

end;updateDataRanges
pro Spurion2_drawplot_class::retrieveDataRanges,xmin=xmin,xmax=xmax,ymin=ymin,ymax=ymax,$
                                     xlog=xlog,ylog=ylog

    self->getInvAng2RLU,xscale,yscale

    xmin=self.zoomxrange[0];*xscale
    xmax=self.zoomxrange[1];*xscale
    ymin=self.zoomyrange[0];*yscale
    ymax=self.zoomyrange[1];*yscale
    xlog = self.xlog
    ylog = self.ylog

end;Spurion2_drawplot_class::retrieveDataRanges

pro Spurion2_drawplot_class::getInvAng2RLU,xscale,yscale


    a = self.abc[0]
    b = self.abc[1]
    c = self.abc[2]

    alpha = self.abg[0]
    beta  = self.abg[1]
    gamma = self.abg[2]

    o1 = self.o1
    o2 = self.o2

;##############################
;SET UP ALTERNATE AXES
;##############################

    val = recip_lattice(a,b,c,alpha,beta,gamma)
    b1    = val.b123.b1
    b2    = val.b123.b2
    b3    = val.b123.b3

;THE FOLLOWING SETS THE AXES ALONG o1,o2
    o1vec = (o1[0]*b1 + o1[1]*b2 + o1[2]*b3)
    o2vec = (o2[0]*b1 + o2[1]*b2 + o2[2]*b3)

    mago1vec = sqrt(dotp(o1vec,o1vec))
    mago2vec = sqrt(dotp(o2vec,o2vec))

    ;CREATE UNIT VECTORS ALONG THE o1,o2 DIRECTIONS ---  THIS SHOULD NOT BE USED IN
    xhat_o1 = o1vec/mago1vec                            ;GENERAL SINCE THEY ARE ALONG
    yhat_o2 = o2vec/mago2vec                            ;THE ORIENTATION VECTOR DIRECTIONS
                                                        ;AND MAY NOT BE ORTHOGONAL.

    xhat = xhat_o1
    xhat = xhat/sqrt(dotp(xhat,xhat))
    zhat = crossp(xhat_o1,yhat_o2)
    zhat = zhat/sqrt(dotp(zhat,zhat))
    yhat = crossp(zhat,xhat)
    yhat = yhat/sqrt(dotp(yhat,yhat))

    ;THESE AXES ARE THE PRIMARY AXES IN spurion
    ;THEY ARE IN UNITS OF hkl, i.e. DIMENSIONLESS!!!
    xscale = mago1vec
    ;GET ANGLE OF o2 WRT X AXIS
    o2theta = acos(dotp(o2vec,xhat)/mago2vec)
    ;CALCULATE THE COMPONENT OF o2 ALONG Y
    yscale  = mago2vec/sin(o2theta)

end;Spurion2_drawplot_class::getInvAng2RLU

;###############################################################################
;
;NAME:
;        Spurion2_drawplot_class::legend
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro Spurion2_drawplot_class::legend,win,yoffset,legend,psym,symsize,color,linestyle,$
                        showdata,showlegend,_Extra=extra


        for i = 0, self->count()-1 do begin
            ref = self->get(position=i)
            ref->legend,win,self.xlegend,self.ylegend-0.04*i,symsize=0.85
        endfor;i


end;Spurion2_drawplot_class::legend



;###############################################################################
;
;NAME:
;        Spurion2_drawplot_class::oplot
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro Spurion2_drawplot_class::oplot,xscale=xscale,yscale=yscale,win,_ref_Extra=extra    ;OVERRIDE IN SUBCLASSES

    if n_elements(xscale) eq 0 then xscale = 1.0
    if n_elements(yscale) eq 0 then yscale = 1.0


    ;OVERPLOT THE DATA OBJECTS IN THE PLOT.
    for i = 0, self->count()-1 do begin

        ;071806
        ;
        !x = *self.xptr
        !y = *self.yptr

        ref = self->get(position=i)
        ref->draw,win,xscale=xscale,yscale=yscale,_strict_Extra=extra
    endfor;i


    ;NEED SEPARATE LEGEND CALL SO THAT THE SETTING OF NORMAL COORDS FOR
    ;LEGENDS DOES NOT CONFLICT WITH THE PLOT COORDINATES
    if self.showlegend gt 0 then begin
        self->legend,win,_strict_Extra=extra
    endif


end;Spurion2_drawplot_class::oplot





;###############################################################################
;
;NAME:
;        Spurion2_drawplot_class::setDataRange
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro Spurion2_drawplot_class::setDataRange,xmin=xmin,xmax=xmax,ymin=ymin,ymax=ymax,no_draw=no_draw


    ;SET THE ZOOM RANGE BASED ON THE INPUTS.


    ;QUIT DRAWING THE BOX AND SET THE RANGE

    if n_elements(no_draw) eq 0 then no_draw = 0


    if n_elements(xmin) ne 0 then self.zoomxrange[0] = xmin
    if n_elements(xmax) ne 0 then self.zoomxrange[1] = xmax
    if n_elements(ymin) ne 0 then self.zoomyrange[0] = ymin
    if n_elements(ymax) ne 0 then self.zoomyrange[1] = ymax


    if no_draw eq 0 then begin
        self->draw
    endif

end;setDataRange
;###############################################################################
;
;NAME:
;        Spurion2_drawplot_class::setZoomRange
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro Spurion2_drawplot_class::setZoomRange


    ;SET THE ZOOM RANGE BASED ON THE MOUSE POSITIONS.


    ;QUIT DRAWING THE BOX AND SET THE RANGE

        xmin = min([self.pressxy[0],self.releasexy[0]])
        xmax = max([self.pressxy[0],self.releasexy[0]])
        ymin = min([self.pressxy[1],self.releasexy[1]])
        ymax = max([self.pressxy[1],self.releasexy[1]])


;TO USE

    !x = *self.xptr
    !y = *self.yptr


    mincoords = convert_coord([xmin,ymin],/device,/to_data)
    maxcoords = convert_coord([xmax,ymax],/device,/to_data)


    self.zoomxrange = [mincoords[0],maxcoords[0]]
    self.zoomyrange = [mincoords[1],maxcoords[1]]



end;setZoomRange
;###############################################################################
;
;NAME:
;        Spurion2_drawplot_class::setxlog
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro Spurion2_drawplot_class::setxlog,xlog
    logxmode = widget_info(self.contextmenu,find_by_uname='LOGXMODE')
    if widget_info(logxmode,/valid) gt 0 then begin
        self.xlog = xlog
        char = (self.xlog eq 1 ? 'X' : '_')
        widget_control,logxmode,set_value='['+char+'] log(x)'
    endif
end;setxlog
;###############################################################################
;
;NAME:
;        Spurion2_drawplot_class::setylog
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro Spurion2_drawplot_class::setylog,ylog

    logymode = widget_info(self.contextmenu,find_by_uname='LOGYMODE')
    if widget_info(logymode,/valid) gt 0 then begin
        self.ylog = ylog
        char = (self.ylog eq 1 ? 'X' : '_')
        widget_control,logymode,set_value='['+char+'] log(y)'
    endif
end;setylog


;###############################################################################
;
;NAME:
;        Spurion2_drawplot_class::range
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro Spurion2_drawplot_class::range,xmin=xmin,xmax=xmax,ymin=ymin,ymax=ymax
    ;SET THE ZOOM RANGE EXPLICITLY. CALLED BY OUTSIDE USER.


        if n_elements(xmin) eq 0 then xmin = self.zoomxrange[0]
        if n_elements(xmax) eq 0 then xmax = self.zoomxrange[1]
        if n_elements(ymin) eq 0 then ymin = self.zoomyrange[0]
        if n_elements(ymax) eq 0 then ymax = self.zoomyrange[1]


    self.zoomflag = 1
    self.zoomxrange = [xmin,xmax]
    self.zoomyrange = [ymin,ymax]


end;range



;##########################################
;STARTUP METHODS
;##########################################
;###############################################################################
;
;NAME:
;        Spurion2_drawplot_class::createContextMenu
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;RETURN VALUE:
;
;###############################################################################
function Spurion2_drawplot_class::createContextMenu



    ;print,'Creating Context Menu:'


    self.contextMenu = widget_base( self.tlb, $
                                    /CONTEXT_MENU,/col,$
                                    uname = 'Spurion2_drawplot_class_CONTEXTMENU',$
                                    uvalue={object:self,$
                                            method:'drawEvents',$
                                            id:'Spurion2_drawplot_class_CONTEXTMENU'})


    bttn0 = widget_button(self.contextMenu, value='Unzoom',$
                                uname='UNZOOM',$
                                uvalue={object:self,$
                                        method:'contextMenuEvents',$
                                        id:'UNZOOM',$
                                        parent:'Spurion2_drawplot_class_CONTEXTMENU'})
    bttn0 = widget_button(self.contextMenu, value='Print to .ps',$
                                uname='PRINTPS',$
                                uvalue={object:self,$
                                        method:'contextMenuEvents',$
                                        id:'PRINTPS',$
                                        parent:'Spurion2_drawplot_class_CONTEXTMENU'})
    bttn0 = widget_button(self.contextMenu, value='Print to .jpg',$
                                uname='PRINTJPG',$
                                uvalue={object:self,$
                                        method:'contextMenuEvents',$
                                        id:'PRINTJPG',$
                                        parent:'Spurion2_drawplot_class_CONTEXTMENU'})
    bttn0 = widget_button(self.contextMenu, value='Print to Default Printer',$
                                uname='PRINTDEFAULTPRINTER',$
                                uvalue={object:self,$
                                        method:'contextMenuEvents',$
                                        id:'PRINTDEFAULTPRINTER',$
                                        parent:'Spurion2_drawplot_class_CONTEXTMENU'})


;REMOVING LOG OPTION FROM Spurion2_drawplot_class SINCE THIS IS ONLY USED FOR
;SCATTERING PLANE PLOT, WHICH IS NEVER LOG/LIN.


;    bttn1 = widget_button(self.contextMenu,value='Log/Lin',/menu)
;    bttn1a = widget_button(bttn1, value='[_] Log(x)',$
;                                uname='LOGXMODE',$
;                                uvalue={object:self,$
;                                        method:'contextMenuEvents',$
;                                        id:'LOGXMODE',$
;                                        parent:'Spurion2_drawplot_class_CONTEXTMENU'})
;    bttn1a = widget_button(bttn1, value='[_] Log(y)',$
;                                uname='LOGYMODE',$
;                                uvalue={object:self,$
;                                        method:'contextMenuEvents',$
;                                        id:'LOGYMODE',$
;                                        parent:'Spurion2_drawplot_class_CONTEXTMENU'})




    bttn1 = widget_button(self.contextMenu,value='Select/Zoom Mode',/menu)
    bttn1a = widget_button(bttn1, value='[X] Zoom',$
                                uname='ZOOMMODE',$
                                uvalue={object:self,$
                                        method:'contextMenuEvents',$
                                        id:'ZOOMMODE',$
                                        parent:'Spurion2_drawplot_class_CONTEXTMENU'})


    bttn1b = widget_button(bttn1, value='[_] Position',$
                                uname='POSITIONMODE',$
                                uvalue={object:self,$
                                        method:'contextMenuEvents',$
                                        id:'POSITIONMODE',$
                                        parent:'Spurion2_drawplot_class_CONTEXTMENU'})
    bttn1c = widget_button(bttn1, value='[_] Start/End',$
                                uname='START_ENDMODE',$
                                uvalue={object:self,$
                                        method:'contextMenuEvents',$
                                        id:'START_ENDMODE',$
                                        parent:'Spurion2_drawplot_class_CONTEXTMENU'})
    bttn1d = widget_button(bttn1, value='[_] Region Select',$
                                uname='REGIONMODE',$
                                uvalue={object:self,$
                                        method:'contextMenuEvents',$
                                        id:'REGIONMODE',$
                                        parent:'Spurion2_drawplot_class_CONTEXTMENU'})


    bttn1e = widget_button(bttn1, value='Hide/Show mode label',$
                                uname='HIDEMODELABEL',$
                                uvalue={object:self,$
                                        method:'contextMenuEvents',$
                                        id:'HIDEMODELABEL',$
                                        parent:'Spurion2_drawplot_class_CONTEXTMENU'})


    if !version.os eq 'Win32' then sensitive = 1 else sensitive = 0


    self.showHideSetMenu = widget_button(self.contextMenu,value='Show/Hide Set',$
                                                          /menu,$
                                                          sensitive=sensitive)


    self.showHideSetList = widget_button(self.showHideSetMenu,value='Sets:',/menu)


    return,1
end;createContextMenu



;##########################################
;GENERAL CLASS METHODS
;##########################################



;###############################################################################
;
;NAME:
;        Spurion2_drawplot_class::setData
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro Spurion2_drawplot_class::setData,x,y,sy,legend=legend,psym=psym,color=color,$
                  rescale=rescale,ebshow=ebshow,showlegend=showlegend,$
                  showdata=showdata,xtitle=xtitle,ytitle=ytitle,title=title,$
                  _Extra=extra


    if n_elements(x) gt 0 and n_elements(y) eq n_elements(x) then begin
        self->clearData
        self->add,x=x,y=y,sy=sy,legend=legend,psym=psym,color=color,$
                  rescale=rescale,ebshow=ebshow,showlegend=showlegend,$
                  showdata=showdata,_Extra=extra

        if n_elements(title)  gt 0 then self.title  = title
        if n_elements(xtitle) gt 0 then self.xtitle = xtitle
        if n_elements(ytitle) gt 0 then self.ytitle = ytitle

    endif


end;setData



;###############################################################################
;
;NAME:
;        Spurion2_drawplot_class::hideData
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro Spurion2_drawplot_class::hideData,position=position

    if n_elements(position) eq 0 then position = -1

    if position ne -1 then begin
        dat = self->get(position=position)
        if obj_valid(dat) then begin
            dat->hide
            dat->hidelegend
        endif
    endif else begin


        ;REMOVE ALL
        count = self->count()

        if count gt 0 then begin
            for i=0,count-1 do begin
                dat = self->get(position=i)
                dat->hide
                dat->hidelegend
            endfor;i
        endif;count


    endelse


end;hideData



;###############################################################################
;
;NAME:
;        Spurion2_drawplot_class::setProperty
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro Spurion2_drawplot_class::setProperty,$
                parent=parent,$
                tlb=tlb,$
                draw=draw,$
                winpix=winpix,$
                winvis=winvis,$
                xptr=xptr,$
                yptr=yptr,$
                xhide=xhide,yhide=yhide,$
                xshow=xshow,yshow=yshow,$
                showplot=showplot,$
                leftMousePressed=leftMousePressed,$
                rightMousePressed=rightMousePressed,$
                mousexy=mousexy,$
                pressxy=pressxy,$
                releasexy=releasexy,$
                    zoomflag=zoomflag,$
                    zoomboxflag=zoomboxflag,$
                    zoomxrange=zoomxrange,$
                    zoomyrange=zoomyrange,$
                    xrange=xrange,$
                    yrange=yrange,$
                    bigtitle=bigtitle,$
                    title=title,$
                    subtitle=subtitle,$
                    xtitle=xtitle,$
                    ytitle=ytitle,$
                    xlog=xlog,$
                ylog=ylog,$
                xlegend=xlegend,$
                ylegend=ylegend,$
                showlegend=showlegend,$
                black=black,$
                red=red,$
                green=green,$
                blue=blue,$
                white=white,$
                frame=frame,$
                contextmenu=contextmenu,$
                _ref_extra=extra

        if n_elements(parent) ne 0 then self.parent=parent
        if n_elements(tlb) ne 0 then self.tlb =tlb
        if n_elements(draw) ne 0 then self.draw =draw
        if n_elements(winpix) ne 0 then self.winpix =winpix
        if n_elements(winvis) ne 0 then self.winvis =winvis
        if n_elements(xptr) ne 0 then self.xptr =xptr
        if n_elements(yptr) ne 0 then self.yptr =yptr
        if n_elements(xhide) ne 0 then self.xhide =xhide
        if n_elements(yhide) ne 0 then self.yhide =yhide
        if n_elements(xshow) ne 0 then self.xshow =xshow
        if n_elements(yshow) ne 0 then self.yshow =yshow
        if n_elements(showplot) ne 0 then self.showplot =showplot


        if n_elements(leftMousePressed) ne 0 then self.leftMousePressed = leftMousePressed
        if n_elements(rightMousePressed) ne 0 then self.rightMousePressed = rightMousePressed
        if n_elements(mousexy) ne 0 then self.mousexy = mousexy
        if n_elements(pressxy) ne 0 then self.pressxy = pressxy
        if n_elements(releasexy) ne 0 then self.releasexy = releasexy
        if n_elements(zoomflag) ne 0 then self.zoomflag = zoomflag
        if n_elements(zoomboxflag) ne 0 then self.zoomboxflag = zoomboxflag
        if n_elements(zoomxrange) ne 0 then self.zoomxrange = zoomxrange
        if n_elements(zoomyrange) ne 0 then self.zoomyrange = zoomyrange
        if n_elements(xrange) ne 0 then self.xrange = xrange
        if n_elements(yrange) ne 0 then self.yrange = yrange
        if n_elements(bigtitle) ne 0 then self.bigtitle = bigtitle
        if n_elements(title) ne 0 then self.title = title
        if n_elements(subtitle) ne 0 then self.subtitle = subtitle
        if n_elements(xtitle) ne 0 then self.xtitle = xtitle
        if n_elements(ytitle) ne 0 then self.ytitle = ytitle
        if n_elements(xlog) ne 0 then self.xlog = xlog
        if n_elements(ylog) ne 0 then self.ylog = ylog
        if n_elements(xlegend) ne 0 then self.xlegend = xlegend
        if n_elements(ylegend) ne 0 then self.ylegend = ylegend
        if n_elements(showlegend) ne 0 then self.showlegend = showlegend
        if n_elements(black) ne 0 then self.black = black
        if n_elements(red) ne 0 then self.red = red
        if n_elements(green) ne 0 then self.green = green
        if n_elements(blue) ne 0 then self.blue = blue
        if n_elements(white) ne 0 then self.white = white
        if n_elements(frame) ne 0 then self.frame = frame
        if n_elements(contextmenu) ne 0 then self.contextmenu = contextmenu



end;Spurion2_drawplot_class::setProperty


;###############################################################################
;
;NAME:
;        Spurion2_drawplot_class::getProperty
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro Spurion2_drawplot_class::getProperty,$
                parent=parent,$
                tlb=tlb,$
                draw=draw,$
                winpix=winpix,$
                winvis=winvis,$
                xptr=xptr,$
                yptr=yptr,$
                xhide=xhide,yhide=yhide,$
                xshow=xshow,yshow=yshow,$
                showplot=showplot,$
                leftMousePressed=leftMousePressed,$
                rightMousePressed=rightMousePressed,$
                mousexy=mousexy,$
                pressxy=pressxy,$
                releasexy=releasexy,$
                    zoomflag=zoomflag,$
                    zoomboxflag=zoomboxflag,$
                    zoomxrange=zoomxrange,$
                    zoomyrange=zoomyrange,$
                    xrange=xrange,$
                    yrange=yrange,$
                    bigtitle=bigtitle,$
                    title=title,$
                    subtitle=subtitle,$
                    xtitle=xtitle,$
                    ytitle=ytitle,$
                    xlog=xlog,$
                ylog=ylog,$
                xlegend=xlegend,$
                ylegend=ylegend,$
                showlegend=showlegend,$
                black=black,$
                red=red,$
                green=green,$
                blue=blue,$
                white=white,$
                frame=frame,$
                contextmenu = contextmenu,$
                _ref_extra=extra




    if arg_present(parent) ne 0 then parent = self.parent
    if arg_present(tlb) ne 0 then tlb = self.tlb


    if arg_present(draw) ne 0 then draw = self.draw
    if arg_present(winpix) ne 0 then winpix = self.winpix
    if arg_present(winvis) ne 0 then winvis = self.winvis
    if arg_present(xptr) ne 0 then xptr=self.xptr
    if arg_present(yptr) ne 0 then yptr=self.yptr
    if arg_present(leftMousePressed) ne 0 then leftMousePressed=self.leftMousePressed
    if arg_present(rightMousePressed) ne 0 then rightMousePressed=self.rightMousePressed
    if arg_present(mousexy) ne 0 then mousexy=self.mousexy
    if arg_present(pressxy) ne 0 then pressxy=self.pressxy
    if arg_present(releasexy) ne 0 then releasexy=self.releasexy
    if arg_present(zoomflag) ne 0 then zoomflag=self.zoomflag
    if arg_present(zoomboxflag) ne 0 then zoomboxflag=self.zoomboxflag
    if arg_present(zoomxrange) ne 0 then zoomxrange=self.zoomxrange
    if arg_present(zoomyrange) ne 0 then zoomyrange=self.zoomyrange
    if arg_present(xrange) ne 0 then xrange=self.xrange
    if arg_present(yrange) ne 0 then yrange=self.yrange
    if arg_present(bigtitle) ne 0 then bigtitle=self.bigtitle
    if arg_present(title) ne 0 then title=self.title
    if arg_present(subtitle) ne 0 then subtitle=self.subtitle
    if arg_present(xtitle) ne 0 then xtitle=self.xtitle
    if arg_present(ytitle) ne 0 then ytitle=self.ytitle
    if arg_present(xlog) ne 0 then xlog=self.xlog
    if arg_present(ylog) ne 0 then ylog=self.ylog
    if arg_present(xlegend) ne 0 then xlegend=self.xlegend
    if arg_present(ylegend) ne 0 then ylegend=self.ylegend
    if arg_present(showlegend) ne 0 then showlegend=self.showlegend
    if arg_present(black) ne 0 then black=self.black
    if arg_present(red) ne 0 then red=self.red
    if arg_present(green) ne 0 then green=self.green
    if arg_present(blue) ne 0 then blue=self.blue
    if arg_present(white) ne 0 then white=self.white
    if arg_present(frame) ne 0 then frame = self.frame
    if arg_present(contextmenu) ne 0 then contextmenu = self.contextmenu

    if arg_present(xhide) ne 0 then xhide =self.xhide
    if arg_present(yhide) ne 0 then yhide =self.yhide
    if arg_present(xshow) ne 0 then xshow =self.xshow
    if arg_present(yshow) ne 0 then yshow =self.yshow
    if arg_present(showplot) ne 0 then showplot =self.showplot



end;Spurion2_drawplot_class::getproperty
;###############################################################################
;
;NAME:
;        Spurion2_drawplot_class_cleanup
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro Spurion2_drawplot_class_cleanup,id
    widget_control,id,get_uvalue=obj
    obj_destroy,obj
end;Spurion2_drawplot_class_cleanup
;###############################################################################
;
;NAME:
;        Spurion2_drawplot_class::cleanup
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro Spurion2_drawplot_class::cleanup

    self->cwo_drawplot_class::cleanup

end;Spurion2_drawplot_class::cleanup


;###############################################################################
;
;NAME:
;        Spurion2_drawplot_class::setvalues
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro Spurion2_drawplot_class::setvalues,xmin=xmin,$
                            xmax=xmax,$
                            ymin=ymin,$
                            ymax=ymax,$
                            xlog=xlog,$
                            ylog=ylog


    self->range,xmin=xmin,$
                xmax=xmax,$
                ymin=ymin,$
                ymax=ymax


    self->setxlog,xlog
    self->setylog,ylog


end;setvalues


;###############################################################################
;
;NAME:
;        Spurion2_drawplot_class_set_value
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro Spurion2_drawplot_class_set_value,id,value
    print,'set_value'
end;Spurion2_drawplot_class_set_value
;###############################################################################
;
;NAME:
;        Spurion2_drawplot_class_get_value
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;RETURN VALUE:
;
;###############################################################################
function Spurion2_drawplot_class_get_value,id
    print,'get_value'
    stash = widget_info(id,/child)
    widget_control,stash,get_uvalue=obj
    return,obj
end;Spurion2_drawplot_class_get_value

pro Spurion2_drawplot_class::setLatticeValues,abc=abc,abg=abg,o1=o1,o2=o2,$
                                    _ref_extra=extra

    if n_elements(abc) eq 3 then self.abc = abc
    if n_elements(abg) eq 3 then self.abg = abg
    if n_elements(o1)  eq 3 then self.o1  = o1
    if n_elements(o2)  eq 3 then self.o2  = o2

end;setLatticeValues

;###############################################################################
;
;NAME:
;        Spurion2_drawplot_class::init
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;RETURN VALUE:
;
;###############################################################################
function Spurion2_drawplot_class::init,parent, tlb=tlb,$
                                    xhide=xhide,yhide=yhide,$
                                    xshow=xshow,yshow=yshow,$
                                    showplot=showplot,$
                                    xsize=xsize,$
                                    ysize=ysize,$
                                    uvalue=uvalue,$
                                    uname=uname,$
                                    frame=frame,$
                                    bigtitle=bigtitle,$
                                    title=title,$
                                    xtitle=xtitle,$
                                    ytitle=ytitle,$
                                    kill_notify=kill_notify,$
				                    position=position,$
				                    xoffset=xoffset,yoffset=yoffset,$
                                    abc=abc,abg=abg,o1=o1,o2=o2,$
                                    _ref_extra=extra

    if n_elements(abc) eq 3 then self.abc = abc
    if n_elements(abg) eq 3 then self.abg = abg
    if n_elements(o1)  eq 3 then self.o1  = o1
    if n_elements(o2)  eq 3 then self.o2  = o2
    if n_elements(bigtitle) eq 0 then self.bigtitle = '' else self.bigtitle=bigtitle


    ret = self->cwo_drawplot_class::init(parent, tlb=tlb,$
                                    xhide=xhide,yhide=yhide,$
                                    xshow=xshow,yshow=yshow,$
                                    showplot=showplot,$
                                    xsize=xsize,$
                                    ysize=ysize,$
                                    uvalue=uvalue,$
                                    uname=uname,$
                                    frame=frame,$
                                    title=title,$
                                    xtitle=xtitle,$
                                    ytitle=ytitle,$
                                    kill_notify=kill_notify,$
				                    position=position,$
				                    xoffset=xoffset,yoffset=yoffset,$
                                    _extra=extra)

    return,1
end;Spurion2_drawplot_class::init


;###############################################################################
;
;NAME:
;        Spurion2_drawplot_class__define
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro Spurion2_drawplot_class__define,class



    ;NOTE THAT THIS BASE CLASS WILL SIMPLY PROVIDE THE PLOTTING
    ;AND INTERACTION CAPABILITY WITHOUT THE SPECIFIC DATA.
    ;THE SPECIFIC DATA WILL BE HANDLED IN THE SUBCLASSES
    ;USING SUBCLASS VARIABLES.


    ;BUT WAIT, THIS IS A CONTAINER!!!!
    ;THE DATA WILL BE STORED IN DATA OBJECTS!!!



    class = {   Spurion2_drawplot_class,$          ;inherits cwo_drawplot,$
                inherits cwo_drawplot_class,$
                abc:dblarr(3),$
                abg:dblarr(3),$
                o1:dblarr(3),$
                o2:dblarr(3),$
                x0title:'',$
                y0title:'',$
                x1title:'',$
                y1title:'',$
                bigtitle:''}


end;Spurion2_drawplot_class__define,class






;###############################################################################
;
;NAME:
;        Spurion2_drawplot
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;RETURN VALUE:
;
;###############################################################################
function Spurion2_drawplot,parent,obj=obj,xsize=xsize,ysize=ysize,$
                      uvalue=uvalue,position=position,$
                      xoffset=xoffset,yoffset=yoffset,$
                      title=title,xtitle=xtitle,ytitle=ytitle,$
                      xhide=xhide,yhide=yhide,$
                      xshow=xshow,yshow=yshow,$
                      showplot=showplot,$
                      frame=frame,abc=abc,abg=abg,o1=o1,o2=o2,$
                      _Extra=extra

    if n_elements(parent) eq 0 then return,0L

    if n_elements(frame) eq 0 then frame=0
    obj = obj_new('Spurion2_drawplot_class',parent,frame=frame,xsize=xsize,ysize=ysize,$
                                 uvalue=uvalue,position=position,$
                                 xoffset=xoffset,yoffset=yoffset,$
                                 xtitle=xtitle,ytitle=ytitle,title=title,$
                                 xhide=xhide,yhide=yhide,$
                                 xshow=xshow,yshow=yshow,$
                                 showplot=showplot,$
                                 abc=abc,abg=abg,o1=o1,o2=o2,$
                                 _Extra=extra)

    obj->getproperty,tlb=tlb
    return,tlb

end;Spurion2_drawplot
