
function recip_lattice,a,b,c,alpha,beta,gamma

    ;CALCULATES ALL THE RELEVANT ITEMS FOR
    ;A RECIPROCAL LATTICE GIVEN a,b,c,alpha,beta,gamma

    dtor = !DPI/double(180.0)

    a = double(a)
    b = double(b)
    c = double(c)
    alpha = double(alpha)
    beta  = double(beta)
    gamma = double(gamma)

    alp = dtor*alpha
    bet = dtor*beta
    gam = dtor*gamma


    ;BY CONVENTION PUT a ALONG X AXIS
    a1 = 2*!dPI*a*[1.,0.,0.]
    ;a1 = a*[1.,0.,0.]
    ;BY CONVENTION PUT b IN THE X-Y PLANE
    a2 = 2*!dPI*b*[cos(gam),sin(gam),0.0]
    ;a2 = b*[cos(gam),sin(gam),0.0]
    ;CALCULATE ANGLE BETWEEN a3 AND THE a1-a2 PLANE
    delta = acos(sqrt((cos(bet) + cos(alp)*cos(gam))^2.0 + (cos(alp)*sin(gam))^2.0))
    ;print,delta
    a3 = 2*!dPI*c*[cos(bet) + cos(alp)*cos(gam),cos(alp)*sin(gam),sin(delta)]
    ;a3 = c*[cos(bet) + cos(alp)*cos(gam),cos(alp)*sin(gam),sin(delta)]


    ;ZERO OUT COMPONENTS THAT ARE EFFECTIVELY ZERO HERE
    if abs(a1[0]) lt 1.0e-8 then a1[0] = 0.0
    if abs(a1[1]) lt 1.0e-8 then a1[1] = 0.0
    if abs(a1[2]) lt 1.0e-8 then a1[2] = 0.0

    if abs(a2[0]) lt 1.0e-8 then a2[0] = 0.0
    if abs(a2[1]) lt 1.0e-8 then a2[1] = 0.0
    if abs(a2[2]) lt 1.0e-8 then a2[2] = 0.0

    if abs(a3[0]) lt 1.0e-8 then a3[0] = 0.0
    if abs(a3[1]) lt 1.0e-8 then a3[1] = 0.0
    if abs(a3[2]) lt 1.0e-8 then a3[2] = 0.0


    ;MAKE AVAILABLE THE DIRECT LATTICE VECTORS
    a123 = {a1:a1,a2:a2,a3:a3}
    a123unit = {a1unit:a1/sqrt(dotp(a1,a1)),$
                a2unit:a2/sqrt(dotp(a2,a2)),$
                a3unit:a3/sqrt(dotp(a3,a3))}


    ;UNIT CELL VOLUME
    V = dotp(a1,crossp(a2,a3))

    ;RECIPROCAL LATTICE VACTORS
    b1 = (2*!dPI/V)*crossp(a2,a3)
    b2 = (2*!dPI/V)*crossp(a3,a1)
    b3 = (2*!dPI/V)*crossp(a1,a2)


    b1 = 2*!dpi*b1
    b2 = 2*!dpi*b2
    b3 = 2*!dpi*b3

    Vstar = dotp(b1,crossp(b2,b3))

    ;MAKE AVAILABLE THE RECIPROCAL LATTICE VECTORS
    b123 = {b1:b1,b2:b2,b3:b3}


    astar = sqrt(dotp(b1,b1))
    bstar = sqrt(dotp(b2,b2))
    cstar = sqrt(dotp(b3,b3))

    b123unit = {b1unit:b1/astar,$
                b2unit:b2/bstar,$
                b3unit:b3/cstar}

    alphastar = acos(dotp(b2,b3)/(bstar*cstar))
    betastar  = acos(dotp(b1,b3)/(astar*cstar))
    gammastar = acos(dotp(b1,b2)/(astar*bstar))

    ;RETURN A STRUCTURE WITH EVERYTHING
    return,{astar:astar,$
            bstar:bstar,$
            cstar:cstar,$
            alphastar:alphastar/dtor,$
            betastar :betastar/ dtor,$
            gammastar:gammastar/dtor,$
            starabc : [astar,bstar,cstar],$
            starabg : [alphastar/dtor,betastar/dtor,gammastar/dtor],$    RECIP IN VECTOR FORM
            a:a,b:b,c:c,alpha:alpha,beta:beta,gamma:gamma,$
            abc:[a,b,c],abg:[alpha,beta,gamma],$    ;DIRECT IN VECTOR FORM
            a123:a123,b123:b123,Vol:V,Vstar:Vstar,$
            a123unit:a123unit,b123unit:b123unit}

end;recip_lattice
