; $Id$
;###############################################################################
;




;
;CLASS NAME:
;    latticePoints
;
;PURPOSE:
;
;CATEGORY:
;
;
;SUPERCLASSES:
;    idl_container
;
;
;METHODS:
;    latticePoints::readStructOutput
;    latticePoints::create2dLattice
;    latticePoints::calculate
;    latticePoints::cleanup
;    latticePoints::init
;    latticePoints__define
;
;
; AUTHOR:
; Larry Kneller
; NIST Center for Neutron Research
; 100 Bureau Drive, Gaithersburg, MD 20899
; United States
; kneller@nist.gov  301-975-8839
; Fri May 26 22:16:29 2006
;
; LICENSE:
; The software in this file is written by an employee of
; National Institute of Standards and Technology
; as part of the DAVE software project.
;
; The DAVE software package is not subject to copyright protection
; and is in the public domain. It should be considered as an
; experimental neutron scattering data reduction, visualization, and
; analysis system. As such, the authors assume no responsibility
; whatsoever for its use, and make no guarantees, expressed or
; implied, about its quality, reliability, or any other
; characteristic. The use of certain trade names or commercial
; products does not imply any endorsement of a particular product,
; nor does it imply that the named product is necessarily the best
; product for the stated purpose. We would appreciate acknowledgment
; if the DAVE software is used or if the code in this file is
; included in another product.
;
;###############################################################################
function latticepoints_hkl,i,j,k

    hkl = intarr(3,9^3)

    for i=0,8 do begin
        for j=0,8 do begin
            for k=0,8 do begin
                hkl[*,i+j*9+k*81] = [i-4,j-4,k-4]
            endfor;k
        endfor;j
    endfor;i

    return,hkl
end;ijk

;###############################################################################
;
;NAME:
;        latticePoints::readStructOutput
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro latticePoints::readStructOutput

    ;GET THE OUTPUT OF A STRUCT FILE AND PUT THE DATA
    ;INTO THE DATA MEMBERS.
    fn = dialog_pickfile(title='INPUT "STRUCT" OUTPUT FILE:')


    if fn ne '' then begin
        ;print,fn

        n = file_lines(fn)
        s = strarr(n)

        openr,lun,fn,/get_lun
        readf,lun,s
        free_lun,lun

        segs = strsplit(s[7],'alfabetagamma,=deg',/extract)
        temp = ''
        for i=0,n_elements(segs)-1 do temp = temp+' '+segs[i]
        segs = strsplit(temp,/extract)
        self.alphastar = double(segs[0])
        self.betastar  = double(segs[1])
        self.gammastar = double(segs[2])


        on = 0
        io = 0
        for i=0,n-1 do begin

            if on eq 1 then begin
                segs = strsplit(s[i],/extract)
                hkl[*,i-io] = fix(segs[0:2])
                strf[i-io]  = double(segs[5])
            endif
            if on eq 0 then begin
                if stregex(s[i],'strf',/fold_case,/boolean) gt 0 then begin
                    on = 1 ;print,s[i]
                    io = i+1
                    hkl  = intarr(3,n-io)
                    strf = dblarr(n-io)
                endif
            endif
        endfor

        if ptr_valid(self.hkl)  ne 0 then ptr_free,self.hkl
        if ptr_valid(self.strf) ne 0 then ptr_free,self.strf

        self.hkl  = ptr_new(hkl)
        self.strf = ptr_new(strf)
    endif else begin

        self.astar = 2*!PI
        self.bstar = 2*!PI
        self.cstar = 2*!PI
        self.alphastar = 90.0
        self.betastar  = 90.0
        self.gammastar = 90.0
        self.hkl  = ptr_new(latticepoints_hkl())
        sz = size(*self.hkl)
        self.strf = ptr_new(dblarr(sz[2])+1.0)
    endelse
end;readStructOutput


;###############################################################################
;
;NAME:
;        latticePoints::create2dLattice
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;RETURN VALUE:
;
;###############################################################################
function latticePoints::create2dLattice

    szhkl  = size(*self.hkl)
    szstrf = size(*self.strf)
;    print,szhkl
;    print,szstrf

    count = 0
    hkl  = (*self.hkl)
    strf = (*self.strf)
    for i=0,szhkl[2]-1 do begin
        vol = total(hkl[*,i]*crossp(self.o1,self.o2))
;        print,hkl[*,i],vol,count
        if vol eq 0 then begin
            count = count + 1
            ;print,hkl[*,i],strf[i]
        endif
    endfor;i

;    print,count

    x = dblarr(count)
    y = dblarr(count)
    s = dblarr(count)
    j = 0
    for i=0,szhkl[2]-1 do begin
        vol = total(hkl[*,i]*crossp(self.o1,self.o2))
;        print,i
        if vol eq 0 then begin
            ;GET DOT PRODUCTS OF hkl's WITH o1,o2

            ;WHAT I ACTUALLY WANT HERE IS
            ;G = hkl[0]*b1+hkl[1]*b2+hkl[2]*b3
            ;x = G.(o1[0]*b1hat + o1[1]*b2hat + o1[2]*b3hat)???
            ;y = G.(o2[0]*b1hat + o2[1]*b2hat + o2[2]*b3hat)???

            x[j] = total(double(hkl[*,i])*(self.o1)/total((self.o1)^2.0))
            y[j] = total(double(hkl[*,i])*(self.o2)/total((self.o2)^2.0))
            s[j] = strf[i]
            j++
        endif
    endfor;i

    o = obj_new('spurion_2dlattice_data',x,y,0.0*y,s,showlegend=0,ebshow=0,psym=4,color=255L,id='SPURION_2DLATTICE')

    ;help,o
    self->add,o

    return,1
end;create2dLattice

;###############################################################################
;
;NAME:
;        latticePoints::calculate
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro latticePoints::calculate

end;calculate


;###############################################################################
;
;NAME:
;        latticePoints::cleanup
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro latticePoints::cleanup

    print,'latticePoints::cleanup'

end;cleanup

;###############################################################################
;
;NAME:
;        latticePoints::init
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;RETURN VALUE:
;
;###############################################################################
function latticePoints::init,hkl,strf,o1=o1,o2=o2


    ;FIRST PASS, NEED hkl VECTORS AND strf
    ;MAKE THIS CLASS USAGE THE SAME AS scanPoints.

    if n_elements(hkl) eq 0 then begin

        self->readStructOutput
        if n_elements(o1) eq 0 then self.o1 = [1.0,0,0.0] else self.o1 = o1
        if n_elements(o2) eq 0 then self.o2 = [0.0,1.0,0] else self.o2 = o2

        print,self.o1
        print,self.o2


    endif else begin

            if ptr_valid(self.hkl) gt 0 then ptr_free,self.hkl
            self.hkl = ptr_new(hkl)

            if ptr_valid(self.strf) gt 0 then ptr_free,self.strf
            self.strf = ptr_new(strf)

            if ptr_valid(self.lattice) gt 0 then ptr_free,self.lattice

            self.o1 = o1
            self.o2 = o2



        ;    o1:dblarr(3),$      ;NEEDED TO SELECT POINTS IN PLANE.
        ;    o2:dblarr(3),$
        ;    astar:0.0d,$        ;NEEDED TO CONVERT hkl POINTS TO Q VALUES
        ;    bstar:0.0d,$        ;WHEN NECESSARY
        ;    cstar:0.0d,$
        ;    alphastar:0.0d,$
        ;    betastar:0.0d,$
        ;    gammastar:0.0d}
    endelse


    return,1
end;latticePoints

;###############################################################################
;
;NAME:
;        latticePoints__define
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro latticePoints__define,class

    class = {latticePoints,$
                inherits idl_container,$
                lattice:ptr_new(),$
                hkl:ptr_new(),$
                strf:ptr_new(),$
                ;
                o1:dblarr(3),$      ;NEEDED TO SELECT POINTS IN PLANE.
                o2:dblarr(3),$
                astar:0.0d,$        ;NEEDED TO CONVERT hkl POINTS TO Q VALUES
                bstar:0.0d,$        ;WHEN NECESSARY
                cstar:0.0d,$
                alphastar:0.0d,$
                betastar:0.0d,$
                gammastar:0.0d}

end;latticePoints__define
