; $Id$
;###############################################################################
;
;
;CLASS NAME:
;    cwo_latParms__define
;
;PURPOSE:
;
;CATEGORY:
;
;
;SUPERCLASSES:
;
;
;METHODS:
;    cwo_latParms_test_event
;    cwo_latParms_test
;    cwo_latParms_event
;    cwo_latParms::event
;    cwo_latParms::getproperty
;    cwo_latParms::setproperty
;    cwo_latparms::updateLattice
;    cwo_latparms::set_Q
;    cwo_latparms::get_Q
;    cwo_latParms_set_value
;    cwo_latParms_get_value
;    cwo_latparms::check_values
;    cwo_latParms::get_values
;    cwo_latParms_cleanup
;    cwo_latParms::cleanup
;    cwo_latParms::init
;    cwo_latparms_values_define
;    cwo_latParms__define
;    cwo_latParms
;
;
; AUTHOR:
; Larry Kneller
; NIST Center for Neutron Research
; 100 Bureau Drive, Gaithersburg, MD 20899
; United States
; kneller@nist.gov  301-975-8839
; Thu May 18 15:20:57 2006
;
; LICENSE:
; The software in this file is written by an employee of
; National Institute of Standards and Technology
; as part of the DAVE software project.
;
; The DAVE software package is not subject to copyright protection
; and is in the public domain. It should be considered as an
; experimental neutron scattering data reduction, visualization, and
; analysis system. As such, the authors assume no responsibility
; whatsoever for its use, and make no guarantees, expressed or
; implied, about its quality, reliability, or any other
; characteristic. The use of certain trade names or commercial
; products does not imply any endorsement of a particular product,
; nor does it imply that the named product is necessarily the best
; product for the stated purpose. We would appreciate acknowledgment
; if the DAVE software is used or if the code in this file is
; included in another product.
;
;###############################################################################

;THIS IS A STATELESS HOLDER OF THE VALUES NEEDED TO DEFINE A CRYSTAL LATTICE


;###############################################################################
;
;NAME:
;        cwo_latParms_test_event
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro cwo_latParms_test_event,event
    print,tag_names(event)
    print,event
end;cwo_latParms_test_event
;###############################################################################
;
;NAME:
;        cwo_latParms_test
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro cwo_latParms_test,obj=obj

    b=widget_base(xoffset=300,yoffset=300,title='LATTICE INPUTS')
    p = cwo_latParms(b,!pi,!pi,!pi,90,90,90,1,1,1,90,90,90,1,0,0,0,1,0,2,2,0,obj=obj)
    ;print,p

    widget_control,b,/realize
    xmanager,'cwo_latParms_test',b,/no_block
end;test


;###############################################################################
;
;NAME:
;        cwo_latParms_event
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;RETURN VALUE:
;
;###############################################################################
function cwo_latParms_event,event
    widget_control,widget_info(event.handler,/child),get_uvalue=self
    event = self->event(event)
    return,event
end;cwo_latParms_event


;###############################################################################
;
;NAME:
;        cwo_latParms::event
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;RETURN VALUE:
;
;###############################################################################
function cwo_latParms::event,event

    ;print,'cwo_latParms::event',event.id

    self->updateLattice

    self.latvals = self->get_values()
    event.id = self.tlb
    return,event
end;cwo_latParms::event

;###############################################################################
;
;NAME:
;        cwo_latParms::getproperty
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro cwo_latParms::getproperty,_ref_extra=extra

    if arg_present(a) ne 0 then widget_control,self.afield,get_value=a
    if arg_present(b) ne 0 then widget_control,self.bfield,get_value=b
    if arg_present(c) ne 0 then widget_control,self.cfield,get_value=c

    if arg_present(alpha) ne 0 then widget_control,self.alphafield,get_value=alpha
    if arg_present(beta) ne 0 then widget_control,self.betafield,get_value=beta
    if arg_present(gamma) ne 0 then widget_control,self.gammafield,get_value=gamma

    if arg_present(astar) ne 0 then widget_control,self.astarfield,get_value=astar
    if arg_present(bstar) ne 0 then widget_control,self.bstarfield,get_value=bstar
    if arg_present(cstar) ne 0 then widget_control,self.cstarfield,get_value=cstar

    if arg_present(alphastar) ne 0 then widget_control,self.alphastarfield,get_value=alphastar
    if arg_present(betastar) ne 0 then widget_control,self.betastarfield,get_value=betastar
    if arg_present(gammastar) ne 0 then widget_control,self.gammastarfield,get_value=gammastar

    if arg_present(h1) ne 0 then widget_control,self.h1field,get_value=h1
    if arg_present(k1) ne 0 then widget_control,self.k1field,get_value=k1
    if arg_present(l1) ne 0 then widget_control,self.l1field,get_value=l1

    if arg_present(h2) ne 0 then widget_control,self.h2field,get_value=h2
    if arg_present(k2) ne 0 then widget_control,self.k2field,get_value=k2
    if arg_present(l2) ne 0 then widget_control,self.l2field,get_value=l2

    if arg_present(hq) ne 0 then widget_control,self.hqfield,get_value=hq
    if arg_present(kq) ne 0 then widget_control,self.kqfield,get_value=kq
    if arg_present(lq) ne 0 then widget_control,self.lqfield,get_value=lq



end;getProperty

;###############################################################################
;
;NAME:
;        cwo_latParms::setproperty
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro cwo_latParms::setproperty,_ref_extra=extra

    if n_elements(parent) ne 0 then self.parent=parent
    if n_elements(tlb) ne 0 then self.tlb = tlb

    if n_elements(a) ne 0 then widget_control,self.afield,set_value=float(a)
    if n_elements(b) ne 0 then widget_control,self.bfield,set_value=float(b)
    if n_elements(c) ne 0 then widget_control,self.cfield,set_value=float(c)

    if n_elements(alpha) ne 0 then widget_control,self.alphafield,set_value=float(alpha)
    if n_elements(beta) ne 0 then widget_control,self.betafield,set_value=float(beta)
    if n_elements(gamma) ne 0 then widget_control,self.gammafield,set_value=float(gamma)

    if n_elements(astar) ne 0 then widget_control,self.astarfield,set_value=float(astar)
    if n_elements(bstar) ne 0 then widget_control,self.bstarfield,set_value=float(bstar)
    if n_elements(cstar) ne 0 then widget_control,self.cstarfield,set_value=float(cstar)

    if n_elements(alphastar) ne 0 then widget_control,self.alphastarfield,set_value=float(alphastar)
    if n_elements(betastar) ne 0 then widget_control,self.betastarfield,set_value=float(betastar)
    if n_elements(gammastar) ne 0 then widget_control,self.gammastarfield,set_value=float(gammastar)

    if n_elements(h1) ne 0 then widget_control,self.h1field,set_value=float(h1)
    if n_elements(k1) ne 0 then widget_control,self.k1field,set_value=float(k1)
    if n_elements(l1) ne 0 then widget_control,self.l1field,set_value=float(l1)

    if n_elements(h2) ne 0 then widget_control,self.h2field,set_value=float(h2)
    if n_elements(k2) ne 0 then widget_control,self.k2field,set_value=float(k2)
    if n_elements(l2) ne 0 then widget_control,self.l2field,set_value=float(l2)

    if n_elements(hq) ne 0 then widget_control,self.hqfield,set_value=float(hq)
    if n_elements(kq) ne 0 then widget_control,self.kqfield,set_value=float(kq)
    if n_elements(lq) ne 0 then widget_control,self.lqfield,set_value=float(lq)

    self.latvals = self->get_values()


end;setproperty

;###############################################################################
;
;NAME:
;        cwo_latparms::updateLattice
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro cwo_latparms::updateLattice

    widget_control,self.afield,get_value=a
    widget_control,self.bfield,get_value=b
    widget_control,self.cfield,get_value=c

    widget_control,self.alphafield,get_value=alpha
    widget_control,self.betafield,get_value=beta
    widget_control,self.gammafield,get_value=gamma


    self.lattice->setproperty,la=a,lb=b,lc=c,$
		                        alpha=alpha,$
		                        beta=beta,$
		                        gamma=gamma

    self.lattice->getproperty, astar=astar,bstar=bstar,cstar=cstar,$
                                alphastar=alphastar,betastar=betastar,gammastar=gammastar


    if n_elements(astar) ne 0 then widget_control,self.astarfield,set_value=float(astar)
    if n_elements(bstar) ne 0 then widget_control,self.bstarfield,set_value=float(bstar)
    if n_elements(cstar) ne 0 then widget_control,self.cstarfield,set_value=float(cstar)

    if n_elements(alphastar) ne 0 then widget_control,self.alphastarfield,set_value=float(alphastar)
    if n_elements(betastar) ne 0 then widget_control,self.betastarfield,set_value=float(betastar)
    if n_elements(gammastar) ne 0 then widget_control,self.gammastarfield,set_value=float(gammastar)




end;updateLattice


;###############################################################################
;
;NAME:
;        cwo_latparms::set_Q
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;RETURN VALUE:
;
;###############################################################################
function cwo_latparms::set_Q,q,qh=qh,qk=qk,ql=ql

    ;USE THIS METHOD WHEN Q IS CHANGED IN SOME OTHER FIELD, SUCH AS cwo_resparms OR OTHERS.

    ret = 1
    if n_elements(q) ge 3 then begin
        qh = q[0]
        qk = q[1]
        ql = q[2]
    endif

    if n_elements(qh) ne 0 then widget_control,self.hqfield,set_value=qh
    if n_elements(qk) ne 0 then widget_control,self.kqfield,set_value=qk
    if n_elements(ql) ne 0 then widget_control,self.lqfield,set_value=ql

    self.latvals = self->get_values()
    o1 = [self.latvals.h1,self.latvals.k1,self.latvals.l1]
    o2 = [self.latvals.h2,self.latvals.k2,self.latvals.l2]
    q  = [self.latvals.hq,self.latvals.kq,self.latvals.lq]
    vol = total(q*crossp(o1,o2))

    if vol ne 0 then begin
        void = dialog_message('YOUR Q IS NOT IN THE SCATTERING PLANE!!!')
        ret = 0
    endif


    return,ret

end;set_Q
;###############################################################################
;
;NAME:
;        cwo_latparms::get_Q
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;RETURN VALUE:
;
;###############################################################################
function cwo_latparms::get_Q
    widget_control,self.hqfield,get_value=qh
    widget_control,self.kqfield,get_value=qk
    widget_control,self.lqfield,get_value=ql

    print,tag_names(self->get_values())
    return,[qh,qk,ql]

end;get_Q


;###############################################################################
;
;NAME:
;        cwo_latParms_set_value
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro cwo_latParms_set_value,id,value
    print,'set_value'
end;cwo_latParms_set_value
;###############################################################################
;
;NAME:
;        cwo_latParms_get_value
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro cwo_latParms_get_value,id,val=val
    print,'get_value'
    stash = widget_info(id,/child)
    widget_control,stash,get_uvalue=obj
    val = obj->get_values()

end;cwo_latParms_get_value


;###############################################################################
;
;NAME:
;        cwo_latparms::check_values
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro cwo_latparms::check_values

    changesMade = 0

    if changesMade ne 0 then void = dialog_message('Changed bad values in resolution parameters')

end;check_values





;###############################################################################
;
;NAME:
;        cwo_latParms::get_values
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;RETURN VALUE:
;
;###############################################################################
function cwo_latParms::get_values

    self->check_values


    ;GET THE VALUES FROM ALL THE WIDGETS WITH VALUES AND
    ;RETURN THEM IN A STRUCTURE.
    widget_control,self.afield,get_value=a
    widget_control,self.bfield,get_value=b
    widget_control,self.cfield,get_value=c

    widget_control,self.alphafield,get_value=alpha
    widget_control,self.betafield,get_value=beta
    widget_control,self.gammafield,get_value=gamma
                    ;
    widget_control,self.astarfield,get_value=astar
    widget_control,self.bstarfield,get_value=bstar
    widget_control,self.cstarfield,get_value=cstar
                    ;
    widget_control,self.alphastarfield,get_value=alphastar
    widget_control,self.betastarfield,get_value=betastar
    widget_control,self.gammastarfield,get_value=gammastar
                    ;
    widget_control,self.h1field,get_value=h1
    widget_control,self.k1field,get_value=k1
    widget_control,self.l1field,get_value=l1
                    ;
    widget_control,self.h2field,get_value=h2
    widget_control,self.k2field,get_value=k2
    widget_control,self.l2field,get_value=l2
                    ;
    widget_control,self.hqfield,get_value=hq
    widget_control,self.kqfield,get_value=kq
    widget_control,self.lqfield,get_value=lq



    ret = self.latvals


    ret.a=a
    ret.b=b
    ret.c=c
    ret.alpha=alpha
    ret.beta=beta
    ret.gamma=gamma
    ret.astar=astar
    ret.bstar=bstar
    ret.cstar=cstar
    ret.alphastar=alphastar
    ret.betastar=betastar
    ret.gammastar=gammastar
    ret.h1=h1
    ret.k1=k1
    ret.l1=l1
    ret.h2=h2
    ret.k2=k2
    ret.l2=l2
    ret.hq=hq
    ret.kq=kq
    ret.lq=lq
    ret.orient1=[h1,k1,l1]
    ret.orient2=[h2,k2,l2]
    ret.q=[hq,kq,lq]

    self.latvals = ret
    return,ret

end;get_values

;###############################################################################
;
;NAME:
;        cwo_latParms_cleanup
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro cwo_latParms_cleanup,id
    print,'cwo_latParms_cleanup'



    widget_control,id,get_uvalue=obj
    obj_destroy,obj

end;cwo_latParms_cleanup

;###############################################################################
;
;NAME:
;        cwo_latParms::cleanup
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro cwo_latParms::cleanup
    print,'cwo_latParms::cleanup'
    if obj_valid(self.lattice) then obj_destroy,self.lattice
end;cleanup

;###############################################################################
;
;NAME:
;        cwo_latParms::init
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;RETURN VALUE:
;
;###############################################################################
function cwo_latParms::init,parent,$
                            a,b,c,alpha,beta,gamma,$
                            astar,bstar,cstar,alphastar,betastar,gammastar,$
                            h1,k1,l1,h2,k2,l2,hq,kq,lq,$
                            orient1=orient1,$
                            orient2=orient2,$
                            q=q,$
                            tlb=tlb,$
                            xsize=xsize,$
                            ysize=ysize,$
                            uvalue=uvalue,$
                            uname=uname,$
                            title=title,$
                            xtitle=xtitle,$
                            ytitle=ytitle,$
                            kill_notify=kill_notify,$
                            _ref_extra=extra





    if n_elements(a) eq 0 then a = 2*!pi
    if n_elements(b) eq 0 then b = 2*!pi
    if n_elements(c) eq 0 then c = 2*!pi

    if n_elements(alpha) eq 0 then alpha = 90.0
    if n_elements( beta) eq 0 then  beta = 90.0
    if n_elements(gamma) eq 0 then gamma = 90.0

    self.lattice = obj_new('lattice',a,b,c,alpha,beta,gamma)

    self.lattice->getproperty, astar=astar,bstar=bstar,cstar=cstar,$
                                alphastar=alphastar,betastar=betastar,gammastar=gammastar


    self.parent = parent
    self.tlb = widget_base(parent,/col,$
                                title='Crystal Lattice/Orientation',$
                                event_func='cwo_latParms_event',$
                                pro_set_value='cwo_latParms_set_value',$
                                func_get_value='cwo_latParms_get_value',$
                                uvalue=uvalue,uname=uname,kill_notify=kill_notify)
    tlb = self.tlb

    row1 = widget_base(tlb,/row,uvalue=self,uname='CWO_LATPARMS_STASH')
    row2 = widget_base(tlb,/row)
    row3 = widget_base(tlb,/row)
    row4 = widget_base(tlb,/row)
    row5 = widget_base(tlb,/row)
    row6 = widget_base(tlb,/row)
    row7 = widget_base(tlb,/row)

    if n_elements(orient1) eq 3 then begin
        h1 = orient1[0]
        k1 = orient1[1]
        l1 = orient1[2]
    endif else begin
        if n_elements(h1) eq 0 then h1 = 1.0
        if n_elements(k1) eq 0 then k1 = 0.0
        if n_elements(l1) eq 0 then l1 = 0.0
    endelse
    if n_elements(orient2) eq 3 then begin
        h2 = orient2[0]
        k2 = orient2[1]
        l2 = orient2[2]
    endif else begin
        if n_elements(h2) eq 0 then h2 = 0.0
        if n_elements(k2) eq 0 then k2 = 1.0
        if n_elements(l2) eq 0 then l2 = 0.0
    endelse

    if n_elements(q) ge 3 then begin
        hq = q[0]
        kq = q[1]
        lq = q[2]
    endif else begin
        if n_elements(hq) eq 0 then hq = 0.5
        if n_elements(kq) eq 0 then kq = 1.0
        if n_elements(lq) eq 0 then lq = 0.0
    endelse



    self.afield = cw_field(row1,title='a',xsize=10,value=a,/floating,/return_events)
    self.bfield = cw_field(row1,title='b',xsize=10,value=b,/floating,/return_events)
    self.cfield = cw_field(row1,title='c',xsize=10,value=c,/floating,/return_events)

    self.alphafield = cw_field(row2,title='alpha',xsize=10,value=alpha,/floating,/return_events)
    self.betafield  = cw_field(row2,title='beta',xsize=10,value=beta,/floating,/return_events)
    self.gammafield = cw_field(row2,title='gamma',xsize=10,value=gamma,/floating,/return_events)

    self.astarfield = cw_field(row3,title='a*',xsize=5,value=astar,/floating,/noedit);/return_events)
    self.bstarfield = cw_field(row3,title='b*',xsize=5,value=bstar,/floating,/noedit);/return_events)
    self.cstarfield = cw_field(row3,title='c*',xsize=5,value=cstar,/floating,/noedit);/return_events)

    self.alphastarfield = cw_field(row4,title='alpha*',xsize=5,value=alphastar,/floating,/noedit);/return_events)
    self.betastarfield  = cw_field(row4,title='beta*',xsize=5,value=betastar,/floating,/noedit);/return_events)
    self.gammastarfield = cw_field(row4,title='gamma*',xsize=5,value=gammastar,/floating,/noedit);/return_events)

    ovec1 = widget_label(row5,value='oVec1')
    self.h1field = cw_field(row5,title='h1',xsize=3,value=fix(h1),/integer,/return_events)
    self.k1field = cw_field(row5,title='k1',xsize=3,value=fix(k1),/integer,/return_events)
    self.l1field = cw_field(row5,title='l1',xsize=3,value=fix(l1),/integer,/return_events)

    ovec2 = widget_label(row6,value='oVec2')
    self.h2field = cw_field(row6,title='h2',xsize=3,value=fix(h2),/integer,/return_events)
    self.k2field = cw_field(row6,title='k2',xsize=3,value=fix(k2),/integer,/return_events)
    self.l2field = cw_field(row6,title='l2',xsize=3,value=fix(l2),/integer,/return_events)

    qtrans = widget_label(row7,value='Qtrans:')
    self.hqfield = cw_field(row7,title='qh',xsize=10,value=hq,/floating,/return_events)
    self.kqfield = cw_field(row7,title='qk',xsize=10,value=kq,/floating,/return_events)
    self.lqfield = cw_field(row7,title='ql',xsize=10,value=lq,/floating,/return_events)


    self.latvals = self->get_values()

    return,1
end;init
;###############################################################################
;
;NAME:
;        cwo_latparms_values_define
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro cwo_latparms_values_define,struct
    struct = { cwo_latparms_values,$
                a:0.0,b:0.0,c:0.0,alpha:0.0,beta:0.0,gamma:0.0,$
                astar:0.0,bstar:0.0,cstar:0.0,$
                alphastar:0.0,betastar:0.0,gammastar:0.0,$
                h1:0.0,k1:0.0,l1:0.0,$
                h2:0.0,k2:0.0,l2:0.0,$
                hq:0.0,kq:0.0,lq:0.0,$
                orient1:[0.0,0.0,0.0],$
                orient2:[0.0,0.0,0.0],$
                q:[0.0,0.0,0.0]}

end;cwo_latparms_values_define
;###############################################################################
;
;NAME:
;        cwo_latParms__define
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro cwo_latParms__define,class


    cwo_latparms_values_define,latvals
;    latvals = { cwo_latparms_lattice_values,$
;                a:0.0,b:0.0,c:0.0,alpha:0.0,beta:0.0,gamma:0.0,$
;                astar:0.0,bstar:0.0,cstar:0.0,$
;                alphastar:0.0,betastar:0.0,gammastar:0.0,$
;                h1:0.0,k1:0.0,l1:0.0,$
;                h2:0.0,k2:0.0,l2:0.0,$
;                hq:0.0,kq:0.0,lq:0.0,$
;                orient1:[0.0,0.0,0.0],$
;                orient2:[0.0,0.0,0.0],$
;                q:[0.0,0.0,0.0]}

    class = { cwo_latParms,$
                    parent:0L,$
                    tlb:0L,$
                    ;
                    afield:0L,$
                    bfield:0L,$
                    cfield:0L,$
                    ;
                    alphafield:0L,$
                    betafield:0L,$
                    gammafield:0L,$
                    ;
                    astarfield:0L,$
                    bstarfield:0L,$
                    cstarfield:0L,$
                    ;
                    alphastarfield:0L,$
                    betastarfield:0L,$
                    gammastarfield:0L,$
                    ;
                    h1field:0L,$
                    k1field:0L,$
                    l1field:0L,$
                    ;
                    h2field:0L,$
                    k2field:0L,$
                    l2field:0L,$
                    ;
                    hqfield:0L,$
                    kqfield:0L,$
                    lqfield:0L,$
                    ;
                    latvals:latvals,$
                    lattice:obj_new()}


end;cwo_latParms__define


;###############################################################################
;
;NAME:
;        cwo_latParms
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;RETURN VALUE:
;
;###############################################################################
function cwo_latParms,parent,$
                            a,b,c,alpha,beta,gamma,$
                            astar,bstar,cstar,alphastar,betastar,gammastar,$
                            h1,k1,l1,h2,k2,l2,hq,kq,lq,$
                            tlb=tlb,$
                            xsize=xsize,$
                            ysize=ysize,$
                            uvalue=uvalue,$
                            uname=uname,$
                            title=title,$
                            xtitle=xtitle,$
                            ytitle=ytitle,$
                            kill_notify=kill_notify,$
                            obj=obj,$
                            _ref_extra=extra


    obj = obj_new('cwo_latParms',parent,$
                                    a,b,c,alpha,beta,gamma,$
                                    astar,bstar,cstar,alphastar,betastar,gammastar,$
                                    h1,k1,l1,h2,k2,l2,hq,kq,lq,$
                                    tlb=tlb,$
                                    xsize=xsize,$
                                    ysize=ysize,$
                                    uvalue=uvalue,$
                                    uname=uname,$
                                    title=title,$
                                    xtitle=xtitle,$
                                    ytitle=ytitle,$
                                    kill_notify=kill_notify,$
                                    _extra=extra)

    obj->getproperty,tlb=tlb
    return,tlb


end;cwo_latParms
