; $Id$
;###############################################################################
;
;CLASS NAME:
;    ooNSEsq1d
;
;PURPOSE:
;   Plot 1D S(Q,t=0) for NSE data.
;CATEGORY:
;
;
;SUPERCLASSES:
;                    inherits myproperties,$
;
;METHODS:
;    ooNSEsq1d::cleanup
;    ooNSEsq1d::init
;    ooNSEsq1d__define
;
;
; AUTHOR:
; Larry Kneller
; NIST Center for Neutron Research
; 100 Bureau Drive, Gaithersburg, MD 20899
; United States
; kneller@nist.gov  301-975-8839
; Fri Oct 21 15:09:09 2005
;
; LICENSE:
; The software in this file is written by an employee of
; National Institute of Standards and Technology
; as part of the DAVE software project.
;
; The DAVE software package is not subject to copyright protection
; and is in the public domain. It should be considered as an
; experimental neutron scattering data reduction, visualization, and
; analysis system. As such, the authors assume no responsibility
; whatsoever for its use, and make no guarantees, expressed or
; implied, about its quality, reliability, or any other
; characteristic. The use of certain trade names or commercial
; products does not imply any endorsement of a particular product,
; nor does it imply that the named product is necessarily the best
; product for the stated purpose. We would appreciate acknowledgment
; if the DAVE software is used or if the code in this file is
; included in another product.
;
;###############################################################################

;###############################################################################
;
;NAME:
;        ooNSEsq1d::cleanup
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro ooNSEsq1d::cleanup
    ;print,'ooNSEsq1d::cleanup'
    if ptr_valid(self.s) gt 0 then ptr_free,self.s
    if ptr_valid(self.ss) gt 0 then ptr_free,self.ss
    if ptr_valid(self.q) gt 0 then ptr_free,self.q
end;ooNSEsq1d::cleanup

;###############################################################################
;
;NAME:
;        ooNSEsq1d::init
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;RETURN VALUE:
;
;###############################################################################
function ooNSEsq1d::init,name,dat,magnetic=magnetic,group=group

    if n_elements(dat) eq 0 then begin
        return,0
    endif else begin
        s = *(dat.s)
        ss = *(dat.ss)
        q = *(dat.q)
        if n_elements(group) eq 0 then group = -1
        if n_elements(magnetic) eq 0 then magnetic = 0

        self.name = name
        if n_elements(tag_names(dat)) eq 3 then begin
            if ptr_valid(self.s) gt 0 then ptr_free,self.s
            self.s = ptr_new(s)
            if ptr_valid(self.ss) gt 0 then ptr_free,self.ss
            self.ss = ptr_new(ss)
            if ptr_valid(self.s) gt 0 then ptr_free,self.q
            self.q = ptr_new(q)
            self.group = group
            self.magnetic = magnetic
            return,1
        endif else begin
            return,0
        endelse
    endelse
end;ooNSEsq1d::init


;###############################################################################
;
;NAME:
;        ooNSEsq1d__define
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro ooNSEsq1d__define,class

    class = {ooNSEsq1d, $
                inherits myproperties,$
                name:'',$
                s:ptr_new(),$
                ss:ptr_new(),$
                q:ptr_new(),$
                magnetic:0,$
                group:-1}


end;ooNSEsq1d__define
