; $Id$
;###############################################################################
;
;FILENAME:
;larrebin.pro
;
;PURPOSE:
;           Rebinning method.  This method sums all the counts in a
;           group of pixels and places the sum into the resulting pixel.
;CATEGORY:
;           Data calculations.
;
;METHODS IN FILE:
;
;    LarRebin
;
;
; AUTHOR:
; Larry Kneller
; NIST Center for Neutron Research
; 100 Bureau Drive, Gaithersburg, MD 20899
; United States
; kneller@nist.gov  301-975-8839
; Jan 24,2005
;
; LICENSE:
; The software in this file is written by an employee of
; National Institute of Standards and Technology
; as part of the DAVE software project.
;
; The DAVE software package is not subject to copyright protection
; and is in the public domain. It should be considered as an
; experimental neutron scattering data reduction, visualization, and
; analysis system. As such, the authors assume no responsibility
; whatsoever for its use, and make no guarantees, expressed or
; implied, about its quality, reliability, or any other
; characteristic. The use of certain trade names or commercial
; products does not imply any endorsement of a particular product,
; nor does it imply that the named product is necessarily the best
; product for the stated purpose. We would appreciate acknowledgment
; if the DAVE software is used of if the code in this file is
; included in another product.
;
;###############################################################################

;NAME       LarRebin
;
;PURPOSE    A REBIN METHOD THAT PRODUCES A HISTOGRAMMED
;           BINNING --- I.E. THE SUM OF THE INVOLVED PIXELS.
;
;
;           THIS WILL REBIN THE TWO IMAGE DIMENSIONS BY THE FACTOR
;           SPECIFIED IN THE "BIN" ARGUMENT.
;
;           THE 3RD DIMENSION, IF THERE IS ONE, WILL NOT BE ALTERED.
;
;           THIS METHOD IS DESIGNED TO DEAL WITH AN ARRAY OF IMAGES.
;
;       PERHAPS THE NAME SHOULD BE CHANGED TO REFLECT THAT THE
;       REBINNING IS DONE IMAGE BY IMAGE.
;

;
;SO, THINK ABOUT THIS.  DOES IT DO THE OPERATION I WANT IN PLACE
;                       OF THE STANDARD REBIN FUNCTION?
;
;
;
;
;NOTE THE USAGE OF rebin IN THE FOLLOWING STATEMENT:
;
;
;        mbin = rebin(m,self.x_dim,self.y_dim,$
;                self.no_of_phases,self.no_of_fourier_times)
;
;
;
;I SHOULD WRITE MY OWN rebin FUNCTION TO BE A DROP-IN
;REPLACEMENT FOR THE ONE I CURRENTLY USE.
;

;
;NOTE ALSO THAT OTHER MATRICES IN ooecho WILL NEED RESIZING,
;INCLUDING MASKS, FIT-INDICATORs, etc.
;


function LarRebin,arr,xnew,ynew,znew,wnew;bin
;
;NAME:
;        LarRebin
;
;PURPOSE:
;           Rebinning method.  This method sums all the counts in a
;           group of pixels and places the sum into the resulting pixel.
;           This expects the new dimensions to divide evenly into the
;           previous dimensions.
;
;PARAMETERS:
;           arr         The array to be rebinned.
;           xnew        The new size of the x dimension
;           ynew        The new size of the y dimension
;           znew        The new size of the z dimension
;           wnew        The new size of the 4th dimension
;KEYWORDS:
;           none
;RETURN VALUE:
;           newArr      The new array created by the binning operation.

    sz = size(arr)
    ;GET THE TYPE OF THE DATA ARRAY
    help,arr,output=s,struct=0
    segs = strsplit(s,/extract)


    if sz[0] eq 2 then begin


        ;mod1 = sz[1] mod bin
        mod1 = sz[1] mod xnew
        mod2 = sz[2] mod ynew

        ;IF2
        if mod1 eq 0 and mod2 eq 0 then begin

            ;GET BIN FACTORS
            binx = sz[1]/xnew
            biny = sz[2]/ynew

            case segs[1] of
            'LONG':newArr = lonarr(xnew,ynew)
            'INT': newArr = lonarr(xnew,ynew)
            'DOUBLE':newArr = dblarr(xnew,ynew)
            'FLOAT':newArr = dblarr(xnew,ynew)
            else:return,0
            endcase


            for i=0,xnew -1 do begin
                for j=0,ynew -1 do begin
                    newArr[i,j] = $
                        total(      $
                        arr[i*binx:(i+1)*binx-1,j*biny:(j+1)*biny-1])
                endfor;j
            endfor;i

        endif else begin;mod1 mod2 endif
            print,'UNEVEN BINNING NOT ALLOWED.'
            return,0
        endelse

    ;ENDIF1  ELSE2
    endif else begin;2D endif
        if sz[0] eq 3 then begin
            mod1 = sz[1] mod xnew
            mod2 = sz[2] mod ynew

            if mod1 eq 0 and mod2 eq 0 and znew eq sz[3] then begin

                ;GET BIN FACTORS
                binx = sz[1]/xnew
                biny = sz[2]/ynew

                ;INITIALIZE REBINNED ARRAY
                case segs[1] of
                'LONG':newArr = lonarr(xnew,ynew,znew)
                'INT': newArr = lonarr(xnew,ynew,znew)
                'DOUBLE':newArr = dblarr(xnew,ynew,znew)
                'FLOAT':newArr = dblarr(xnew,ynew,znew)
                else:return,0
                endcase;segs[1]


                for i=0,xnew - 1 do begin
                    for j=0,ynew - 1 do begin
                        for k=0,znew - 1 do begin
                            newArr[i,j,k] =                 $
                                total(                      $
                                arr[i*binx:(i+1)*binx-1,      $
                                    j*biny:(j+1)*biny-1,k])
                        endfor;k
                    endfor;j
                endfor;i
            endif else begin
                print,'DIMENSIONAL ISSUE FOR sz[0] eq 3:'
                print,'MAY ONLY CHANGE DIMS 1,2'
                return,0
            endelse
        endif else begin;3D endif

            ;NOW INSERT THE 4D CASE (x,y,phase,tau)
            if sz[0] eq 4 then begin
;            print,'TEST AT LARREBIN sz[0] EQ 4'
;            help,/traceback,output=out
;            print,transpose(out)

                mod1 = sz[1] mod xnew
                mod2 = sz[2] mod ynew
                if mod1 eq 0 and mod2 eq 0 and $
                    znew eq sz[3] and wnew eq sz[4] then begin

                        ;GET BIN FACTORS
                        binx = sz[1]/xnew
                        biny = sz[2]/ynew

                        ;INITIALIZE REBINNED ARRAY
                        case segs[1] of
                        'LONG':newArr = lonarr(xnew,ynew,znew,wnew)
                        'INT': newArr = lonarr(xnew,ynew,znew,wnew)
                        'DOUBLE':newArr = dblarr(xnew,ynew,znew,wnew)
                        'FLOAT':newArr = dblarr(xnew,ynew,znew,wnew)
                        else:return,0
                        endcase;segs[1]


                        for i=0,xnew - 1 do begin
                            for j=0,ynew - 1 do begin
                                for k=0,znew - 1 do begin
                                    for l=0,wnew - 1 do begin
                                        newArr[i,j,k,l] =                 $
                                            total(                      $
                                            arr[i*binx:(i+1)*binx-1,      $
                                                j*biny:(j+1)*biny-1,k,l])
                                    endfor;l
                                endfor;k
                            endfor;j
                        endfor;i
                endif else begin;mod1 mod2 endif
                    print,'INPUT ARRAY MUST HAVE 2,3 OR 4 DIMENSIONS'
                    print,'AND BINNING IS DONE OVER ONLY DIMS 1,2.'
                    return,0
                endelse;4D
            endif else begin;sz[0] eq 4
                print,'ARRAY MUST HAVE HAVE 2,3 OR 4 DIMENSIONS'
                print,'AND BINNING IS DONE OVER ONLY DIMS 1,2.'
                return,0
            endelse
        endelse;3D
endelse;2D


return,newArr


end;LarRebin
