;#############################################################################
pro inspect_run_gui_cleanup,id
    widget_control,id,get_uvalue=pstate


    if ptr_valid(pstate) gt 0 then begin
       if ptr_valid((*pstate).ptr_echofiles) gt 0 then ptr_free,(*pstate).ptr_echofiles
       if ptr_valid((*pstate).ptr_data) gt 0 then ptr_free,(*pstate).ptr_data
       ptr_free,pstate
    endif

end;event
;#############################################################################

; ************************** ;
pro inspect_run_gui_event,event

    widget_control,event.top,get_uvalue=pstateinspectrun

	black = 0L
	red = 255L
	green = 256L*255L
	blue = 256L*256L*255L
	white = red + green + blue
	if (tag_names(event,/structure_name) ne 'CWO_DRAWPLOT_EVENT') and $
		(tag_names(event,/structure_name) ne '') then begin
		case event.id of

		(*pstateinspectrun).refresh: begin
			pathdir=dialog_pickfile(/directory,title='Select a Charlotte NSE data directory')
			pathdirlength=strlen(pathdir)
			templongechofiles=file_search(pathdir+'m????.echo')
			if (pathdir eq '') or (templongechofiles[0] eq '') then begin
				void = dialog_message('No .echo files there.')
;				return,0
			endif else begin

				device,get_screen_size=screen_size

				temp_tlb=widget_base(/col)
				temp_message=widget_label(temp_tlb,value='Please, wait...')
				geom=widget_info(temp_tlb,/geometry)
				widget_control,temp_tlb,xoff= (screen_size[0]/2)-(geom.scr_xsize/2), $
					yoff= (screen_size[1]/2)-(geom.scr_ysize/2)
				widget_control,temp_tlb,/realize

				tempechofiles=strmid(templongechofiles,pathdirlength)
				tempechofilesno=n_elements(tempechofiles)
				echo_exist=[0]
				for i=0,tempechofilesno-1 do begin
					echo_e=file_search(pathdir+'SingleTimes/'+strmid(tempechofiles[i],0,5)+'*_*.dat')
					if (echo_e[0] eq '') then begin
						echo_exist=[echo_exist,0]
					endif else begin
						echo_exist=[echo_exist,1]
					endelse
				endfor

                wh = where((echo_exist[1:(n_elements(echo_exist)-1)]) eq 1,wh_count)

                if wh_count ne 0 then begin
    				echofiles=tempechofiles[wh]
    				echofilesno=n_elements(echofiles)

    				widget_control,temp_tlb,/destroy

    				widget_control, (*pstateinspectrun).echofileslist, set_value=echofiles
    				widget_control, (*pstateinspectrun).echofileslist, set_combobox_select=(echofilesno-1)

    				if (ptr_valid((*pstateinspectrun).ptr_echofiles)) then ptr_free,(*pstateinspectrun).ptr_echofiles
    					(*pstateinspectrun).ptr_echofiles=ptr_new(echofiles)
    					(*pstateinspectrun).pathdir=pathdir
    					dummyevent={event,id:(*pstateinspectrun).echofileslist, $
    						top:(*pstateinspectrun).tlbinspectrun, $
    						handler:(*pstateinspectrun).tlbinspectrun, index:(echofilesno-1)}
       					inspect_run_gui_event,dummyevent
       			endif else begin
    				widget_control,temp_tlb,/destroy
                    void = dialog_message('No "SINGLETIMES" directory available.')
       			endelse
   			endelse

		end ; refresh

		(*pstateinspectrun).restoreall: begin

			device, get_decomposed=dc
			device, decomposed = 1
			device,get_screen_size=screen_size

			widget_control,(*pstateinspectrun).plotpi, bad_id=badid, get_value=winidtemp
			if (badid ne 0) then begin

				pi_base=widget_base(group_leader=(*pstateinspectrun).tlbinspectrun,/column, $
					yoffset=screen_size[1]*.65, xoffset=0, title='Pi Flipper')
				row1_pi=widget_base(pi_base,/row)
				column1_pi=widget_base(row1_pi,/column,/base_align_center)
				pi_x=widget_label(column1_pi,xsize=screen_size[0]*.095)
				pi_x_line=widget_draw(column1_pi,xsize=screen_size[0]*.095,ysize=5,uname='pixline')
				column2_pi=widget_base(row1_pi,/column,/base_align_center)
				pi_y=widget_label(column2_pi,xsize=screen_size[0]*.095)
				pi_y_line=widget_draw(column2_pi,xsize=screen_size[0]*.095,ysize=5,uname='piyline')
				column3_pi=widget_base(row1_pi,/column,/base_align_center)
				pi_z=widget_label(column3_pi,xsize=screen_size[0]*.095)
				pi_z_line=widget_draw(column3_pi,xsize=screen_size[0]*.095,ysize=5,uname='pizline')

				row2_pi=widget_base(pi_base,/row)
				pi_showlabel=widget_label(row2_pi, value='show ')
				pi_show=widget_combobox(row2_pi, $
					value=['x','y','z','all'],xsize=70)
				widget_control, pi_show, set_combobox_select=3
				pi_updpwnlabel=widget_label(row2_pi, value='Up Down ')
				pi_updown=widget_combobox(row2_pi, $
					value=['yes','no'],xsize=70)
				row3_pi=widget_base(pi_base,/row)
				plotpi = cwo_drawplot(row3_pi,xsize=screen_size[0]*.30,ysize=screen_size[1]*.2,uname='plotpi', $
					obj=plotpi_obj, position=[0.15,0.15,0.85,0.85])

;				pi_base=widget_base(group_leader=(*pstateinspectrun).tlbinspectrun,/column, $
;				yoffset=700, title='Pi Flipper')
;			row1_pi=widget_base(pi_base,/row)
;			column1_pi=widget_base(row1_pi,/column,/base_align_center)
;			pi_x=widget_label(column1_pi,xsize=135)
;			pi_x_line=widget_draw(column1_pi,xsize=120,ysize=5,uname='pixline')
;			column2_pi=widget_base(row1_pi,/column,/base_align_center)
;			pi_y=widget_label(column2_pi,xsize=135)
;			pi_y_line=widget_draw(column2_pi,xsize=120,ysize=5,uname='piyline')
;			column3_pi=widget_base(row1_pi,/column,/base_align_center)
;			pi_z=widget_label(column3_pi,xsize=135)
;			pi_z_line=widget_draw(column3_pi,xsize=120,ysize=5,uname='pizline')
;
;			row2_pi=widget_base(pi_base,/row)
;			pi_showlabel=widget_label(row2_pi, value='show ')
;			pi_show=widget_combobox(row2_pi, $
;				value=['x','y','z','all'],xsize=70)
;			widget_control, pi_show, set_combobox_select=3
;			pi_updpwnlabel=widget_label(row2_pi, value='Up Down ')
;			pi_updown=widget_combobox(row2_pi, $
;				value=['yes','no'],xsize=70)
;			row3_pi=widget_base(pi_base,/row)
;			plotpi = widget_draw(row3_pi,xsize=450,ysize=240,uname='plotpi')

				widget_control,pi_base,/realize
				(*pstateinspectrun).pi_base=pi_base
				(*pstateinspectrun).pi_x=pi_x
				(*pstateinspectrun).pi_y=pi_y
				(*pstateinspectrun).pi_z=pi_z
				(*pstateinspectrun).pi_show=pi_show
				(*pstateinspectrun).pi_updown=pi_updown
				(*pstateinspectrun).plotpi=plotpi
				(*pstateinspectrun).plotpi_obj=plotpi_obj

				widget_control,pi_base,set_uvalue=pstateinspectrun

				xmanager,'inspect_run_gui',pi_base,/no_block;,cleanup='inspect_run_gui_cleanup'

				widget_control,pi_x_line,get_value=winid
				wset,winid
				plot, [10000], [10000], xrange=[0,1], yrange=[0,1], $
				color = red, background = red

				widget_control,pi_y_line,get_value=winid
				wset,winid
				plot, [10000], [10000], xrange=[0,1], yrange=[0,1], $
				color = green, background = green

				widget_control,pi_z_line,get_value=winid
				wset,winid
				plot, [10000], [10000], xrange=[0,1], yrange=[0,1], $
				color = blue, background = blue

			end ; pi

			widget_control,(*pstateinspectrun).plotpi21, bad_id=badid, get_value=winidtemp
			if (badid ne 0) then begin

				pi21_base=widget_base(group_leader=(*pstateinspectrun).tlbinspectrun,/column, $
					yoffset=screen_size[1]*.65, xoffset=screen_size[0]*.33, title='Pi2 Flipper #1')
				row1_pi21=widget_base(pi21_base,/row)
				column1_pi21=widget_base(row1_pi21,/column,/base_align_center)
				pi21_x=widget_label(column1_pi21,xsize=screen_size[0]*.095)
				pi21_x_line=widget_draw(column1_pi21,xsize=screen_size[0]*.095,ysize=5,uname='pi21xline')
				column2_pi21=widget_base(row1_pi21,/column,/base_align_center)
				pi21_y=widget_label(column2_pi21,xsize=screen_size[0]*.095)
				pi21_y_line=widget_draw(column2_pi21,xsize=screen_size[0]*.095,ysize=5,uname='pi21yline')
				column3_pi21=widget_base(row1_pi21,/column,/base_align_center)
				pi21_z=widget_label(column3_pi21,xsize=screen_size[0]*.095)
				pi21_z_line=widget_draw(column3_pi21,xsize=screen_size[0]*.095,ysize=5,uname='pi21zline')
				row2_pi21=widget_base(pi21_base,/row)
				pi21_showlabel=widget_label(row2_pi21, value='show ')
				pi21_show=widget_combobox(row2_pi21, $
					value=['x','y','z','all'],xsize=70)
				widget_control, pi21_show, set_combobox_select=3
				pi21_updpwnlabel=widget_label(row2_pi21, value='Up Down ')
				pi21_updown=widget_combobox(row2_pi21, $
					value=['yes','no'],xsize=70)
				row3_pi21=widget_base(pi21_base,/row)
				plotpi21 = cwo_drawplot(row3_pi21,xsize=screen_size[0]*.30,ysize=screen_size[1]*.2, $
					uname='plotpi21',obj=plotpi21_obj, position=[0.15,0.15,0.85,0.85])

;			pi21_base=widget_base(group_leader=(*pstateinspectrun).tlbinspectrun,/column, $
;				yoffset=700, xoffset=495, title='Pi2 Flipper #1')
;			row1_pi21=widget_base(pi21_base,/row)
;			column1_pi21=widget_base(row1_pi21,/column,/base_align_center)
;			pi21_x=widget_label(column1_pi21,xsize=135)
;			pi21_x_line=widget_draw(column1_pi21,xsize=120,ysize=5,uname='pi21xline')
;			column2_pi21=widget_base(row1_pi21,/column,/base_align_center)
;			pi21_y=widget_label(column2_pi21,xsize=135)
;			pi21_y_line=widget_draw(column2_pi21,xsize=120,ysize=5,uname='pi21yline')
;			column3_pi21=widget_base(row1_pi21,/column,/base_align_center)
;			pi21_z=widget_label(column3_pi21,xsize=135)
;			pi21_z_line=widget_draw(column3_pi21,xsize=120,ysize=5,uname='pi21zline')
;
;			row2_pi21=widget_base(pi21_base,/row)
;			pi21_showlabel=widget_label(row2_pi21, value='show ')
;			pi21_show=widget_combobox(row2_pi21, $
;				value=['x','y','z','all'],xsize=70)
;			widget_control, pi21_show, set_combobox_select=3
;			pi21_updpwnlabel=widget_label(row2_pi21, value='Up Down ')
;			pi21_updown=widget_combobox(row2_pi21, $
;				value=['yes','no'],xsize=70)
;			row3_pi21=widget_base(pi21_base,/row)
;			plotpi21 = widget_draw(row3_pi21,xsize=450,ysize=240,uname='plotpi21')


				widget_control,pi21_base,/realize
				(*pstateinspectrun).pi21_base=pi21_base
				(*pstateinspectrun).pi21_x=pi21_x
				(*pstateinspectrun).pi21_y=pi21_y
				(*pstateinspectrun).pi21_z=pi21_z
				(*pstateinspectrun).pi21_show=pi21_show
				(*pstateinspectrun).pi21_updown=pi21_updown
				(*pstateinspectrun).plotpi21=plotpi21
				(*pstateinspectrun).plotpi21_obj=plotpi21_obj

				widget_control,pi21_base,set_uvalue=pstateinspectrun

				xmanager,'inspect_run_gui',pi21_base,/no_block;,cleanup='inspect_run_gui_cleanup'

				widget_control,pi21_x_line,get_value=winid
				wset,winid
				plot, [10000], [10000], xrange=[0,1], yrange=[0,1], $
				color = red, background = red

				widget_control,pi21_y_line,get_value=winid
				wset,winid
				plot, [10000], [10000], xrange=[0,1], yrange=[0,1], $
				color = green, background = green

				widget_control,pi21_z_line,get_value=winid
				wset,winid
				plot, [10000], [10000], xrange=[0,1], yrange=[0,1], $
				color = blue, background = blue

			end ; pi21

			widget_control,(*pstateinspectrun).plotpi22, bad_id=badid, get_value=winidtemp
			if (badid ne 0) then begin

				pi22_base=widget_base(group_leader=(*pstateinspectrun).tlbinspectrun,/column, $
					yoffset=screen_size[1]*.65, xoffset=screen_size[0]*.66, title='Pi2 Flipper #2')
				row1_pi22=widget_base(pi22_base,/row)
				column1_pi22=widget_base(row1_pi22,/column,/base_align_center)
				pi22_x=widget_label(column1_pi22,xsize=screen_size[0]*.095)
				pi22_x_line=widget_draw(column1_pi22,xsize=screen_size[0]*.095,ysize=5,uname='pi22xline')
				column2_pi22=widget_base(row1_pi22,/column,/base_align_center)
				pi22_y=widget_label(column2_pi22,xsize=screen_size[0]*.095)
				pi22_y_line=widget_draw(column2_pi22,xsize=screen_size[0]*.095,ysize=5,uname='pi22yline')
				column3_pi22=widget_base(row1_pi22,/column,/base_align_center)
				pi22_z=widget_label(column3_pi22,xsize=screen_size[0]*.095)
				pi22_z_line=widget_draw(column3_pi22,xsize=screen_size[0]*.095,ysize=5,uname='pi22zline')

				row2_pi22=widget_base(pi22_base,/row)
				pi22_showlabel=widget_label(row2_pi22, value='show ')
				pi22_show=widget_combobox(row2_pi22, $
					value=['x','y','z','all'],xsize=70)
				widget_control, pi22_show, set_combobox_select=3
				pi22_updpwnlabel=widget_label(row2_pi22, value='Up Down ')
				pi22_updown=widget_combobox(row2_pi22, $
					value=['yes','no'],xsize=70)
				row3_pi22=widget_base(pi22_base,/row)
				plotpi22 = cwo_drawplot(row3_pi22,xsize=screen_size[0]*.30,ysize=screen_size[1]*.20, $
					uname='plotpi22',obj=plotpi22_obj, position=[0.15,0.15,0.85,0.85])

;			pi22_base=widget_base(group_leader=(*pstateinspectrun).tlbinspectrun,/column, $
;				yoffset=700, xoffset=990, title='Pi2 Flipper #1')
;			row1_pi22=widget_base(pi22_base,/row)
;			column1_pi22=widget_base(row1_pi22,/column,/base_align_center)
;			pi22_x=widget_label(column1_pi22,xsize=135)
;			pi22_x_line=widget_draw(column1_pi22,xsize=120,ysize=5,uname='pi22xline')
;			column2_pi22=widget_base(row1_pi22,/column,/base_align_center)
;			pi22_y=widget_label(column2_pi22,xsize=135)
;			pi22_y_line=widget_draw(column2_pi22,xsize=120,ysize=5,uname='pi22yline')
;			column3_pi22=widget_base(row1_pi22,/column,/base_align_center)
;			pi22_z=widget_label(column3_pi22,xsize=135)
;			pi22_z_line=widget_draw(column3_pi22,xsize=120,ysize=5,uname='pi22zline')
;
;			row2_pi22=widget_base(pi22_base,/row)
;			pi22_showlabel=widget_label(row2_pi22, value='show ')
;			pi22_show=widget_combobox(row2_pi22, $
;				value=['x','y','z','all'],xsize=70)
;			widget_control, pi22_show, set_combobox_select=3
;			pi22_updpwnlabel=widget_label(row2_pi22, value='Up Down ')
;			pi22_updown=widget_combobox(row2_pi22, $
;				value=['yes','no'],xsize=70)
;			row3_pi22=widget_base(pi22_base,/row)
;			plotpi22 = widget_draw(row3_pi22,xsize=450,ysize=240,uname='plotpi22')

				widget_control,pi22_base,/realize
				(*pstateinspectrun).pi22_base=pi22_base
				(*pstateinspectrun).pi22_x=pi22_x
				(*pstateinspectrun).pi22_y=pi22_y
				(*pstateinspectrun).pi22_z=pi22_z
				(*pstateinspectrun).pi22_show=pi22_show
				(*pstateinspectrun).pi22_updown=pi22_updown
				(*pstateinspectrun).plotpi22=plotpi22
				(*pstateinspectrun).plotpi22_obj=plotpi22_obj

				widget_control,pi22_base,set_uvalue=pstateinspectrun

				xmanager,'inspect_run_gui',pi22_base,/no_block;,cleanup='inspect_run_gui_cleanup'

				widget_control,pi22_x_line,get_value=winid
				wset,winid
				plot, [10000], [10000], xrange=[0,1], yrange=[0,1], $
				color = red, background = red

				widget_control,pi22_y_line,get_value=winid
				wset,winid
				plot, [10000], [10000], xrange=[0,1], yrange=[0,1], $
				color = green, background = green

				widget_control,pi22_z_line,get_value=winid
				wset,winid
				plot, [10000], [10000], xrange=[0,1], yrange=[0,1], $
				color = blue, background = blue

			end ; pi22

			device,decomposed=dc

			widget_control,(*pstateinspectrun).plotmonitor, bad_id=badid, get_value=winidtemp
			if (badid ne 0) then begin

				monitor_base=widget_base(group_leader=(*pstateinspectrun).tlbinspectrun,/column, $
					xoffset=screen_size[0]*.58, yoffset=screen_size[1]*.03, title='Monitor')
				row1_monitor=widget_base(monitor_base,/row)
			plotmonitor = cwo_drawplot(row1_monitor,xsize=screen_size[0]*.15,ysize=screen_size[1]*.15, $
				uname='plotmonitor',obj=plotmonitor_obj, position=[0.25,0.15,0.90,0.85])

;			monitor_base=widget_base(group_leader=(*pstateinspectrun).tlbinspectrun,/column, $
;				xoffset=950, title='Monitor')
;			row1_monitor=widget_base(monitor_base,/row)
;			plotmonitor = widget_draw(row1_monitor,xsize=255,ysize=180,uname='plotmonitor')

				widget_control,monitor_base,/realize
				(*pstateinspectrun).plotmonitor=plotmonitor
				(*pstateinspectrun).plotmonitor_obj=plotmonitor_obj

				xmanager,'inspect_run_gui',monitor_base,/no_block;,cleanup='inspect_run_gui_cleanup'

			end ; monitor

			widget_control,(*pstateinspectrun).plotdetector, bad_id=badid, get_value=winidtemp
			if (badid ne 0) then begin

				detector_base=widget_base(group_leader=(*pstateinspectrun).tlbinspectrun,/column, $
					xoffset=screen_size[0]*.76, yoffset=screen_size[1]*.03, title='Detector')
				row1_detector=widget_base(detector_base,/row)
				plotdetector = cwo_drawplot(row1_detector,xsize=screen_size[0]*.15,ysize=screen_size[1]*.15, $
					uname='plotdetector',obj=plotdetector_obj, position=[0.25,0.15,0.90,0.85])

;			detector_base=widget_base(group_leader=(*pstateinspectrun).tlbinspectrun,/column, $
;				xoffset=1250, title='Detector')
;			row1_detector=widget_base(detector_base,/row)
;			plotdetector = widget_draw(row1_detector,xsize=255,ysize=180,uname='plotdetector')

				widget_control,detector_base,/realize

				(*pstateinspectrun).plotdetector=plotdetector
				(*pstateinspectrun).plotdetector_obj=plotdetector_obj

				xmanager,'inspect_run_gui',detector_base,/no_block;,cleanup='inspect_run_gui_cleanup'

			end ; detector

			widget_control,(*pstateinspectrun).plotbkg, bad_id=badid, get_value=winidtemp
			if (badid ne 0) then begin

				bkg_base=widget_base(group_leader=(*pstateinspectrun).tlbinspectrun,/column, $
					yoffset=screen_size[1]*.23, xoffset=screen_size[0]*.58, title='Background')
				row1_bkg=widget_base(bkg_base,/row)
				plotbkg = cwo_drawplot(row1_bkg,xsize=screen_size[0]*.15,ysize=screen_size[1]*.15, $
					uname='plotbkg',obj=plotbkg_obj, position=[0.25,0.15,0.90,0.85])

;			bkg_base=widget_base(group_leader=(*pstateinspectrun).tlbinspectrun,/column, $
;				yoffset=250, xoffset=950, title='Background')
;			row1_bkg=widget_base(bkg_base,/row)
;			plotbkg = widget_draw(row1_bkg,xsize=255, ysize=180,uname='plotbkg')

				widget_control,bkg_base,/realize

				(*pstateinspectrun).plotbkg=plotbkg
				(*pstateinspectrun).plotbkg_obj=plotbkg_obj

				xmanager,'inspect_run_gui',bkg_base,/no_block;,cleanup='inspect_run_gui_cleanup'

			end ; background

			widget_control,(*pstateinspectrun).plottime, bad_id=badid, get_value=winidtemp
			if (badid ne 0) then begin

				time_base=widget_base(group_leader=(*pstateinspectrun).tlbinspectrun,/column, $
					yoffset=screen_size[1]*.23, xoffset=screen_size[0]*.76, title='Time')
				row1_time=widget_base(time_base,/row)
				plottime = cwo_drawplot(row1_time,xsize=screen_size[0]*.15,ysize=screen_size[1]*.15, $
					uname='plottime',obj=plottime_obj, position=[0.25,0.15,0.90,0.85])

;			time_base=widget_base(group_leader=(*pstateinspectrun).tlbinspectrun,/column, $
;				yoffset=250, xoffset=1250, title='Time')
;			row1_time=widget_base(time_base,/row)
;			plottime = widget_draw(row1_time,xsize=255, ysize=180,uname='plottime')

				widget_control,time_base,/realize

				(*pstateinspectrun).plottime=plottime
				(*pstateinspectrun).plottime_obj=plottime_obj

				xmanager,'inspect_run_gui',time_base,/no_block;,cleanup='inspect_run_gui_cleanup'

			end ; time

			widget_control,(*pstateinspectrun).plottemperature, bad_id=badid, get_value=winidtemp
			if (badid ne 0) then begin

				temperature_base=widget_base(group_leader=(*pstateinspectrun).tlbinspectrun,/column, $
					yoffset=screen_size[1]*.43, xoffset=screen_size[0]*.58, title='Temperature')
				row1_temperature=widget_base(temperature_base,/row)
				plottemperature = cwo_drawplot(row1_temperature,xsize=screen_size[0]*.15,ysize=screen_size[1]*.15, $
					uname='plottemperature',obj=plottemperature_obj, position=[0.25,0.15,0.90,0.85])

;			temperature_base=widget_base(group_leader=(*pstateinspectrun).tlbinspectrun,/column, $
;				yoffset=480, xoffset=950, title='Temperature')
;			row1_temperature=widget_base(temperature_base,/row)
;			plottemperature = widget_draw(row1_temperature,xsize=255,ysize=180,uname='plottemperature')

				widget_control,temperature_base,/realize

				(*pstateinspectrun).plottemperature=plottemperature
				(*pstateinspectrun).plottemperature_obj=plottemperature_obj

				xmanager,'inspect_run_gui',temperature_base,/no_block;,cleanup='inspect_run_gui_cleanup'

			end ; temperature

			datfilesel=nse_comboindex((*pstateinspectrun).datfileslist)

			dummyevent={id:(*pstateinspectrun).datfileslist, $
				top:event.top, $
				handler:event.top, index:datfilesel}
			inspect_run_gui_event,dummyevent

		end ; restoreall


	(*pstateinspectrun).quitinspectrun: begin
	widget_control,event.top,/destroy
	end

	(*pstateinspectrun).echofileslist: begin
		line=''
		echofile=(*pstateinspectrun).pathdir+(*(*pstateinspectrun).ptr_echofiles)(event.index)
		openr,unit,echofile,/get_lun
		skip_lun,unit,39,/lines
		readf,unit,line
		sample_descr=strsplit(line,'"',/extract)
		free_lun,unit
		widget_control,(*pstateinspectrun).sampledescr, $
			set_value=sample_descr(1)

		datfilesstr=getdatfiles(event.top,filesel=event.index)
		widget_control,(*pstateinspectrun).qvalue, $
			set_value='Q= '+strtrim(string(datfilesstr.q,format='(f5.3)'),2)
		widget_control,(*pstateinspectrun).datfileslist, $
			set_value=strtrim(string(datfilesstr.ft(datfilesstr.ftorder)),2)
		widget_control,(*pstateinspectrun).datfileslist, $
			set_combobox_select=(n_elements(datfilesstr.ft)-1)

		dummyevent={event,id:(*pstateinspectrun).datfileslist, $
			top:event.top, $
			handler:event.top, index:(n_elements(datfilesstr.ft)-1)}
		inspect_run_gui_event,dummyevent
	end ; event echo file list

	(*pstateinspectrun).ringlist: begin
		ringsel=event.index

		winid  = (*pstateinspectrun).plotinspect
		widget_control,(*pstateinspectrun).plotinspect, bad_id=badid
		winid_bad=badid
		datax=(*(*pstateinspectrun).ptr_data)(0,*)
		datay=(*(*pstateinspectrun).ptr_data)(11+ringsel,*)
		if (winid_bad eq 0) then begin

			plotobjs = (*pstateinspectrun).plotinspect_obj
			plotobjs->setdata,datax,datay,sqrt(datay),psym=4,showlegend=0,rescale=1
;			plotobjs->clearData
;			dat1=obj_new('cwo_drawplot_data',datax,datay,sqrt(datay),psym=4)
;			plotobjs->add,dat1
;			plotobjs->add,defaultDraw
			widget_control,winid,/show
		end

	end ; ringlist

	else: begin

	updown_option=intarr(3)
	updown_option(0)=nse_comboindex((*pstateinspectrun).pi_updown)
	updown_option(1)=nse_comboindex((*pstateinspectrun).pi21_updown)
	updown_option(2)=nse_comboindex((*pstateinspectrun).pi22_updown)

	show_option=intarr(3)
	show_option(0)=nse_comboindex((*pstateinspectrun).pi_show)
	show_option(1)=nse_comboindex((*pstateinspectrun).pi21_show)
	show_option(2)=nse_comboindex((*pstateinspectrun).pi22_show)

	coloration=lonarr(4)
	coloration(0)=red
	coloration(1)=green
	coloration(2)=blue
	coloration(3)=black
	background=white

	winid=intarr(9)
	winid_bad=intarr(9)

	plotobjs = [(*pstateinspectrun).plotinspect_obj, $
		(*pstateinspectrun).plotmonitor_obj, $
		(*pstateinspectrun).plotdetector_obj, $
		(*pstateinspectrun).plottime_obj, $
		(*pstateinspectrun).plotbkg_obj, $
		(*pstateinspectrun).plotpi_obj, $
		(*pstateinspectrun).plotpi21_obj, $
		(*pstateinspectrun).plotpi22_obj, $
		(*pstateinspectrun).plottemperature_obj]
print,plotobjs
;032406
;	widget_control,(*pstateinspectrun).plotpi, bad_id=badid, get_value=winidtemp
;	winid(5)=winidtemp
	winid[5] = (*pstateinspectrun).plotpi
	widget_control,(*pstateinspectrun).plotpi, bad_id=badid
	winid_bad[5]=badid
;	widget_control,(*pstateinspectrun).plotpi21, bad_id=badid, get_value=winidtemp
;	winid(6)=winidtemp
;	winid_bad(6)=badid

	winid[6] = (*pstateinspectrun).plotpi21
	widget_control,(*pstateinspectrun).plotpi21, bad_id=badid
	winid_bad[6]=badid

;	widget_control,(*pstateinspectrun).plotpi22, bad_id=badid, get_value=winidtemp
;	winid(7)=winidtemp
;	winid_bad(7)=badid

	winid[7] = (*pstateinspectrun).plotpi22
	widget_control,(*pstateinspectrun).plotpi22, bad_id=badid
	winid_bad[7]=badid

	winid[8] = (*pstateinspectrun).plottemperature
	widget_control,(*pstateinspectrun).plottemperature, bad_id=badid
	winid_bad[8]=badid

	datapi=[21, 17, 22, 18, 23, 19, 24, 20, 25]

	if (event.id eq (*pstateinspectrun).datfileslist) then begin

		if (ptr_valid((*pstateinspectrun).ptr_data)) then ptr_free,(*pstateinspectrun).ptr_data

		filesel=nse_comboindex((*pstateinspectrun).echofileslist)
		ringsel=nse_comboindex((*pstateinspectrun).ringlist)
		datfilesstr=getdatfiles(event.top,filesel=filesel)
		longdatfile=(*pstateinspectrun).pathdir+'SingleTimes/'+ $
			datfilesstr.datfiles(datfilesstr.ft_files(datfilesstr.ftorder(event.index)))
		if (longdatfile ne ((*pstateinspectrun).pathdir+'SingleTimes/')) then begin

			line=''
			openr,unit_dat,longdatfile,/get_lun
			nlines = long(file_lines(longdatfile))
			ftlines=fix(strsplit(datfilesstr.posftxdat(datfilesstr.ft_files(datfilesstr.ftorder(event.index)))+string(nlines+1),/extract))
			skip_lun,unit_dat,3+ftlines(datfilesstr.ft_files_pos(datfilesstr.ftorder(event.index))),/lines
			readf,unit_dat,line
			if (strmatch(line,'*Temperatur*')) then begin
				tempexist=1
				readf,unit_dat,line
				readf,unit_dat,line
				data=fltarr(27,ftlines(datfilesstr.ft_files_pos(datfilesstr.ftorder(event.index))+1)-ftlines(datfilesstr.ft_files_pos(datfilesstr.ftorder(event.index)))-7)
				readf,unit_dat,data
				if (winid_bad[8] eq 0) then begin
					plotobjs[8]->setdata,data[0,*],data[17,*],psym=4,showlegend=0,rescale=1
					;plotobjs[8]->cleardata
					;dat1=obj_new('cwo_drawplot_data',data(0,*),data(17,*),psym=4)
					;plotobjs[8]->add,dat1
					;plotobjs[8]->defaultDraw
					widget_control,(*pstateinspectrun).plottemperature,/show
				endif
			endif else begin
				tempexist=0
				readf,unit_dat,line
				readf,unit_dat,line
				data=fltarr(26,ftlines(datfilesstr.ft_files_pos(datfilesstr.ftorder(event.index))+1)-ftlines(datfilesstr.ft_files_pos(datfilesstr.ftorder(event.index)))-7)
				readf,unit_dat,data
				if (winid_bad[8] eq 0) then begin
					plotobjs[8]->cleardata
					plotobjs[8]->defaultDraw
					widget_control,(*pstateinspectrun).plottemperature,/show
				endif
			endelse

			free_lun,unit_dat

			(*pstateinspectrun).ptr_data=ptr_new(data)

			datax=data(0,*)
			updowndata=intarr(n_elements(datax))
			tempwhere=(where(datax ne 0.))
			if (tempwhere(0) ne -1) then begin
				updowndata(where(datax ne 0.))=1 & echo_exist=1
			endif else begin
				echo_exist=0
			end

			winid[0] = (*pstateinspectrun).plotinspect
			widget_control,(*pstateinspectrun).plotinspect, bad_id=badid
			winid_bad[0]=badid

			winid[1] = (*pstateinspectrun).plotmonitor
			widget_control,(*pstateinspectrun).plotmonitor, bad_id=badid
			winid_bad[1]=badid

			winid[2] = (*pstateinspectrun).plotdetector
			widget_control,(*pstateinspectrun).plotdetector, bad_id=badid
			winid_bad[2]=badid

			winid[3] = (*pstateinspectrun).plottime
			widget_control,(*pstateinspectrun).plottime, bad_id=badid
			winid_bad[3]=badid

			winid[4] = (*pstateinspectrun).plotbkg
			widget_control,(*pstateinspectrun).plotbkg, bad_id=badid
			winid_bad[4]=badid

			datasel=[11+ringsel,1,2,4,5]

			if (winid_bad[0] eq 0) then begin
				plotobjs[0]->setdata,datax,data[datasel[0],*],sqrt(data[datasel[0],*]),psym=4,showlegend=0,rescale=1
;				plotobjs[0]->cleardata
;				dat1=obj_new('cwo_drawplot_data',datax,data(datasel[0],*),sqrt(data(datasel[0],*)), psym=4)
;				plotobjs[0]->add,dat1
;				plotobjs[0]->defaultDraw
				widget_control,winid[0],/show
			end

			for i=1,4 do begin
				if (winid_bad(i) eq 0) then begin
					plotobjs[i]->setdata,datax,data[datasel[i],*],psym=4,showlegend=0,rescale=1
;					plotobjs[i]->cleardata
;					dat1=obj_new('cwo_drawplot_data',datax,data(datasel(i),*), psym=4)
;					plotobjs[i]->add,dat1
;					plotobjs[i]->defaultDraw
					widget_control,winid[i],/show
				end
			end

			if (winid_bad(5) eq 0) then begin
				widget_control,(*pstateinspectrun).pi_x,set_value='Bpi x '+strtrim(string(data(datapi(0)+tempexist,0)),2)
				widget_control,(*pstateinspectrun).pi_y,set_value='Bpi y '+strtrim(string(data(datapi(1)+tempexist,0)),2)
				widget_control,(*pstateinspectrun).pi_z,set_value='Bpi z '+strtrim(string(data(datapi(2)+tempexist,0)),2)
			end

			if (winid_bad(6) eq 0) then begin
				widget_control,(*pstateinspectrun).pi21_x,set_value='Bpi21 x '+strtrim(string(data(datapi(3)+tempexist,0)),2)
				widget_control,(*pstateinspectrun).pi21_y,set_value='Bpi21 y '+strtrim(string(data(datapi(4)+tempexist,0)),2)
				widget_control,(*pstateinspectrun).pi21_z,set_value='Bpi21 z '+strtrim(string(data(datapi(5)+tempexist,0)),2)
			end

			if (winid_bad(7) eq 0) then begin
				widget_control,(*pstateinspectrun).pi22_x,set_value='Bpi22 x '+strtrim(string(data(datapi(6)+tempexist,0)),2)
				widget_control,(*pstateinspectrun).pi22_y,set_value='Bpi22 y '+strtrim(string(data(datapi(7)+tempexist,0)),2)
				widget_control,(*pstateinspectrun).pi22_z,set_value='Bpi22 z '+strtrim(string(data(datapi(8)+tempexist,0)),2)
			end

			device,decomposed=dc
			endif else begin
print,'cavolo!'
				widget_control,(*pstateinspectrun).plotinspect,get_value=winid
				wset,winid
				wshow,winid
				device, get_decomposed=dc
			        device, decomposed = 1
				black = 0L
				red = 255L
				green = 256L*255L
				blue = 256L*256L*255L
				white = red + green + blue
				plot, [10000], [10000], min_value=0, max_value=1, xrange=[0,1], yrange=[0,1], $
					color = white, background = white

				widget_control,(*pstateinspectrun).plotmonitor,get_value=winid
				wset,winid
				wshow,winid
				plot, [10000], [10000], min_value=0, max_value=1, xrange=[0,1], yrange=[0,1], $
					color = white, background = white

				widget_control,(*pstateinspectrun).plotdetctor,get_value=winid
				wset,winid
				plot, [10000], [10000], min_value=0, max_value=1, xrange=[0,1], yrange=[0,1], $
					color = white, background = white

				widget_control,(*pstateinspectrun).plottime,get_value=winid
				wset,winid
				wshow,winid
				plot, [10000], [10000], min_value=0, max_value=1, xrange=[0,1], yrange=[0,1], $
					color = white, background = white

				widget_control,(*pstateinspectrun).plotbkg,get_value=winid
				wset,winid
				wshow,winid
				plot, [10000], [10000], min_value=0, max_value=1, xrange=[0,1], yrange=[0,1], $
					color = white, background = white

				device,decomposed=dc
			end

	piloopstart=0 & piloopend=2

	endif else begin

		data=(*(*pstateinspectrun).ptr_data)
		tempexist=(n_elements(data(*,0)) eq 27)
		datax=data(0,*)
		updowndata=intarr(n_elements(datax))
		tempwhere=(where(datax ne 0.))
		if (tempwhere(0) ne -1) then begin
			updowndata(where(datax ne 0.))=1 & echo_exist=1
		endif else begin
			echo_exist=0
		end

		case event.id of

			(*pstateinspectrun).pi_show: begin
				piloopstart=0 & piloopend=0
			end ; show pi

			(*pstateinspectrun).pi_updown: begin
				piloopstart=0 & piloopend=0
			end ; show pi

			(*pstateinspectrun).pi21_show: begin
				piloopstart=1 & piloopend=1
			end ; show pi

			(*pstateinspectrun).pi21_updown: begin
				piloopstart=1 & piloopend=1
			end ; show pi

			(*pstateinspectrun).pi22_show: begin
				piloopstart=2 & piloopend=2
			end ; show pi

			(*pstateinspectrun).pi22_updown: begin
				piloopstart=2 & piloopend=2
			end ; show pi

		endcase ; second

	endelse

		for i=piloopstart,piloopend do begin

		if (echo_exist ge updown_option(i)) then begin

			if (show_option(i) ne 3 ) then begin
				datay=data(datapi(i*3+show_option[i])+tempexist,where(updowndata ge updown_option[i]))
				if (winid_bad(5+i) eq 0) then begin
					plotobjs[5+i]->setdata,datax(where(updowndata ge updown_option[i])), $
						datay,psym=4,showlegend=0,rescale=1,color=coloration[show_option[i]]
;					plotobjs[5+i]->clearData
;					dat1=obj_new('cwo_drawplot_data',datax(where(updowndata ge updown_option[i])), $
;						datay,psym=4,color=coloration[show_option[i]])
;					plotobjs[5+i]->add,dat1
;					plotobjs[5+i]->add,defaultDraw
					widget_control,winid[5+i],/show
				end
			endif else begin
				if (winid_bad(5+i) eq 0) then begin
					datay=[data[datapi[i*3]+tempexist,where(updowndata ge updown_option[i])]- $
						data[datapi[i*3]+tempexist,0], $
						data[datapi[i*3+1]+tempexist,where(updowndata ge updown_option[i])]- $
						data[datapi[i*3+1]+tempexist,0], $
						data[datapi[i*3+2]+tempexist,where(updowndata ge updown_option[i])]- $
						data[datapi[i*3+2]+tempexist,0]]

					plotobjs[5+i]->clearData
					dat1=obj_new('cwo_drawplot_data',datax(where(updowndata ge updown_option[i])), $
						datay[0,*],psym=4,color=red,showlegend=0)
					dat2=obj_new('cwo_drawplot_data',datax(where(updowndata ge updown_option[i])), $
						datay[1,*],psym=4,color=green,showlegend=0)
					dat3=obj_new('cwo_drawplot_data',datax(where(updowndata ge updown_option[i])), $
						datay[2,*],psym=4,color=blue,showlegend=0)
					plotobjs[5+i]->add,dat1
					plotobjs[5+i]->add,dat2
					plotobjs[5+i]->add,dat3
					plotobjs[5+i]->defaultDraw
					widget_control,winid[5+i],/show
				endif
			end
		endif else begin
print,'cav'
      ;073108
      ;COMMENTING OUT THE NEXT LINE ACCORDING TO ANTONIO'S INSTRUCTIONS.
      ;
			;plot_blank, winid(5+i)
		end

		end ; i pis loop

	end
	endcase ; first
	endif;CWO_DRAWPLOT_EVENT

end ;

; ************************** ;


function inspect_run_gui,leader

    ;title='Select a Charlotte NSE data directory'
    ;print,title
	pathdir=dialog_pickfile(/directory,title='Select a Charlotte NSE data directory')

	pathdirlength=strlen(pathdir)
	templongechofiles4=file_search(pathdir+'m????.echo')
  if templongechofiles4[0] eq '' then fours = 0 else fours = 1
  templongechofiles5=file_search(pathdir+'m?????.echo')
  if templongechofiles5[0] eq '' then fives = 0 else fives = 1
  templongechofiles6=file_search(pathdir+'m??????.echo')
  if templongechofiles6[0] eq '' then sixes = 0 else sixes = 1

  if fours ne 0 then templongechofiles = [templongechofiles4]
  if fives ne 0 and n_elements(templongechofiles) ne 0 then begin
    templongechofiles = [templongechofiles,templongechofiles5] 
  endif else begin
    if fives ne 0 then templongechofiles = [templongechofiles5]
  endelse
  if sixes ne 0 and n_elements(templongechofiles) ne 0 then begin
    templongechofiles = [templongechofiles,templongechofiles6] 
  endif else begin
    if sixes ne 0 then templongechofiles = [templongechofiles6]
  endelse
  
	if (pathdir eq '') or (templongechofiles[0] eq '') then begin
		void = dialog_message('No .echo files there.')
		return,0
	endif else begin

	device,get_screen_size=screen_size

	temp_tlb=widget_base(/col)
	temp_message=widget_label(temp_tlb,value='Please, wait...')
	geom=widget_info(temp_tlb,/geometry)
	widget_control,temp_tlb,xoff= (screen_size[0]/2)-(geom.scr_xsize/2), $
		yoff= (screen_size[1]/2)-(geom.scr_ysize/2)
	widget_control,temp_tlb,/realize

	tempechofiles=strmid(templongechofiles,pathdirlength)
	tempechofilesno=n_elements(tempechofiles)
	echo_exist=[0]

	for i=0,tempechofilesno-1 do begin
		echo_e=file_search(pathdir+'SingleTimes/'+strmid(tempechofiles[i],0,5)+'*_*.dat')

		if (echo_e[0] eq '') then begin
			echo_exist=[echo_exist,0]
		endif else begin
			echo_exist=[echo_exist,1]
		endelse
	endfor

    wh = where((echo_exist[1:(n_elements(echo_exist)-1)]) eq 1,wh_count)

    if wh_count ne 0 then begin
    	echofiles=tempechofiles[wh]
	    echofilesno=n_elements(echofiles)

    	widget_control,temp_tlb,/destroy

    	line=''

    	tlbinspectrun = widget_base(title="Inspect Run", xoffset=0, yoffset=screen_size[1]*.03,mbar=inspectrunbar,/column,group_leader=leader)
    	fileinspectrun = widget_button(inspectrunbar,value='File')
    	refresh = widget_button(fileinspectrun,value='Refresh/Change Directory',uname='REFRESH_inspectrun')
    	restoreall = widget_button(fileinspectrun,value='Restore All Windows',uname='RESTORE_inspectrun')
    	quitinspectrun = widget_button(fileinspectrun,value='Quit All',uname='QUIT_inspectrun')

    	row1=widget_base(tlbinspectrun,/row)
    	echofileslist=widget_combobox(row1,value=echofiles)
    	qvalue=widget_label(row1,xsize=100)
    	datlistlabel=widget_label(row1, value='      Ft ')
    	datfileslist=widget_combobox(row1)
    	ringlistlabel=widget_label(row1, value='      ring ')
    	ringlist=widget_combobox(row1, $
    		value=['1','2','3','4','5','6'],xsize=50)
    	row2=widget_base(tlbinspectrun,/row)
    	sampledescr=widget_label(row2,xsize=screen_size[0]*.45,/align_left)
    	row3=widget_base(tlbinspectrun,/row)
    	plotinspect = cwo_drawplot(row3,xsize=screen_size[0]*.55,ysize=screen_size[1]*.45,uname='plotinspect', $
    		obj=plotinspect_obj,position=[0.15,0.15,0.85,0.85]);

    	pi_base=widget_base(group_leader=tlbinspectrun,/column, $
    		yoffset=screen_size[1]*.65, title='Pi Flipper')
    	row1_pi=widget_base(pi_base,/row)
    	column1_pi=widget_base(row1_pi,/column,/base_align_center)
    	pi_x=widget_label(column1_pi,xsize=screen_size[0]*.095)
    	pi_x_line=widget_draw(column1_pi,xsize=screen_size[0]*.095,ysize=5,uname='pixline')
    	column2_pi=widget_base(row1_pi,/column,/base_align_center)
    	pi_y=widget_label(column2_pi,xsize=screen_size[0]*.095)
    	pi_y_line=widget_draw(column2_pi,xsize=screen_size[0]*.095,ysize=5,uname='piyline')
    	column3_pi=widget_base(row1_pi,/column,/base_align_center)
    	pi_z=widget_label(column3_pi,xsize=screen_size[0]*.095)
    	pi_z_line=widget_draw(column3_pi,xsize=screen_size[0]*.095,ysize=5,uname='pizline')

    	row2_pi=widget_base(pi_base,/row)
    	pi_showlabel=widget_label(row2_pi, value='show ')
    	pi_show=widget_combobox(row2_pi, $
    		value=['x','y','z','all'],xsize=70)
    	widget_control, pi_show, set_combobox_select=3
    	pi_updpwnlabel=widget_label(row2_pi, value='Up Down ')
    	pi_updown=widget_combobox(row2_pi, $
    		value=['yes','no'],xsize=70)
    	row3_pi=widget_base(pi_base,/row)
    	plotpi = cwo_drawplot(row3_pi,xsize=screen_size[0]*.30,ysize=screen_size[1]*.2, $
    		uname='plotpi',obj=plotpi_obj, position=[0.15,0.15,0.85,0.85])

    	pi21_base=widget_base(group_leader=tlbinspectrun,/column, $
    		yoffset=screen_size[1]*.65, xoffset=screen_size[0]*.33, title='Pi2 Flipper #1')
    	row1_pi21=widget_base(pi21_base,/row)
    	column1_pi21=widget_base(row1_pi21,/column,/base_align_center)
    	pi21_x=widget_label(column1_pi21,xsize=screen_size[0]*.095)
    	pi21_x_line=widget_draw(column1_pi21,xsize=screen_size[0]*.095,ysize=5,uname='pi21xline')
    	column2_pi21=widget_base(row1_pi21,/column,/base_align_center)
    	pi21_y=widget_label(column2_pi21,xsize=screen_size[0]*.095)
    	pi21_y_line=widget_draw(column2_pi21,xsize=screen_size[0]*.095,ysize=5,uname='pi21yline')
    	column3_pi21=widget_base(row1_pi21,/column,/base_align_center)
    	pi21_z=widget_label(column3_pi21,xsize=screen_size[0]*.095)
    	pi21_z_line=widget_draw(column3_pi21,xsize=screen_size[0]*.095,ysize=5,uname='pi21zline')
    	row2_pi21=widget_base(pi21_base,/row)
    	pi21_showlabel=widget_label(row2_pi21, value='show ')
    	pi21_show=widget_combobox(row2_pi21, $
    		value=['x','y','z','all'],xsize=70)
    	widget_control, pi21_show, set_combobox_select=3
    	pi21_updpwnlabel=widget_label(row2_pi21, value='Up Down ')
    	pi21_updown=widget_combobox(row2_pi21, $
    		value=['yes','no'],xsize=70)
    	row3_pi21=widget_base(pi21_base,/row)
    	plotpi21 = cwo_drawplot(row3_pi21,xsize=screen_size[0]*.30,ysize=screen_size[1]*.2, $
    		uname='plotpi21',obj=plotpi21_obj, position=[0.15,0.15,0.85,0.85])

    	pi22_base=widget_base(group_leader=tlbinspectrun,/column, $
    		yoffset=screen_size[1]*.65, xoffset=screen_size[0]*.66, title='Pi2 Flipper #2')
    	row1_pi22=widget_base(pi22_base,/row)
    	column1_pi22=widget_base(row1_pi22,/column,/base_align_center)
    	pi22_x=widget_label(column1_pi22,xsize=screen_size[0]*.095)
    	pi22_x_line=widget_draw(column1_pi22,xsize=screen_size[0]*.095,ysize=5,uname='pi22xline')
    	column2_pi22=widget_base(row1_pi22,/column,/base_align_center)
    	pi22_y=widget_label(column2_pi22,xsize=screen_size[0]*.095)
    	pi22_y_line=widget_draw(column2_pi22,xsize=screen_size[0]*.095,ysize=5,uname='pi22yline')
    	column3_pi22=widget_base(row1_pi22,/column,/base_align_center)
    	pi22_z=widget_label(column3_pi22,xsize=screen_size[0]*.095)
    	pi22_z_line=widget_draw(column3_pi22,xsize=screen_size[0]*.095,ysize=5,uname='pi22zline')

    	row2_pi22=widget_base(pi22_base,/row)
    	pi22_showlabel=widget_label(row2_pi22, value='show ')
    	pi22_show=widget_combobox(row2_pi22, $
    		value=['x','y','z','all'],xsize=70)
    	widget_control, pi22_show, set_combobox_select=3
    	pi22_updpwnlabel=widget_label(row2_pi22, value='Up Down ')
    	pi22_updown=widget_combobox(row2_pi22, $
    		value=['yes','no'],xsize=70)
    	row3_pi22=widget_base(pi22_base,/row)
    	plotpi22 = cwo_drawplot(row3_pi22,xsize=screen_size[0]*.30,ysize=screen_size[1]*.20, $
    		uname='plotpi22',obj=plotpi22_obj, position=[0.15,0.15,0.85,0.85])

    	monitor_base=widget_base(group_leader=tlbinspectrun,/column, $
    		xoffset=screen_size[0]*.58, yoffset=screen_size[1]*.03, title='Monitor')
    	row1_monitor=widget_base(monitor_base,/row)
    	plotmonitor = cwo_drawplot(row1_monitor,xsize=screen_size[0]*.15,ysize=screen_size[1]*.15, $
    		uname='plotmonitor',obj=plotmonitor_obj, position=[0.25,0.15,0.90,0.85])

    	detector_base=widget_base(group_leader=tlbinspectrun,/column, $
    		xoffset=screen_size[0]*.76, yoffset=screen_size[1]*.03, title='Detector')
    	row1_detector=widget_base(detector_base,/row)
    	plotdetector = cwo_drawplot(row1_detector,xsize=screen_size[0]*.15,ysize=screen_size[1]*.15, $
    		uname='plotdetector',obj=plotdetector_obj, position=[0.25,0.15,0.90,0.85])

    	bkg_base=widget_base(group_leader=tlbinspectrun,/column, $
    		yoffset=screen_size[1]*.23, xoffset=screen_size[0]*.58, title='Background')
    	row1_bkg=widget_base(bkg_base,/row)
    	plotbkg = cwo_drawplot(row1_bkg,xsize=screen_size[0]*.15,ysize=screen_size[1]*.15, $
    		uname='plotbkg',obj=plotbkg_obj, position=[0.25,0.15,0.90,0.85])

    	time_base=widget_base(group_leader=tlbinspectrun,/column, $
    		yoffset=screen_size[1]*.23, xoffset=screen_size[0]*.76, title='Time')
    	row1_time=widget_base(time_base,/row)
    	plottime = cwo_drawplot(row1_time,xsize=screen_size[0]*.15,ysize=screen_size[1]*.15, $
    		uname='plottime',obj=plottime_obj, position=[0.25,0.15,0.90,0.85])

    	temperature_base=widget_base(group_leader=tlbinspectrun,/column, $
    		yoffset=screen_size[1]*.43, xoffset=screen_size[0]*.58, title='Temperature')
    	row1_temperature=widget_base(temperature_base,/row)
    	plottemperature = cwo_drawplot(row1_temperature,xsize=screen_size[0]*.15,ysize=screen_size[1]*.15, $
    		uname='plottemperature',obj=plottemperature_obj, position=[0.25,0.15,0.90,0.85])

    	widget_control,tlbinspectrun,/realize
    	widget_control,pi_base,/realize
    	widget_control,pi21_base,/realize
    	widget_control,pi22_base,/realize
    	widget_control,monitor_base,/realize
    	widget_control,detector_base,/realize
    	widget_control,bkg_base,/realize
    	widget_control,time_base,/realize
    	widget_control,temperature_base,/realize

    	device, get_decomposed=dc
    	device, decomposed = 1
    	black = 0L
    	red = 255L
    	green = 256L*255L
    	blue = 256L*256L*255L
    	white = red + green + blue

    	widget_control,pi_x_line,get_value=winid
    	wset,winid
    	plot, [10000], [10000], xrange=[0,1], yrange=[0,1], $
    	color = red, background = red

    	widget_control,pi_y_line,get_value=winid
    	wset,winid
    	plot, [10000], [10000], xrange=[0,1], yrange=[0,1], $
    	color = green, background = green

    	widget_control,pi_z_line,get_value=winid
    	wset,winid
    	plot, [10000], [10000], xrange=[0,1], yrange=[0,1], $
    	color = blue, background = blue

    	widget_control,pi21_x_line,get_value=winid
    	wset,winid
    	plot, [10000], [10000], xrange=[0,1], yrange=[0,1], $
    	color = red, background = red

    	widget_control,pi21_y_line,get_value=winid
    	wset,winid
    	plot, [10000], [10000], xrange=[0,1], yrange=[0,1], $
    	color = green, background = green

    	widget_control,pi21_z_line,get_value=winid
    	wset,winid
    	plot, [10000], [10000], xrange=[0,1], yrange=[0,1], $
    	color = blue, background = blue

    	widget_control,pi22_x_line,get_value=winid
    	wset,winid
    	plot, [10000], [10000], xrange=[0,1], yrange=[0,1], $
    	color = red, background = red

    	widget_control,pi22_y_line,get_value=winid
    	wset,winid
    	plot, [10000], [10000], xrange=[0,1], yrange=[0,1], $
    	color = green, background = green

    	widget_control,pi22_z_line,get_value=winid
    	wset,winid
    	plot, [10000], [10000], xrange=[0,1], yrange=[0,1], $
    	color = blue, background = blue

    	device,decomposed=dc
    	ptr_echofiles=ptr_new(echofiles)
    	ptr_data=ptr_new()
    	stateinspectrun={tlbinspectrun:tlbinspectrun, $
    		quitinspectrun:quitinspectrun, $
    		echofileslist:echofileslist, $
    		ptr_echofiles:ptr_echofiles, $
    		qvalue:qvalue, $
    		datfileslist:datfileslist, $
    		ringlist:ringlist, $
    		sampledescr:sampledescr, $
    		plotinspect:plotinspect, plotinspect_obj:plotinspect_obj, pathdir:pathdir, $
    		plotmonitor:plotmonitor, plotmonitor_obj:plotmonitor_obj, $
    		plotdetector:plotdetector, plotdetector_obj:plotdetector_obj,$
    		plottime:plottime, plottime_obj:plottime_obj, $
    		plotbkg:plotbkg, plotbkg_obj:plotbkg_obj, $
    		plottemperature:plottemperature, plottemperature_obj:plottemperature_obj, $
    		pi22_base:pi22_base, pi22_x:pi22_x, pi22_y:pi22_y, $
    		pi22_z:pi22_z, pi22_show:pi22_show, pi22_updown:pi22_updown, $
    		plotpi22:plotpi22, plotpi22_obj:plotpi22_obj,$
    		pi_base:pi_base, pi_x:pi_x, pi_y:pi_y, $
    		pi_z:pi_z, pi_show:pi_show, pi_updown:pi_updown, $
    		plotpi:plotpi, plotpi_obj:plotpi_obj,$
    		pi21_base:pi21_base, pi21_x:pi21_x, pi21_y:pi21_y, $
    		pi21_z:pi21_z, pi21_show:pi21_show, pi21_updown:pi21_updown, $
    		plotpi21:plotpi21, plotpi21_obj:plotpi21_obj,$
    		ptr_data:ptr_data, restoreall:restoreall, $
    		refresh:refresh}

    	pstateinspectrun=ptr_new(stateinspectrun)

    	widget_control,tlbinspectrun,set_uvalue=pstateinspectrun
    	widget_control,pi_base,set_uvalue=pstateinspectrun
    	widget_control,pi21_base,set_uvalue=pstateinspectrun
    	widget_control,pi22_base,set_uvalue=pstateinspectrun
    	widget_control,monitor_base,set_uvalue=pstateinspectrun
    	widget_control,bkg_base,set_uvalue=pstateinspectrun
    	widget_control,time_base,set_uvalue=pstateinspectrun
    	widget_control,temperature_base,set_uvalue=pstateinspectrun
    	widget_control,detector_base,set_uvalue=pstateinspectrun
    	widget_control,echofileslist,set_combobox_select=(echofilesno-1)

    	xmanager,'inspect_run_gui',tlbinspectrun,/no_block,cleanup='inspect_run_gui_cleanup'
    	xmanager,'inspect_run_gui',pi_base,/no_block;,cleanup='inspect_run_gui_cleanup'
    	xmanager,'inspect_run_gui',pi21_base,/no_block;,cleanup='inspect_run_gui_cleanup'
    	xmanager,'inspect_run_gui',pi22_base,/no_block;,cleanup='inspect_run_gui_cleanup'
    	xmanager,'inspect_run_gui',bkg_base,/no_block;,cleanup='inspect_run_gui_cleanup'
    	xmanager,'inspect_run_gui',time_base,/no_block;,cleanup='inspect_run_gui_cleanup'
    	xmanager,'inspect_run_gui',temperature_base,/no_block;,cleanup='inspect_run_gui_cleanup'
    	xmanager,'inspect_run_gui',detector_base,/no_block;,cleanup='inspect_run_gui_cleanup'
    	xmanager,'inspect_run_gui',monitor_base,/no_block;,cleanup='inspect_run_gui_cleanup'

    	dummyevent={event,id:stateinspectrun.echofileslist, $
    		top:stateinspectrun.tlbinspectrun, $
    		handler:stateinspectrun.tlbinspectrun, index:(echofilesno-1)}
    		inspect_run_gui_event,dummyevent

        return,tlbinspectrun
    endif else begin
    	widget_control,temp_tlb,/destroy
        void = dialog_message('No "SINGLETIMES" directory available.')
        return,0
    endelse
endelse
end ; inspectrun


pro launch_inspect_run_gui,event,$
                 group_leader=group_leader,$
                 workDir=workDir,$
                 dataDir=dataDir,$
                 DAVETool=DAVETool,$
                 _Extra=extra
if n_elements(event) eq 0 then begin
    a=inspect_run_gui(group_leader)
endif else begin
    a=inspect_run_gui(event.top)
endelse
end;launch_inspect_run_gui
