; $Id$
;###############################################################################
;
;
;CLASS NAME:
;    cwo_removetlist
;
;
;PURPOSE:
;   SELECT FOURIER TIMES FOR DELETION FROM A LIST
;   AND SEND THE SELECTED TIME UP THE EVENT CHAIN.
;CATEGORY:
;
;
;SUPERCLASSES:
;   inherits myproperties
;
;
;METHODS:
;    cwo_removetlist
;    cwo_removetlist_event
;    cwo_removetlist::event
;    cwo_removetlist::cleanup
;    cwo_removetlist_cleanup
;    cwo_removetlist::init
;    cwo_removetlist__define
;
;
; AUTHOR:
; Larry Kneller
; NIST Center for Neutron Research
; 100 Bureau Drive, Gaithersburg, MD 20899
; United States
; kneller@nist.gov  301-975-8839
; Mon Feb 14 23:59:01 2005
;
; LICENSE:
; The software in this file is written by an employee of
; National Institute of Standards and Technology
; as part of the DAVE software project.
;
; The DAVE software package is not subject to copyright protection
; and is in the public domain. It should be considered as an
; experimental neutron scattering data reduction, visualization, and
; analysis system. As such, the authors assume no responsibility
; whatsoever for its use, and make no guarantees, expressed or
; implied, about its quality, reliability, or any other
; characteristic. The use of certain trade names or commercial
; products does not imply any endorsement of a particular product,
; nor does it imply that the named product is necessarily the best
; product for the stated purpose. We would appreciate acknowledgment
; if the DAVE software is used or if the code in this file is
; included in another product.
;
;###############################################################################

;
;;###############################################################################
;;
;;NAME:
;;        cwo_removetlist
;;
;;PURPOSE:
;;
;;PARAMETERS:
;;        parent     The parent base of this widget.
;;KEYWORDS:
;;        objref     The object reference of this widget (for user access).
;;        uvalue     The uvalue for this object.
;;        value      A string array of values for the list.
;;        xsize      The sizes.
;;        ysize
;;
;;_EXTRA - is used to pass keywords meant for the superclass.
;;
;;RETURN VALUE:
;;       tlb     The top level base of the widget.
;;###############################################################################
;function cwo_removetlist,parent,$
;                            obj_ref=obj_ref,$
;                            uvalue=uvalue,$
;                            value=value,$
;                            xsize=xsize,$
;                            ysize=ysize,$
;                            _Extra=extra
;
;
;
;    ;FUNCTION TO RETURN THE BASE ID FROM THE OBJECT
;    o = obj_new('cwo_removetlist',parent,$
;                            value=value,$
;                            xsize=xsize,$
;                            ysize=ysize,$
;                            _Extra=extra)
;
;
;    if obj_valid(o) gt 0 then begin
;
;        obj_ref=o   ;SETS VALUE OF obj_ref IN FUNCTION CALL
;                    ;TO ALLOW USER OF PROGRAM ACCESS TO THE
;                    ;OBJECT REFERENCE.
;
;
;        x = o->getProperty(/tlb)
;
;        return,o->getProperty(/tlb)
;    endif else begin
;        return,0L
;    endelse
;
;end;cwo_removetlist
;###############################################################################
;
;NAME:
;        cwo_removetlist_event
;
;PURPOSE:
;       Event handler external to the class.
;PARAMETERS:
;       event The event to handle.
;KEYWORDS:
;       none
;RETURN VALUE:
;       newevent    Pass the event up the widget hierarchy.
;###############################################################################
function cwo_removetlist_event_func,event
;pro cwo_removetlist_event_func,event


    widget_control,event.id,get_uvalue=uval
    newevent = call_method(uval.method,uval.object,event)
    ;call_method,uval.method,uval.object,event

    ;print,'in cwo_removetlist_event_func ',tag_names(newevent,/structure_name)
    return,newevent
end;cwo_removetlist_event_func

;###############################################################################
;
;NAME:
;        cwo_removetlist::event
;
;PURPOSE:
;        Event handler for this class.
;PARAMETERS:
;        event  The event to handle.
;KEYWORDS:
;        none.
;RETURN VALUE:
;        newevent   An event with the string of the selected item in the t field,
;                   '-1' for general non selections.
;###############################################################################
function cwo_removetlist::event,event


    ;print,tag_names(event)
    ;print,event
    closeVal = 0

    id = self.tlb
    top = event.top
    handler = event.handler
    t = '-1'
    closeVal = 0



    case event.id of
    self.list:begin
        ;print,'list event'
        t = '-1'
        closeVal = 0
    end
    self.removeButton:begin


        vals = *(self.pvals)
        ;print,vals
        index = widget_info(self.list,/list_select)
        ;print,index





        if index[0] ne -1 then begin

  
            ;DECIDE WHICH t's ARE REMOVED:
            ;ikeep = indgen(n_elements(vals))
            ikeep = [-1]
            for j=0,n_elements(vals)-1 do begin
               matchcount = 0 
               for k = 0,n_elements(index)-1 do begin
                  if j eq index[k] then begin
                    ;print,matchcount
                    matchcount++                    
                  endif 
               endfor;k
               if matchcount eq 0 then ikeep = [ikeep,j] 
            endfor;j
            if n_elements(ikeep) gt 1 then begin
              ikeep = ikeep[1:*]
              ikeep = ikeep[sort(ikeep)]
            endif
            
               
            itoss = index
            t=vals[itoss]
            ;print,t

            if n_elements(ikeep) eq 1 then begin
                if ikeep[0] ne -1 then begin
                    ;print,ikeep
                    newvals = vals[ikeep]
                endif else begin
                    newvals = ['-1']
                endelse
            endif else begin
                    ;print,ikeep
                    newvals = vals[ikeep]
            endelse
            ;print,newvals

            if ptr_valid(self.pvals) gt 0 then ptr_free,self.pvals
            self.pvals = ptr_new(newvals)

            widget_control,self.list,set_value=newvals
        endif else begin
            t = string(-1)
        endelse
        closeVal = 0

    end;remove
    self.closeButton:begin
        t='-1'
        closeVal = 1

        ;DON'T CLOSE THE OBJECT ITSELF, BUT LET IT BE DONE BY
        ;A HANDLER OUTSIDE THIS CLASS.

        ;widget_control,self.tlb,/destroy
    end;close
    else:begin
        print,'UNSURE OF WIDGET ID.'
        t = '-1'
        closeVal = 0
    end;else
    endcase


    ;newevent={cwo_removetlist_event,id:id,top:top,handler:handler,t:t,close:closeVal}
    newevent={id:id,top:top,handler:handler,t:t,close:closeVal}

    return,newevent
end;event
;###############################################################################
;
;NAME:
;        cwo_removetlist::cleanup
;
;PURPOSE:
;        Clean up pointer associated with this object before
;        destruction.
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro cwo_removetlist::cleanup,dum
    ;help,dum

    if ptr_valid(self.pvals) gt 0 then ptr_free,self.pvals


end;cwo_removetlist::cleanup
;###############################################################################
;
;NAME:
;        cwo_removetlist_cleanup
;
;PURPOSE:
;       External cleanup method to be called on destruction of the list.
;PARAMETERS:
;       id  The id of the widget calling the method (self.list)
;KEYWORDS:
;       none
;
;###############################################################################
pro cwo_removetlist_cleanup,id

    ;print,'ARRIVED AT cwo_removetlist_cleanup'
    widget_control,id,get_uvalue=uval
    obj_destroy,uval.object
end;cwo_removetlist_cleanup

;###############################################################################
;
;NAME:
;        cwo_removetlist::init
;
;PURPOSE:
;        Class init method.
;PARAMETERS:
;        parent     The parent for the compoune widget.
;KEYWORDS:
;        value      Value for the widget (a STRING ARRAY.)
;        uvalue     The uvalue for the widget.
;        xsize      The xsize of the base.
;        ysize      The ysize of the base.
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;RETURN VALUE:
;       0 for failure, 1 for success.
;###############################################################################
function cwo_removetlist::init,parent,$
                            value=value,$
                            uvalue=uvalue,$
                            xsize=xsize,$
                            ysize=ysize,$
                            _Extra=extra

    help,value,output=out,struct=0

    if n_elements(value) eq 0 or not stregex(out,'STRING',/fold_case,/boolean) then begin

        Print,'Please enter a string array for the value.'
        return,0

    endif else begin

        self.tlb = widget_base(parent,title='Select Fourier time for Removal',$
                                    column=1,$
                                    event_func='cwo_removetlist_event_func',$
                                    xsize=xsize,$
                                    ysize=ysize,$
                                    uvalue=uvalue $
                                    )

        self.list = widget_list(self.tlb,value=value,ysize=6,xsize = 40,$
                                    /multi,$  ;LRK 11/06/08
                                    kill_notify='cwo_removetlist_cleanup',$
                                    event_func='cwo_removetlist_event_func',$
                                    uvalue={object:self,$
                                            method:'event',$
                                            id:'LIST'})


        self.removeButton = widget_button(self.tlb,value="Remove T",$
                                                event_func='cwo_removetlist_event_func',$
                                                uvalue={object:self,$
                                                        method:'event',$
                                                        id:'REMOVE'})


        self.closeButton = widget_button(self.tlb,value="Close",$
                                                event_func='cwo_removetlist_event_func',$
                                                uvalue={object:self,$
                                                        method:'event',$
                                                        id:'CLOSE'})

        self.pvals = ptr_new(value)

        ;xmanager,'cwo_removetlist',self.tlb,event_handler='cwo_removetlist_event_func'

        return,1
    endelse

end;init



;###############################################################################
;
;NAME:
;        cwo_removetlist__define
;
;PURPOSE:
;        Define the class structure.
;PARAMETERS:
;        struct     Allows the use of myproperties.
;KEYWORDS:
;       none
;###############################################################################
pro cwo_removetlist__define,struct

    struct = {cwo_removetlist,$
                inherits myproperties,$
                pvals:ptr_new(),$
                tlb:0L, $
                list:0L,$
                closeButton:0L,$
                removeButton:0L $
                }

end;cwo_removetlist__define




;###############################################################################
;
;NAME:
;        cwo_removetlist
;
;PURPOSE:
;
;PARAMETERS:
;        parent     The parent base of this widget.
;KEYWORDS:
;        objref     The object reference of this widget (for user access).
;        uvalue     The uvalue for this object.
;        value      A string array of values for the list.
;        xsize      The sizes.
;        ysize
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;RETURN VALUE:
;       tlb     The top level base of the widget.
;###############################################################################
function cwo_removetlist,parent,$
                            obj_ref=obj_ref,$
                            uvalue=uvalue,$
                            value=value,$
                            xsize=xsize,$
                            ysize=ysize,$
                            _Extra=extra



    ;FUNCTION TO RETURN THE BASE ID FROM THE OBJECT
    o = obj_new('cwo_removetlist',parent,$
                            value=value,$
                            xsize=xsize,$
                            ysize=ysize,$
                            _Extra=extra)


    if obj_valid(o) gt 0 then begin

        obj_ref=o   ;SETS VALUE OF obj_ref IN FUNCTION CALL
                    ;TO ALLOW USER OF PROGRAM ACCESS TO THE
                    ;OBJECT REFERENCE.


        x = o->getProperty(/tlb)

        return,o->getProperty(/tlb)
    endif else begin
        return,0L
    endelse

end;cwo_removetlist
