; $Id$
;###############################################################################
;
;CLASS NAME:
;    pro cwo_pickmethod_class__define,struct
;
;PURPOSE:
;       Widget to allow the selection of several choice of fit routines.
;CATEGORY:
;       Utility data visualization and analysis widget.
;SUPERCLASSES:
;       myproperties
;
;METHODS:
;    cwo_pickmethod
;    cwo_pickmethod_class::handleEvent
;    cwo_pickmethod_class_event_func
;    cwo_pickmethod_class::cleanup
;    cwo_pickmethod_class_cleanup
;    cwo_pickmethod_class::init
;    cwo_pickmethod_class__define
;
;
; AUTHOR:
; Larry Kneller
; NIST Center for Neutron Research
; 100 Bureau Drive, Gaithersburg, MD 20899
; United States
; kneller@nist.gov  301-975-8839
; Jan 24,2005
;
; LICENSE:
; The software in this file is written by an employee of
; National Institute of Standards and Technology
; as part of the DAVE software project.
;
; The DAVE software package is not subject to copyright protection
; and is in the public domain. It should be considered as an
; experimental neutron scattering data reduction, visualization, and
; analysis system. As such, the authors assume no responsibility
; whatsoever for its use, and make no guarantees, expressed or
; implied, about its quality, reliability, or any other
; characteristic. The use of certain trade names or commercial
; products does not imply any endorsement of a particular product,
; nor does it imply that the named product is necessarily the best
; product for the stated purpose. We would appreciate acknowledgment
; if the DAVE software is used of if the code in this file is
; included in another product.
;
;###############################################################################

;
;
;   title   cwo_pickmethod_class.pro
;
;   purpose AN INTERFACE FOR SELECTING THE METHOD OF FITTING
;           THE NSE DATA AT VARIOUS FOURIER TIMES.
;
;           IDEALLY THIS WILL BE GENERAL ENOUGH FOR OTHER USES.
;
;   author  Larry Kneller
;
;
;
;
;set_value will set the value of a 2 elements int array
;denoting the values in startfield and endfield
;

;;
;function cwo_pickmethod_class,parent,options,fieldnames,$
;                            obj_ref=obj_ref,$
;                            uvalue=uvalue,$
;                            frame = frame,$
;                            xsize=xsize,$
;                            ysize=ysize,$
;                            _Extra=extra
;;
;;NAME:
;;        cwo_pickmethod
;;
;;PURPOSE:
;;       Widget createion function.
;;PARAMETERS:
;;       parent      id of parent widget.
;;       options     array of names of fitting options.
;;       fieldnames  array fo names of fields.
;;
;;KEYWORDS:
;;       obj_ref[out]    The object reference for this cwo.
;;       uvalue          uvalue of the cwo.
;;       frame           width of the cwo's frame.
;;_EXTRA -   Is used to pass keywords meant for the superclass.
;;           It is also a catch-all for the keywords as the program develops.
;;RETURN VALUE:
;;           id  ID of the cwo's tlb.
;;
;
;    ;FUNCTION TO RETURN THE BASE ID FROM THE OBJECT
;    o = obj_new('cwo_pickmethod_class',parent, $
;                                options,$
;                                fieldnames,$
;                                title=title,$
;                                uvalue=uvalue,$
;                                xsize=xsize,$
;                                ysize=ysize,$
;                                frame=frame)
;
;    obj_ref=o   ;SETS VALUE OF obj_ref IN FUNCTION CALL
;                ;TO ALLOW USER OF PROGRAM ACCESS TO THE
;                ;OBJECT REFERENCE.
;
;
;    ;print,'FINISHED SETTING PROPERTIES.'
;
;    id = o->getProperty(/tlb)
;    ;print,'CHECKING VALUE OF tlb'
;
;    return,id
;
;end;cwo_pickmethod
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;function cwo_pickmethod_get_value,id,value=value
;    ;THE get_value FUNCTION IS NOT REALLY USED HERE,
;    ;BUT I INCLUDE IT FOR MY OWN EDUCATION.
;
;    print,id
;    widget_control,widget_info(id,/child),get_uvalue=self
;    value = self->getProperty(/)
;
;    ;value = (*pstate).value
;    return,value
;end;cwo_pickmethod_get_value
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
function cwo_pickmethod_class::handleEvent,event
;
;NAME:
;        cwo_pickmethod_class::handleEvent
;
;PURPOSE:
;       Event handler for the cwo.
;PARAMETERS:
;       event   event produced in the cwo.
;KEYWORDS:
;       none.
;RETURN VALUE:
;       newevent    event returned to event function with more info.
    print,'EVENT CAME TO cwo_pickmethod_class::handleEvent'






;NEEDED TO ELIMINATE THESE TWO cw_field WIDGETS DUE
;TO LIMITED SPACE ON X11 DISPLAYS.

;    widget_control,self.startfield,get_value=startv
;    startval = fix(startv)
;    widget_control,self.endfield,get_value=endv
;    endval = fix(endv)


    startval = self.startval
    endval = self.endval

    fit = 0
    option = ''

    ;GET CURRENT FIT TYPE SELECTION
;    widget_control,self.combo,get_value = fittype
;    widget_control,self.combo,get_index = fittype


;CHANGE FOR REPLACEMENT OF COMBOBOX WITH button,/menu
;    sfittype = widget_info(self.combo,/combobox_gettext)
;    option = sfittype
    if widget_info(event.id,/parent) eq self->getproperty(/combo) then begin
        widget_control,event.id,get_value=sfittype
        option = sfittype
        event.id = self->getproperty(/combo)
        print,tag_names(event)
        print,event
    endif;combo


    fittype = 0
    widget_control,self.combo,get_value=comboval

    for i=0,n_elements(*self.options)-1 do begin
        if strpos(comboval,(*(self.options))[i]) ne -1 then fittype = i
        ;if sfittype eq (*self.options)[i] then fittype = i
    endfor;i
    print,'fittype=',fittype

    option = (*(self.options))[fittype]

    case event.id of
    self.combo:begin

        ;print,'COMBO EVENT, INDEX=',event.index
        thefittype = where(*self.options eq sfittype)
        fittype = thefittype[0]
        option = (*(self.options))[fittype]
        print,'self.combo fittype=',fittype

        ;fittype = event.index
        fit = 0

        widget_control,self.combo,set_value=option+' >'



    end;combo
    self.startfield:begin
        widget_control,self.startfield,get_value=val
        print,'STARTFIELD EVENT, VALUE=',val
        fit = 0
    end;startfield
    self.endfield:begin
        widget_control,self.endfield,get_value=val
        print,'ENDFIELD EVENT, VALUE=',val
        fit = 0
    end;endfield
    self.fitbut:begin
        print,'FITBUT EVENT'
        fit = 1
    end;fitbut
    self.tlb:begin
        print,'TLB EVENT'
        fit = 0
    end;tlb
    else:begin
        print,'EVENT OF UNKNOWN ORIGIN:',tag_names(event,/structure)
        fit = 0
    end;else
    endcase


    print,'newevent fittype=',fittype
    newevent = {cwo_pickmethod_event,$
                    id:event.handler,$
                    top:event.top,$
                    handler:event.handler,$
                    fittype:fittype,$
                    option:option,$
                    fit:fit,$
                    values:[startval,endval]}

    return,newevent
end;handleEvent
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
function cwo_pickmethod_event_func,event
;
;NAME:
;        cwo_pickmethod_event_func
;
;PURPOSE:
;       Catch events and pass them to the object's event handling method.
;PARAMETERS:
;       event   the event.
;KEYWORDS:
;       none
;RETURN VALUE:
;       Return event up hierarchy.
    print,'EVENT CAME TO cwo_pickmethod_event_func'


    wid = widget_info(event.handler,/child)
    widget_control,wid,get_uvalue=obj

    newevent = obj->handleEvent(event)

    return,newevent
end;cwo_pickmethod_event
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro cwo_pickmethod_class::cleanup,dum
;
;NAME:
;        cwo_pickmethod_class::cleanup
;
;PURPOSE:
;       Cleanup method for cwo_pickmethod_class object.
;PARAMETERS:
;       dum     WIDGET ID???
;KEYWORDS:
;       none

    help,dum
    print,'CLEANING UP cwo_pickmethod_class'

    if ptr_valid(self.options) gt 0 then  ptr_free,self.options

end;
pro cwo_pickmethod_cleanup,id
;
;NAME:
;        cwo_pickmethod_cleanup
;
;PURPOSE:
;       Cleanup method for the compound widget.
;PARAMETERS:
;       id  ID of widget.
;KEYWORDS:
;       none
;_EXTRA - is used to pass keywords meant for the superclass.


    print,'ARRIVED AT cwo_pickmethod_cleanup'
    widget_control,id,get_uvalue=obj
    obj_destroy,obj
end;cwo_pickmethod_cleanup



;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
function cwo_pickmethod_class::init,parent, $
                                options,$
                                fieldnames,$
                                fieldvalues=fieldvalues,$
                                title=title,$
                                uvalue=uvalue,$
                                xsize=xsize,$
                                ysize=ysize,$
                                frame=frame
;
;NAME:
;        cwo_pickmethod_class::init
;
;PURPOSE:
;       init method for cwo_pickmethod_class.
;PARAMETERS:
;           parent          cwo's parent widget id
;           options         Fitting options in the dropdown widget.
;           fieldnames      names of the fields in the widget.
;KEYWORDS:
;            fieldvalues    Values in fields.
;            title          cw title.
;            uvalue         uvalue
;            xsize          xsize of cwo
;            ysize          ysize of cwo
;            frame          frame width of cwo
;
;RETURN VALUE:
;            1 for success, 0 for failure.
;
    ;
    ;'options' is a string array
    ;'fieldnames' is a string array
    ;
    ;


    ;NEED TO UPDATE THIS TO BE SMALLER DUE TO LARGER WIDGET DISPLAY
    ;IN X11 DISPLAYS.



    if n_elements(fieldnames) eq 0 then fieldnames = ['t_beg','t_end']
    if n_elements(options) eq 0 then options = ['arc','spiral','Larry']
    if n_elements(fieldvalues) ne 2 then fieldvalues = [0,0]
    self.startfield = fieldvalues[0]
    self.endfield = fieldvalues[1]

    if n_elements(title) ne 1 then title = ' Method ';'SELECT FIT METHOD'
    if n_elements(xsize) eq 0 then $
        geom = widget_info(parent,/geometry) & xsize = geom.xsize
    if n_elements(ysize) eq 0 then $
        ysize = 20;100

    ysize=25
    buttonysize = ysize

    ;print,'cwo_pickmethod_class::init frame=',frame
;    self.tlb = widget_base(parent,xsize=xsize,ysize=ysize,/col,$
    self.tlb = widget_base(parent,xsize=xsize,ysize=ysize,/row,$
                        event_func='cwo_pickmethod_event_func',$
                        $;func_get_value='cwo_pickmethod_get_value',$
                        $;pro_set_value='cwo_pickmethod_set_value',$
                        uvalue=uvalue,frame=frame)

    void = widget_label(self.tlb,value=title,$
                                uvalue = self,$
                                xsize=xsize,$;,ysize=ysize/5,$
                                kill_notify='cwo_pickmethod_cleanup')


;    listbase = widget_base(self.tlb,/row,xsize=xsize,$   ;JUST ONE FOR NOW
;                            ysize=ysize/3)


    ;NEED TO UPDATE THIS TO BE SMALLER DUE TO LARGER WIDGET DISPLAY
    ;IN X11 DISPLAYS.


;;;;;    self.combo = widget_combobox(listbase,$  ;JUST ONE FOR NOW
;;;;;                            value=options,$
;;;;;                            uvalue=self)
;;;;;    self.startfield = cw_field(listbase,title = fieldnames[0],/row,$
;;;;;                            value = strtrim(string(self.startfield),2),$
;;;;;                            uvalue=self,xsize=5,/return_events,/noedit)
;;;;;    self.endfield = cw_field(listbase,title = fieldnames[1],/row,$
;;;;;                            value = strtrim(string(self.endfield),2),$
;;;;;                            uvalue=self,xsize=5,/return_events,/noedit)
;;;;;    self.fitbut = widget_button(self.tlb,value='Fit',$
;;;;;                            tooltip = 'Fit all echoes using selected method.',$
;;;;;                            xsize=xsize,ysize=ysize/5)

;    self.combo = widget_combobox(self.tlb,$  ;JUST ONE FOR NOW
;                            value=options,$
;                            uvalue=self)


    self.combo = widget_button(self.tlb,$  ;JUST ONE FOR NOW
                            value=options[0]+' >',$
                            uvalue=self,/menu,xsize=100,ysize=buttonysize)
    for i=0,n_elements(options)-1 do begin
        but = widget_button(self.combo,value=options[i],uvalue=self,xsize=100,ysize=buttonysize)
    endfor;i


    self.fitbut = widget_button(self.tlb,value='Fit',$
                            tooltip = 'Fit all echoes using selected method.',$
                            xsize=50,ysize=buttonysize);xsize=xsize/2);,ysize=ysize/5)

    if ptr_valid(self.options) gt 0 then ptr_free,options
    self.options = ptr_new(options)

    return,1
end;init
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro cwo_pickmethod_class__define,struct
;
;NAME:
;        cwo_pickmethod_class__define
;
;PURPOSE:
;           Class definition.
;PARAMETERS:
;           struct  Pass the structure so the class tags are available for myproperties.
;KEYWORDS:
;           none


    struct = {cwo_pickmethod_class,$
                inherits myproperties,$
                combo:0L,$          ;DROPLIST WIDGET FOR METHOD SELECTION - JUST ONE FOR NOW
                startfield:0L,$     ;CW_FIELD FOR STARTING FOURIER TIME
                endfield:0L,$       ;CW_FIELD FOR ENDING FOURIER TIME
                fitbut:0L,$         ;BUTTON TO START fitall
                startval:0,$
                endval:0,$
                tlb:0L,$
                options:ptr_new() $
                }
end;cwo_pickmethod_class



;
function cwo_pickmethod,parent,options,fieldnames,$
                            obj_ref=obj_ref,$
                            uvalue=uvalue,$
                            frame = frame,$
                            xsize=xsize,$
                            ysize=ysize,$
                            _Extra=extra
;
;NAME:
;        cwo_pickmethod
;
;PURPOSE:
;       Widget createion function.
;PARAMETERS:
;       parent      id of parent widget.
;       options     array of names of fitting options.
;       fieldnames  array fo names of fields.
;
;KEYWORDS:
;       obj_ref[out]    The object reference for this cwo.
;       uvalue          uvalue of the cwo.
;       frame           width of the cwo's frame.
;_EXTRA -   Is used to pass keywords meant for the superclass.
;           It is also a catch-all for the keywords as the program develops.
;RETURN VALUE:
;           id  ID of the cwo's tlb.
;

    ;FUNCTION TO RETURN THE BASE ID FROM THE OBJECT
    o = obj_new('cwo_pickmethod_class',parent, $
                                options,$
                                fieldnames,$
                                title=title,$
                                uvalue=uvalue,$
                                xsize=xsize,$
                                ysize=ysize,$
                                frame=frame)

    obj_ref=o   ;SETS VALUE OF obj_ref IN FUNCTION CALL
                ;TO ALLOW USER OF PROGRAM ACCESS TO THE
                ;OBJECT REFERENCE.


    ;print,'FINISHED SETTING PROPERTIES.'

    id = o->getProperty(/tlb)
    ;print,'CHECKING VALUE OF tlb'

    return,id

end;cwo_pickmethod
