; $Id$
;###############################################################################
;
;FILENAME:
;           chirpfun.pro
;
;PURPOSE:
;
;CATEGORY:
;
;
;METHODS IN FILE:
;
;    chirpFun
;
;
; AUTHOR:
; Larry Kneller
; NIST Center for Neutron Research
; 100 Bureau Drive, Gaithersburg, MD 20899
; United States
; kneller@nist.gov  301-975-8839
; Jan 24,2005
;
; LICENSE:
; The software in this file is written by an employee of
; National Institute of Standards and Technology
; as part of the DAVE software project.
;
; The DAVE software package is not subject to copyright protection
; and is in the public domain. It should be considered as an
; experimental neutron scattering data reduction, visualization, and
; analysis system. As such, the authors assume no responsibility
; whatsoever for its use, and make no guarantees, expressed or
; implied, about its quality, reliability, or any other
; characteristic. The use of certain trade names or commercial
; products does not imply any endorsement of a particular product,
; nor does it imply that the named product is necessarily the best
; product for the stated purpose. We would appreciate acknowledgment
; if the DAVE software is used of if the code in this file is
; included in another product.
;
;###############################################################################
function chirpFun,X,P
;
;NAME:
;        chirpFun
;
;PURPOSE:
;        THIS IS THE echo FUNCTION USED IN SPIN-ECHO DATA REDUCTION.
;
;PARAMETERS:
;       X[in]: THE DATA VALUES
;       P[in]: THE PARAMETER VALUES.
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.

;RETURN VALUE:
;       AN ARRAY OF VALUES OF THE FUNCTION AT EACH OF THE X VALUES.
;
;
    ;NEED THIS DEFINITION TO SATISFY EXECUTE STATEMENT IN mpfitfun
;    return,P[0] - $
;            P[1]*exp(-1.0*((X-P[2]-P[5])/(2.0*P[3]))^2)*$
;            cos(P[4]*(!PI/180.0)*(X - P[2]-P[5]))
    return,P[0] - $
            P[1]*exp(-1.0*((X-P[2]-P[5])/(sqrt(2.0)*P[3]))^2)*$
            cos(P[4]*(!PI/180.0)*(X - P[2]-P[5]))
end
