; $Id$
;###############################################################################
;
;FILENAME:
;launch_nsediffractionviewer.pro
;
;PURPOSE:
;           Launch NSEdiffractionviewer from DAVE.
;CATEGORY:
;
;
;METHODS IN FILE:
;
;    launch_nsediffractionviewer
;
;
; AUTHOR:
; Larry Kneller
; NIST Center for Neutron Research
; 100 Bureau Drive, Gaithersburg, MD 20899
; United States
; kneller@nist.gov  301-975-8839
; Jan 30,2006
;
; LICENSE:
; The software in this file is written by an employee of
; National Institute of Standards and Technology
; as part of the DAVE software project.
;
; The DAVE software package is not subject to copyright protection
; and is in the public domain. It should be considered as an
; experimental neutron scattering data reduction, visualization, and
; analysis system. As such, the authors assume no responsibility
; whatsoever for its use, and make no guarantees, expressed or
; implied, about its quality, reliability, or any other
; characteristic. The use of certain trade names or commercial
; products does not imply any endorsement of a particular product,
; nor does it imply that the named product is necessarily the best
; product for the stated purpose. We would appreciate acknowledgment
; if the DAVE software is used of if the code in this file is
; included in another product.
;
;###############################################################################
;
pro launch_nsediffractionviewer,event,$
                 group_leader=group_leader,$
                 workDir=workDir,$
                 dataDir=dataDir,$
                 DAVETool=DAVETool,$
                 _Extra=extra
;
;NAME:
;        launch_nsediffractionviewer
;
;PURPOSE:
;           Launch NSEdiffractionviewer from DAVE.
;PARAMETERS:
;           event   Event to launch the module.
;KEYWORDS:
;           None.



    ; Launching program for the NSE data reduction module.

    if n_elements(event) eq 0 then begin
        NSEDiffractionViewer,group_leader=group_leader,workdir=workdir,datadir=datadir
        
    endif else begin
        this_event = tag_names(event,/structure_name)

        case this_event of
        'WIDGET_BUTTON': $
            begin
                workdir = (*!dave_defaults).workDir
                datadir = (*!dave_defaults).datDir
                device,decomposed = 0
                NSEDiffractionViewer,group_leader=event.top,workdir=workdir,datadir=datadir
            end
        'WIDGET_TREE_SEL': $
            begin
                workdir = (*!dave_defaults).workDir
                datadir = (*!dave_defaults).datDir
                NSEDiffractionViewer,group_leader=event.top,workdir=workdir,datadir=datadir
            end
        'NSE_EVENT': $
            begin
                NSEDiffractionViewer,group_leader=event.top
            end
        else:
        endcase
    endelse

end;launch_nsediffractionviewer


