; NAME:
;       MUR
;PD Dr. Philip Tregenna-Piggott,
;Laboratory for Neutron Scattering,
;ETHZ and Paul-Scherrer Institute,
;CH-5232 Villigen PSI,
;Switzerland.
;
;Tel. :+41 56 310 54 05
;Fax. :+41 56 310 29 39
;Email:philip.tregenna@psi.ch
;
;
; CATEGORY:
;
;       MARS Tools
;
; CALLING SEQUENCE:
;
;      MarsUserRegistration
;
;
; INPUT FIELDS:
;
;
; EXAMPLES FOR POTENTIALS (must use IDL syntax as shown below):
;
;
; DISCLAIMER
;
;     This software is provided as is without any warranty whatsoever.
;     Permission to use, copy, modify, and distribute modified or
;     unmodified copies is granted, provided this disclaimer
;     is included unchanged.
;
; MODIFICATION HISTORY:
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;get sics functions and procedures
@idlsics
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro mur_cleanup,tlb
widget_control,tlb,get_uvalue = pState_mur
wdelete,(*pState_mur).winPix_mesot
wdelete,(*pState_mur).winpix_IR
device, decomposed = (*pState_mur).old_dc
if (*pState_mur).connect_status eq 1 then begin
sicsclose,(*pState_mur).UnitUser
endif
heap_free,pState_mur
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro mur_exit,event
widget_control,event.top,get_uvalue = pState_mur
widget_control,event.top,/destroy
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro IR_droplist,event
widget_control,event.top,get_uvalue = pState_mur
picture_index=widget_info((*pState_mur).IRdroplist,/droplist_select)
image=(*pState_mur).struct_jpeg.(picture_index)
tvimage,Image
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro mur_connect,event
widget_control,event.top,get_uvalue = pState_mur
widget_control,(*pState_mur).connect_button,sensitive = 0
delim=(*pState_mur).delim
get_lun,UnitUser
(*pState_mur).UnitUser=UnitUser
filename=!DAVE_AUXILIARY_DIR+'PSI'+delim+'MARS'+delim+'MarsSICSInfo_User.txt'
hoststring=''
portstring=''
userstring=''
passwordstring=''
openr,lun,filename,/get_lun
readf,lun,hoststring
readf,lun,portstring
readf,lun,userstring
readf,lun,passwordstring
free_lun,lun,/force
;
equalsign=strpos(hoststring,'=')
host=strmid(hoststring,equalsign+1)
equalsign=strpos(portstring,'=')
port=strmid(portstring,equalsign+1)
port=long(port)
equalsign=strpos(userstring,'=')
user=strmid(userstring,equalsign+1)
equalsign=strpos(passwordstring,'=')
password=strmid(passwordstring,equalsign+1)
;
;
response=sicsconnect(UnitUser,host,port,error=error)
;print,'response = ',response
;print,'error = ',error
;help,response
    IF response eq 0 then begin
print,'Connection Successful'
(*pState_mur).connect_status=1
logon=sicslogon(UnitUser,user,password)
;print,'woofb'
;print,logon
if logon eq 0 then begin
void = dialog_message(dialog_parent = event.top,/error, $
'SICS User login is incorrect. Please inspect and edit the file ' +  $
'in the Dave auxillary directory.')
(*pState_mur).connect_status=0
widget_control,(*pState_mur).connect_button,sensitive = 1
return
endif
    ENDIF ELSE BEGIN
    void = dialog_message(dialog_parent = event.top,/information, $
    'Connection to MARS not found.')
(*pState_mur).connect_status=0
widget_control,(*pState_mur).connect_button,sensitive = 1
return
    ENDELSE
widget_control,(*pState_mur).connect_button,sensitive = 1
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro mur_send,event
widget_control,event.top,get_uvalue = pState_mur
if (*pState_mur).connect_status eq 0 then begin
    void = dialog_message(dialog_parent = event.top,/error, $
    'Connect to instrument first.')
return
endif
widget_control,(*pState_mur).send_button,sensitive = 0
UnitUser=(*pState_mur).UnitUser
response=strarr(6)
widget_control,(*pState_mur).title,get_value = title
command='title '+strtrim(string(title),2)
response[0]=sicsexecute(event,UnitUser,command)
widget_control,(*pState_mur).name,get_value = name
command='user '+strtrim(string(name),2)
response[1]=sicsexecute(event,UnitUser,command)
widget_control,(*pState_mur).email,get_value = email
command='email '+strtrim(string(email),2)
response[2]=sicsexecute(event,UnitUser,command)
widget_control,(*pState_mur).address,get_value = address
command='address '+strtrim(string(address),2)
response[3]=sicsexecute(event,UnitUser,command)
widget_control,(*pState_mur).phone,get_value = phone
command='phone '+strtrim(string(phone),2)
response[4]=sicsexecute(event,UnitUser,command)
index=widget_info((*pState_mur).IRdroplist,/droplist_select)
InstrumentResponsible=(*pState_mur).IR_NAME[index]
command='InstrumentResponsible '+InstrumentResponsible
response[5]=sicsexecute(event,UnitUser,command)
;
WhereError=where(strpos(strlowcase(response),'ok') eq -1,count)
if count eq 0 then begin
    void = dialog_message(dialog_parent = event.top,/information, $
    'The data transmission has been successful.')
endif else begin
msg=strarr(2+count)
msg[0]='The data transmission has not been successful.'
msg[1]='The error messages from SICS are as follows:'
for i = 0,count-1 do begin
msg[2+i]=response[WhereError[i]]
endfor
    void = dialog_message(dialog_parent = event.top,/error, msg)
endelse
widget_control,(*pState_mur).send_button,sensitive = 1
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro mur_events,event
widget_control,event.top,get_uvalue = pState_mur
uname=widget_info(event.id,/uname)
case uname of
'quit':    $
begin
mur_exit,event
end
'IRdroplist':    $
begin
IR_droplist,event
end
'connect':    $
begin
mur_connect,event
end
'send':    $
begin
mur_send,event
end
else:
endcase
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro MUR, group_leader=group_leader, workDir=workDir, dataDir=dataDir, $
         DAVETool=oDAVETool, _EXTRA=extra

;print,'Register Name =',register_name
;;;;;;;added following 4 lines for non-modal widget action
if n_elements(group_leader) eq 0 then group_leader = 0L
if n_elements(notify_ids) eq 0 then notify_ids = [0L,0L]
if n_elements(register_name) eq 0 then register_name = 'MARS_User_Registration'
if xregistered(register_name) then return
if n_elements(workDir) eq 0 then begin
workDir='C:\Documents and Settings\tregenna\My Documents\temp\dave\Working Data Directory\'
endif
device, get_decomposed = old_dc
device,decomposed = 0
delim=path_sep()
read_jpeg,!DAVE_AUXILIARY_DIR+'PSI'+delim+'MARS'+delim+'mesot_pic.jpg',mesot_pic
image=mesot_pic

filename=!DAVE_AUXILIARY_DIR+'PSI'+delim+'MARS'+delim+'RadiationProtectionHomePage.txt'

SafetyVideo=''
openr,lun,filename,/get_lun
readf,lun,SafetyVideo
free_lun,lun,/force

filename=!DAVE_AUXILIARY_DIR+'PSI'+delim+'MARS'+delim+'InstrumentResponsibles.txt'
line=''

openr,lun,filename,/get_lun
while eof(lun) eq 0 do begin
readf,lun,line
IR=strtrim(strsplit(line,',',/extract),2)
if n_elements(IR_NAME) eq 0 then begin
IR_NAME=IR[0]
IR_PIC=IR[1]
endif else begin
IR_NAME=[IR_NAME,IR[0]]
IR_PIC=[IR_PIC,IR[1]]
endelse
;print,IR[0]
;print,IR[1]
;print,''
endwhile
free_lun,lun,/force

for i = 0, n_elements(IR_PIC) - 1 do begin
name=IDL_VALIDNAME(IR_PIC[i],/CONVERT_ALL)
read_jpeg,!DAVE_AUXILIARY_DIR+'PSI'+delim+'MARS'+delim+IR_PIC[i],woof
if i eq 0 then begin
struct_jpeg=create_struct(name,woof)
endif else begin
struct_jpeg=create_struct(struct_jpeg,name,woof)
endelse
endfor

;print,tag_names(struct_jpeg)


tlb = widget_base(group_leader = group_leader,/col,title = 'MARS User Registration')

Baseupper=widget_base(tlb,/row)


    s = size(image)
    sx = s[2] & sy = s[3]
aspect = 1.0*sy/sx              ; find the aspect ratio of the image...

picxsize = 67 & picysize = fix(aspect*picxsize)

picbase = widget_base(Baseupper,xsize = picxsize,ysize = picysize)

picwin = widget_draw(picbase,xsize = picxsize,ysize = picysize)
    dispimage = image

msg=strarr(5)
msg[0]='Welcome to MARS, the flagship instrument of the Swiss spallation neutron source (SINQ).'
msg[1]='To facilitate the successful execution of your experiment, please complete this'
msg[2]='user registation form.  If you are new to the SINQ facility then please view the
msg[3]='radiation protection video under the following link:'
msg[4]=SafetyVideo


message_base=widget_base(Baseupper)
if !version.os_family eq 'Windows' then begin
void = widget_text(message_base,value = msg,xsize = 70,ysize=5)
endif else begin
void = widget_text(message_base,value = msg,xsize = strlen(msg[0]),ysize=5)
endelse
;base2=widget_base(Baseupper,/col)
;total_runs=cw_field(Base2,/col,title='Total Number of Runs',value='',xsize=10,/noedit)
;current_run=cw_field(Base2,/col,title='Current Run',value='',xsize=10,/noedit)

;base3=widget_base(Baseupper,/col)

;current_abscissa=cw_field(Base3,/col,title='Current Value of Abscissa',value='',xsize=10,/noedit)
;current_ordinate=cw_field(Base3,/col,title='Current Value of Ordinate',value='',xsize=10,/noedit)



;base4=widget_base(Baseupper,/col)
;StartTime=systime()
;void=cw_field(Base4,/col,title='Calibration Run Commenced at:',value=StartTime,xsize=15,/noedit)
;Completion_Time=cw_field(Base4,/col,title='Estimated Time of Completion:',value='',xsize=15,/noedit)

Baselower=widget_base(tlb,/col,/align_center)

title=cw_field(Baselower,/col,title='Experiment Title',value='',xsize=80)
name=cw_field(Baselower,/col,title='User''s Name',value='',xsize=80)
email=cw_field(Baselower,/col,title='User''s Email Address',value='',xsize=80)
address=cw_field(Baselower,/col,title='User''s Street Address',value='',xsize=80)
phone=cw_field(Baselower,/col,title='User''s Phone Number',value='',xsize=80)
BaselowerA=widget_base(Baselower,/row)
BaselowerB=widget_base(BaselowerA,/col)

void=widget_label(BaselowerB,value='Instrument Responsible')
IRdroplist=widget_Droplist(BaselowerB,value=IR_NAME, $
              /dynamic_resize,uname='IRdroplist' )

image=struct_jpeg.(0)

    s = size(image)
    sx = s[2] & sy = s[3]
aspect = 1.0*sy/sx              ; find the aspect ratio of the image...

IRpicxsize = 50 & IRpicysize = fix(aspect*IRpicxsize)

IRpicbase = widget_base(BaselowerA,xsize = IRpicxsize,ysize = IRpicysize)

IRpicwin = widget_draw(IRpicbase,xsize = IRpicxsize,ysize = IRpicysize)
    IRdispimage = image

connect_button = widget_button(BaselowerA,value = 'Connect to Instrument', $
    uname='connect')

send_button = widget_button(BaselowerA,value = 'Send Data to Instrument', $
    uname='send')


;Interrupt_nicely = widget_button(Baselower,value = 'Interrupt after completion of current run', $
;    uname='Interrupt_nicely')

void = widget_button(BaselowerA,value = ' Quit ', $
    uname='quit')

centertlb,tlb

widget_control,tlb,/realize

widget_control,picwin,get_value = picVis
window,/free,/pixmap,xsize = picxsize,ysize = picysize
winpix_mesot = !d.window
wset,winpix_mesot
tvimage,dispImage
wset,picVis
device,copy = [0,0,!d.x_size,!d.y_size,0,0,winpix_mesot]
;
widget_control,IRpicwin,get_value = IRpicvIS
window,/free,/pixmap,xsize = IRpicxsize,ysize = IRpicysize
winpix_IR = !d.window
wset,winpix_IR
tvimage,IRdispImage
wset,IRpicvIS
device,copy = [0,0,!d.x_size,!d.y_size,0,0,winpix_IR]


state_mur={winpix_mesot:winpix_mesot, $
       winpix_IR:winpix_IR, $
       old_dc:old_dc, $
       IRdroplist:IRdroplist, $
       connect_button:connect_button, $
       send_button:send_button, $
       delim:delim, $
       UnitUser:0, $
       connect_status:0B, $
       IR_NAME:IR_NAME, $
       title:title, $
       name:name, $
       email:email, $
       address:address, $
       phone:phone, $
       struct_jpeg:struct_jpeg $
       }

pState_mur = ptr_new(state_mur,/no_copy)
widget_control,tlb,set_uvalue = pState_mur
xmanager, register_name,tlb,event_handler = 'mur_events',cleanup= 'mur_cleanup' ;register with the xmanager
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;