; $Id$
;
;--------------------------------------------------------------------------------------------------------
; This function takes data as an array input whose columns are specified by the vector columns
; The devices which are compared for concatenation are specified by the vector devs
; 
; Input :
;     data    : data array to be concatenated
;     devs    : devices to be compared for concatenation
;     columns : data array columns
;     
; Output :
;     data    : concatenated data array
;     
; Written by : Vivek Thampy (01/05/2010)     
;--------------------------------------------------------------------------------------------------------
function vMACS_concat_data, data, devs, columns, bin_size=bin_size 

   n_data  = n_elements(data[0,*])
   n_devs  = n_elements(devs)
   dev_ran = fltarr(n_devs,2)
   dev_col = intarr(n_devs)
   n_dets  = n_elements(where(strmid(columns,0,4) eq 'SPEC'))
   
   ;-----------------------------------------------------------------------------------------------------
   ; Similar to bkg_sub routine. Binsize and ranges for devices calculated
   ; Index the data on the devices (dev_inds).
   ; The n-dimensional indices (for n devices) are converted into 1-dimensional indices (inds)
   ;-----------------------------------------------------------------------------------------------------
   if n_elements(bin_size) ne n_devs then bin_size = fltarr(n_devs) else bin_size=float(bin_size)
   for i = 0, n_devs-1 do begin
      dev_col[i]   = where(columns eq strupcase(devs[i]))
      if (bin_size[i] eq 0) then bin_size[i]   = vMACS_calcbinsize(data[dev_col[i],*])
      dev_ran[i,0] = [[min(data[dev_col[i],*]) - bin_size[i]/2], [max(data[dev_col[i],*]) + bin_size[i]/2]]  
   end 
   
   dev_inds  = long(fix((data[dev_col,*] - rebin(dev_ran[*,0], n_devs, n_data))/rebin(reform(bin_size), n_devs, n_data)))
   dev_bins  = round((dev_ran[*,1] - dev_ran[*,0])/bin_size)
   
   inds      = dev_inds[0,*]
   for j = 1, n_devs-1 do inds += dev_inds[j,*] * vMACS_cmproduct(dev_bins[0:j-1])
   
   ;-----------------------------------------------------------------------------------------------------
   ; Histogram the indices to bin together data with the same indices, i.e. have the same values of devs.
   ; Sum all the data points that lie within the same bin into first element of bin. Return first element
   ; of all occupied bins. 
   ;-----------------------------------------------------------------------------------------------------
   sortinds = vmacs_bsort(inds)
   inds = inds[sortinds]  &  data = data[*, sortinds]
   uniqinds = uniq(inds)  &  uniqinds = [0, uniqinds]

   if n_elements(uniqinds)-1 eq n_elements(inds) then return, data
   
   for i = 0, n_elements(uniqinds)-2 do begin
      if i eq 0 then begin
         j = 0 & returninds = 0 
      endif else begin $
         j = 1 & returninds = [returninds, uniqinds[i]+j]
      endelse
      if uniqinds[i+1] - (uniqinds[i]+j) lt 1 then continue
      data[0, uniqinds[i]+j] = total(data[0, uniqinds[i]+j : uniqinds[i+1]])
      data[1:n_dets, uniqinds[i]+j] = total(data[1:n_dets, uniqinds[i]+j : uniqinds[i+1]], 2)
      data[n_dets+1:2*n_dets, uniqinds[i]+j] = sqrt(data[1:n_dets, uniqinds[i]+j])
   endfor
   
   return, data[*, returninds]

end;vMACS_concat_data
