; $Id$


pro MACSScanProject::setName,name

  
  duh = self->getData(data)
  ;help,data,/str
  data.name = name

  duh = self->setData(data)


end;MACSScanProject::setName

function MACSScanProject::getName

  duh = self->getData(data)
  ;help,data,/str
  name = data.name
  return,name

end;MACSScanProject::getName

function MACSScanProject::init,name=name,$
                               diffweights=diffweights,specweights=specweights,$
                               diffMask=diffMask,specMask=specMask,$
                               lattice=lattice,orientation=orientation,$
                               _Extra=extra

  if n_elements(name) eq 0 then name = 'Project'
  if n_elements(diffWeights) eq 0 then diffWeights = 1.0+fltarr(20)
  if n_elements(specWeights) eq 0 then specWeights = 1.0+fltarr(20)
  if n_elements(diffMask) eq 0 then diffMask = intarr(20)
  if n_elements(specMask) eq 0 then specMask = intarr(20)
  if n_elements(orientation) ne 6 then orientation = [1.,0,0,0,1,0]
  if n_elements(lattice) ne 6 then lattice = [2*!PI,2*!PI,2*!PI,90.0,90.0,90.0]


  dataStr = {name:name,diffweights:diffweights,specWeights:specWeights,diffMask:diffMask,specMask:specMask,$
             lattice:lattice,orientation:orientation}

  ret = self->idlitdata::init(_Extra=extra)
  ret = self->idl_container::init()
  self.myname = name
  ret = self->setdata(dataStr);,'DATASTR')
  return,1
end;MACSScanProject::init

pro MACSScanProject__define,class

  class = {MACSScanProject,$
            inherits idlitdata,$
            inherits idl_container,$
            myname:''}

end;MACSScanProject__define




