; $Id$
;
;

function MACSScanManager_inputDialog,title=title,label=label,value=value,group_leader=group_leader,$
                                     xoffset=xoffset,yoffset=yoffset,_Extra=extra

        if n_elements(label) eq 0 then label = ''
        if n_elements(value) eq 0 then value = ''
        if n_elements(group_leader) eq 0 then group_leader = 0L
        if n_elements(title) eq 0 then title = 'Input:'
        
        myxoffset = 0
        myyoffset = 0
        if group_leader ne 0L then begin
          geom = widget_info(group_leader,/geom)
          myxoffset = geom.xoffset+geom.xsize/2
          myyoffset = geom.yoffset+geom.ysize/2
        endif
        
        if n_elements(xoffset) eq 0 then xoffset = myxoffset
        if n_elements(yoffset) eq 0 then yoffset = myyoffset
        
        newval = value

        tlb = widget_base(title=title,group_leader=group_leader,$
                          xoffset=xoffset,yoffset=yoffset,/col)

        
        field = cw_field(tlb,title=label,value=value,/row,xsize=40+(strlen(value) > strlen(title)))

        donebase = widget_base(tlb,/row)
        ok = widget_button(donebase,value='OK')
        cancel = widget_button(donebase,value='Cancel')

        widget_control,tlb,/realize
        event = {id:0L,top:0L,handler:0L}
        while event.id ne ok and event.id ne cancel do begin
          event = widget_event(tlb,/nowait)          
          widget_control,field,get_value=val
        endwhile  
        if event.id eq ok then newval = val
          
        ;IN CASE WINDOW WAS Xed OUT
        if widget_info(tlb,/valid) then begin
          widget_control,tlb,/destroy
        endif
        return,newval
end;MACSScanManager_inputDialog

