; $Id$

pro MACSScanManager_print2Printer,event

;    if n_elements(*self.dataPtr) eq 0 then return
    widget_control,event.handler,get_uvalue=pstate

    okay = dialog_printersetup(dialog_parent=(*pstate).tlb)
    if (~okay) then return

    keywords = PSWindow(/printer,fudge=0.25)
    if (keywords.yoffset gt keywords.ysize) then begin
        tmp = keywords.ysize
        keywords.ysize = keywords.yoffset
        keywords.yoffset = tmp
    endif

    ;RE-CREATE THE CURRENT IMAGES IN JPEG
    MACSScanManager_HandleQuickSlice,event,jpeg=jpeg

    ;SET THE PRINTER DEVICE AND PRINT 
    oldDevice = !D.name
    set_plot, 'PRINTER'
    device, _Extra=keywords

;REPLACE THE NEXT LINE WITH THE CODE NEEDED TO PRINT THE DATA WINDOWS
;    self->niceOutput,event = event, ps_out = 0
    tvimage,jpeg

    device, /close_document

    set_plot, oldDevice

    return
end;MACSScanManager_print2Printer

pro MACSScanManager_sortContainer,event,data=data,bkg=bkg,empty=empty,project=project,$
                                  sortedlist=sortedlist,order=order,_Extra=extra

  widget_control,event.handler,get_uvalue=pstate
 
  if n_elements(data) eq 0 then data = 0
  if n_elements(bkg) eq 0 then bkg= 0
  if n_elements(empty) eq 0 then empty = 0
  if n_elements(project) eq 0 then project = 0


  pc = (*pstate).projContainer
  dc = (*pstate).dataContainer
  bc = (*pstate).bkgContainer
  ec = (*pstate).emptyContainer
  
  if data ne 0 then c = dc
  if bkg ne 0 then c = bc
  if empty ne 0 then c = ec
  if project ne 0 then c = pc

  ;GET SORTING PARAMETER
  if c->count() eq 0 then begin
    return
  endif else begin

        if project ne 0 then begin
          list = strarr(c->count())
          for i=long64(0),c->count()-1L do begin
            list[i] = (c->get(position=i))->getName()
          endfor;i
          
        endif else begin
          list = strarr(c->count())
          for i=long64(0),c->count()-1L do begin
          
            (c->get(position=i))->getProperty,filename=filename
            list[i] = file_basename(filename)
          endfor;i
        endelse
        
        
        ;CREATE SORT ORDER ARRAY
        order = sort(list)
        sortedlist = list[order]
        
        ;COPY ALL INDICES TO AN obj_array
        oarr = objarr(c->count())
        for i=long64(0),c->count()-1L do begin
          oarr[i] = c->get(position=i)
        endfor;i

        
        ;REMOVE ALL OBJECTS FROM CONTAINER
        c->remove,/all
        
        
        ;PLACE OBJECTS INTO CONTAINER IN CORRECT ORDER 
        for i=long64(0),n_elements(oarr)-1L do begin
          c->add,oarr[order[i]],position=i
        endfor;i
      
      
  endelse

end;MACSScanManager_sortContainer

pro MACSScanManager_updateLatticeAndOrientation,event,fromproj=fromproj,fromwid=fromwid,fromdata=fromData,_Extra=extra
      if n_elements(fromproj) eq 0 then fromproj=0
      if n_elements(fromWid) eq 0 then fromWid=0
      if n_elements(fromData) eq 0 then fromData=0
      
      if fromProj eq 0 and fromWid eq 0 and fromdata eq 0 then fromproj = 0 ; i.e. do nothing.

      widget_control,event.handler,get_uvalue=pstate



      ;GATHER THE INFO:
      ow = (*pstate).orientations
      lw = (*pstate).lattice



      if (*pstate).projContainer->count() gt 0 then begin
        pc = (*pstate).projContainer->get(position=(*pstate).currentProj)
        duh = pc->getData(dataStr)
        latt = dataStr.lattice
        orie = dataStr.orientation

        

        ;NOW SYNCH UP DATA
        if fromdata eq 1 then begin
            
            dc = pc->get(position=0)
            if dc->count() gt 0 then begin
              fromWid = 1  ;SO INFO GETS TRANSFERRED TO PROJECT
              fromProj = 0
              mdo = dc->get(position=0)
              
              newlatt = mdo->pullTheData('LATTICE')
              neworie = mdo->pullTheData('ORIENTATION')

              for i=long64(0),n_elements(ow)-1L do begin
                widget_control,ow[i],set_value=strtrim(string(neworie[i]),2)
                widget_control,lw[i],set_value=strtrim(string(newlatt[i]),2)
              endfor;i
            endif else begin
              return
            endelse
        endif



        if fromProj eq 1 then begin
          
          for i=long64(0),n_elements(ow)-1L do begin
            widget_control,ow[i],set_value=orie[i]
            widget_control,lw[i],set_value=latt[i]
          endfor;i
        endif;fromProj eq 1
        if fromwid eq 1 then begin
          
          for i=long64(0),n_elements(ow)-1L do begin
            widget_control,ow[i],get_value=val7
            orie[i] = float(val7)
            widget_control,lw[i],get_value=val8
            latt[i] = float(val8)
          endfor;i        
          
          dataStr.orientation = orie
          dataStr.lattice = latt
          duh = pc->setData(dataStr)
            
        endif;fromWid eq 1

      endif;exista proiecta

end;MACSScanManager_updateLatticeAndOrientation

pro MACSScanManager_updateMaskAndWeights,event,fromproj=fromproj,fromwid=fromwid,_Extra=extra

      if n_elements(fromproj) eq 0 then fromproj=0
      if n_elements(fromWid) eq 0 then fromWid=0
      
      if fromProj eq 0 and fromWid eq 0 then fromproj = 1

      widget_control,event.handler,get_uvalue=pstate

      ;GATHER THE INFO:
      md1 = (*pstate).diffmaskgroup1
      md2 = (*pstate).diffmaskgroup2
      ms1 = (*pstate).specmaskgroup1
      ms2 = (*pstate).specmaskgroup2
      dw = (*pstate).diffWeights
      sw = (*pstate).specWeights
      ow = (*pstate).orientations
      lw = (*pstate).lattice

      if (*pstate).projContainer->count() gt 0 then begin
        pc = (*pstate).projContainer->get(position=(*pstate).currentProj)
        duh = pc->getData(dataStr)

        ;NOW SYNCH UP DATA
        if fromproj eq 1 then begin
          dwts = dataStr.diffweights
          swts = datastr.specWeights
          dmsk = datastr.diffmask
          smsk = dataStr.specmask
          latt = dataStr.lattice
          orie = dataStr.orientation
          
          widget_control,md1,set_value=dmsk[0:9]
          widget_control,md2,set_value=dmsk[10:19]
          widget_control,ms1,set_value=smsk[0:9]
          widget_control,ms2,set_value=smsk[10:19]
          for i=long64(0),n_elements(dw)-1L do begin
            widget_control,dw[i],set_value=strtrim(string(dwts[i]),2)
            widget_control,sw[i],set_value=strtrim(string(swts[i]),2)
          endfor;i
          for i=long64(0),n_elements(ow)-1L do begin
            widget_control,ow[i],set_value=strtrim(string(orie[i]),2)
            widget_control,lw[i],set_value=strtrim(string(latt[i]),2)
          endfor
        endif;fromProj eq 1

        if fromWid eq 1 then begin
          dwts = dataStr.diffweights
          swts = datastr.specWeights
          dmsk = datastr.diffmask
          smsk = dataStr.specmask
          latt = dataStr.lattice
          orie = dataStr.orientation
          
          ;NOTE: MASKED eq 1 MEANS SOMETHING DIFFERENT IN THE CHECKBOXES VS. IN macs_get_a12345_int
          widget_control,md1,get_value=val1
          dmsk[0:9] = val1
          widget_control,md2,get_value=val2
          dmsk[10:19] = val2
          widget_control,ms1,get_value=val3
          smsk[0:9] = val3
          widget_control,ms2,get_value=val4
          smsk[10:19] = val4
          for i=long64(0),n_elements(dw)-1L do begin
            widget_control,dw[i],get_value=val5
            dwts[i] = float(val5)
            widget_control,sw[i],get_value=val6
            swts[i] = float(val6)
          endfor;i        
          for i=long64(0),n_elements(ow)-1L do begin
            widget_control,ow[i],get_value=val7
            orie[i] = float(val7)
            widget_control,lw[i],get_value=val8
            latt[i] = float(val8)
          endfor;i        
          
          dataStr.diffweights = dwts
          datastr.specWeights = swts
          datastr.diffmask = dmsk
          dataStr.specmask = smsk
          dataStr.orientation = orie
          dataStr.lattice = latt
          duh = pc->setData(dataStr)
            
        endif;fromWid eq 1

      endif;exista proiecta


end;MACSScanManager_updateMaskAndWeights

pro MACSScanManager_updateList,event,emptydata=emptydata,data=data,bkg=bkg,all=all,prj=prj

      widget_control,event.handler,get_uvalue=pstate
      sel = widget_info((*pstate).projlist,/list_select)
      if n_elements(emptydata) eq 0 then emptydata=0
      if n_elements(data) eq 0 then data=0
      if n_elements(bkg) eq 0 then bkg=0
      if n_elements(all) eq 0 then all = 0
      if n_elements(prj) eq 0 then prj = 0
      
      if all eq 1 then begin
        emptydata=1
        data=1
        bkg=1
        prj=1
      endif 

      if emptydata eq 1 then begin
        c=(*pstate).emptycontainer
        list = (*pstate).emptylist
        s='No Data'
        fs = ''
        if obj_isa(c,'idl_container') then begin
          ;GET THE NAMES
          for i=long64(0),c->count()-1L do begin
            o=c->get(position=i)
            o->getProperty,filename=filename
            s = [s,file_basename(filename)]        
            fs = [fs,filename]
          endfor;i
          ;SORT THE NAMES AND PROJECTS
          if n_elements(s) gt 1 then begin  
            s=s[1:*]
            fs = fs[1:*]
            MACSScanManager_sortContainer,event,/empty,order=order,sortedlist=sortedlist
            if n_elements(sortedlist) eq 0 then begin
              sortedlist = 'No Data'
              fs = ''
              order = [0]
            endif
              s = sortedlist           
              fs = fs[order]
;              print,s
;              print,fs         
            endif
          endif
        widget_control,list,set_value=s,set_uvalue=fs
      endif
      if data eq 1 then begin
        c=(*pstate).datacontainer
        list=(*pstate).datalist
        s='No Data'
        fs = ''
        if obj_isa(c,'idl_container') then begin
          for i=long64(0),c->count()-1L do begin
            o=c->get(position=i)
            o->getProperty,filename=filename
            s = [s,file_basename(filename)]
            fs = [fs,filename]
          endfor;i
          if n_elements(s) gt 1 then s=s[1:*]
          if n_elements(fs) gt 1 then fs=fs[1:*]
          MACSScanManager_sortContainer,event,/data,order=order,sortedlist=sortedlist
          if n_elements(sortedlist) eq 0 then begin
            sortedlist = 'No Data'
            fs = ''
            order = [0]
          endif
          s = sortedlist           
          fs = fs[order]
;          print,s
;          print,fs         
        endif
        widget_control,list,set_value=s,set_uvalue=fs
      endif
      if bkg eq 1 then begin
        c=(*pstate).bkgcontainer
        list=(*pstate).bkglist
        s='No Data'
        fs = ''
        if obj_isa(c,'idl_container') then begin
          for i=long64(0),c->count()-1L do begin
            o=c->get(position=i)
            o->getProperty,filename=filename
            s = [s,file_basename(filename)]        
            fs = [fs,filename]        
          endfor;i
          if n_elements(s) gt 1 then begin  
            s=s[1:*]
            fs=fs[1:*]
            MACSScanManager_sortContainer,event,/bkg,order=order,sortedlist=sortedlist
            if n_elements(sortedlist) eq 0 then begin
              sortedlist = 'No Data'
              fs = ''
              order = [0]
            endif
            s = sortedlist           
            fs = fs[order]
;            print,s
;            print,fs         
          endif
        endif
        widget_control,list,set_value=s,set_uvalue=fs
      endif
      if prj eq 1 then begin
        c=(*pstate).projcontainer
        list=(*pstate).projlist
        s='No Projects'
        if obj_isa(c,'idl_container') then begin
          for i=long64(0),c->count()-1L do begin
            o=c->get(position=i)
            name = o->getname()
            s = [s,name]        
          endfor;i
          if n_elements(s) gt 1 then begin
            s=s[1:*]
            MACSScanManager_sortContainer,event,/project,order=order,sortedlist=sortedlist
            s = sortedlist
          endif
        endif
        widget_control,list,set_value=s,set_uvalue=s

        if (*pstate).currentProj ne -1 then widget_control,(*pstate).projlist,set_list_select=(*pstate).currentProj
      endif


end;MACSScanManager_updateList

function MACSScanManager_getExt,s,iext=iext,len=len
        if n_elements(s) eq 0 then return,''
        iext = strpos(s,'.',/reverse_search)

        if iext ne -1 then begin
            len  = strlen(s)
            ext  = strmid(s,iext+1,len-iext)
        endif else begin
            ext = ''
        endelse
        return,ext

end;MACSScanManager_getExt

pro MACSScanManager_addDotSav,ofn

        ext = MACSScanManager_getExt(ofn,iext=iext,len=len)
        if ext ne 'sav' then begin
            if iext gt 0 then begin
                sublen=len-iext
                ofn = strendsub(ofn,'sav',sublen)
            endif else begin
                ofn = ofn+'.sav'
            endelse
        endif

end;MACSScanManager_addDotSav
pro MACSScanManager_addDotJPG,ofn

        ext = MACSScanManager_getExt(ofn,iext=iext,len=len)
        if ext ne 'jpg' then begin
            if iext gt 0 then begin
                sublen=len-iext
                ofn = strendsub(ofn,'jpg',sublen)
            endif else begin
                ofn = ofn+'.jpg'
            endelse
        endif

end;MACSScanManager_addDotJPG
pro MACSScanManager_addDotTXT,ofn

        ext = MACSScanManager_getExt(ofn,iext=iext,len=len)
        if ext ne 'txt' then begin
            if iext gt 0 then begin
                sublen=len-iext
                ofn = strendsub(ofn,'txt',sublen)
            endif else begin
                ofn = ofn+'.txt'
            endelse
        endif

end;MACSScanManager_addDotTXT

pro MACSScanManager_saveSession,event
  widget_control,event.handler,get_uvalue=pstate
     fn = dialog_pickfile(path=(*pstate).workdir,filter='*.sav',/write,/overwrite_prompt)
     if fn ne '' then begin
       (*pstate).workdir = file_dirname(fn[0])
       MACSScanManager_addDotSav,fn
       projcontainer = (*pstate).projcontainer
       projnames = *(*pstate).projnames
       save,projnames,projContainer,filename=fn
     endif

end;MACSScanManager_saveSession


;------------------------------------------------------------------------------------------------------------------
;

pro MACSScanManager_quickSlice,event,fn,emptyfile=emptyfile,datapath=datapath,mslice=mslice,$
                               dataObj=dataObj,emptyObj=emptyObj,$ ; THESE KEYWORDS WILL REPLACE THE fn ARGUMENT
                               jpeg=jpeg
    
          ;help,/traceback
          widget_control,event.handler,get_uvalue=pstate

          print,'MACSScanManager_quickSlice'
          help,dataObj
          help,emptyObj

          ;SYNCH UP THE VALUES, JUST IN CASE USER DID NOT HIT RETURN
          MACSScanManager_updateMaskAndWeights,event,/fromwid

          if n_elements(mslice) eq 0 then mslice = 0
        
          ;GET WEIGHTS, MASK, 
        ;  pro macs_slice2,files,emptyfile=emptyfile,xo,yo,zo,avhw,a3ran=a3ran,white=white $
        ;      ,nx=nx,ny=ny,xran=xran,yran=yran,difdet=difdet,a3shift=a3shift,weights=weights $
        ;      ,xabs=xabs,yabs=yabs
        
          cp = (*pstate).projcontainer->get(position=(*pstate).currentProj)
          ;help,cp
          duh = cp->getData(ProjStr)
          ;help,ProjStr,/struct
          diffweights = ProjStr.diffWeights
          specweights = ProjStr.specWeights
;print,'diffweights='
;print,diffweights
          ;macs_get_a12345_int EXPECTS mask eq 1 MEANS UNMASKED, SO I HAVE TO FLIP THEM HERE:
          diffmask = ProjStr.diffMask
          specmask = ProjStr.specMask

          ;INVERT THE MASK VALUES:
          for i = long64(0),n_elements(diffmask)-1L do begin
            if diffmask[i] eq 0 then diffmask[i] = 1 else diffmask[i] = 0
          endfor;i
          for i = long64(0),n_elements(specmask)-1L do begin
            if specmask[i] eq 0 then specmask[i] = 1 else specmask[i] = 0
          endfor;i
        
        
        ;loadct,4
        ;datapath='/usr/local/ice/usr/0/data/'
;        if n_elements(datapath) eq 0 then datapath = 'C:\Documents and Settings\kneller\Desktop\dave_clean_062409\dave\programs\modules\MACS\DATA'
;        cd,datapath

        osfamily = !version.OS_FAMILY
        if strupcase(osfamily) eq 'WINDOWS' then begin
           set_plot,'win'
        endif else begin
           set_plot,'X'
        endelse
        device,decomposed=0
        ;loadct,20
        colortable=makepts(xlo=0,xhi=255,npts=256)
        colortable=reverse(colortable)
        tvlct,colortable,colortable,colortable
        loadct,39
        xran=[-3.5,3.5]
        yran=[-3.5,3.5]
;print,'MACSScanManager_quickSlice'        
;help,specweights,specmask
        macs_slice2,fn,qx,qy,rint,hw,white=white,nx=80,ny=80,emptyfile=emptyfile,weights=specweights,$
                    specweights=specweights,$
                    mask_det=specmask,$
                    dataObj=dataObj,emptyObj=emptyObj ; THESE KEYWORDS WILL REPLACE THE fn ARGUMENT
                    


;        print,'_______'
;        help,qx,qy,rint,hw,white
        z=MACS_cgrain(rint,2,2,white=white)
        
        wset,(*pstate).specWinPix
  
;  help,hw      
        ;WHY DID DANNY SCALE THE Q VALUES THIS WAY? --- THIS CONVERTS HIS DATA FROM A^-1 TO RLU FOR HIS CASE.
;        macs_plotslice,qx/(2.*!pi*sqrt(2.)/3.8),qy/(2.*!pi/3.8),z,zr=[0,125],xran=xran,yran=yran,hw,white=white,_extra=_extra,$
;                                  xrange=[-1.3,1.3],yrange=[-1.8,1.8],/spec
        zrange = [min(z),max(z)] 
        macs_plotslice,qx,qy,z,zr=zrange,xran=xran,yran=yran,hw,white=white,_extra=_extra,$
                                  xrange=[-3.3,3.3],yrange=[-3.8,3.8],/spec

        jpegSpec = tvrd(true=1)
        
        wset,(*pstate).specWinVis
        device,copy=[0,0,450,300,0,0,(*pstate).specwinPix]
        
        
        ;window,4,title='1.1 meV, T=1.5 K Diffraction'
        ;slice2,'hw_1p2_q_scan128'+['28','29','30','31','32','33','34','35']+'.ng0',qx,qy,rint,hw,white=white,nx=80,ny=80,/difdet
;help,diffweights,diffmask
        macs_slice2,fn,qx,qy,rint,hw,white=white,nx=80,ny=80,/difdet,emptyfile=emptyfile,weights=diffweights,$
                    diffweights=diffweights,$
                    mask_det=diffmask,$
                    dataObj=dataObj,emptyObj=emptyObj ; THESE KEYWORDS WILL REPLACE THE fn ARGUMENT
                    

        z=MACS_cgrain(rint,2,2,white=white)
        
        wset,(*pstate).diffWinPix
;help,hw
;        macs_plotslice,qx/(2.*!pi*sqrt(2.)/3.8),qy/(2.*!pi/3.8),z,zr=[0,40000],xran=xran,yran=yran,hw,white=white,_extra=_extra,$
;                                  xrange=[-1.3,1.3],yrange=[-1.8,1.8],/diff
        zrange = [min(z),max(z)] 
        print,'MACSScanManager_quickSlice xran,yran=',xran,yran
        
        macs_plotslice,qx,qy,z,zr=zrange,xran=xran,yran=yran,hw,white=white,_extra=_extra,$
                                  xrange=[-3.3,3.3],yrange=[-3.8,3.8],/diff
        jpegDiff = tvrd(true=1)
                                  
        wset,(*pstate).diffWinVis
        device,copy=[0,0,450,300,0,0,(*pstate).diffwinPix]

;help,jpegSpec,jpegDiff
        jpegsz = size(jpegSpec)
        jpeg = bytarr(3,2*jpegsz[2],jpegsz[3])
        jpeg[*,0:jpegsz[2]-1,*] = jpegDiff
        jpeg[*,jpegsz[2]:2*jpegsz[2]-1,*] = jpegSpec
;help,jpeg
end;MACSScanManager_quickSlice
;end;MACSScanManager_plotLaCoNiO1P1_feb_dannytry_for_larry

pro MACSScanManager_MSlice,event,fn,emptyfile=emptyfile,datapath=datapath,mslice=mslice,$
                           dataObj=dataObj,emptyObj=emptyObj,$ ; THESE KEYWORDS WILL REPLACE THE fn ARGUMENT
                           spec=spec,diff=diff,result=result,noplot=noplot

;fn should be passed in as an array of data structures
;
;emptyfile should be a data structure

  if n_elements(noplot) eq 0 then noplot = 0

  widget_control,event.handler,get_uvalue=pstate
  if n_elements(mslice) eq 0 then mslice = 1  ;IN THIS METHOD
  

  print,'MACSScanManager_MSlice'
  help,dataObj
  help,emptyObj
  
  if n_elements(diff) eq 0 then diff = 0
  if n_elements(spec) eq 0 then spec = 0

  if diff eq 0 and spec eq 0 then spec = 1
  

  ;
  ;GET WEIGHTS, MASK, 
;  pro macs_slice2,files,emptyfile=emptyfile,xo,yo,zo,avhw,a3ran=a3ran,white=white $
;      ,nx=nx,ny=ny,xran=xran,yran=yran,difdet=difdet,a3shift=a3shift,weights=weights $
;      ,xabs=xabs,yabs=yabs

  cp = (*pstate).projcontainer->get(position=(*pstate).currentProj)
  duh = cp->getData(ProjStr)
  diffweights = ProjStr.diffWeights
  specweights = ProjStr.specWeights


  ;macs_get_a12345_int EXPECTS mask eq 1 MEANS UNMASKED, SO I HAVE TO FLIP THEM HERE:
  diffmask = ProjStr.diffMask
  specmask = ProjStr.specMask


  ;INVERT THE MASK VALUES:
  for i = long64(0),n_elements(diffmask)-1L do begin
    if diffmask[i] eq 0 then diffmask[i] = 1 else diffmask[i] = 0
  endfor;i
  for i = long64(0),n_elements(specmask)-1L do begin
    if specmask[i] eq 0 then specmask[i] = 1 else specmask[i] = 0
  endfor;i

  if spec eq 1 then begin
    detector = 'spec' 
    themask = specmask
  endif else begin
    detector = 'diff'
    themask = diffmask
  endelse




;
;
;help,projstr,/struct
;loadct,4
;datapath='/usr/local/ice/usr/0/data/'
if n_elements(datapath) eq 0 then datapath = 'C:\Documents and Settings\kneller\Desktop\dave_clean_062409\dave\programs\modules\MACS\DATA'
if n_elements(datapath) eq 0 then datapath = 'C:\Documents and Settings\kneller\Desktop\Data\MACS\'
cd,datapath
;set_plot,'win'

        osfamily = !version.OS_FAMILY
        if strupcase(osfamily) eq 'WINDOWS' then begin
           set_plot,'win'
        endif else begin
           set_plot,'X'
        endelse


device,decomposed=0
;loadct,20
;colortable=makepts(xlo=0,xhi=255,npts=256)
;colortable=reverse(colortable)
;tvlct,colortable,colortable,colortable
;loadct,39
xran=[-3.5,3.5]
yran=[-3.5,3.5]
;window,0,title='1.1 meV, T=1.5 K'
;slice2,'hw_1p2_q_scan128'+['28','29','30','31','32','33','34','35']+'.ng0',qx,qy,rint,hw,white=white,nx=80,ny=80

macs_slice3,fn,qx,qy,rint,hw,white=white,nx=80,ny=80,emptyfile=emptyfile,zoerr=rinterr,$
            specweights=specweights,diffweights=diffweights,$ ;LRK - 04/12/10  ADDING THESE KEYWORDS B/C I BELIEVE WEIGHTS
                                                              ;                ARE NOT APPLIED PROPERLY
            dataObj=dataObj,emptyObj=emptyObj,$; THESE KEYWORDS WILL REPLACE THE fn ARGUMENT
            spectroscopic=spec,diffraction=diff,$
            detector=detector,mask_det = themask

          if mslice eq 1 then begin
            ;;FROM YIMING'S EMAIL, 2/17/10:
        ;    widget_control,(*pstate).MSliceAllGroups,get_value=allVars
          
        ;    case allVars of 
        ;    1:begin
              mslicedata = findgen(n_elements(qx), 5)
catch,es
if es ne 0 then begin
  errormsg = ['The following problem occurred in MACSScanManager_MSlice:',!error_state.msg]
  void = dialog_message(ERRORmsg,DIALOG_PARENT=(*PSTATE).TLB)
  
  catch,/cancel
  return
endif;catch        
          
              ;HAVE I SELECTED THE CORRECT ITEMS HERE?????
              mslicedata[*,0] = rint
              mslicedata[*,1] = rinterr
              mslicedata[*,2] = qx
              mslicedata[*,3] = qy
              mslicedata[*,4] = hw
              label = ['I','dI','qx','qy','hw']
              unit  = ['cts','','','','']
              is_uniq = [0,0,1,1,1]
              dataPtr = ptr_new({data:mslicedata,label:label,unit:unit,is_uniq:is_uniq,instrument:'MACS'})
    
    
          ;SWITCH TO: 
          ;pro dcs_mslice,group_leader=group_leader, workDir=workDir, dataDir=dataDir, DAVETool=DAVETool,dataPtr=dataPtr,obj_mslice=obj_mslice,_extra=extra
          ;    obj_mslice = obj_new('dcs_mslice',group_leader=group_leader,workDir=workDir,dataDir=dataDir,DAVETool=DAVETool,dataPtr=dataPtr)
          ;end   
              result = dataPtr
              if noplot eq 0 then begin
                obj_mslice = obj_new('dcs_mslice',dataPtr=dataPtr,group_leader=(*pstate).tlb)
              endif
          ;if ptr_valid(dataptr) gt 0 then ptr_free,dataptr
          
              ;the is_uniq keyword can be also called in the reset_data method
          
          endif;mslice
           
end;MACSScanManager_MSlice


pro MACSScanManager_HandleQuickSlice,event,jpeg=jpeg
      widget_control,event.handler,get_uvalue=pstate
      widget_control,(*pstate).dataList,get_uvalue=dataList    
      dataSelect = widget_info((*pstate).dataList,/list_select)
      widget_control,(*pstate).emptyList,get_uvalue=emptyList    
      emptySelect = widget_info((*pstate).emptyList,/list_select)
      

      if (*pstate).datacontainer->count() eq 0 then begin
            void = dialog_message('No Data Available',dialog_parent=(*pstate).tlb,title='MACS Scan Manager:')
        
      endif else begin
      
            if dataSelect[0] ne -1 then begin
      
      
                ;LRK 04/13/10
                ;DATA OBJECTS ARE NOW SORTED IN THEIR CONTAINERS IN THE SAME ORDER AS THE
                ;DATA FILE LIST.  SO NOW I JUST NEED TO GRAB THE DATA OBJECTS
                ;FROM THE CONTAINERS
                ;COLLECT DATA OBJECTS TO PASS TO MACS_slice2,MACS_slice3
                dataObj = objarr(n_elements(dataSelect))
                for i=long64(0),n_elements(dataSelect)-1L do begin
                  dataObj[i] = (*pstate).dataContainer->get(position=dataSelect[i])
                  ;duh->getproperty,filename=fn
                  print,'MACSScanManager_event, Data Available:    '+(['Yes!','No :-('])[dataObj[i]->getData(testStr)]
                  ;help,testStr,/struct
                endfor;i
      
      
      ;THERE IS NO LIMITATION TO A SINGLE EMPTY FILE.
      ;          if n_elements(emptySelect) gt 1 then begin
      ;            void = dialog_message('Please select only ONE empty file.',dialog_parent=(*pstate).tlb)
      ;            return          
      ;          endif
                if emptyselect[0] ne -1 and (*pstate).emptyContainer->count() gt 0 then begin
                    emptyObj = (*pstate).emptyContainer->get(position=emptySelect[0])
                    emptyOK = emptyObj->getData(emptyStr)
                    if emptyOK eq 0 then begin
                      void = dialog_message('There is a problem with the "Empty" data.',dialog_parent=(*pstate).tlb)
                      return                  
                    endif;emptyOK
                    
                    MACSScanManager_QuickSlice,event,dataList[dataSelect],emptyfile=emptylist[emptyselect[0]],$
                                                                          datapath=(*pstate).dataDir,mslice=0,$
                                                                          dataObj=dataObj,emptyObj=emptyObj,jpeg=jpeg
                endif else begin
      ;          MACSScanManager_plotLaCoNiO1P1_feb_dannytry_for_larry,event,dataList[dataSelect],$
      ;                                                                      datapath=(*pstate).dataDir,mslice=0
                  for i=long64(0),n_elements(dataSelect)-1L do begin
                    duh = (*pstate).dataContainer->get(position=i)
                    duh->getproperty,filename=fn
      ;            print,i,fn,' ',dataList[i]
                  
                   endfor;i
                   MACSScanManager_QuickSlice,event,dataList[dataSelect],$
                                                    datapath=(*pstate).dataDir,mslice=0,$
                                                    dataObj=dataObj,jpeg=jpeg
                endelse
            endif else begin
              void = dialog_message('No Data Selected',dialog_parent=(*pstate).tlb,title='MACS Scan Manager:')
            endelse
      endelse;DATA AVAILABLE
end;MACSScanManager_HandleQuickSlice


pro MACSScanManager_showFileContents,event,data=data,empty=empty,bkg=bkg


      widget_control,event.handler,get_uvalue=pstate

      if n_elements(data) eq 0 then mydata = 0 else mydata = 1
      if n_elements(empty) eq 0 then myempty = 0 else myempty = 2
      if n_elements(bkg) eq 0 then mybkg = 0 else mybkg = 4

      mysum = mydata+myempty+mybkg
      
      case mysum of
      1:begin
          widget_control,(*pstate).dataList,get_uvalue=dataList    
          Select = widget_info((*pstate).dataList,/list_select)
          c = (*pstate).dataContainer
      end;data
      2:begin
          widget_control,(*pstate).emptyList,get_uvalue=emptyList    
          Select = widget_info((*pstate).emptyList,/list_select)
          c = (*pstate).emptyContainer
      end;empty
      4:begin
          widget_control,(*pstate).bkgList,get_uvalue=dataList    
          Select = widget_info((*pstate).BkgList,/list_select)
          c = (*pstate).bkgContainer          
      end;4
      else:return
      endcase
      
      if c->count() gt 0 then begin
          if Select[0] ne -1 then begin
            if n_elements(Select) gt 1 then begin
              void = dialog_message('Please select only one file.',dialog_parent=(*pstate).tlb,title='MACS Scan Manager:')          
              return
            endif
            o = c->get(position=select[0])
            duh = o->getData(mystr)
            o->getProperty,filename=myfilename
            
            xdisplayfile,text=mystr.fileContents,$
                         title='MACS Scan Manager: '+file_basename(myfilename),$
                         /block,$;/modal,$
                         group=(*pstate).tlb
    
    ;PRO XDisplayFile, FILENAME, TITLE = TITLE, GROUP = GROUP, WIDTH = WIDTH, $
    ;                  HEIGHT = HEIGHT, TEXT = TEXT, FONT = font, $
    ;                  DONE_BUTTON=done_button, MODAL=MODAL, $
    ;                  EDITABLE=editable, GROW_TO_SCREEN=grow_to_screen, $
    ;                  WTEXT=filetext, BLOCK=block, RETURN_ID=return_id        
    
          endif;select
                 
    endif;count() gt 0

end;MACSScanManager_showFileContents


pro MACSScanManager_event,event


catch,es
if es ne 0 then begin
  errormsg = ['In MACSScanManager_event - the following problem occurred in MACSScanManager:',!error_state.msg]
  void = dialog_message(ERRORmsg,DIALOG_PARENT=(*PSTATE).TLB)
  
  catch,/cancel
  return
endif;catch        



  widget_control,event.handler,get_uvalue=pstate
;help,*pstate,/struct
  case event.id of
  (*pstate).quickslicebutton:begin
      MACSScanManager_handleQuickSlice,event
  end;quickslicebutton
  (*pstate).writeJPG:begin
    print,'writeJPG'
    MACSScanManager_HandleQuickSlice,event,jpeg=jpeg
    fn = dialog_pickfile(filter='*.jpg',title='JPEG OUTPUT FILE:',dialog_parent=(*pstate).tlb,path=(*pstate).workdir)
    if fn [0] ne '' then begin
      MACSScanManager_addDotJPG,fn
      (*pstate).workdir = file_dirname(fn)
      write_jpeg,fn,jpeg,true=1
    endif    
  end;writeJPG
  (*pstate).print:begin  
    MACSScanManager_print2Printer,event
  end;print
  (*pstate).viewDataContents:begin
    if (*pstate).datacontainer->count() gt 0 then begin
      print,'viewDataContents'
      MACSScanManager_showFileContents,event,/data
      widget_control,event.handler,get_uvalue=pstate

      widget_control,(*pstate).dataList,get_uvalue=dataList    
      dataSelect = widget_info((*pstate).dataList,/list_select)

      widget_control,(*pstate).bkgList,get_uvalue=dataList    
      bkgSelect = widget_info((*pstate).BkgList,/list_select)

      widget_control,(*pstate).emptyList,get_uvalue=emptyList    
      emptySelect = widget_info((*pstate).emptyList,/list_select)
            
      if dataSelect[0] ne -1 then begin
        if n_elements(dataSelect) gt 1 then begin
          void = dialog_message('Please select only one file.',dialog_parent=(*pstate).tlb,title='MACS Scan Manager:')          
          return
        endif
        o = (*pstate).dataContainer->get(position=dataselect[0])
        duh = o->getData(mystr)
        o->getProperty,filename=myfilename
        
        xdisplayfile,text=mystr.fileContents,$
                     title='MACS Scan Manager: '+file_basename(myfilename),$
                     /block,$;/modal,$
                     group=(*pstate).tlb

;PRO XDisplayFile, FILENAME, TITLE = TITLE, GROUP = GROUP, WIDTH = WIDTH, $
;                  HEIGHT = HEIGHT, TEXT = TEXT, FONT = font, $
;                  DONE_BUTTON=done_button, MODAL=MODAL, $
;                  EDITABLE=editable, GROW_TO_SCREEN=grow_to_screen, $
;                  WTEXT=filetext, BLOCK=block, RETURN_ID=return_id        

      endif;dataselect
                 
    endif;count() gt 0
  end;viewDataContents
  (*pstate).viewBkgContents:begin
     print,'viewBkgContents'
     MACSScanManager_showFileContents,event,/bkg
  end;viewBkgContents
  (*pstate).viewEmptyContents:begin
    print,'viewEmptyContents'
    MACSScanManager_showFileContents,event,/empty  
  end;viewEmptyContents

  (*pstate).mslicebutton:begin


;NOW I HAVE TO ASSUME ALL THE ITEMS IN THE DATA CONTAINER ARE
;ORDERED IN THE SAME WAY AS THE DATA LIST!!!! -- THAT MS

      widget_control,(*pstate).dataList,get_uvalue=dataList    
      dataSelect = widget_info((*pstate).dataList,/list_select)
      widget_control,(*pstate).emptyList,get_uvalue=emptyList    
      emptySelect = widget_info((*pstate).emptyList,/list_select)


      widget_control,(*pstate).dataList,get_uvalue=dataList    
      dataSelect = widget_info((*pstate).dataList,/list_select)
      widget_control,(*pstate).emptyList,get_uvalue=emptyList    
      emptySelect = widget_info((*pstate).emptyList,/list_select)
;print,'emptylist=',emptylist
;print,'emptylist[emptySelect]=',emptylist[emptySelect]

      spec = 0
      diff = 0
      widget_control,(*pstate).MSliceChoiceGroup,get_value=SpecDiff
      if specDiff eq 0 then begin
        spec = 1
        diff = 0
      endif else begin
        spec = 0
        diff = 1
      endelse 

      if dataSelect[0] ne -1 then begin

        ;GET DATA OBJECTS
        dataObj = objarr(n_elements(dataSelect))
        for i=long64(0),n_elements(dataSelect)-1L do begin
          dataObj[i] = (*pstate).dataContainer->get(position=dataselect[i])
          ;duh->getproperty,filename=fn
          print,'MACSScanManager_event, Data Available:    '+(['Yes!','No :-('])[dataObj[i]->getData(testStr)]
          ;help,testStr,/struct
        endfor;i

        if emptyselect[0] ne -1 then begin
          emptyObj = (*pstate).emptyContainer->get(position=emptySelect[0])
          emptyOK = emptyObj->getData(emptyStr)
          if emptyOK eq 0 then begin
            void = dialog_message('There is a problem with the "Empty" data.',dialog_parent=(*pstate).tlb)
            return                  
          endif;emptyOK

          MACSScanManager_MSlice,event,dataList[dataSelect],$
                                       emptyfile=emptylist[emptyselect[0]],$
                                       datapath=(*pstate).dataDir,mslice=1,$
                                       spec=spec,diff=diff,$
                                       emptyObj=emptyObj,dataObj=dataObj,$
                                       result=result
        endif else begin
          MACSScanManager_MSlice,event,dataList[dataSelect],$
                                       datapath=(*pstate).dataDir,mslice=1,$
                                       spec=spec,diff=diff,$
                                       emptyObj=emptyObj,dataObj=dataObj,$
                                       result=result
        endelse
    endif;dataselect
  end;mslicebutton
  (*pstate).writeMsliceToFileButton:begin


;NOW I HAVE TO ASSUME ALL THE ITEMS IN THE DATA CONTAINER ARE
;ORDERED IN THE SAME WAY AS THE DATA LIST!!!! -- THAT MS

      widget_control,(*pstate).dataList,get_uvalue=dataList    
      dataSelect = widget_info((*pstate).dataList,/list_select)
      widget_control,(*pstate).emptyList,get_uvalue=emptyList    
      emptySelect = widget_info((*pstate).emptyList,/list_select)


      widget_control,(*pstate).dataList,get_uvalue=dataList    
      dataSelect = widget_info((*pstate).dataList,/list_select)
      widget_control,(*pstate).emptyList,get_uvalue=emptyList    
      emptySelect = widget_info((*pstate).emptyList,/list_select)
;print,'emptylist=',emptylist
;print,'emptylist[emptySelect]=',emptylist[emptySelect]

      spec = 0
      diff = 0
      widget_control,(*pstate).MSliceChoiceGroup,get_value=SpecDiff
      if specDiff eq 0 then begin
        spec = 1
        diff = 0
      endif else begin
        spec = 0
        diff = 1
      endelse 

      if dataSelect[0] ne -1 then begin

        ;GET DATA OBJECTS
        dataObj = objarr(n_elements(dataSelect))
        for i=long64(0),n_elements(dataSelect)-1L do begin
          dataObj[i] = (*pstate).dataContainer->get(position=dataSelect[i])
          ;duh->getproperty,filename=fn
          print,'MACSScanManager_event, Data Available:    '+(['Yes!','No :-('])[dataObj[i]->getData(testStr)]
          ;help,testStr,/struct
        endfor;i

        if emptyselect[0] ne -1 then begin
          emptyObj = (*pstate).emptyContainer->get(position=emptySelect[0])
          emptyOK = emptyObj->getData(emptyStr)
          if emptyOK eq 0 then begin
            void = dialog_message('There is a problem with the "Empty" data.',dialog_parent=(*pstate).tlb)
            return                  
          endif;emptyOK

          MACSScanManager_MSlice,event,dataList[dataSelect],$
                                       emptyfile=emptylist[emptyselect[0]],$
                                       datapath=(*pstate).dataDir,mslice=1,$
                                       spec=spec,diff=diff,$
                                       emptyObj=emptyObj,dataObj=dataObj,$
                                       result=result,/noplot
        endif else begin
          MACSScanManager_MSlice,event,dataList[dataSelect],$
                                       datapath=(*pstate).dataDir,mslice=1,$
                                       spec=spec,diff=diff,$
                                       emptyObj=emptyObj,dataObj=dataObj,$
                                       result=result,/noplot
        endelse
        fn = dialog_pickfile(title='MACS_ScatestnManager: ASCII OUTPUT File:',filter=['*.txt','*.dat'],path=(*pstate).workdir)
        if fn[0] ne '' then begin
          print,'__________________'
          print,'   mslicebutton   '
          help,*result,/struct
          MACSScanManager_addDotTXT,fn
          
          openw,lun,fn,/get_lun
          printf,lun,'#',(*result).label[*],format='(A,5A15)' 
          for i=long64(0),n_elements((*result).data[*,0])-1L do begin
            printf,lun,(*result).data[i,*],format='(5g15.7)'
          endfor;i 
          free_lun,lun          
        endif
      endif else begin
        void = dialog_message('No Data Selected',dialog_parent=(*pstate).tlb,title='MACS Scan Manager:')
      endelse

  end;writeMsliceToFileButton
  (*pstate).adddata:begin
    if (*pstate).currentProj ne -1 then begin
      fn = dialog_pickfile(path=(*pstate).datadir,/multi,dialog_parent=(*pstate).tlb)
      if fn[0] ne '' then begin
        (*pstate).datadir = file_dirname(fn[0])
        for i=long64(0),n_elements(fn)-1L do begin
          o=obj_new('macsdataobject',filename=fn[i])
          if obj_valid(o) gt 0 then begin
            (*pstate).datacontainer->add,o
          endif        
        endfor
        MACSScanManager_updateList,event,/data
        MACSScanManager_updateLatticeAndOrientation,event,/fromData
      endif
    endif
  end;adddata
  (*pstate).renameProj:begin
    print,'Rename Proj'
    sel = widget_info((*pstate).projlist,/list_select)
    if (sel[0] gt -1) and ((*pstate).projContainer->count() gt sel[0]) then begin
        (*pstate).currentProj = sel[0] 
        p = (*pstate).projContainer->get(position=sel[0])
        newname = MACSScanManager_inputDialog(group_leader = (*pstate).tlb,title='Enter new project name:',value=p->getName())
        p->setName,newname
        MACSScanManager_updateList,event,/all         

    endif        
  end;renameProj

  (*pstate).open:begin

      if (*pstate).projContainer->count() gt 0 then begin
           yn = dialog_message('Would you like to save the current session before proceeding?',$
                                /question,dialog_parent=(*pstate).tlb,$
                                title='MACS Scan Manager:')
      
           if strupcase(yn) eq 'YES' then begin
            MACSScanManager_saveSession,event
           endif           
     endif;(*pstate).count
     

     
     fn = dialog_pickfile(path=(*pstate).workdir,filter='*.sav',/read,dialog_parent=(*pstate).tlb)
     if fn ne '' then begin
       (*pstate).workdir = file_dirname(fn[0])
       restore,fn
       if obj_valid(projcontainer) then begin
        ;help,projcontainer,projnames
       
         (*pstate).currentproj = -1
         (*pstate).projcontainer = projcontainer
          (*pstate).projnames = ptr_new(projnames) 

          if (*pstate).projContainer->count() gt 0 then begin
              (*pstate).currentProj = 0 
              p = (*pstate).projContainer->get(position=0)
              d = p->get(position=0)
              b = p->get(position=1)
              e = p->get(position=2)
              (*pstate).datacontainer=d
              (*pstate).bkgcontainer=b
              (*pstate).emptycontainer=e
          endif else begin
            void=dialog_message('No valid data in that file.',dialog_parent=(*pstate).tlb)
          endelse
          
          MACSScanManager_updateList,event,/all         
          MACSScanManager_updateMaskAndWeights,event,/fromproj
       endif
     endif
  end;open
  (*pstate).save:begin
      MACSScanManager_saveSession,event
  end;save
  
  (*pstate).projlist:begin
    sel = widget_info((*pstate).projlist,/list_select)
    if (sel[0] gt -1) and ((*pstate).projContainer->count() gt sel[0]) then begin
        (*pstate).currentProj = sel[0] 
        p = (*pstate).projContainer->get(position=sel[0])
        d = p->get(position=0)
        b = p->get(position=1)
        e = p->get(position=2)

        (*pstate).datacontainer=d
        (*pstate).bkgcontainer=b
        (*pstate).emptycontainer=e

        widget_control,(*pstate).projlist,set_list_select=(*pstate).currentProj
        MACSScanManager_updateMaskAndWeights,event,/all,/fromproj
    endif
    MACSScanManager_updateList,event,/all
  end;projlist
  (*pstate).diffmaskgroup1:begin
    MACSScanManager_updateMaskAndWeights,event,/fromwid
  end;diffmaskgroup1
  (*pstate).diffmaskgroup2:begin
    MACSScanManager_updateMaskAndWeights,event,/fromwid
  end;diffmaskgroup2
  (*pstate).specmaskgroup1:begin
    MACSScanManager_updateMaskAndWeights,event,/fromwid

  end;specmaskgroup1
  (*pstate).specmaskgroup2:begin
    MACSScanManager_updateMaskAndWeights,event,/fromwid
  end;specmaskgroup2  
  
  (*pstate).newproj:begin


      ;SO AS NOT TO BREAK ANYTHING, KEEP THIS FOR NOW
      names = *(*pstate).projnames
      if n_elements(names) eq 1 and names[0] eq '' then begin
        names[0] = 'Project 1'
      endif else begin
        newnum = n_elements(names)+1
        lastnum = fix((strsplit(names[n_elements(names)-1],/extract))[1]) 
        if newnum le lastnum then newnum = lastnum+1  
        names = [names,'Project '+strtrim(string(newnum),2)]
      endelse
      if ptr_valid((*pstate).projnames) then ptr_free,(*pstate).projnames
      (*pstate).projnames = ptr_new(names)


      ;INITIALIZE SOME PROJECT-WIDE VALUES:
      newname = 'Project '+strtrim(string((*pstate).projcontainer->count() + 1),2)
      diffWeights = 1.0+fltarr(20)
      specWeights = 1.0+fltarr(20)
      diffMask = intarr(20)
      specMask = intarr(20)

      p = obj_new('MACSScanProject',name=newname,diffweights=diffweights,specweights=specweights,$
                                    diffMask=diffMask,specMask=specMask)
      d = obj_new('idl_container')
      b = obj_new('idl_container')
      e = obj_new('idl_container')
      ;ADD IN THESE POSITIONS
      p->add,d,position=0
      p->add,b,position=1
      p->add,e,position=2

      (*pstate).projcontainer->add,p

      (*pstate).currentProj = (*pstate).projcontainer->count()-1

      (*pstate).datacontainer=d
      (*pstate).bkgcontainer=b
      (*pstate).emptycontainer=e
      widget_control,(*pstate).projlist,set_value=names
      MACSScanManager_updateList,event,/all
      MACSScanManager_updateMaskAndWeights,event,/fromproj
  end;newproj
  (*pstate).delproj:begin
      sel = widget_info((*pstate).projlist,/list_select)

      if (*pstate).projContainer->count() gt 0 then begin

          p = (*pstate).projContainer->get(position=sel[0])
          (*pstate).projContainer->remove,p
          obj_destroy,p
          ;(*pstate).datacontainer=obj_new()
          ;(*pstate).bkgcontainer=obj_new()
          ;(*pstate).emptycontainer=obj_new()

          if (*pstate).projContainer->count() gt 0 then begin
              (*pstate).currentProj = 0
              p = (*pstate).projContainer->get(position=0)
              (*pstate).datacontainer=p->get(position=0)
              (*pstate).bkgcontainer=p->get(position=1)
              (*pstate).emptycontainer=p->get(position=2)
              
              names = *(*pstate).projnames
              i=indgen(n_elements(names))
              wh = where(i ne sel[0])
              names = names[wh]

              ptr_free,(*pstate).projnames
              (*pstate).projnames = ptr_new(names)
          endif else begin 
              ptr_free,(*pstate).projnames
              (*pstate).projnames = ptr_new('No Projects')
              (*pstate).currentProj = -1
          endelse
      endif
  ;    widget_control,(*pstate).projlist,set_value=names
      MACSScanManager_updateList,event,/all
  end;delproj  

  (*pstate).addbkg:begin
    if (*pstate).currentProj ne -1 then begin
      fn = dialog_pickfile(path=(*pstate).datadir,/multi,dialog_parent=(*pstate).tlb)
      if fn[0] ne '' then begin
        (*pstate).datadir = file_dirname(fn[0])
        for i=long64(0),n_elements(fn)-1L do begin
          o=obj_new('macsdataobject',filename=fn[i])
          if obj_valid(o) gt 0 then begin
            (*pstate).bkgcontainer->add,o
          endif        
        endfor
        MACSScanManager_updateList,event,/bkg

      endif
    endif
  end;addbkg
  (*pstate).addempty:begin
    if (*pstate).currentProj ne -1 then begin
      fn = dialog_pickfile(path=(*pstate).datadir,/multi,dialog_parent=(*pstate).tlb)
      if fn[0] ne '' then begin
        (*pstate).datadir = file_dirname(fn[0])
        for i=long64(0),n_elements(fn)-1L do begin
          o=obj_new('macsdataobject',filename=fn[i])
          if obj_valid(o) gt 0 then begin
            (*pstate).emptycontainer->add,o
          endif        
        endfor
        MACSScanManager_updateList,event,/empty
      endif
    endif
  end;addempty
  (*pstate).removedata:begin
    sel = widget_info((*pstate).datalist,/list_select)
    if sel[0] ne -1 then begin
      if (*pstate).datacontainer->count() gt 0 then begin
        o=(*pstate).datacontainer->get(position=sel)
        (*pstate).datacontainer->remove,o
        obj_destroy,o      
        MACSScanManager_updateList,event,/data
      endif
    endif
  end;
  (*pstate).removeempty:begin
    sel = widget_info((*pstate).emptylist,/list_select)
    if sel[0] ne -1 then begin
      if (*pstate).emptycontainer->count() gt 0 then begin
        o=(*pstate).emptycontainer->get(position=sel)
        (*pstate).emptycontainer->remove,o
        obj_destroy,o      
        MACSScanManager_updateList,event,/empty
      endif
    endif
  end;removeempty
  (*pstate).removebkg:begin
    sel = widget_info((*pstate).bkglist,/list_select)
    if sel[0] ne -1 then begin
      if (*pstate).bkgcontainer->count() gt 0 then begin
        o=(*pstate).bkgcontainer->get(position=sel)
        (*pstate).bkgcontainer->remove,o
        obj_destroy,o      
        MACSScanManager_updateList,event,/bkg
      endif
    endif
  end;removebkg
  (*pstate).quit:begin
    MACSScanManager_saveSession,event
    widget_control,(*pstate).tlb,/destroy
  end;quit
  (*pstate).emptylist:begin
  end;emptylist
  (*pstate).datalist:begin
  end;datalist
  (*pstate).bkglist:begin
    
  end;bkglist
  else:begin
    ;help,event,/struct
    ;CHECK THE WEIGHTS WIDGETS
    whspec = where(event.id eq (*pstate).specweights,specCount)
    whdiff = where(event.id eq (*pstate).diffweights,diffCount)    
    whlatt = where(event.id eq (*pstate).lattice,lattcount)
    whorie = where(event.id eq (*pstate).orientations,oriecount)

    if (specCount + diffCount +lattCount + orieCount) gt 0 then begin
      MACSScanManager_updateMaskAndWeights,event,/fromwid
    endif

  endelse
  endcase


end;MACSScanManager_event

pro MACSScanManager_cleanup,id
  widget_control,id,get_value=pstate
  obj_destroy,(*pstate).allcontainer
  if (*pstate).bkgcontainer->count() gt 0 then begin
    b = (*pstate).bkgcontainer->get(/all)
    (*pstate).bkgcontainer->remove,/all
    if obj_valid(b[0]) gt 0 then obj_destroy,b
  endif
  obj_destroy,(*pstate).bkgcontainer

  if (*pstate).datacontainer->count() gt 0 then begin
    d = (*pstate).datacontainer->get(/all)
    (*pstate).datacontainer->remove,/all
    if obj_valid(d[0]) gt 0 then obj_destroy,d
  endif
  obj_destroy,(*pstate).datacontainer

  if (*pstate).emptycontainer->count() gt 0 then begin
    e = (*pstate).emptycontainer->get(/all)
    (*pstate).emptycontainer->remove,/all
    if obj_valid(e[0]) gt 0 then obj_destroy,e
  endif
  obj_destroy,(*pstate).emptycontainer
  
  if (*pstate).projcontainer->count() gt 0 then begin
    p = (*pstate).emptycontainer->get(/all)
    (*pstate).projcontainer->remove,/all
    if obj_valid(p[0]) gt 0 then obj_destroy,p
  endif
  obj_destroy,(*pstate).projcontainer

  ptr_free,(*pstate).projnames
  ptr_free,pstate

end;MACSScanManager_cleanup

pro launch_MACSScanManager,event,$
                 group_leader=group_leader,$
                 workDir=workDir,$
                 dataDir=dataDir,$
                 DAVETool=DAVETool,$
                 _Extra=extra
;
;NAME:
;        launch_MACSScanManager
;
;PURPOSE:
;           Launch MACSScanManager application from DAVE.
;PARAMETERS:
;           event   Event to launch the module.
;KEYWORDS:
;           None.

  if n_elements(event) eq 0 then begin
        MACSScanManager,group_leader=group_leader,$
                        workDir=workDir,$
                        dataDir=dataDir,$
                        DAVETool=DAVETool,$
                        _Extra=extra
  endif else begin
        this_event = tag_names(event,/structure_name)
        MACSScanManager,group_leader=event.top,$
                        workDir=workDir,$
                        dataDir=dataDir,$
                        DAVETool=DAVETool,$
                        _Extra=extra
  endelse
end;launch_MACSScanManager



pro MACSScanManager,group_leader=group_leader,datadir=datadir,workdir=workdir,daveTool=daveTool,_Extra=extra

  if n_elements(datadir) eq 0 then datadir = '.'
  if n_elements(workdir) eq 0 then workdir = '.'
  if n_elements(daveTool) eq 0 then daveTool = obj_new()

  if n_elements(group_leader) eq 1 then begin
    tlb = widget_base(title='MACS Scan Manager',/col,mbar=bar,group_leader=group_leader)
  endif else begin    
    tlb = widget_base(title='MACS Scan Manager',/col,mbar=bar)
  endelse


    top_tlb=widget_base(tlb,/row)
        options_tab=widget_tab(top_tlb)
        actionbase = widget_base(top_tlb,/col)

;HIDE THE QUICKSLICE FEATURES UNTIL THEY ARE BETTER IRONED OUT.
        qactionbase = widget_base(actionbase,/col,frame=2)
        QuickSliceButton = widget_button(qactionbase,value='QuickSlice')
        writeJPGButton = widget_button(qactionbase,value='QuickSlice: Write To JPG')
        axisLabels=['qx','qy','hw']
        QuickSliceXGroup=0L;cw_bgroup(qactionBase,axisLabels,/row,/exclusive,uname='QuickSliceXGroup',label_left='X axis',set_value=0)
        QuickSliceYGroup=0L;cw_bgroup(qactionBase,axisLabels,/row,/exclusive,uname='QuickSliceYGroup',label_left='Y axis',set_value=1)

        mactionbase = widget_base(actionbase,/col,frame=2)
        MSliceButton = widget_button(mactionbase,value='Mslice')
        writeMsliceToFileButton = widget_button(mactionbase,value='Write MSLICE Data to ASCII')
        MSliceChoiceGroup=cw_bgroup(mactionBase,['Spectroscopic','Diffraction'],/row,/exclusive,$
                                    uname='MSliceDiffSpec',label_left='Detector Choice: ',set_value=0)

        MSliceAllGroups = 0L;cw_bgroup(mactionBase,['Send All Variables'],/row,/nonexclusive,uname='MSliceAllGroups',label_left='Send All Variables',set_value=1)
        MSliceXGroup = 0L   ;cw_bgroup(mactionBase,axisLabels,/row,/exclusive,uname='MSliceXGroup',label_left='X axis',set_value=0)
        MSliceYGroup = 0L   ;cw_bgroup(mactionBase,axisLabels,/row,/exclusive,uname='MSliceYGroup',label_left='Y axis',set_value=1)
        
        
;ELIMINATE "MASK" TAB AND ADD AN OPERATIONS TAB   
;ALSO HAVE TOLERANCES FOR "BACKGROUND" AND "CELL"  
     
        mask_tab=widget_base(options_tab,title='Mask',/row)
;            mask_detectors=widget_base(mask_tab,title='Mask Detectors',/column)
;
;;MOVE TO  DIFFRACTION DETECTORS TAB
;              mask_detectors_title=widget_label(mask_detectors,value='Mask Diffraction Detectors:')
;              all_labels=['01','02','03','04','05','06','07','08','09','10']
;              diffmaskgroup1=cw_bgroup(mask_detectors,all_labels,/row,/nonexclusive,uname='det_all')
;              all_labels2=['11','12','13','14','15','16','17','18','19','20']
;              diffmaskgroup2=cw_bgroup(mask_detectors,all_labels2,/row,/nonexclusive,uname='det_all2')

;MOVE TO SPECTROSCOPIC DETECTORS TAB
;              mask_detectors_title=widget_label(mask_detectors,value='Mask Spectroscopic Detectors:')
;              all_labels=['01','02','03','04','05','06','07','08','09','10']
;              specmaskgroup1=cw_bgroup(mask_detectors,all_labels,/row,/nonexclusive,uname='det_all')
;              all_labels2=['11','12','13','14','15','16','17','18','19','20']
;              specmaskgroup2=cw_bgroup(mask_detectors,all_labels2,/row,/nonexclusive,uname='det_all2')

              mask_a3_a4=widget_base(mask_tab,/column)            
            ;;;;;;;
                mask_a3=widget_base(mask_a3_a4,/row)
                    mask_a3_title=widget_label(mask_a3,value='Mask A3:')
                    A3_choose=widget_Base(mask_a3,/row,/exclusive)
                    maskA3_yes=widget_button(A3_choose,value='Yes',uname='Yes_A4mask')
                    maskA3_no=widget_button(A3_choose,value='NO',uname='No_A4mask')
                    A3_choose2=widget_Base(mask_a3,/row)
                    mask_A3_min= WIDGET_LABEL(A3_choose2,value='Min A3:')
                    mask_A3_min_txt=widget_text(A3_choose2,value='0.0',uname='a3_txt',/editable,xsize=5,/CONTEXT_EVENTS)
                    mask_A3_MAX= WIDGET_LABEL(A3_choose2,value='         Max A3:')
                    mask_A3_max_txt=widget_text(A3_choose2,value='0.0',uname='a3_txt',/editable,xsize=5,/CONTEXT_EVENTS)
                    
            
                mask_a4=widget_base(mask_a3_a4,/row)
                    mask_A4_title= WIDGET_LABEL(mask_a4,value='Mask A4:')
                    A4_choose=widget_Base(mask_a4,/row,/exclusive)          
                    maskA4_yes=widget_button(A4_choose,value='Yes',uname='Yes_A4mask')
                    maskA4_no=widget_button(A4_choose,value='NO',uname='No_A4mask')
                    A4_choose2=widget_Base(mask_a4,/row)
                    mask_A4_min= WIDGET_LABEL(A4_choose2,value='Min A4:')
                    mask_A4_min_txt=widget_text(A4_choose2,value='0.0',uname='a4_txt',/editable,xsize=5,/CONTEXT_EVENTS)
                    mask_A4_MAX= WIDGET_LABEL(A4_choose2,value='         Max A4:')
                    mask_A4_max_txt=widget_text(A4_choose2,value='0.0',uname='a4_txt',/editable,xsize=5,/CONTEXT_EVENTS)
            
        tol_tab=widget_base(options_tab,title='Tolerance',/row)
            tol_backgd=widget_base(tol_tab,/col)
            tol_backgd_label=widget_label(tol_backgd,value='Background Tolerance: ')
            tol_tab1=widget_base(tol_backgd,/row)
            tol_tab2=widget_base(tol_backgd,/row)
              kidney_ent=widget_base(tol_tab1,/row)
              kidney_tit=widget_label(kidney_ent,value='Kidney tolerance: ')
              kidney_tol=widget_text(kidney_ent,value='0.0',uname='kidney_tolerance',/editable,xsize=5,/CONTEXT_EVENTS)
              A3_ent=widget_base(tol_tab2,/row)
              A3_tit=widget_label(A3_ent,value=        'A3 tolerance:       ')
              A3_tol=widget_text(A3_ent,value='0.0',uname='A3_tolerance',/editable,xsize=5,/CONTEXT_EVENTS)
              Ei_ent=widget_base(tol_tab1,/row)
              Ei_tit=widget_label(Ei_ent,value='Ei tolerance: ')
              Ei_tol=widget_text(Ei_ent,value='0.0',uname='Ei_tolerance',/editable,xsize=5,/CONTEXT_EVENTS)
              Ef_ent=widget_base(tol_tab2,/row)
              Ef_tit=widget_label(Ef_ent,value='Ef tolerance: ')
              Ef_tol=widget_text(Ef_ent,value='0.0',uname='Ef_tolerance',/editable,xsize=5,/CONTEXT_EVENTS)
            
              tol_empty=widget_base(tol_tab,/col)
              tol_empty_label=widget_label(tol_backgd,value='Background Tolerance: ')
              tol_tab1=widget_base(tol_backgd,/row)
              tol_tab2=widget_base(tol_backgd,/row)
              kidney_ent=widget_base(tol_tab1,/row)
              kidney_tit=widget_label(kidney_ent,value='Kidney tolerance: ')
              kidney_tol=widget_text(kidney_ent,value='0.0',uname='kidney_tolerance',/editable,xsize=5,/CONTEXT_EVENTS)
              A3_ent=widget_base(tol_tab2,/row)
              A3_tit=widget_label(A3_ent,value=        'A3 tolerance:       ')
              A3_tol=widget_text(A3_ent,value='0.0',uname='A3_tolerance',/editable,xsize=5,/CONTEXT_EVENTS)
              Ei_ent=widget_base(tol_tab1,/row)
              Ei_tit=widget_label(Ei_ent,value='Ei tolerance: ')
              Ei_tol=widget_text(Ei_ent,value='0.0',uname='Ei_tolerance',/editable,xsize=5,/CONTEXT_EVENTS)
              Ef_ent=widget_base(tol_tab2,/row)
              Ef_tit=widget_label(Ef_ent,value='Ef tolerance: ')
              Ef_tol=widget_text(Ef_ent,value='0.0',uname='Ef_tolerance',/editable,xsize=5,/CONTEXT_EVENTS)
        
        

        latparmwids = lonarr(6)
        orientationwids = lonarr(6) 
        Smpl_tab=widget_base(options_tab,title='Orientation',/row)
            smpl_tab1=widget_base(smpl_tab,/col)
            smpl_tab2=widget_base(smpl_tab,/col)
            lattice_par=widget_label(smpl_tab1,value='Lattice parameters: ')
                lat_abc=widget_base(smpl_tab1,/row)
                lat_ang=widget_base(smpl_tab1,/row)  
                lat_a_lab=widget_label(lat_abc,value= ' a('+STRING("305B)+'):' )
                latparmwids[0]=widget_text(lat_abc,value='0.0',uname='lat_a_u',/editable,xsize=5,/CONTEXT_EVENTS)    
                
                lat_b_lab=widget_label(lat_abc,value= '  b('+STRING("305B)+'):')                
                latparmwids[1]=widget_text(lat_abc,value='0.0',uname='lat_b_u',/editable,xsize=5,/CONTEXT_EVENTS)
                                
                lat_c_lab=widget_label(lat_abc,value= '  c('+STRING("305B)+'):')                
                latparmwids[2]=widget_text(lat_abc,value='0.0',uname='lat_c_u',/editable,xsize=5,/CONTEXT_EVENTS)
                
                lat_alpa_lab=widget_label(lat_ang,value= 'a('+string("260B)+'):',font='symbol')                
                latparmwids[3]=widget_text(lat_ang,value='0.0',uname='lat_alpha_u',/editable,xsize=5,/CONTEXT_EVENTS)    

                lat_beta_lab=widget_label(lat_ang,value= ' b('+string("260B)+'):',font='symbol')                
                latparmwids[4]=widget_text(lat_ang,value='0.0',uname='lat_beta_u',/editable,xsize=5,/CONTEXT_EVENTS)                

                lat_gamma_lab=widget_label(lat_ang,value= ' g('+string("260B)+'):',font='symbol')                
                latparmwids[5]=widget_text(lat_ang,value='0.0',uname='lat_gamma_u',/editable,xsize=5,/CONTEXT_EVENTS)


            lattice_par=widget_label(smpl_tab2,value='Orientation vectors: ')
                lat_u=widget_base(smpl_tab2,/row)
                  lat_ux_lab=widget_label(lat_u,value= '   ux:' )
                  orientationwids[0]=widget_text(lat_u,value='0.0',uname='lat_ux_u',/editable,xsize=5,/CONTEXT_EVENTS)    
                  lat_uy_lab=widget_label(lat_u,value= ' uy:')
                  orientationwids[1]=widget_text(lat_u,value='0.0',uname='lat_uy_u',/editable,xsize=5,/CONTEXT_EVENTS)
                  lat_uz_lab=widget_label(lat_u,value= ' uz:')
                  orientationwids[2]=widget_text(lat_u,value='0.0',uname='lat_uz_u',/editable,xsize=5,/CONTEXT_EVENTS)
                lat_v=widget_base(smpl_tab2,/row)
                  lat_vx_lab=widget_label(lat_v,value= '   vx:' )
                  orientationwids[3]=widget_text(lat_v,value='0.0',uname='lat_vx_u',/editable,xsize=5,/CONTEXT_EVENTS)    
                  lat_vy_lab=widget_label(lat_v,value= ' vy:')
                  orientationwids[4]=widget_text(lat_v,value='0.0',uname='lat_vy_u',/editable,xsize=5,/CONTEXT_EVENTS)
                  lat_vz_lab=widget_label(lat_v,value= ' vz:')
                  orientationwids[5]=widget_text(lat_v,value='0.0',uname='lat_vz_u',/editable,xsize=5,/CONTEXT_EVENTS)
        
        
        weights_tab=widget_base(options_tab,title='Diffraction Detectors',/col)
          ws_lab=widget_label(weights_tab,value= 'Diffraction Detector Weights: ' ) 
          weight_bank1_diff=widget_base(weights_tab,/row)
          weight_bank2_diff=widget_base(weights_tab,/row)
          
          ;WIDGET IDS OF TEXT FIELDS FOR DETECTOR WEIGHTS:
          diffweights=lonarr(20)
          
          templabels = ['01 ','  02 ','  03 ','  04 ','  05 ','  06 ','  07 ','  08 ','  09 ','  10 ',$
                        '11 ','  12 ','  13 ','  14 ','  15 ','  16 ','  17 ','  18 ','  19 ','  20 ']
          for i=0,9 do begin
            w1s_lab=widget_label(weight_bank1_diff,value= templabels[i] )        
            diffweights[i] = widget_text(weight_bank1_diff,value='1.0',/editable,xsize=5)
          endfor;i
          for i=10,19 do begin
            w1s_lab=widget_label(weight_bank2_diff,value= templabels[i] )        
            diffweights[i] = widget_text(weight_bank2_diff,value='1.0',/editable,xsize=5)
          endfor;i

            mask_detectors=widget_base(weights_tab,/col);title='Mask Detectors',/column)

;MOVE TO  DIFFRACTION DETECTORS TAB
              mask_detectors_title=widget_label(mask_detectors,value='Diffraction Detector Mask:')
              all_labels=['01','02','03','04','05','06','07','08','09','10']
              diffmaskgroup1=cw_bgroup(mask_detectors,all_labels,/row,/nonexclusive,uname='det_all')
              all_labels2=['11','12','13','14','15','16','17','18','19','20']
              diffmaskgroup2=cw_bgroup(mask_detectors,all_labels2,/row,/nonexclusive,uname='det_all2')




        weights_tab_spec=widget_base(options_tab,title='Spectroscopic Detectors',/col)
        wd_lab=widget_label(weights_tab_spec,value= 'Spectroscopic Detector Weights: ' ) 
          weight_bank1_spec=widget_base(weights_tab_spec,/row)
          weight_bank2_spec=widget_base(weights_tab_spec,/row)
          
          ;WIDGET IDS OF TEXT FIELDS FOR DETECTOR WEIGHTS:
          specweights=lonarr(20)
          
          templabels = ['01 ','  02 ','  03 ','  04 ','  05 ','  06 ','  07 ','  08 ','  09 ','  10 ',$
                        '11 ','  12 ','  13 ','  14 ','  15 ','  16 ','  17 ','  18 ','  19 ','  20 ']
          for i=0,9 do begin
            w1s_lab=widget_label(weight_bank1_spec,value= templabels[i] )        
            specweights[i] = widget_text(weight_bank1_spec,value='1.0',/editable,xsize=5)
          endfor;i
          for i=10,19 do begin
            w1s_lab=widget_label(weight_bank2_spec,value= templabels[i] )        
            specweights[i] = widget_text(weight_bank2_spec,value='1.0',/editable,xsize=5)
          endfor;i

          mask_detectors=widget_base(weights_tab_spec,/col);title='Mask Detectors',/column)

          mask_detectors_title=widget_label(mask_detectors,value='Spectroscopic Detector Mask:')
          all_labels=['01','02','03','04','05','06','07','08','09','10']
          specmaskgroup1=cw_bgroup(mask_detectors,all_labels,/row,/nonexclusive,uname='det_all')
          all_labels2=['11','12','13','14','15','16','17','18','19','20']
          specmaskgroup2=cw_bgroup(mask_detectors,all_labels2,/row,/nonexclusive,uname='det_all2')
                

     Operations_tab=widget_base(options_tab,title='Operations',/col)


;SET UP THE FILE MENU        
    filemenus = widget_base(tlb,/row)
        col0 = widget_base(filemenus,/col)
        col1 = widget_base(filemenus,/col)
        col2 = widget_base(filemenus,/col)
        col3 = widget_base(filemenus,/col)

  file = widget_button(bar,/menu,value='File')
  open = widget_button(file,value='Open Session')
  save = widget_button(file,value='Save Session')
  print = widget_button(file,value='Print Images')
  quit = widget_button(file,value='Quit')


;SET UP THE DATA MANAGER
  newproj = widget_button(col0,value='New Project')
  delproj = widget_button(col0,value='Remove Project')
  renameproj = widget_button(col0,value='Rename Project')
  
  projlist = widget_list(col0,xsize=40,ysize=10,/context_events)
  
  adddata = widget_button(col1,value='Add Data')
  removedata = widget_button(col1,value='Remove Data')
  viewdataContents = widget_button(col1,value='View Data Selection Contents')
  datalist = widget_list(col1,xsize=40,ysize=10,/multiple)

  addbkg = widget_button(col2,value='Add Background')
  removebkg = widget_button(col2,value='Remove Background')
  viewbkgContents = widget_button(col2,value='View Background Selection Contents')
  bkglist = widget_list(col2,xsize=40,ysize=10,/multiple)
  addempty = widget_button(col3,value='Add Empty')
  removeempty = widget_button(col3,value='Remove Empty')
  viewEmptyContents = widget_button(col3,value='View Empty Selection Contents')
  
  emptylist = widget_list(col3,xsize=40,ysize=10,/multiple)

  allcontainer = obj_new();'idl_container')
  projcontainer = obj_new('idl_container')
  datacontainer = obj_new();'idl_container')
  bkgcontainer = obj_new();'idl_container')
  emptycontainer = obj_new();'idl_container')
;  allcontainer->add,datacontainer
;  allcontainer->add,bkgcontainer
;  allcontainer->add,emptycontainer



;SET UP THE DRAW WINDOWS
  winbase = widget_base(tlb,/row)
  winxsize=450
  winysize=300
  window,/pixmap,/free,xsize=winxsize,ysize=winysize
  diffwinpix = !d.window
  window,/pixmap,/free,xsize=winxsize,ysize=winysize
  specwinpix = !d.window
  diffdraw = widget_draw(winbase,xsize=winxsize,ysize=winysize,/motion_events,/button_events)
  specdraw = widget_draw(winbase,xsize=winxsize,ysize=winysize,/motion_events,/button_events)


;THIS SEEMS UNUSED
;; ******************  Inicialize files
;
;allfiles=ptr_new(/allocate_heap)
;emptyfiles=ptr_new(/allocate_heap)
;subsfiles=ptr_new(/allocate_heap)
;lattice=[1.,1.,1.,90.,90.,90.]
;det='spec'
;mask_a3=[0.,0.]
;mask_a4=[0.,0.]
;a3_shift=0.0
;mask_det=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0]


  centertlb,tlb
  widget_control,tlb,/realize

  widget_control,diffdraw,get_value=diffWinVis
  widget_control,specdraw,get_value=specWinVis

  state={tlb:tlb,open:open,quit:quit,save:save,print:print,$
                                               removedata:removedata,removeempty:removeEmpty,removeBkg:removeBkg,$
                                               datalist:datalist,emptylist:emptylist,bkglist:bkglist,$
                                               adddata:adddata,addbkg:addbkg,addempty:addempty,$
                                               viewDataContents:viewDataContents,$
                                               viewBkgContents:viewBkgContents,$
                                               viewEmptyContents:viewEmptyContents,$
                                               allcontainer:allcontainer,$
                                               projcontainer:projcontainer,$
                                               datacontainer:datacontainer,$
                                               bkgcontainer:bkgcontainer,$
                                               emptycontainer:emptycontainer,$
                                               writeJPG:writeJPGButton,$
                                               MSliceButton:MSliceButton,$
                                               writeMsliceToFileButton:writeMsliceToFileButton,$
                                               MSliceChoiceGroup:MSliceChoiceGroup,$
                                               MsliceXGroup:MsliceXGroup,$
                                               MsliceYGroup:MsliceYGroup,$
                                               MSliceAllGroups:MSliceAllGroups,$
                                               QuickSliceButton:QuickSliceButton,$
                                               QuickSliceXGroup:QuickSliceXGroup,$
                                               QuickSliceYGroup:QuickSliceYGroup,$
                                               projNames:ptr_new(['']),$
                                               workdir:workdir,datadir:datadir,$
                                               daveTool:daveTool,$
                                               newproj:newproj,delproj:delproj,projlist:projlist,$
                                               renameProj:renameProj,$
                                               diffWinPix:diffWinPix, diffWinVis:diffWinVis,diffDraw:diffDraw,$ 
                                               specWinPix:specWinPix, specWinVis:specWinVis,specDraw:specDraw,$
                                               diffmaskgroup1:diffmaskgroup1,diffmaskgroup2:diffmaskgroup2,$
                                               specmaskgroup1:specmaskgroup1,specmaskgroup2:specmaskgroup2,$
                                               orientations:orientationWids,lattice:latparmWids,$
                                               diffweights:diffweights,specweights:specweights,$
                                               currentproj:-1}

  pstate = ptr_new(state)
  widget_control,tlb,set_uvalue=pstate
  
  xmanager,'MACSScanManager',tlb,event_handler='MACSScanManager_event',/no_block  

end;MACSScanManager


