; $Id$
;###############################################################################
;
; NAME:
;  IN5_opan_time_REBIN_WIDGET
;
; PURPOSE:
;  This widget dialog allows the user to type in preferences for rebinning
;  the currently-loaded data set.
;
; CATEGORY:
;  DAVE, Data Analysis, PAN, curve fitting
;
;PD Dr. Philip Tregenna-Piggott,
;Laboratory for Neutron Scattering,
;ETHZ and Paul-Scherrer Institute,
;CH-5232 Villigen PSI,
;Switzerland.
;
;Tel. :+41 56 310 54 05
;Fax. :+41 56 310 29 39
;Email:philip.tregenna@psi.ch
;
;Based on the Program  opan_rebin_widget.pro by:
;   Robert M. Dimeo, Ph.D.
;   NIST Center for Neutron Research
;   100 Bureau Drive
;   Gaithersburg, MD 20899
;   Phone: (301) 975-8135
;   E-mail: robert.dimeo@nist.gov
;   http://www.ncnr.nist.gov/staff/dimeo
;
; LICENSE:
;  The software in this file is written by an employee of
;  National Institute of Standards and Technology
;  as part of the DAVE software project.
;
;  The DAVE software package is not subject to copyright protection
;  and is in the public domain. It should be considered as an
;  experimental neutron scattering data reduction, visualization, and
;  analysis system. As such, the authors assume no responsibility
;  whatsoever for its use, and make no guarantees, expressed or
;  implied, about its quality, reliability, or any other
;  characteristic. The use of certain trade names or commercial
;  products does not imply any endorsement of a particular product,
;  nor does it imply that the named product is necessarily the best
;  product for the stated purpose. We would appreciate acknowledgment
;  if the DAVE software is used of if the code in this file is
;  included in another product.
;
;###############################################################################
pro IN5_opan_time_rw,event
widget_control,event.top,get_uvalue = pState
case event.id of
(*pState).cancelButton: $
         begin
           (*pState).out.cancel = 1
           widget_control,event.top,/destroy
           return
         end
(*pState).acceptButton: $
         begin
    widget_control,(*pState).b_lo,get_value = tmin
    tmin=double(tmin[0])
    (*pState).out.tmin=tmin
    widget_control,(*pState).b_hi,get_value = tmax
    tmax=double(tmax[0])
    (*pState).out.tmax=tmax
    widget_control,(*pState).b_step,get_value = step
    step=double(step[0])
    (*pState).out.step=step
    widget_control,(*pState).b_bins,get_value = ntbins
    ntbins=fix(ntbins[0])
    (*pState).out.ntbins=ntbins
    (*pState).out.cancel = 0
    ;print,(*pState).out

    widget_control,event.top,/destroy
    return
    end
else:
endcase
uname=widget_info(event.id,/uname)
case uname of
'step':    $
begin
    ;this fixes ntbins
    widget_control,(*pState).b_step,get_value = step
    step=double(step[0])
    widget_control,(*pState).b_lo,get_value = tmin
    tmin=double(tmin[0])
    widget_control,(*pState).b_hi,get_value = tmax
    tmax=double(tmax[0])
    if step eq 0.0 then return
;    if step eq 0.0 then step =1.0
    tbins=tmin+step/2.0
;    print,tbins
    ntbins=1
    while tbins lt (tmax-step*1.49999) do begin
    tbins+=step
    ntbins+=1
;    print,tbins
    endwhile
 ;   print,''
 ;  make sure desired number of bins is not greater than total_bins
          if ntbins gt (*pState).total_bins then begin
    ntbins=(*pState).total_bins
    widget_control,(*pState).b_lo,get_value = tmin
    tmin=double(tmin[0])
    widget_control,(*pState).b_hi,get_value = tmax
    tmax=double(tmax[0])
    if ntbins lt 2 then begin
    return
    ;ntbins=2
    endif
    step=(tmax-tmin)/(ntbins)
    widget_control,(*pState).b_step,set_value = step
        endif

    widget_control,(*pState).b_bins,set_value =  ntbins
end
'ntbins':    $
begin
    ;this fixes the step
    widget_control,(*pState).b_bins,get_value = ntbins
    ntbins=fix(ntbins[0])
    if ntbins gt (*pState).total_bins then begin
    ntbins=(*pState).total_bins
    widget_control,(*pState).b_bins,set_value = ntbins
    endif
    widget_control,(*pState).b_lo,get_value = tmin
    tmin=double(tmin[0])
    widget_control,(*pState).b_hi,get_value = tmax
    tmax=double(tmax[0])
    if ntbins lt 2 then begin
    return
    ;ntbins=2
    widget_control,(*pState).b_bins,set_value = ntbins
    endif
    step=(tmax-tmin)/(ntbins)
    widget_control,(*pState).b_step,set_value = step
end
'tmin':    $
begin
    ;this fixes ntbins
    widget_control,(*pState).b_lo,get_value = tmin
    tmin=double(tmin[0])
    if tmin lt (*pState).min_t then begin
    tmin=(*pState).min_t
    widget_control,(*pState).b_lo,set_value = tmin
    endif
    widget_control,(*pState).b_step,get_value = step
    step=double(step[0])
    widget_control,(*pState).b_hi,get_value = tmax
    tmax=double(tmax[0])
    tbins=tmin+step/2.0
    ntbins=1
    while tbins lt (tmax-step*1.499) do begin
    tbins+=step
    ntbins+=1
    endwhile
     ;  make sure desired number of bins is not greater than total_bins
          if ntbins gt (*pState).total_bins then begin
    ntbins=(*pState).total_bins
    widget_control,(*pState).b_lo,get_value = tmin
    tmin=double(tmin[0])
    widget_control,(*pState).b_hi,get_value = tmax
    tmax=double(tmax[0])
    if ntbins lt 2 then begin
    return
    ;ntbins=2
    endif
    step=(tmax-tmin)/(ntbins)
    widget_control,(*pState).b_step,set_value = step
        endif




    widget_control,(*pState).b_bins,set_value =  ntbins
end
'tmax':    $
begin
    ;this fixes ntbins
    widget_control,(*pState).b_hi,get_value = tmax
    tmax=double(tmax[0])
    if tmax gt (*pState).max_t then begin
    tmax=(*pState).max_t
    widget_control,(*pState).b_hi,set_value = tmax
    endif
    widget_control,(*pState).b_step,get_value = step
    step=double(step[0])
    widget_control,(*pState).b_lo,get_value = tmin
    tmin=double(tmin[0])

    tbins=tmax-step/2.0
    ntbins=1
    while tbins gt (tmin+step*1.499) do begin
    tbins-=step
    ntbins+=1
    endwhile
     ;  make sure desired number of bins is not greater than total_bins
          if ntbins gt (*pState).total_bins then begin
    ntbins=(*pState).total_bins
    widget_control,(*pState).b_lo,get_value = tmin
    tmin=double(tmin[0])
    widget_control,(*pState).b_hi,get_value = tmax
    tmax=double(tmax[0])
    if ntbins lt 2 then begin
    return
    ;ntbins=2
    endif
    step=(tmax-tmin)/(ntbins)
    widget_control,(*pState).b_step,set_value = step
        endif

    widget_control,(*pState).b_bins,set_value =  ntbins

end
endcase

return
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
function IN5_opan_time_rebin_widget,tmin,tmax,ntbins,step,x,group_leader = group_leader
if n_elements(group_leader) eq 0 then begin
  tlb = widget_base(/col,title = ' Time Rebinning Utility',/tlb_frame_attr)
endif else begin
  tlb = widget_base(group_leader = group_leader, /col,/modal, $
        title = 'Time Rebinning Utility',/tlb_frame_attr)
endelse
total_bins=n_elements(x)
max_t=max(x)
min_t=min(x)
;
;
base = widget_base(tlb,/row)
base1 = widget_base(base,/col,/frame)
void = widget_label(base1,value = 'Current Binning')
nb_bins = cw_field(base1,/row,value = string(ntbins),title = '# of bins',/noedit)
nb_lo = cw_field(base1,/row,value = string(tmin),title = 'Lower Time Limit',/noedit)
nb_high= cw_field(base1,/row,value = string(tmax),title = 'Upper Time Limit',/noedit)
nb_step= cw_field(base1,/row,value = string(step),title = 'Step Size',/noedit)

base2 = widget_base(base,/col,/frame)
void = widget_label(base2,value = 'Desired Binning')
b_bins = cw_field(base2,/row,uname='ntbins',value = string(ntbins),title = '# of bins',/return_events)
b_lo = cw_field(base2,/row,uname='tmin',value = string(tmin),title = 'Lower Time Limit',/return_events)
b_hi = cw_field(base2,/row,uname='tmax',value = string(tmax),title = 'Upper Time Limit',/return_events)
b_step= cw_field(base2,/row,uname='step',value = string(step),title = 'Step Size',/return_events)
;

acceptButton = widget_button(tlb,value = 'Accept')
cancelButton = widget_button(tlb,value = 'Cancel')


widget_control,tlb,/realize

out = {tmin:tmin,tmax:tmax,step:step,ntbins:ntbins,cancel:1}
state = {out:out, $
         b_bins:b_bins,b_lo:b_lo,b_hi:b_hi,b_step:b_step, $
         total_bins:total_bins,max_t:max_t,min_t:min_t, $
         cancelButton:cancelButton, $
         acceptButton:acceptButton}

pState = ptr_new(state,/no_copy)
widget_control,tlb,set_uvalue = pState

xmanager,'IN5_opan_time_rebin_widget',tlb,event_handler = 'IN5_opan_time_rw'

out = (*pState).out
ptr_free,pState
return,out
end