; $Id: sine_cam_funq.pro,v 1.3 2005/02/09 16:58:01 dimeo Exp $
;###############################################################################
;
; NAME:
;  SINE_CAM_FUNQ
;
; PURPOSE:
;  Sine cam function implementation for the time-to-energy conversion
;  for the HFBS data.
;
; CATEGORY:
;  DAVE, HFBS, data reduction
;
; AUTHOR:
;   Robert M. Dimeo, Ph.D.
;   NIST Center for Neutron Research
;   100 Bureau Drive
;   Gaithersburg, MD 20899
;   Phone: (301) 975-8135
;   E-mail: robert.dimeo@nist.gov
;   http://www.ncnr.nist.gov/staff/dimeo
;
; LICENSE:
;  The software in this file is written by an employee of
;  National Institute of Standards and Technology
;  as part of the DAVE software project.
;
;  The DAVE software package is not subject to copyright protection
;  and is in the public domain. It should be considered as an
;  experimental neutron scattering data reduction, visualization, and
;  analysis system. As such, the authors assume no responsibility
;  whatsoever for its use, and make no guarantees, expressed or
;  implied, about its quality, reliability, or any other
;  characteristic. The use of certain trade names or commercial
;  products does not imply any endorsement of a particular product,
;  nor does it imply that the named product is necessarily the best
;  product for the stated purpose. We would appreciate acknowledgment
;  if the DAVE software is used of if the code in this file is
;  included in another product.
;
;###############################################################################
;==========================================
function sine_cam_funQ,npts,f
; function returns the doppler profile over one
; complete cycle for the sine cam.
; f: oscillation frequency of doppler drive

pi = !Pi
beta = pi
amp = 0.045
velocity = Fltarr(npts)
w = 2.0*pi*f
channels = Fltarr(npts)
channels = Findgen(npts)
velocity = w*amp*Sin(2.0*!pi*channels/npts-0.5*pi)
tnew = Fltarr(npts)
thi = 1.0/f & dt = thi/(npts-1)
tnew = dt*Findgen(npts)
data = Fltarr(2,npts)
data[0,0:npts-1] = tnew[0:npts-1]
data[1,0:npts-1] = velocity[0:npts-1]

Return,data

end