; $Id$
;###############################################################################
;
; NAME:
;  OPAN_Q_REBIN_WIDGET
;
; PURPOSE:
;  This widget dialog allows the user to type in preferences for rebinning
;  the currently-loaded data set.
;
; CATEGORY:
;  FOCUS Utilities
;
;PD Dr. Philip Tregenna-Piggott,
;Laboratory for Neutron Scattering,
;ETHZ and Paul-Scherrer Institute,
;CH-5232 Villigen PSI,
;Switzerland.
;
;Tel. :+41 56 310 54 05
;Fax. :+41 56 310 29 39
;Email:philip.tregenna@psi.ch
;
;Based on the Program  opan_rebin_widget.pro by:
;   Robert M. Dimeo, Ph.D.
;   NIST Center for Neutron Research
;   100 Bureau Drive
;   Gaithersburg, MD 20899
;   Phone: (301) 975-8135
;   E-mail: robert.dimeo@nist.gov
;   http://www.ncnr.nist.gov/staff/dimeo
;
; LICENSE:
;  The software in this file is written by an employee of
;  National Institute of Standards and Technology
;  as part of the DAVE software project.
;
;  The DAVE software package is not subject to copyright protection
;  and is in the public domain. It should be considered as an
;  experimental neutron scattering data reduction, visualization, and
;  analysis system. As such, the authors assume no responsibility
;  whatsoever for its use, and make no guarantees, expressed or
;  implied, about its quality, reliability, or any other
;  characteristic. The use of certain trade names or commercial
;  products does not imply any endorsement of a particular product,
;  nor does it imply that the named product is necessarily the best
;  product for the stated purpose. We would appreciate acknowledgment
;  if the DAVE software is used of if the code in this file is
;  included in another product.
;
;###############################################################################
pro opan_Q_rw,event
widget_control,event.top,get_uvalue = pstate
case event.id of
(*pstate).cancelButton: $
         begin
           (*pstate).out.cancel = 1
           widget_control,event.top,/destroy
           return
         end
(*pstate).acceptButton: $
         begin
    widget_control,(*pstate).b_lo,get_value = qmin
    qmin=double(qmin[0])
    (*pstate).out.qmin=qmin
    widget_control,(*pstate).b_hi,get_value = qmax
    qmax=double(qmax[0])
    (*pstate).out.qmax=qmax
    widget_control,(*pstate).b_step,get_value = step
    step=double(step[0])
    (*pstate).out.step=step
    widget_control,(*pstate).b_bins,get_value = nqbins
    nqbins=fix(nqbins[0])
    (*pstate).out.nqbins=nqbins
    (*pstate).out.cancel = 0
    ;print,(*pstate).out

    widget_control,event.top,/destroy
    return
    end
(*pstate).ResetButton: $
         begin
    widget_control,(*pstate).nb_bins,get_value = nqbins
    widget_control,(*pstate).b_bins,set_value = nqbins
    widget_control,(*pstate).nb_lo,get_value = qmin
    widget_control,(*pstate).b_lo,set_value = qmin
    widget_control,(*pstate).nb_hi,get_value = qmax
    widget_control,(*pstate).b_hi,set_value = qmax
    widget_control,(*pstate).nb_step,get_value = step
    widget_control,(*pstate).b_step,set_value = step
           return
         end
else:
endcase
uname=widget_info(event.id,/uname)
case uname of
'step':    $
begin
    ;this fixes nqbins
    widget_control,(*pstate).b_step,get_value = step
    step=double(step[0])
    widget_control,(*pstate).b_lo,get_value = qmin
    qmin=double(qmin[0])
    widget_control,(*pstate).b_hi,get_value = qmax
    qmax=double(qmax[0])
    if step eq 0.0 then return
;    if step eq 0.0 then step =1.0
    qbins=qmin+step/2.0
;    print,qbins
    nqbins=1
    while qbins lt (qmax-step*1.49999) do begin
    qbins+=step
    nqbins+=1
;    print,qbins
    endwhile
 ;   print,''
    widget_control,(*pstate).b_bins,set_value =  nqbins
end
'nqbins':    $
begin
    ;this fixes the step
    widget_control,(*pstate).b_bins,get_value = nqbins
    nqbins=fix(nqbins[0])
    widget_control,(*pstate).b_lo,get_value = qmin
    qmin=double(qmin[0])
    widget_control,(*pstate).b_hi,get_value = qmax
    qmax=double(qmax[0])
    if nqbins lt 2 then begin
    return
    ;nqbins=2
    widget_control,(*pstate).b_bins,set_value = nqbins
    endif
    step=(qmax-qmin)/(nqbins)
    widget_control,(*pstate).b_step,set_value = step
end
'qmin':    $
begin
    ;this fixes nqbins
        widget_control,(*pstate).b_step,get_value = step
    step=double(step[0])
    widget_control,(*pstate).b_lo,get_value = qmin
    qmin=double(qmin[0])
    widget_control,(*pstate).b_hi,get_value = qmax
    qmax=double(qmax[0])
    qbins=qmin+step/2.0
    nqbins=1
    while qbins lt (qmax-step*1.49999) do begin
    qbins+=step
    nqbins+=1
    endwhile
    widget_control,(*pstate).b_bins,set_value =  nqbins
end
'qmax':    $
begin
    ;this fixes nqbins
    widget_control,(*pstate).b_step,get_value = step
    step=double(step[0])
    widget_control,(*pstate).b_lo,get_value = qmin
    qmin=double(qmin[0])
    widget_control,(*pstate).b_hi,get_value = qmax
    qmax=double(qmax[0])

    qbins=qmax-step/2.0
    nqbins=1
    while qbins gt (qmin+step*1.49999) do begin
    qbins-=step
    nqbins+=1
    endwhile
    widget_control,(*pstate).b_bins,set_value =  nqbins

end
endcase

return
end
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro launch_Neutron_calc,event
widget_control,event.top,get_uvalue = pstate
LambdaEntry=(*pstate).LambdaEntry
neut_calc,group_leader=event.top,LambdaEntry = LambdaEntry
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
function opan_Q_rebin_widget,LambdaEntry,qmin,qmax,nqbins,step,group_leader = group_leader

  tlb = widget_base(/col,title = ' Q Rebinning Utility',/tlb_frame_attr)

;if n_elements(group_leader) eq 0 then begin
;  tlb = widget_base(/col,title = ' Q Rebinning Utility',/tlb_frame_attr)
;endif else begin
   ; tlb = widget_base(group_leader = group_leader, /col,/modal, $
 ;       title = 'Q Rebinning Utility',/tlb_frame_attr)
;endelse
;step=(qmax-qmin)/(nqbins)
base = widget_base(tlb,/row)

base1 = widget_base(base,/col,/frame)
void = widget_label(base1,value = 'Current Binning')
nb_bins = cw_field(base1,/row,value = string(nqbins),title = '# of bins',/noedit)
nb_lo = cw_field(base1,/row,value = string(qmin),title = 'Lower Q limit',/noedit)
nb_hi= cw_field(base1,/row,value = string(qmax),title = 'Upper Q limit',/noedit)
nb_step= cw_field(base1,/row,value = string(step),title = 'Step Size',/noedit)

base2 = widget_base(base,/col,/frame)
void = widget_label(base2,value = 'Desired Binning')
b_bins = cw_field(base2,/row,uname='nqbins',value = string(nqbins),title = '# of bins',/return_events)
b_lo = cw_field(base2,/row,uname='qmin',value = string(qmin),title = 'Lower Q limit',/return_events)
b_hi = cw_field(base2,/row,uname='qmax',value = string(qmax),title = 'Upper Q limit',/return_events)
b_step= cw_field(base2,/row,uname='step',value = string(step),title = 'Step Size',/return_events)
;



ResetButton = widget_button(base1,value = 'Reset')

Neut_Calc_Button = widget_button(base1,value = 'View Accessible Q-Range', $
              event_pro='launch_Neutron_calc')

cancelButton = widget_button(base2,value = 'Cancel')
acceptButton = widget_button(base2,value = 'Accept')

centertlb,tlb

widget_control,tlb,/realize

out = {qmin:qmin,qmax:qmax,step:step,nqbins:nqbins,cancel:1}
state = {out:out, $
         b_bins:b_bins,b_lo:b_lo,b_hi:b_hi,b_step:b_step, $
         nb_bins:nb_bins,nb_lo:nb_lo,nb_hi:nb_hi,nb_step:nb_step, $
         cancelButton:cancelButton, $
         acceptButton:acceptButton, $
         ResetButton:ResetButton, $
         LambdaEntry:LambdaEntry}


pstate = ptr_new(state,/no_copy)
widget_control,tlb,set_uvalue = pstate

xmanager,'opan_Q_rebin_widget',tlb,event_handler = 'opan_Q_rw'

out = (*pstate).out
ptr_free,pstate
return,out
end