;-------------------------------------------------------------------------------
; Purpose
;   Get method
;===============================================================================
pro IDLitVisMolecule::cleanup
compile_opt idl2


;arr = *self._orb
print,'IDLitVisMolecule::cleanup'
atoms = self->get(/all)
obj_destroy,atoms
ptr_free,self.list

self->IDLitVisualization::cleanup

end


;-------------------------------------------------------------------------------
; Purpose
;   Get method
;===============================================================================
pro IDLitVisMolecule::setProperty, parent=parent $
    ,transparency=transparency $
    ,xpos=xpos $
    ,ypos=ypos $
    ,zpos=zpos $
    ,_EXTRA=etc
compile_opt idl2

;; Parent requires careful handling since any IDLitComponent should
;; only have 1 parent
if (n_elements(parent) gt 0) then $
    self->IDLgrModel::setProperty, parent=parent


;LOOP OVER ALL THE ATOMS AND SET THE VARIOUS PROPERTIES.
;BUT ONLY LOOP IF AT LEAST ONE OF THE PROPERTIES NEEDS SETTING.
if (n_elements(xpos) gt 0) or $
   (n_elements(ypos) gt 0) or $
   (n_elements(zpos) gt 0) or $
   (n_elements(etc) gt 0) then begin

        natoms = self->count()
        for i = 0,natoms-1 do begin
          ref = self->get(position=i)
          
          ;ref->getproperty, pos = pos
          pos = [((*self.list)[i]).x,((*self.list)[i]).y,((*self.list)[i]).z]
          if (n_elements(xpos) gt 0) then pos[0] = pos[0] + xpos         
          if (n_elements(ypos) gt 0) then pos[1] = pos[1] + ypos         
          if (n_elements(zpos) gt 0) then pos[2] = pos[2] + zpos         

          ref->setproperty, pos = pos
          if (n_elements(transparency) gt 0) then $
                ref->setproperty, alpha_channel=0 > ((100.0 - transparency)/100) < 1              
          if (n_elements(etc) gt 0) then ref->setproperty, _EXTRA=etc 

        endfor;i
endif

;; Call the set method on the base class and orb component
if (n_elements(etc) gt 0) then begin
    self->IDLitVisualization::setProperty, _EXTRA=etc
endif


end;setproperty


;-------------------------------------------------------------------------------
; Purpose
;   Get method
;===============================================================================
pro IDLitVisMolecule::getProperty, transparency=transparency $
    ,xpos=xpos $
    ,ypos=ypos $
    ,zpos=zpos $
    ,_REF_EXTRA=etc
compile_opt idl2


if arg_present(transparency) then begin
    ref = self->get(position=0)
    ref->getproperty, alpha_channel=alpha
    transparency = 0 > fix(100 - alpha * 100) < 100
endif

if (arg_present(xpos) || arg_present(ypos) || arg_present(zpos)) then begin

    ref = self->get(position=0)
    list = *self.list

    ;GET THE ORIGINAL POSITION
    pos0 = [list[0].x,list[0].y,list[0].z]
    
    ;GET THE CURRENT POSITION
    ref->getproperty, pos=pos

    ;REPORT THE DIFFERENCE
    xpos = pos0[0] - pos[0]
    ypos = pos0[1] - pos[1]
    zpos = pos0[2] - pos[2]
endif

;; Call the get method on the base class and orb component
if (n_elements(etc) gt 0) then begin
    ref = self->get(position=0)
    ref->getproperty, _Extra=etc
    self._orb->getproperty, _EXTRA=etc
    self->IDLitVisualization::getProperty, _EXTRA=etc
endif

end;getproperty



;-------------------------------------------------------------------------------
; IDLitVisMolecule::Restore
;
; Purpose:
;   This procedure method performs any cleanup work required after
;   an object of this class has been restored from a save file to
;   ensure that its state is appropriate for the current revision.
;
;===============================================================================
pro IDLitVisMolecule::Restore
compile_opt idl2

;; Call superclass restore.
self->_IDLitVisualization::Restore

;; Call ::GetProperty on each aggregated graphic object
;; to force its internal restore process to be called, thereby
;; ensuring any new properties are registered.
if (obj_valid(self._orb)) then self._orb->GetProperty

;; Register new properties.
self->IDLitVisMolecule::_RegisterProperties, update_from_version=self.idlitcomponentversion

end


;===============================================================================
function IDLitVisMolecule::init, name=name, description=desc, _REF_EXTRA=etc
compile_opt idl2


;help,/traceback
void = dialog_message('IDLitVisMolecule::init      Continue:',/question)


;THE NEW PROJECT FORMAT WILL REQUIRE MULTIPLE COPIES OF THE 
;RELEVANT FILES, ONE IN EACH PROJECT DRIECTORY.  NO LONGER CAN I GRAB
;FILES FROM ALL OVER MY COMPUTER.  ONE PROJECT, ONE DIRECTORY!!!!!  FUCK YOU PEOPLE!!!!
ret = readcifSpecial(atoms,x,y,z,list=list,bonds=bonds,ucboxpoints=ucboxpoints,abc=abc,abg=abg)
;x,y,z ALREADY CONVERTED
print,'ret=',ret
print,'abc=',abc
print,'abg=',abg



print,'self is a model? ',obj_isa(self,'idlgrmodel')

print,'IDLitVisMolecule::init'





if (~keyword_set(name)) then name = 'Molecule'
if (~keyword_set(desc)) then desc = 'Set of Spherical Graphic Atom'

;; Initialize superclass
if (not self->IDLitVisualization::Init(name=name $
                                       ,type='IDLMOLECULE' $
                                       ,icon='demo' $
                                       ,description=desc $
                                       ,/MANIPULATOR_TARGET $
                                       ,_EXTRA=etc)) $
  then begin
    void = dialog_message('not self->IDLitVisualization::init',/warning)
  	return, 0

  endif

; Create an orb and add it to self
; use /private so that this orb will not be displayed seperately in the iTool browser window
; use /register_properties to register properties defined within the orb class

self.list = ptr_new(list)
for i=0,n_elements(list)-1 do begin

	atom = obj_new('orb',pos=[list[i].x,list[i].y,list[i].z],color = list[i].color)
	self->add,atom

endfor;i
self._orb = obj_new('orb',/register_properties,_EXTRA=etc,/private)
print,obj_isa(self._orb,'idlgrpolygon')
help,self._orb
self->add, self._orb

print,'Added an orb!!!'

;self->RegisterParameter, 'GRAPHICS OBJECT', $
;  DESCRIPTION='A IDL Object Graphics element.', $
;  /OPTARGET, /INPUT, TYPES='IDLGROBJECT'


;; Register properties
self->registerProperty,'RADIUS',/float,name='Orb radius',description='Radius of sphere in data units'

self->registerProperty,'DENSITY',/float,name='Density' $
  ,description='Density at which vertices are generated along the orb surface'

self->registerProperty,'STYLE',name='Style',description='Style polygon to be drawn',enumlist=['0','1','2']

self->registerProperty,'COLOR',/color,name='Color',description='Orb Color'

self->registerProperty,'SPECULAR',/color,name='Specular highlight color',description='Specify the color of the specular highlights of this object'

self->registerProperty,'SHADING',name='Shading',description='Type of shading to use',enumlist=['0','1']

desc = 'Higher values of shininess concentrate specular highlights into smaller and brighter areas'
self->registerProperty,'SHININESS',/float,name='Shininess',description=desc,valid_range=[0.0,128.0,5.0]

self->registerProperty, 'TRANSPARENCY', /INTEGER, name='Transparency',description='Transparency of Orb',valid_range=[0,100,5]

self->registerProperty,'XPOS',/float,name='X Position',description='X Coordinate of Orb'
self->registerProperty,'YPOS',/float,name='Y Position',description='Y Coordinate of Orb'
self->registerProperty,'ZPOS',/float,name='Z Position',description='Z Coordinate of Orb'
;self->registerProperty,'',/,name='',description=''
;self->registerProperty,'',/,name='',description=''
;self->registerProperty,'',/,name='',description=''
;self->registerProperty,'',/,name='',description=''
;self->registerProperty,'',/,name='',description=''
;self->registerProperty,'',/,name='',description=''






self->aggregate, self._orb      ; aggregate the orb properties (ie those defined for its IDLgrPolygon component)


return, 1                       ; Success

end


;===============================================================================
pro IDLitVisMolecule__Define
compile_opt idl2

struct = {IDLitVisMolecule,           $
          inherits IDLitVisualization,$ ; Superclass: _IDLitVisualization
          list:ptr_new(),$  
          _orb:obj_new() $
         }

end
