; $Id$
;See e.g. P. 121 in iTools Develpers Guide.

;LRK - 111008
;ORIGINAL init METHOD
;function denproVisUCOutline::init,abc=abc,abg=abg,_REF_Extra=_Extra
;
;    if (self->IDLitVisualization::init(/register_properties,$
;                                       type='denproVisUCOutline',$
;                                       name='denproVisUCOutline Visualization',$
;                                       icon='plot',$
;                                       /private,$
;                                       _Extra=_Extra) ne 1) then return,0 
;
;  self->registerParameter,'ABC',description='ABC Unit Cell Lengths',$
;                               /input,$
;                               types='IDLVECTOR',$
;                               /optarget
;                               
;  self->registerParameter,'ABG',description='ABG Unit Cell Angles',$
;                               /input,$
;                               types='IDLVECTOR',$
;                               /optarget
;                               
;  if n_elements(abc) eq 3 then begin
;    self.abc = abc
;  endif else begin
;    self.abc = (1.0/(2*!PI))*(fltarr(3)+1)
;  endelse
;  if n_elements(abg) eq 3 then begin
;    self.abg = abg
;  endif else begin
;    self.abg = (fltarr(3) + 90)
;  endelse
;;  self._a1_01 = obj_new('DenPropolyline',parent=self)
;;  self->add,self._a1_01,/aggregate 
;;  self._a1_32 = obj_new('DenPropolyline',parent=self)
;;  self->add,self._a1_32,/aggregate  
;;  self._a1_45 = obj_new('DenPropolyline',parent=self)
;;  self->add,self._a1_45,/aggregate
;;  self._a1_76 = obj_new('DenPropolyline',parent=self)
;;  self->add,self._a1_76,/aggregate
;;  self._a2_03 = obj_new('DenPropolyline',parent=self)
;;  self->add,self._a2_03,/aggregate
;;  self._a2_12 = obj_new('DenPropolyline',parent=self)
;;  self->add,self._a2_12,/aggregate
;;  self._a2_47 = obj_new('DenPropolyline',parent=self)
;;  self->add,self._a2_47,/aggregate
;;  self._a2_56 = obj_new('DenPropolyline',parent=self)
;;  self->add,self._a2_56,/aggregate
;;  self._a3_04 = obj_new('DenPropolyline',parent=self)
;;  self->add,self._a3_04,/aggregate
;;  self._a3_15 = obj_new('DenPropolyline',parent=self)
;;  self->add,self._a3_15,/aggregate
;;  self._a3_26 = obj_new('DenPropolyline',parent=self)
;;  self->add,self._a3_26,/aggregate
;;  self._a3_37 = obj_new('DenPropolyline',parent=self)
;;  self->add,self._a3_37,/aggregate
;
;  self._a1_01 = obj_new('denprobond',parent=self)
;  self->add,self._a1_01,/aggregate 
;  self._a1_32 = obj_new('denprobond',parent=self)
;  self->add,self._a1_32,/aggregate  
;  self._a1_45 = obj_new('denprobond',parent=self)
;  self->add,self._a1_45,/aggregate
;  self._a1_76 = obj_new('denprobond',parent=self)
;  self->add,self._a1_76,/aggregate
;  self._a2_03 = obj_new('denprobond',parent=self)
;  self->add,self._a2_03,/aggregate
;  self._a2_12 = obj_new('denprobond',parent=self)
;  self->add,self._a2_12,/aggregate
;  self._a2_47 = obj_new('denprobond',parent=self)
;  self->add,self._a2_47,/aggregate
;  self._a2_56 = obj_new('denprobond',parent=self)
;  self->add,self._a2_56,/aggregate
;  self._a3_04 = obj_new('denprobond',parent=self)
;  self->add,self._a3_04,/aggregate
;  self._a3_15 = obj_new('denprobond',parent=self)
;  self->add,self._a3_15,/aggregate
;  self._a3_26 = obj_new('denprobond',parent=self)
;  self->add,self._a3_26,/aggregate
;  self._a3_37 = obj_new('denprobond',parent=self)
;  self->add,self._a3_37,/aggregate
;
;
;  self->registerProperty,'MyName',$
;                         /string,$
;                         description='MyName',$
;                         name='MyName',$
;                         sensitive=1
;
;                         
;                        
;  if n_elements(_Extra) gt 0 then self->denprovisUCOutline::setProperty,_Extra=_Extra
;  
;  
;  return,1                       
;end;denproVisUCOutline::init
function denproVisUCOutline::init,abc=abc,abg=abg,_REF_Extra=_Extra

    if (self->IDLitVisualization::init(/register_properties,$
                                       type='denproVisUCOutline',$
                                       name='denproVisUCOutline Visualization',$
                                       icon='plot',$
                                       /private,$
                                       /MANIPULATOR_TARGET,$
                                       _Extra=_Extra) ne 1) then return,0 

  self->registerParameter,'ABC',description='ABC Unit Cell Lengths',$
                               /input,$
                               types='IDLVECTOR',$
                               /optarget
                               
  self->registerParameter,'ABG',description='ABG Unit Cell Angles',$
                               /input,$
                               types='IDLVECTOR',$
                               /optarget
                               
  if n_elements(abc) eq 3 then begin
    self.abc = abc
  endif else begin
    self.abc = (1.0/(2*!PI))*(fltarr(3)+1)
  endelse
  if n_elements(abg) eq 3 then begin
    self.abg = abg
  endif else begin
    self.abg = (fltarr(3) + 90)
  endelse
  self._a1_01 = obj_new('idlitvispolyline',parent=self)
  self->add,self._a1_01,/aggregate 
  self._a1_32 = obj_new('idlitvispolyline',parent=self)
  self->add,self._a1_32,/aggregate  
  self._a1_45 = obj_new('idlitvispolyline',parent=self)
  self->add,self._a1_45,/aggregate
  self._a1_76 = obj_new('idlitvispolyline',parent=self)
  self->add,self._a1_76,/aggregate
  self._a2_03 = obj_new('idlitvispolyline',parent=self)
  self->add,self._a2_03,/aggregate
  self._a2_12 = obj_new('idlitvispolyline',parent=self)
  self->add,self._a2_12,/aggregate
  self._a2_47 = obj_new('idlitvispolyline',parent=self)
  self->add,self._a2_47,/aggregate
  self._a2_56 = obj_new('idlitvispolyline',parent=self)
  self->add,self._a2_56,/aggregate
  self._a3_04 = obj_new('idlitvispolyline',parent=self)
  self->add,self._a3_04,/aggregate
  self._a3_15 = obj_new('idlitvispolyline',parent=self)
  self->add,self._a3_15,/aggregate
  self._a3_26 = obj_new('idlitvispolyline',parent=self)
  self->add,self._a3_26,/aggregate
  self._a3_37 = obj_new('idlitvispolyline',parent=self)
  self->add,self._a3_37,/aggregate



  self->registerProperty,'MyName',$
                         /string,$
                         description='MyName',$
                         name='MyName',$
                         sensitive=1

                         
                        
  if n_elements(_Extra) gt 0 then self->denprovisUCOutline::setProperty,_Extra=_Extra
  
  
  return,1                       
end;denproVisUCOutline::init


pro denproVisUCOutline::cleanup
  print,'denproVisUCOutline::cleanup'
  obj_destroy,self._a1_01
  obj_destroy,self._a1_32
  obj_destroy,self._a1_45
  obj_destroy,self._a1_76
  obj_destroy,self._a2_03
  obj_destroy,self._a2_12
  obj_destroy,self._a2_47
  obj_destroy,self._a2_56
  obj_destroy,self._a3_04
  obj_destroy,self._a3_15
  obj_destroy,self._a3_26
  obj_destroy,self._a3_37


  self->IDLitVisualization::Cleanup
  
end;denproVisUCOutline::cleanup

pro DenProVisUCOutline::getProperty,$
    myName=myName,$
    abc=abc,abg=abg,$
    _Ref_Extra=_Extra

  if arg_present(myName) then begin
    myName=self.myName
  endif
  if arg_present(abc) then begin
    abc = self.abc
  endif
  if arg_present(abg) then begin
    abg = self.abg
  endif
  
  if n_elements(_Extra) gt 0 then self->IDLitVisualization::getProperty,_Extra=_Extra
    
end;DenProVisUCOutline::getProperty

pro DenProVisUCOutline::setProperty,$
    myName=myName,$
    abc=abc,abg=abg,$
    _Ref_Extra=_Extra
  print,'DenProVisUCOutline::setProperty'
  if n_elements(myName) then begin
    self.myName=myName
  endif
  if n_elements(abc) eq 3 then begin
    self.abc = abc
    oABC = OBJ_NEW('IDLitDataIDLVector', $
                     abc,$
                     NAME='ABC', TYPE='IDLVector')
    result = self->SetData(oABC,parameter_name='ABC')
    print,'abc set data'
  endif
  if n_elements(abg) eq 3 then begin
    self.abg = abg
    oABG = OBJ_NEW('IDLitDataIDLVector', $
                     abg,$
                     NAME='ABG', TYPE='IDLVector')
    result = self->SetData(oABG,parameter_name='ABG')
  endif


  if n_elements(_Extra) gt 0 then self->IDLitVisualization::setProperty,_Extra=_Extra
    
end;DenProVisUCOutline::setProperty

pro DenProVisUCOutline::setBondValues,xvals,yvals,zvals

      print,'DenProVisUCOutline::setBondValues'
              oABC = self->getByName('ABC')
              oABG = self->getByName('ABG')

        if (obj_valid(oABG) ne 0) and (obj_valid(oABG) ne 0) then begin
              result = oABC->getData(abc)
              result = oABG->getData(abg)
              ;print,'abc,abg=',abc,abg
        endif
              abc = self.abc
              abg = self.abg

              duh = ThreeDenPro_createVolVertices(abc,abg,corners=corners)
              xvals = reform(corners[0,*])
              yvals = reform(corners[1,*])
              zvals = reform(corners[2,*])
              ;print,'xvals=',transpose(xvals)
              ;print,'yvals=',transpose(yvals)
              ;print,'zvals=',transpose(zvals)

              ibeg = [0,3,4,7,0,1,4,5,0,1,2,3]
              iend = [1,2,5,6,3,2,7,6,4,5,6,7]
              color = [[255,0,0],$
                       [255,0,0],$
                       [255,0,0],$
                       [255,0,0],$
                       [0,255,0],$
                       [0,255,0],$
                       [0,255,0],$
                       [0,255,0],$
                       [0,0,255],$
                       [0,0,255],$
                       [0,0,255],$
                       [0,0,255]]

              arr = [ self._a1_01,$
                      self._a1_32,$
                      self._a1_45,$
                      self._a1_76,$
                      self._a2_03,$
                      self._a2_12,$
                      self._a2_47,$
                      self._a2_56,$
                      self._a3_04,$
                      self._a3_15,$
                      self._a3_26,$
                      self._a3_37]
              for i = 0,n_elements(arr)-1 do begin        
                bondbegin = [xvals[ibeg[i]],yvals[ibeg[i]],zvals[ibeg[i]]]
                bondend   = [xvals[iend[i]],yvals[iend[i]],zvals[iend[i]]]
                arr[i]->setProperty,data=[[bondbegin],[bondend]],$;bondbegin=bondbegin,bondend=bondend
                                    color=reform(color[*,i]),thick = 5
;                arr[i]->setProperty,x=[bondbegin[0],bondend[0]],$
;                                    y=[bondbegin[1],bondend[1]],$
;                                    z=[bondbegin[2],bondend[2]],$
;                                    color=reform(color[*,i])
              endfor;i

end;DenProVisUCOutline::setBondValues


pro DenProVisUCOutline::onDataChangeUpdate,oSubject,parmName

;WHEN DOES THE SYSTEM SET THE PARAMETERS I HAVE REGISTERED??????
;IF I TRY TO SET THEM HERE I SEND THE PROGRAM INTO AN INFINITE LOOP!!!!

  case strupcase(parmName) of
  '<PARAMETER SET>':begin
    oParams = oSubject->get(/all, count=nParam, name=paramnames)
    for i=0,nparam-1 do begin
      if paramnames[i] eq '' then continue
      odata = osubject->getByName(paramnames[i])
      if obj_valid(odata) then self->onDataChangeUpdate,oData,paramnames[i]  
    endfor;i
  end;'<PARAMETER SET>'
  'ABC':begin
    success = oSubject->getData(data)
    ndata = n_elements(data)
    if ndata eq 3 then begin
            self.abc = data
;            oABC = self->GetByName('ABC')
;            ;PROVIDE THE FOLLOWING CHECK TO AVOID INFINITE LOOP
;            if self.abcStopLoop eq 0 then begin
;              if obj_valid(oABC) then begin
;                result = oABC->getData(abc)
;                for i =0,n_elements(abc)-1 do begin
;                  ;ONLY CALL self->setData IF THERE WAS A CHANGE TO AVOIS INFINITE LOOP                
;                  if abc[i] ne data[i] then begin
;                    result = self->setData(osubject,parameter_name='ABC');data,parameter_name='ABC')
;                    self.abcStopLoop = 1
;                    break
;                  endif 
;                endfor;i
;              endif else begin
;                    result = self->setData(osubject,parameter_name='ABC');data,parameter_name='ABC')
;                    self.abcStopLoop = 1
;              endelse
;              oABG = self->GetByName('ABG')
;              if obj_valid(oABG) then begin
                ;SET THE BOND VALUES IF BOTH ABC AND ABG PARAMETERS ARE SET
                self->setBondValues,xvals,yvals,zvals
;              endif
;            endif else begin;abcStopLoop
;              self.abcStopLoop = 0
;              return
;            endelse
    endif
  end;'ABC'
  'ABG':begin
    success = oSubject->getData(data)
    ndata = n_elements(data)
    if ndata eq 3 then begin
            self.abg = data

            ;PROVIDE THE FOLLOWING CHECK TO AVOID INFINITE LOOP
;            if self.abgStopLoop eq 0 then begin
;              oABG = self->GetByName('ABG')
;              if obj_valid(oABC) then begin
;                result = oABG->getData(abg)
;                for i =0,n_elements(abc)-1 do begin
;                  ;ONLY CALL self->setData IF THERE WAS A CHANGE TO AVOIS INFINITE LOOP
;                  if abc[i] ne data[i] then begin
;                    result = self->setData(osubject,parameter_name='ABG');data,parameter_name='ABG')
;                    self.abgStopLoop = 1
;                    break
;                  endif 
;                endfor;i
;              endif else begin
;                    result = self->setData(osubject,parameter_name='ABG');data,parameter_name='ABG')
;                    self.abgStopLoop = 1
;              endelse
;              oABC = self->GetByName('ABC')
;              if obj_valid(oABC) then begin
                self->setBondValues,xvals,yvals,zvals
;              endif
;            endif else begin;abcStopLoop
;              self.abcStopLoop = 0
;              return
;            endelse
    endif              
  end;'ABG'
  else:
  endcase

end;DenProVisUCOutline::onDataChangeUpdate


pro DenProVisUCOutline::onDataDisconnect,parmName
  case parmname of
  'ABC':begin
              bondbegin = [0.,0.,0.]
              bondend   = [1.,1.,1.]
              self._a1_01->setProperty,data=[[bondbegin],[bondend]];bondbegin=bondbegin,bondend=bondend
              self._a1_32->setProperty,data=[[bondbegin],[bondend]];bondbegin=bondbegin,bondend=bondend
              self._a1_45->setProperty,data=[[bondbegin],[bondend]];bondbegin=bondbegin,bondend=bondend
              self._a1_76->setProperty,data=[[bondbegin],[bondend]];bondbegin=bondbegin,bondend=bondend
              self._a2_03->setProperty,data=[[bondbegin],[bondend]];bondbegin=bondbegin,bondend=bondend
              self._a2_12->setProperty,data=[[bondbegin],[bondend]];bondbegin=bondbegin,bondend=bondend
              self._a2_47->setProperty,data=[[bondbegin],[bondend]];bondbegin=bondbegin,bondend=bondend
              self._a2_56->setProperty,data=[[bondbegin],[bondend]];bondbegin=bondbegin,bondend=bondend
              self._a3_04->setProperty,data=[[bondbegin],[bondend]];bondbegin=bondbegin,bondend=bondend
              self._a3_15->setProperty,data=[[bondbegin],[bondend]];bondbegin=bondbegin,bondend=bondend
              self._a3_26->setProperty,data=[[bondbegin],[bondend]];bondbegin=bondbegin,bondend=bondend
              self._a3_37->setProperty,data=[[bondbegin],[bondend]];bondbegin=bondbegin,bondend=bondend

              self._a1_01->setProperty,/hide
              self._a1_32->setProperty,/hide
              self._a1_45->setProperty,/hide
              self._a1_76->setProperty,/hide
              self._a2_03->setProperty,/hide
              self._a2_12->setProperty,/hide
              self._a2_47->setProperty,/hide
              self._a2_56->setProperty,/hide
              self._a3_04->setProperty,/hide
              self._a3_15->setProperty,/hide
              self._a3_26->setProperty,/hide
              self._a3_37->setProperty,/hide
    
  end
  'ABG':begin
              bondbegin = [0.,0.,0.]
              bondend   = [1.,1.,1.]
              self._a1_01->setProperty,data=[[bondbegin],[bondend]];bondbegin=bondbegin,bondend=bondend
              self._a1_32->setProperty,data=[[bondbegin],[bondend]];bondbegin=bondbegin,bondend=bondend
              self._a1_45->setProperty,data=[[bondbegin],[bondend]];bondbegin=bondbegin,bondend=bondend
              self._a1_76->setProperty,data=[[bondbegin],[bondend]];bondbegin=bondbegin,bondend=bondend
              self._a2_03->setProperty,data=[[bondbegin],[bondend]];bondbegin=bondbegin,bondend=bondend
              self._a2_12->setProperty,data=[[bondbegin],[bondend]];bondbegin=bondbegin,bondend=bondend
              self._a2_47->setProperty,data=[[bondbegin],[bondend]];bondbegin=bondbegin,bondend=bondend
              self._a2_56->setProperty,data=[[bondbegin],[bondend]];bondbegin=bondbegin,bondend=bondend
              self._a3_04->setProperty,data=[[bondbegin],[bondend]];bondbegin=bondbegin,bondend=bondend
              self._a3_15->setProperty,data=[[bondbegin],[bondend]];bondbegin=bondbegin,bondend=bondend
              self._a3_26->setProperty,data=[[bondbegin],[bondend]];bondbegin=bondbegin,bondend=bondend
              self._a3_37->setProperty,data=[[bondbegin],[bondend]];bondbegin=bondbegin,bondend=bondend

              self._a1_01->setProperty,/hide
              self._a1_32->setProperty,/hide
              self._a1_45->setProperty,/hide
              self._a1_76->setProperty,/hide
              self._a2_03->setProperty,/hide
              self._a2_12->setProperty,/hide
              self._a2_47->setProperty,/hide
              self._a2_56->setProperty,/hide
              self._a3_04->setProperty,/hide
              self._a3_15->setProperty,/hide
              self._a3_26->setProperty,/hide
              self._a3_37->setProperty,/hide
  end
  else:
  endcase
end;pro DenProVisUCOutline::onDataDisconnect

pro denproVisUCOutline__define
      class = {denproVisUCOutline, $
                inherits IDLitVisualization, $
                myName:'',$
                abcStopLoop:0,$
                abgStopLoop:0,$
                abc:findgen(3),$
                abg:findgen(3),$
                _a1_01: obj_new(),$
                _a1_32: obj_new(),$
                _a1_45: obj_new(),$
                _a1_76: obj_new(),$
                _a2_03: obj_new(),$
                _a2_12: obj_new(),$
                _a2_47: obj_new(),$
                _a2_56: obj_new(),$
                _a3_04: obj_new(),$
                _a3_15: obj_new(),$
                _a3_26: obj_new(),$
                _a3_37: obj_new() $                
                }

end;denproVisUCOutline__define