


; $Id$
;
; Copyright (c) 2002-2007, ITT Visual Information Solutions. All
;       rights reserved. Unauthorized reproduction is prohibited.
;
;+
; CLASS_NAME:
;    denprovisIsosurface
;
; PURPOSE:
;    The denprovisIsosurface class implements a a polygon visualization
;    object for the iTools system.
;
; CATEGORY:
;    Components
;
; SUPERCLASSES:
;   IDLitVisualization
;
;-

;----------------------------------------------------------------------------
; denprovisIsosurface::Init
;
; Purpose:
;   Initialization routine of the object.
;
; Parameters:
;   None.
;
; Keywords:
;   NAME   - The name to associated with this item.
;
;   Description - Short string that will describe this object.
;
;   All other keywords are passed to the super class
function denprovisIsosurface::Init,abc=abc,abg=abg, _REF_EXTRA=_extra

;print,'AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA'
;print,'denprovisIsosurface::Init, _REF_EXTRA=_extra'
    compile_opt idl2, hidden
help,abc,abg

    ; Initialize superclass
;081308
;IDLitData CHOKES ON THE NAME HERE AS BEING UNDEFINED.  TRY CHANGING THE NAME.
;    if (~self->IDLitVisPolygon::Init(NAME="Isosurface", $
    if (~self->IDLitVisPolygon::Init(NAME="DenProIsosurface", $
        TYPE='IDLISOSURFACE', $
        ICON='volume', $
        DESCRIPTION="An Isosurface", $
        LINESTYLE=6, $
        SHADING=1, $
        /IMPACTS_RANGE, $
        _EXTRA=_extra))then return, 0

    ; Register Parameters

    self->RegisterParameter, 'VOLUME', DESCRIPTION='Volume', $
        /INPUT, TYPES='IDLARRAY3D'
    self->RegisterParameter, 'RGB_TABLE', DESCRIPTION='RGB Table', $
        /INPUT, /OPTIONAL, TYPES=['IDLPALETTE','IDLARRAY2D']
    self->RegisterParameter, 'VOLUME_DIMENSIONS', DESCRIPTION='Volume Dimensions', $
        /INPUT, /OPTIONAL, TYPES='IDLVECTOR'
    self->RegisterParameter, 'VOLUME_LOCATION', DESCRIPTION='Volume Location', $
        /INPUT, /OPTIONAL, TYPES='IDLVECTOR'

;012908
;NOW I NEED TO ADD TWO PARAMETERS FOR abc,abg
    self->RegisterParameter, 'VOLUME_ABC', DESCRIPTION='Volume ABC Values';, $
        ;/INPUT, /OPTIONAL, TYPES='IDLVECTOR'
    self->RegisterParameter, 'VOLUME_ABG', DESCRIPTION='Volume ABG Values';, $
        ;/INPUT, /OPTIONAL, TYPES='IDLVECTOR'
    self->RegisterParameter, 'VOLUME_MAX', DESCRIPTION='Volume Maximum';, $
        ;/INPUT, /OPTIONAL, TYPES='IDLVECTOR'
    self->RegisterParameter, 'VOLUME_MIN', DESCRIPTION='Volume Minimum';, $
        ;/INPUT, /OPTIONAL, TYPES='IDLVECTOR'


    ; The VERTICES and CONNECTIVITY parameters are "OUTPUT" parameters in the sense
    ; that this object generates the data for these parameters.
    self->SetParameterAttribute, ['VERTICES', 'CONNECTIVITY'], $
        INPUT=0, OUTPUT=1, OPTARGET=0

    ; Register Properties
    ;self->denprovisIsosurface::_RegisterProperties
    self->_RegisterProperties
    
    
    ; Init state
    self._sourceColor = 0
    self._fillColor = [255b,0b,0b]
    self->IDLitVisPolygon::SetProperty, FILL_COLOR=self._fillColor
    self._decimate = 100

    self->setProperty,color=bindgen(3)

    self->Set3D, /ALWAYS
    self->SetDefaultSelectionVisual, OBJ_NEW('IDLitManipVisSelectBox', /HIDE)

    return, 1 ; Success
end;denprovisIsosurface::Init


pro DenProVisIsosurface::_RegisterProperties, $
    UPDATE_FROM_VERSION=updateFromVersion

    compile_opt idl2, hidden


;;NOW I NEED TO ADD TWO PARAMETERS FOR abc,abg, volume_min,volume_max
;    self->RegisterParameter, 'VOLUME_ABC', DESCRIPTION='Volume ABC Values';, $
;        ;/INPUT, /OPTIONAL, TYPES='IDLVECTOR'
;    self->RegisterParameter, 'VOLUME_ABG', DESCRIPTION='Volume ABG Values';, $
;        ;/INPUT, /OPTIONAL, TYPES='IDLVECTOR'
;    self->RegisterParameter, 'VOLUME_MAX', DESCRIPTION='Volume Maximum';, $
;        ;/INPUT, /OPTIONAL, TYPES='IDLVECTOR'
;    self->RegisterParameter, 'VOLUME_MIN', DESCRIPTION='Volume Minimum';, $
;        ;/INPUT, /OPTIONAL, TYPES='IDLVECTOR'

    if (~self->QueryProperty('VOLUME_MAX')) then begin
        print,'VOLUME_MAX:VOLUME_MAX:VOLUME_MAX:VOLUME_MAX:VOLUME_MAX:VOLUME_MAX:VOLUME_MAX:VOLUME_MAX:VOLUME_MAX:VOLUME_MAX:VOLUME_MAX:'
        ; Hide to avoid showing on style sheet.
;        self->RegisterProperty, 'ISOVALUE', $
;            NAME='Isovalue dialog', $
;            USERDEF='Select isovalue...', $
;            DESCRIPTION='Isovalue dialog', /HIDE
    endif
    
    self->IDLitVisIsosurface::_RegisterProperties, $
                              UPDATE_FROM_VERSION=updateFromVersion
;    registerAll = ~KEYWORD_SET(updateFromVersion)
;
;    if (registerAll) then begin
;        self->RegisterProperty, 'SOURCE_COLOR', $
;            ENUMLIST=['Isovalue selected (Volume color table)', $
;                      'User selected (Fill Color Property)'], $
;            DESCRIPTION='Method of selecting color for mesh', $
;            NAME='Source color'
;    endif
;
;    ; For IDLitVisIntVol, we changed ISOVALUES to ISOVALUE, so we need to
;    ; register it. Easiest if we just check if we have the property.
;    if (~self->QueryProperty('ISOVALUE')) then begin
;        ; Hide to avoid showing on style sheet.
;        self->RegisterProperty, 'ISOVALUE', $
;            NAME='Isovalue dialog', $
;            USERDEF='Select isovalue...', $
;            DESCRIPTION='Isovalue dialog', /HIDE
;    endif
;
;    ; New properties in IDL64.
;    if (registerAll || updateFromVersion lt 640) then begin
;        self->RegisterProperty, '_ISOVALUE0', /FLOAT, $
;            NAME='Isovalue', $
;            DESCRIPTION='Isovalue', /HIDE, SENSITIVE=0, $
;            VALID_RANGE=[0,255], /UNDEFINED
;
;        self->RegisterProperty, '_ISOVALUE1', /FLOAT, $
;            NAME='Isovalue 1', $
;            DESCRIPTION='Isovalue 1', /HIDE, SENSITIVE=0, $
;            VALID_RANGE=[0,255], /UNDEFINED
;
;        self->RegisterProperty, 'DECIMATE', /INTEGER, $
;            NAME='Mesh quality', $
;            DESCRIPTION='Mesh quality: % of mesh retained', $
;            /HIDE, SENSITIVE=0, $
;            VALID_RANGE=[1,100,1]
;    endif
;
;    self->SetPropertyAttribute, 'SHADING', HIDE=0

end




pro denprovisIsosurface::warpSurface,verts,pvol

print,'denprovisIsosurface::warpSurface'

;help,self

t0 = systime(/seconds)
    
;print,'abc = ',(abc=self.abc)
;print,'abg = ',(abg=self.abg)
;;help,*pvol

abc=self.abc
abg=self.abg

szvol = size(*pvol)
szverts = size(verts)


;VERTS COME IN SCALED TO THE DIMENSIONS OF pVol

;SCALE THEM ON A 0-1 SCALE
verts[0,*] = verts[0,*]/float(szvol[1])
verts[1,*] = verts[1,*]/float(szvol[2])
verts[2,*] = verts[2,*]/float(szvol[3])


t1=systime(/seconds)-t0


;MULTIPLY SCALED VERTS BY THE a1,a2,a3 DIMENSIONS

  ;CALCULATE ANGLES IN RADIANS
  alpha = !dtor*abg[0]
  beta  = !dtor*abg[1]
  gamma = !dtor*abg[2]
  delta = acos(sqrt( (cos(beta) + cos(alpha)*cos(gamma))^2 + (cos(alpha)*sin(gamma))^2))

  ;CALCULATE PRIMITIVE LATTICE COMPONENT VECTORS
  a1 = [abc[0],0,0]
  a2 = abc[1]*[cos(gamma),sin(gamma),0]
  a3 = abc[2]*[cos(beta)+cos(alpha)*cos(gamma),cos(alpha)*sin(gamma),sin(delta)]
  
;print,'abc=',abc
;print,'abg=',abg
;print,'delta=',delta
;help,verts
;help,szverts
;help,*pVol
  for i=0L,szverts[2]-1 do begin
    xyz = verts[*,i]
    verts[*,i] = xyz[0]*a1 + xyz[1]*a2 + xyz[2]*a3
  endfor;i

t2 = systime(/seconds)-t0                    
print,'t1,t2=',t1,t2


end;denprovisIsosurface::warpSurface



;----------------------------------------------------------------------------
; denprovisIsosurface::_GenerateVisualization
;
; Purpose:
;   Generate the isosurface vertex and connectivity data.
;
; Parameters:
;   None.
;
; Keywords:
;    None.

pro denprovisIsosurface::_GenerateVisualization

    compile_opt idl2, hidden

    ; Make sure that our isovalue property has been set.
    self->GetPropertyAttribute, '_ISOVALUE0', UNDEFINED=undef
    isValid = (self._volMin ne self._volMax) && ~undef

    self->SetPropertyAttribute, 'ISOVALUE', HIDE=0
    self->SetPropertyAttribute, '_ISOVALUE0', HIDE=0, $
        SENSITIVE=isValid, $
        VALID_RANGE=isValid ? [self._volMin, self._volMax] : [0,255]
    self->SetPropertyAttribute, 'DECIMATE', HIDE=0, $
        SENSITIVE=isValid

    if (~isValid) then return

    ; Get volume data to make isosurface with
    oVol = self->GetParameter('VOLUME')
    if not OBJ_VALID(oVol) then return
    success = oVol->GetData(pVol, /POINTER)
    if success eq 0 then return
help,self
    self->getProperty,color=color
print,color
    self.volmin = min(*pvol)
    self.volmax = max(*pvol)

    ; This may take awhile...
    oTool = self->GetTool()
    if (~OBJ_VALID(oTool)) then $
        return

    ISOSURFACE, *pVol, self._isovalues[0], verts, conn, $
        PROGRESS_OBJECT=self, $
        PROGRESS_METHOD='_ProgressCallback', $
        PROGRESS_USERDATA=oTool

    ; Cancelled.
    if (N_ELEMENTS(verts) le 3) then $
        return

    if self._decimate ne 100 then begin
        r = MESH_DECIMATE(verts, conn, conn, $
            PERCENT_POLYGONS=self._decimate, $
            PROGRESS_OBJECT=self, $
            PROGRESS_METHOD='_DecimateCallback', $
            PROGRESS_USERDATA=oTool)
    endif
    void = oTool->DoUIService("HourGlassCursor", self)

    ; Get the parms so we can update the vertex and connectivity data
    ; Create the parms if they are not there yet.
    oVerts = self->GetParameter('VERTICES')

print,'WARP   : WARP   : WARP   : WARP   : WARP   : WARP   : WARP   : WARP   : WARP   : WARP   : WARP   : WARP   : WARP   : '
print,'denprovisIsosurface::_GenerateVisualization  WARP THE VERTICES HERE!!!!'
help,oVerts
help,self.abc
print,self.abc
help,self.abg
print,self.abg
help,verts

print,'WARP   : WARP   : WARP   : WARP   : WARP   : WARP   : WARP   : WARP   : WARP   : WARP   : WARP   : WARP   : WARP   : '
;denprovisIsosurface::warpSurface



    if not OBJ_VALID(oVerts) then begin
        oVerts = OBJ_NEW('IDLitData', TYPE='IDLVERTEX', $
            ICON='segpoly', NAME="Isosurface Vertices")
        void = self->SetData(oVerts, $
            PARAMETER_NAME='VERTICES', /NO_UPDATE, /BY_VALUE)
    endif
    oConn = self->GetParameter('CONNECTIVITY')
    if not OBJ_VALID(oConn) then begin
        oConn = OBJ_NEW('IDLitData', TYPE='IDLCONNECTIVITY', $
            ICON='segpoly', NAME="Isosurface Polygon Connectivity")
        void = self->SetData(oConn, $
            PARAMETER_NAME='CONNECTIVITY', /NO_UPDATE, /BY_VALUE)
    endif

    ; Empty out polygon in case there is no isosurface
    ; (Need to do it in this order!)
    success = oConn->SetData([-1])
    success = oVerts->SetData(FLTARR(3,3))

    ; Make sure that we have enough verts to keep the polygon happy
    if N_ELEMENTS(verts) lt 9 then begin
        verts = FLTARR(3,3)
    endif

    ; Prepare vertex data
    ; - scale by dimensions
    oDimensions = self->GetParameter('VOLUME_DIMENSIONS')
;    if OBJ_VALID(oDimensions) then begin
;        success = oDimensions->GetData(dimensions)
;        dimensions = FLOAT(dimensions)
;        volDims = SIZE(*pVol, /DIMENSIONS)
;        help,volDims
;        verts[0,*] *= dimensions[0] / volDims[0]
;        verts[1,*] *= dimensions[1] / volDims[1]
;        verts[2,*] *= dimensions[2] / volDims[2]
;    endif
;
;    ; - translate by volume location
    oLocation = self->GetParameter('VOLUME_LOCATION')
;    if OBJ_VALID(oLocation) then begin
;        success = oLocation->GetData(location)
;        help,location
;        verts[0,*] += location[0]
;        verts[1,*] += location[1]
;        verts[2,*] += location[2]
;    endif
;
;
;;WARP THE VERTICES HERE ??????????????:
    self->warpSurface,verts,pvol

    ; Update Parameters
    success = oVerts->SetData(verts)
    success = oConn->SetData(conn)

    ; Move the Isosurface before the Volume Visualization.
    ; This improves the mixed display of Volumes (with ZBUFFER on) and
    ; solid geometry.
    oDataSpace = self->GetDataSpace()
    if OBJ_VALID(oDataSpace) then begin
        oAllList = oDataSpace->Get(/ALL)
        volPosition = WHERE(OBJ_ISA(oAllList, 'IDLITVISVOLUME'))
        isoPosition = WHERE(oAllList eq self)
        if volPosition[0] lt isoPosition[0] then $
            oDataSpace->Move, isoPosition[0], volPosition[0]
    endif



print,color
    self->_setColor,color


    ; Turn off OPTARGET on the vertices because we don't have
    ; any operations work on vertex lists.
    self->SetParameterAttribute, 'VERTICES', OPTARGET=0


end;denprovisIsosurface::_GenerateVisualization


;;----------------------------------------------------------------------------
;function denprovisIsosurface::EditUserDefProperty, oTool, identifier
;
;    compile_opt idl2, hidden
;
;    case identifier of
;
;    'ISOVALUE': begin
;        success = oTool->DoUIService('ISOSURFACE', self)
;        if success then return, 1
;        return, 0
;    end
;    else:
;
;    endcase
;
;    ; Call our superclass.
;    return, self->IDLitVisualization::EditUserDefProperty(oTool, identifier)
;
;end;denprovisIsosurface::EditUserDefProperty

;----------------------------------------------------------------------------
; IIDLProperty Interface
;----------------------------------------------------------------------------
;----------------------------------------------------------------------------
;+
; METHODNAME:
;      denprovisIsosurface::GetProperty
;
; PURPOSE:
;      This procedure method retrieves the
;      value of a property or group of properties.
;
; CALLING SEQUENCE:
;      Obj->[denprovisIsosurface::]GetProperty
;
; INPUTS:
;      There are no inputs for this method.
;
; KEYWORD PARAMETERS:
;      Any keyword to denprovisIsosurface::Init followed by the word "Get"
;      can be retrieved using denprovisIsosurface::GetProperty.  In addition
;      the following keywords are available:
;
;      ALL: Set this keyword to a named variable that will contain
;              an anonymous structure containing the values of all the
;              retrievable properties associated with this object.
;              NOTE: UVALUE is not returned in this struct.
;-
pro denprovisIsosurface::GetProperty, $
                                   _ISOVALUE0=isovalue0, $
                                   _ISOVALUE1=isovalue1, $
                                   USE_ISOVALUES=useIsovalues, $
                                   SOURCE_COLOR=sourceColor, $
                                   FILL_COLOR=fillColor, $
                                   DATA_OBJECTS=oData, $
                                   PALETTE_OBJECTS=oPalette, $
                                   DECIMATE=decimate, $
                                  _DATA=_data, $
                                  _oPolygon=_oPolygon,$
                                  abc=abc,$
                                  abg=abg,$
                                  name=name,$  ;THIS SHOULD NOT BE NECESSARY SINCE IT SHOULD BE CAUGHT IN _extra, 
                                            $  ;BUT IT'S NOT, SO I INCLUDE IT!!!!
                                  selection_pad=selection_pad,$  ;SAME HERE!!!!!
                                  hide=hide,$  ;SAME HERE!!!!!  
                                  description=description,$    ;SAME HERE!!!!!     
                                  active_position=active_position,$  ;SAME HERE!!!!!
                                  depth_test_disable=depth_test_disable,$
                                  depth_write_disable=depth_write_disable,$
                                  depth_test_function=depth_test_function,$
                                  lighting=lighting,$
                                  _Parent=_Parent,$
                                  render_method=render_method,$
                                  select_target=select_target,$
                                  color=color,$
                                  linestyle=linestyle,$
                                  thick=thick,$
                                  fill_background=fill_background,$
                                  shading=shading,$
                                  transparency=transparency,$
                                  use_bottom_color=use_bottom_color,$
                                  bottom=bottom,$
                                  ambient=ambient,$
                                  diffuse=diffuse,$
                                  specular=specular,$
                                  emission=emission,$
                                  shininess=shininess,$
                                  no_close=no_close,$
                                  tessellate=tessellate,$
                                  zvalue=zvalue,$
                                  _REF_EXTRA=_extra

        compile_opt idl2, hidden
;    print,'denprovisIsosurface::GetProperty arg_present(oparent)=',arg_present(oparent)
;    print,'denprovisIsosurface::GetProperty arg_present(active_position)=',arg_present(active_position)
;    print,'denprovisIsosurface::GetProperty arg_present(selection_pad)=',arg_present(selection_pad)
;    print,'denprovisIsosurface::GetProperty arg_present(_isovalue0)=',arg_present(_isovalue0)
;    print,'denprovisIsosurface::GetProperty arg_present(_isovalue1)=',arg_present(_isovalue1)


        if (ARG_PRESENT(abc)) then abc = self.abc    
        if (ARG_PRESENT(abg)) then abg = self.abg        
        if (arg_present(_oPolygon)) then _oPolygon = self._oPolygon
        if arg_present(color) then begin
          self._oPolygon->getProperty,color=color
        endif

                self->IDLitVisIsosurface::GetProperty, $
                                   _ISOVALUE0=isovalue0, $
                                   _ISOVALUE1=isovalue1, $
                                   USE_ISOVALUES=useIsovalues, $
                                   SOURCE_COLOR=sourceColor, $
                                   FILL_COLOR=fillColor, $
                                   DATA_OBJECTS=oData, $
                                   PALETTE_OBJECTS=oPalette, $
                                   DECIMATE=decimate, $
                                  _DATA=_data, $
                                  name = name,$
                                  selection_pad=selection_pad,$
                                  hide=hide,$
                                  description=description,$
                                  active_position=active_position,$
                                  depth_write_disable=depth_write_disable,$
                                  depth_test_disable=depth_test_disable,$
                                  depth_test_function=depth_test_function,$
                                  lighting=lighting,$
                                  _Parent=_Parent,$
                                  render_method=render_method,$
                                  select_target=select_target,$
                                  linestyle=linestyle,$
                                  thick=thick,$
                                  fill_background=fill_background,$
                                  shading=shading,$
                                  transparency=transparency,$
                                  use_bottom_color=use_bottom_color,$
                                  bottom=bottom,$
                                  ambient=ambient,$
                                  diffuse=diffuse,$
                                  specular=specular,$
                                  emission=emission,$
                                  shininess=shininess,$
                                  no_close=no_close,$
                                  tessellate=tessellate,$
                                  zvalue=zvalue,$
                                  _EXTRA=_extra

    ; get superclass properties
    if (N_ELEMENTS(_extra) gt 0) then $
        self->IDLitVisPolygon::GetProperty, _EXTRA=_extra

end;denprovisIsosurface::GetProperty

;----------------------------------------------------------------------------
;+
; METHODNAME:
;      denprovisIsosurface::SetProperty
;
; PURPOSE:
;      This procedure method sets the value
;      of a property or group of properties.
;
; CALLING SEQUENCE:
;      Obj->[denprovisIsosurface::]SetProperty
;
; INPUTS:
;      There are no inputs for this method.
;
; KEYWORD PARAMETERS:
;      Any keyword to denprovisIsosurface::Init followed by the word "Set"
;      can be set using denprovisIsosurface::SetProperty.
;-
pro denprovisIsosurface::SetProperty, $
    _ISOVALUE0=isovalue0, $
    _ISOVALUE1=isovalue1, $
    SOURCE_COLOR=sourceColor, $
    FILL_COLOR=fillColor, $
    FILL_BACKGROUND=fillBackground, $
    SELECTED_DATASET=selectedDataset, $
    DECIMATE=decimate, $
    abc=abc,$
    abg=abg,$
    volmax=volmax,$
    volmin=volmin,$
    hide=hide,$
    color=color,$
    _REF_EXTRA=_extra

    compile_opt idl2, hidden

;print,'BBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBB'
;print,'denprovisIsosurface::SetProperty'
;print,n_elements(name)
;help,self.name
    refresh = 0b
    oTool = self->GetTool()
    if (obj_isa(oTool, "IDLitSystem")) then $
       oTool = oTool->_GetCurrentTool()

    doUpdate = 0b

    if n_elements(abc) eq 3 then begin
      print,'denprovisIsosurface::SetProperty  SETTING ABC'
      self.abc = abc
      print,'NEED TO DECIDE WHETHER TO WARP THE SURFACE BASED ON THIS SETPROPERTY'
      print,"IT SHOULDN'T GET CHANGED, BUT IF IT DOES THEN THE ISOSURFACE SHOULD REACT"
    endif

    if n_elements(abg) eq 3 then begin
      print,'denprovisIsosurface::SetProperty  SETTING ABG'
      self.abg = abg
      print,'NEED TO DECIDE WHETHER TO WARP THE SURFACE BASED ON THIS SETPROPERTY'
      print,"IT SHOULDN'T GET CHANGED, BUT IF IT DOES THEN THE ISOSURFACE SHOULD REACT"
    endif


    ;COLOR NEEDS TO BE HANDLED IN THIS MANNER.
    if n_elements(color) ne 0 then begin
      self._oPolygon->setproperty,color=color 
      ;self.color = color
    endif


    self->IDLitVisIsosurface::SetProperty, $
                            _ISOVALUE0=isovalue0, $
                            _ISOVALUE1=isovalue1, $
                            SOURCE_COLOR=sourceColor, $
                            FILL_COLOR=fillColor, $
                            FILL_BACKGROUND=fillBackground, $
                            SELECTED_DATASET=selectedDataset, $
                            DECIMATE=decimate, $
                            hide=hide,$
                            _EXTRA=_extra


    if refresh && OBJ_VALID(oTool) then $
        oTool->RefreshCurrentWindow
otool = getdenprotool()
oTool->enableUpdates
otool->RefreshCurrentWindow
 
end;denprovisIsosurface::SetProperty
;----------------------------------------------------------------------------
; IDLitVisIsosurface::_SetColor
;
; Purpose:
;   Set the isosurface color.
;   If the source of the color comes from the isosurface, convert the
;   isovalue into a color index into the volume color table.
;   Otherwise, use the last set FILL_COLOR value.
;   In either case, set the color into the superclass.
;
; Parameters:
;   None.
;
; Keywords:
;    None.

pro DenProVisIsosurface::_SetColor,color

    compile_opt idl2, hidden
    ;self._oPolygon->getproperty,color=color
    if n_elements(color) ne 3 then begin
      self->IDLitVisPolygon::getProperty, FILL_COLOR=color
      ;self._oPolygon->getProperty,color=color
    endif
    ;self._oPolygon->setProperty,color=color
    self->IDLitVisPolygon::SetProperty, FILL_COLOR=color

;    case self._sourceColor of
;    0: begin
;        ; Compute color index if we have vol data
;        if (self._volMax - self._volMin) ne 0 then begin
;            ; Convert the iso value to a color table index
;            index = (self._isovalues[0] - self._volMin) / (self._volMax - self._volMin)
;            index = (ROUND(index * 255) > 0) < 255
;            ; Lookup color in color table
;            oPal = self->GetParameter('RGB_TABLE')
;            success = 0
;            if OBJ_VALID(oPal) then $
;                success = oPal->GetData(colortable)
;            if success then begin
;                color = REFORM(BYTE(colortable[*, index]))
;            endif else begin
;                color = [index, index, index]
;            endelse
;        endif
;        ; Fallback
;        if N_ELEMENTS(color) eq 0 then $
;            color = [128b,128b,128b]
;        self->IDLitVisPolygon::SetProperty, FILL_COLOR=color
;    end
;    1: begin
;        self->IDLitVisPolygon::SetProperty, FILL_COLOR=self._fillColor
;    end
;    endcase

end

;;----------------------------------------------------------------------------
;; denprovisIsosurface::OnDataDisconnect
;;
;; Purpose:
;;   This is called by the framework when a data item has disconnected
;;   from a parameter on the surface.
;;
;; Parameters:
;;   ParmName   - The name of the parameter that was disconnected.
;;
;pro denprovisIsosurface::OnDataDisconnect, ParmName
;
;    compile_opt hidden, idl2
;
;    switch STRUPCASE(parmname) of
;    'VOLUME': begin
;        self->SetPropertyAttribute, $
;            ['ISOVALUE', 'ISOVALUE0', 'ISOVALUE1', 'DECIMATE'], SENSITIVE=0
;        self->DoOnNotify, self->GetFullIdentifier(), 'SETPROPERTY', ''
;    end
;    endswitch
;end
;
;;----------------------------------------------------------------------------
;;+
;; METHODNAME:
;;    denprovisIsosurface::OnDataChangeUpdate
;;
;; PURPOSE:
;;    This procedure method is called by a Subject via a Notifier when
;;    its data has changed.  This method obtains the data from the subject
;;    and updates the object.
;;
;; CALLING SEQUENCE:
;;
;;    Obj->[denprovisIsosurface::]OnDataChangeUpdate, oSubject
;;
;; INPUTS:
;;    oSubject: The Subject object in the Subject-Observer relationship.
;;    This object (the surface) is the observer, so it uses the
;;    IIDLDataSource interface to get the data from the subject.
;;
;; KEYWORD PARAMETERS:
;;
;; OUTPUTS:
;;
;; SIDE EFFECTS:
;;
;; RESTRICTIONS:
;;
;; PROCEDURE:
;
;; EXAMPLE:
;;
;;-
;pro denprovisIsosurface::OnDataChangeUpdate, oSubject, parmName
;
;    compile_opt idl2, hidden
;
;    case STRUPCASE(parmName) OF
;    '<PARAMETER SET>': begin
;        void = oSubject->Get(/ALL, count=nCount, NAME=names)
;        for i=0,nCount-1 do begin
;            ; Skip RGB_TABLE because that work is handled by VOLUME
;            if (names[i] eq '' || names[i] eq 'RGB_TABLE') then continue
;            oData = (oSubject->GetByName(names[i]))[0]
;            if (OBJ_VALID(oData)) then begin
;                self->OnDataChangeUpdate, oData, names[i]
;            endif
;        endfor
;    end
;
;    'VOLUME': begin
;        if (oSubject->GetData(pVol, /POINTER)) then begin
;            volMin = MIN(*pVol, MAX=volMax)
;            self._volMin = volMin
;            self._volMax = volMax
;        endif
;        self->_GenerateVisualization
;        self->_SetColor
;    end
;
;    'VOLUME_DIMENSIONS': self->_GenerateVisualization
;    'VOLUME_LOCATION': self->_GenerateVisualization
;    'RGB_TABLE': self->_SetColor
;
;    else: $
;        self->IDLitVisPolygon::OnDataChangeUpdate, oSubject, parmName
;    endcase
;
;end

;----------------------------------------------------------------------------
; Object Definition
;----------------------------------------------------------------------------

;----------------------------------------------------------------------------
;+
; denprovisIsosurface__Define
;
; PURPOSE:
;    Defines the object structure for an denprovisIsosurface object.
;
;-
pro denprovisIsosurface__Define

    compile_opt idl2, hidden

    struct = { denprovisIsosurface,    $
        inherits IDLitVisIsosurface,  $
        abc:dblarr(3),                $
        abg:dblarr(3),                $
        volmax:0.0,$
        volmin:0.0 $;,$
        ;color:bindgen(3) $
        }
end
