; $Id$
;
;
;Read data from a CIF file and return the information via
;keywords and arguments.
;
;Return values in 1 for success, 0 for failure.

function threeDenPro_ReadCIF2_getSymmetries,symmetry,unitrotator,unittranslator

    print,'####################################################'
    print,'symmetry='
    print,symmetry
    unitrotator = fltarr(3,3,n_elements(symmetry))
    unitrotator[0,0,*] = 1
    unitrotator[1,1,*] = 1
    unitrotator[2,2,*] = 1
    unittranslator = fltarr(3,n_elements(symmetry))

    if n_elements(symmetry) gt 1 then begin
      for i=0,n_elements(symmetry)-1 do begin
        ;print,symmetry[i]
        symsegs = strsplit(symmetry[i],"'",/extract)
        if n_elements(symsegs) gt 1 then begin
          ssymsegs = strsplit(symsegs[1],',',/extract)
        endif else begin
          ssymsegs = strsplit(symsegs[0],',',/extract)
        endelse
        print,'i,j,dumxpos,dumypos,dumzpos,dummpos,dumfpos'
        vrot = fltarr(3,3)
        vtrans = fltarr(3)
        for j = 0,2 do begin
          for ichar=0,strlen(ssymsegs[j])-1 do begin
            thisch=strmid(ssymsegs[j],ichar,1)
            if thisch eq 'x' then begin
              vrot[0,j] = 1
              if ichar gt 0 then begin
                tempch=strmid(ssymsegs[j],ichar-1,1)
                if tempch eq '-' then vrot[0,j] = -1
              endif
            endif
            if thisch eq 'y' then begin
              vrot[1,j] = 1
              if ichar gt 0 then begin
                tempch=strmid(ssymsegs[j],ichar-1,1)
                if tempch eq '-' then vrot[1,j] = -1
              endif
            endif
            if thisch eq 'z' then begin
              vrot[2,j] = 1
              if ichar gt 0 then begin
                tempch=strmid(ssymsegs[j],ichar-1,1)
                if tempch eq '-' then vrot[2,j] = -1
              endif
            endif
            if thisch eq '/' then begin
              tempchSign  = strmid(ssymsegs[j],ichar-2,1)
              tempchNumer = strmid(ssymsegs[j],ichar-1,1)
              tempchDenom = strmid(ssymsegs[j],ichar+1,1)
              vtrans[j] = float(tempchNumer)/float(tempchDenom)
              if tempchSign eq '-' then vtrans[j] = -vtrans[j]
            endif

          endfor;ichar
          print,i,j,':',ssymsegs[j]

        endfor;j
        print,vrot,vtrans
        unitrotator[*,*,i] = vrot
        unittranslator[*,i] = vtrans
      endfor;i
    endif
    print,'####################################################'
    return,1

end;threeDenPro_ReadCIF2_getSymmetries



function threeDenPro_ReadCIF2,$
                        atoms,x,y,z,$
                        list=list,bonds=bonds,$
                        symmetry=symmetry,$
                        ucboxpoints=ucboxpoints,$
                        abc=abc,abg=abg,$
                        datapath=datapath,$
                        filename=filename,$
                        unitrotator=unitrotator,$
                        unittranslator=unittranslator
                        

;void = dialog_message('STARTING threeDenPro_ReadCIF2')
	;cfn = 'C:\Documents and Settings\kneller\Desktop\GRID\Ce_MOF.cif'
	;cfn = dialog_pickfile(filter='*.cif',path='C:\Documents and Settings\kneller\Desktop\GRID',title='PLEASE SELECT A .cif FILE:')
 
  if n_elements(datapath) eq 0 then datapath = 'C:\Documents and Settings\kneller\Desktop\DAVECode061808\dave_devel\programs\modules\DenPro\Data\'

  ;if n_elements(filename) eq 0 then filename = 'C:\Documents and Settings\kneller\Desktop\GRID\GRID\Data\4LarrySpecial.cif'
;	cfn = 'C:\Documents and Settings\kneller\Desktop\GRID\4LarrySpecial.cif'
  if n_elements(filename) ne 0 then begin
    cfn = filename;'C:\Documents and Settings\kneller\Desktop\GRID\GRID\Data\4LarrySpecial.cif'
  endif else begin
    cfn = dialog_pickfile(filter='*.cif',path=datapath,title='Select a CIF file:') 
    filename = cfn   
  endelse
  if file_test(cfn) ne 1 then begin
    return,0
;    cfn = dialog_pickfile(filter='*.cif',path=datapath,title='Select a CIF file:')
;    print,cfn
;    if cfn ne '' then datapath = file_dirname(cfn)
    
  endif
  
	if cfn ne '' then begin

		natoms = -1
		nbonds = -1
    nsymmetries = -1
		atomstart = -1
		atomend = -1
		bondstart = -1
		bondend = -1
    symmetryStart = -1
    symmetryEnd = -1
    

		print,'cfn=',cfn

		;
		;	;READ THE FILE INTO A STRING ARRAY
			nlines = file_lines(cfn)
			line = ''
			s = strarr(nlines)
			openr,lun,cfn,/get_lun
			readf,lun,s
			free_lun,lun


			;GET THE NUMBER OF ATOMS AND BONDS

			ucboxpoints = dblarr(8,3)


      ;loop_ 
      ;JUST USE A STRING ARRAY INSTEAD. (SEE BELOW).
      sym = {_symmetry_equiv_pos_as_xyz:''} 

			;loop_
			unit = { _atom_site_label:'',$
		 			 _atom_site_type_symbol:'',$
					 _atom_site_fract_x:0d,$
					 _atom_site_fract_y:0d,$
					 _atom_site_fract_z:0d,$
					 _atom_site_U_iso_or_equiv:0d,$
					 _atom_site_adp_type:'',$
					 _atom_site_occupancy:0d,$
					 _atom_site_symmetry_multiplicity:0,$
					 _atom_site_calc_flag:'',$
					 _atom_site_refinement_flags:'',$
					 _atom_site_disorder_assembly:'',$
					 _atom_site_disorder_group:'',$
					 _atom_site_Wyckoff_symbol:'',$
					 color:[0,0,0],$
					 radius:0d,$
					 x:0d,$
					 y:0d,$
					 z:0d}

		;	list = replicate(unit,201)

		;NEXT GET THE BOND INFO
				;bondstart = 442
				;nbonds = 138


		;TO DEFINE THIS STRUCTURE, COULD PARSE FOR ITEMS BEGINNING WITH AN
		;UNDERSCORE.  ONCE THAT IS SET, THE FIRST NON-UNDERSCORE LINE BEGINS THE DATA
		;WITH THE SAME NUMBER OF SEGMENTS PER LINE AS THE NUMBER OF TAGS IN THE
		;STRUCTURE.

				bond = {_geom_bond_atom_site_label_1:'',$
		 				_geom_bond_atom_site_label_2:'',$
		 				_geom_bond_distance:0.0d,$
		 				_geom_bond_site_symmetry_2:0.0d,$
		 				_geom_bond_publ_flag:''}



		;		bonds = replicate(bond,nbonds)



			;LATTICE ANGLES AND SIDE LENGTHS
			abc = dblarr(3)
			abg = dblarr(3)


			;PRIMITIVE LATTICE
			a1 = dblarr(3)
			a2 = dblarr(3)
			a3 = dblarr(3)

			for i=0,nlines-1 do begin
				line = s[i]
        print,i,line
        if i eq 52 then begin
          print,'OK'
        endif
				if stregex(line,'cell_length_a',/fold_case,/boolean) gt 0 then begin
					;print,'line=',line
					segs = strsplit(line,/extract)
					abc[0] = double(segs[1])
				endif
				if stregex(line,'cell_length_b',/fold_case,/boolean) gt 0 then begin
					;print,'line=',line
					segs = strsplit(line,/extract)
					abc[1] = double(segs[1])
				endif
				if stregex(line,'cell_length_c',/fold_case,/boolean) gt 0 then begin
					;print,'line=',line
					segs = strsplit(line,/extract)
					abc[2] = double(segs[1])
				endif
				if stregex(line,'cell_angle_alpha',/fold_case,/boolean) gt 0 then begin
					;print,'line=',line
					segs = strsplit(line,/extract)
					abg[0] = double(segs[1])
				endif
				if stregex(line,'cell_angle_beta',/fold_case,/boolean) gt 0 then begin
					;print,'line=',line
					segs = strsplit(line,/extract)
					abg[1] = double(segs[1])
				endif
				if stregex(line,'cell_angle_gamma',/fold_case,/boolean) gt 0 then begin
					;print,'line=',line
					segs = strsplit(line,/extract)
					abg[2] = double(segs[1])
				endif



				;NOW GET istart_atoms, istart_bonds, n_atoms, n_bonds
				;AND TRY TO GET THE LABELS
				;SHOULD I BOTHER WITH THE SPECIES?????  THE INFORMATION WILL BE READ FROM A DATA FILE.


				if stregex(line,'loop_',/fold_case,/boolean) gt 0 then begin

		;			print,'LOOP!'
		;			print,s[i+1]


          ;HERE ARE THE SYMMETRY EQUIVALENT POSITIONS
          ;NOTE: THIS IS OFTEN HOW THE MAJORITY OF ATOMIC POSITIONS ARE SPECIFIED
          if (strsplit(s[i+1],/extract))[0] eq '_symmetry_equiv_pos_as_xyz' or $
              stregex(s[i]  ,'_symmetry_equiv_pos_as_xyz',/fold_case,/boolean) or $
              stregex(s[i+1],'_symmetry_equiv_pos_as_xyz',/fold_case,/boolean) then begin

              symmetryStart = i+2
              j = i+2

              if stregex(s[i],'_symmetry_equiv_pos_as_xyz',/fold_case,/boolean) then begin
                symmetryStart = i+1
                j = i+1
              endif
            
            ;CHECK TO MAKE SURE j lt nlines
            while( (n_elements(strsplit(s[j],/extract)) gt 1)  and (j lt n_elements(s)-1)) do begin
              j++
            endwhile
            symmetryEnd = j-1
            nsymmetries = symmetryEnd-symmetryStart+1
          endif;_symmetry_equiv_pos_as_xyz

					if (strsplit(s[i],/extract))[0]   eq '_atom_site_label' or $
					   (strsplit(s[i+1],/extract))[0] eq '_atom_site_label' or $
					   (strsplit(s[i+2],/extract))[0] eq '_atom_site_label' or $
					   (strsplit(s[i+3],/extract))[0] eq '_atom_site_label' $
					   then begin
						;print,'HERE ARE THE ATOMS!'
              if (strsplit(s[i+1],/extract))[0] eq 'loop_' then j = i+2
              if (strsplit(s[i],/extract))[0]   eq 'loop_' then j = i+1
						  if (strsplit(s[i-1],/extract))[0] eq 'loop_' then j = i
              if (strsplit(s[i-2],/extract))[0] eq 'loop_' then j = i-1
              if (strsplit(s[i-3],/extract))[0] eq 'loop_' then j = i-2
              if (strsplit(s[i-4],/extract))[0] eq 'loop_' then j = i-3
;              if (strsplit(s[i],/extract))[0]   eq '_atom_site_label' then j = i-1
;              if (strsplit(s[i+1],/extract))[0] eq '_atom_site_label' then j = i
;              if (strsplit(s[i+2],/extract))[0] eq '_atom_site_label' then j = i+1
;              if (strsplit(s[i+3],/extract))[0] eq '_atom_site_label' then j = i+2
                   
						
						;FIRST GET ALL THE LABELS AND NOTE THE POSITIONS OF THE FRACTIONAL x,y,z VALUES
						scheck = s[j]

            labelposition = 0
            symbolposition = 1
						xposition = 2
						yposition = 3
						zposition = 4

            tagposition = 0
						while( (stregex(s[j],'_atom_site',/fold_case,/boolean))  and (j lt n_elements(s)-1))  do begin
              print,j,s[j]
              if stregex(s[j],'_atom_site_label',/fold_case,/boolean) gt 0 then  begin
                print,'_atom_site_label at',tagposition ,j
                labelposition = tagposition
              endif 
              if stregex(s[j],'_atom_site_type_symbol',/fold_case,/boolean) gt 0 then  begin
                print,'_atom_site_type_symbol at',tagposition 
                symbolposition = tagposition
              endif 
              if stregex(s[j],'_fract_x',/fold_case,/boolean) gt 0 then begin
                print,'_fract_x at',tagposition 
                xposition = tagposition
              endif 
              if stregex(s[j],'_fract_y',/fold_case,/boolean) gt 0 then  begin
                print,'_fract_y at',tagposition 
                yposition = tagposition
              endif 
              if stregex(s[j],'_fract_z',/fold_case,/boolean) gt 0 then  begin
                print,'_fract_z at',tagposition 
                zposition = tagposition
              endif 
              print,labelposition,symbolposition,xposition,yposition,zposition
							j++
							tagposition++ 
						endwhile
						atomstart = j

            
            ;NOW THIS HAS TO ACCOUNT FOR CASES WHERE THE SYMBOL IS SPECIFIED BEFORE THE INFO
            if (n_elements(strsplit(s[j],/extract)) gt 1) then begin 
  						while( (n_elements(strsplit(s[j],/extract)) gt 1)   and (j lt n_elements(s)-1)) do begin
  							j++
  						endwhile
              atomend = j-1
              print,'atomstart,atomend=',atomstart,atomend
              ;print,s[atomstart]
              ;print,s[atomend]
              natoms = atomend-atomstart+1
              print,'natoms=',natoms
              symbolsplitlineflag = 0
            endif else begin
              while( (n_elements(strsplit(s[j],/extract)) ge 1)   and (j lt n_elements(s)-1)) do begin
                j++
              endwhile
              atomend = j-1
              print,'atomstart,atomend=',atomstart,atomend
              ;print,s[atomstart]
              ;print,s[atomend]
              natoms = (atomend-atomstart+1)/2
              print,'natoms=',natoms
              symbolsplitlineflag = 1
            endelse


					endif
					if (strsplit(s[i+1],/extract))[0] eq '_geom_bond_atom_site_label_1' then begin
						;print,'HERE ARE THE BONDS!'
						j = i+1
						scheck = s[j]
						while( (stregex(s[j],'_geom_bond',/fold_case,/boolean))  and (j lt n_elements(s)-1)) do begin
							j++
						endwhile
						bondstart = j

						while( n_elements(strsplit(s[j],/extract)) gt 1 and (j lt n_elements(s)-1)) do begin

							j++

						endwhile
						bondend = j-1
						print,'bondstart,bondend=',bondstart,bondend
						;print,s[bondstart]
						;print,s[bondend]
						nbonds = bondend-bondstart+1
						;print,'nbonds=',nbonds
					endif
				endif

		endfor;i




    ;THE NEXT BLOCK DOES NOT WORK IF NO SYMMETRIES AND/OR BONDS ARE SPECIFIED!!!!
    ;REPLACE IT WITH THE STUFF BELOW IT
;   if  atomstart eq atomend or $
;     bondstart eq bondend or $
;      symmetrystart eq symmetryend or $      
;     atomstart eq -1      or $
;     atomend   eq -1    or $
;     bondstart eq -1    or $
;     bondend   eq -1    or $
;      symmetryStart eq -1    or $
;      symmetryEnd   eq -1    then begin
;
;     return,0
;
;   endif


    if atomstart eq atomend $
       or atomstart eq -1 $
       or atomend   eq -1 $
        then begin
      return,0
    endif;atoms


    if nsymmetries gt 0 then begin
      ;symmetry  = '';strarr(nSymmetries);replicate(sym,nSymmetries)
  
      symmetry  = strarr(nSymmetries);replicate(sym,nSymmetries)
      istart = symmetryStart
      for i=istart,istart+nsymmetries-1 do begin
        symmetry[i-istart] = s[i]
      endfor;i
    endif else begin
      symmetry = ['x, y, z']
    endelse
    print,threeDenPro_ReadCIF2_getSymmetries(symmetry,unitrotator,unittranslator)
    

    nsymmetries = n_elements(symmetry)






		;
		;
		;		loop_
		;		 _atom_site_label
		;		 _atom_site_type_symbol
		;		 _atom_site_fract_x
		;		 _atom_site_fract_y
		;		 _atom_site_fract_z
		;		 _atom_site_U_iso_or_equiv
		;		 _atom_site_adp_type
		;		 _atom_site_occupancy
		;		 _atom_site_symmetry_multiplicity
		;		 _atom_site_calc_flag
		;		 _atom_site_refinement_flags
		;		 _atom_site_disorder_assembly
		;		 _atom_site_disorder_group



		;		loop_
		;		 _geom_bond_atom_site_label_1
		;		 _geom_bond_atom_site_label_2
		;		 _geom_bond_distance
		;		 _geom_bond_site_symmetry_2
		;		 _geom_bond_publ_flag


;    if nsymmetries gt 0 then begin
;      ;symmetry  = '';strarr(nSymmetries);replicate(sym,nSymmetries)
;  
;      symmetry  = strarr(nSymmetries);replicate(sym,nSymmetries)
;      istart = symmetryStart
;      for i=istart,istart+nsymmetries-1 do begin
;        symmetry[i-istart] = s[i]
;      endfor;i
;    endif else begin
;      symmetry = 'x, y, z'
;    endelse
;    print,threeDenPro_ReadCIF2_getSymmetries(symmetry,unitrotator,unittranslator)
;    
;
;    nsymmetries = n_elements(symmetry)
    
    list = replicate(unit,natoms*nsymmetries)

    if nbonds gt 0 then begin
      bonds = replicate(bond,nbonds)
    endif else begin
      bonds = replicate(bond,1)
    endelse

		segs = strsplit(line,/extract)
		istart = atomstart

	;;;Ce1 Ce 0.08344(3) 0.70617(11) 0.33337(14) 0.0301(3) Uani 1 1 d . . .
		atoms = strarr(natoms*nsymmetries)
		x = dblarr(natoms*nsymmetries)
		y = dblarr(natoms*nsymmetries)
		z = dblarr(natoms*nsymmetries)

		;if i ge istart and i lt istart+natoms then begin
		for i=istart,istart+natoms-1 do begin

			segs = strsplit(s[i],/extract)
;      if symbolsplitlinetag ne 0 then begin
;        segs = [segs,strsplit(s[i+1],/extract)]
;      endif
;print,segs
			;ASSUME NOW THAT abc,abg ARE AVAILABLE


			;CALCULATE ANGLES IN RADIANS
			alpha = !dtor*abg[0]
			beta  = !dtor*abg[1]
			gamma = !dtor*abg[2]
			delta = acos(sqrt( (cos(beta) + cos(alpha)*cos(gamma))^2 + (cos(alpha)*sin(gamma))^2))

			;CALCULATE PRIMITIVE LATTICE COMPONENTS
			a1 = [abc[0],0,0]
			a2 = abc[1]*[cos(gamma),sin(gamma),0]
			a3 = abc[2]*[cos(beta)+cos(alpha)*cos(gamma),cos(alpha)*sin(gamma),sin(delta)]


			ucboxpoints[0,*] = [0,0,0]
			ucboxpoints[1,*] = a1
			ucboxpoints[2,*] = a2
			ucboxpoints[3,*] = a3
			ucboxpoints[4,*] = a1+a2
			ucboxpoints[5,*] = a2+a3
			ucboxpoints[6,*] = a1+a3
			ucboxpoints[7,*] = a1+a2+a3


;LRK 01/20/09
;NOW I HAVE TO CREATE ALL THE SYMMETRIES BEFORE CONTINUING       
rotsize  = size(unitrotator)
transize = size(unittranslator)
      for isym = 0,nsymmetries-1 do begin

        			;CONVERT THE COORDINATES FROM PRIMITIVE LATTICE CORRDS TO XYZ.
        			atoms[i-istart+natoms*isym] = segs[labelposition]
              ;atoms[i-istart+natoms*isym] = segs[1]
        ;NOW MAKE THE COORDINATE TRANSFORMATION HERE:

              ;GET THE FRACTIONAL COORDINATES (0-1, hence "uni")
              uni0 = double(segs[xposition])
              uni1 = double(segs[yposition])
              uni2 = double(segs[zposition])
;              uni0 = double(segs[2])
;              uni1 = double(segs[3])
;              uni2 = double(segs[4])

              ;MAKE THE ROTATION AND TRANSLATION
;FIRST CHECK TO SEE IF THE ROTATOR IS 3x3 or 3x3xnsymmetries AND TRANSLATOR IS 3 element OR 3xnsymmetries
              if transize[0] eq 2 then begin
                unix = unittranslator[0,isym] + unitrotator[0,0,isym]*uni0 + unitrotator[0,1,isym]*uni1 + unitrotator[0,2,isym]*uni2 
                uniy = unittranslator[1,isym] + unitrotator[1,0,isym]*uni0 + unitrotator[1,1,isym]*uni1 + unitrotator[1,2,isym]*uni2 
                uniz = unittranslator[2,isym] + unitrotator[2,0,isym]*uni0 + unitrotator[2,1,isym]*uni1 + unitrotator[2,2,isym]*uni2 
              endif else begin
                unix = unittranslator[0] + unitrotator[0,0]*uni0 + unitrotator[0,1]*uni1 + unitrotator[0,2]*uni2 
                uniy = unittranslator[1] + unitrotator[1,0]*uni0 + unitrotator[1,1]*uni1 + unitrotator[1,2]*uni2 
                uniz = unittranslator[2] + unitrotator[2,0]*uni0 + unitrotator[2,1]*uni1 + unitrotator[2,2]*uni2 
              endelse

              ;NOW TRANSLATE SYMMETRIC STUFF INSIDE THE UNIT CELL.
              ;
              if unix ge 2.0 then unix = unix - 2.0
              if uniy ge 2.0 then uniy = uniy - 2.0
              if uniz ge 2.0 then uniz = uniz - 2.0

              if unix ge 1.0 and unix lt 2.0 then unix = unix - 1.0
              if uniy ge 1.0 and uniy lt 2.0 then uniy = uniy - 1.0
              if uniz ge 1.0 and uniz lt 2.0 then uniz = uniz - 1.0

              if unix lt 0.0 and unix ge -1.0 then unix = unix + 1.0
              if uniy lt 0.0 and uniy ge -1.0 then uniy = uniy + 1.0
              if uniz lt 0.0 and uniz ge -1.0 then uniz = uniz + 1.0

              if unix lt -1.0 then unix = unix + 2.0
              if uniy lt -1.0 then uniy = uniy + 2.0
              if uniz lt -1.0 then uniz = uniz + 2.0


              ;CONVERT TO UNIT CELL VALUES
        			coords = a1*unix + a2*uniy + a3*uniz
        			;print,'coords=',coords
        			x[i-istart+natoms*isym] = coords[0]
        			y[i-istart+natoms*isym] = coords[1]
        			z[i-istart+natoms*isym] = coords[2]
        
          
        
        			list[i-istart+natoms*isym]._atom_site_label = segs[labelposition]
        			list[i-istart+natoms*isym]._atom_site_type_symbol = segs[symbolposition]

        			list[i-istart+natoms*isym]._atom_site_fract_x = unix;double(segs[2])
        			list[i-istart+natoms*isym]._atom_site_fract_y = uniy;double(segs[3])
        			list[i-istart+natoms*isym]._atom_site_fract_z = uniz;double(segs[4])
;LRK 021309 COMMENT OUT THE NEXT ITEMS FOR NOW
;        			if n_elements(segs) gt 5 then list[i-istart+natoms*isym]._atom_site_U_iso_or_equiv = double(segs[5])
;        			if n_elements(segs) gt 6 then list[i-istart+natoms*isym]._atom_site_adp_type = segs[6]
;        			if n_elements(segs) gt 7 then list[i-istart+natoms*isym]._atom_site_occupancy = double(segs[7])
;        			if n_elements(segs) gt 8 then list[i-istart+natoms*isym]._atom_site_symmetry_multiplicity = fix(segs[8])
;        			if n_elements(segs) gt 9 then list[i-istart+natoms*isym]._atom_site_calc_flag = segs[9]
;        			if n_elements(segs) gt 10 then list[i-istart+natoms*isym]._atom_site_refinement_flags = segs[10]
;        			if n_elements(segs) gt 11 then list[i-istart+natoms*isym]._atom_site_disorder_assembly = segs[11]
;        			if n_elements(segs) gt 12 then list[i-istart+natoms*isym]._atom_site_disorder_group = segs[12]

print,segs[symbolposition]
        			list[i-istart+natoms*isym].color = cifcolor(segs[symbolposition])
        			list[i-istart+natoms*isym].radius = cifradius(segs[symbolposition])
        			list[i-istart+natoms*isym].x = x[i-istart+natoms*isym]
        			list[i-istart+natoms*isym].y = y[i-istart+natoms*isym]
        			list[i-istart+natoms*isym].z = z[i-istart+natoms*isym]
      endfor;isym
		endfor;i 	(atoms)
    
    ;NOW ELIMINATE REDUNDANCIES IN LIST
    ;1) LOOP THROUGH AND LOCATE REDUNDANCIES
    ;2) CREATE NEW LIST WITH RIGHT LENGTH
    ;3) ADD ALL NON-REDUNDANT ITEMS TO THE NEW LIST
    whredundant = [-1]
    redundantcount = 0
    for i=0,n_elements(LIST)-1 do begin
      for j=i+1,n_elements(list)-1 do begin
        rdiff = sqrt((list[i].x-list[j].x)^2 + (list[i].y-list[j].y)^2 + (list[i].z-list[j].z)^2)
        if rdiff lt 0.3 then begin
          whredundantredundant = where(whredundant eq j,redundantredundant)
          if redundantredundant eq 0 then begin
            whredundant = [whredundant,j]
            redundantcount = redundantcount + 1
          endif;redundantredundant
        endif
      endfor;j
    endfor;i
print,whredundant
    if redundantcount gt 0 then begin
      newlist = replicate(unit,natoms*nsymmetries - redundantcount)
      whredundant = whredundant[1:*]
    
      index = 0
      for i = 0 , n_elements(list)-1 do begin
        redundant = where(i eq whredundant,redcount)
        if redcount eq 0 then begin
          newlist[index] = list[i]
          index = index + 1
        endif 
      endfor
      list = newlist      
    endif;redundantcount

    if nbonds gt 0 then begin
      		;segs = strsplit(line,/extract)
      		for i = bondstart, bondstart+nbonds-1 do begin
      			segs = strsplit(s[i],/extract)
      			bonds[i-bondstart]._geom_bond_atom_site_label_1 = segs[0]
      			bonds[i-bondstart]._geom_bond_atom_site_label_2 = segs[1]
      			bonds[i-bondstart]._geom_bond_distance = double(segs[2])
      ;			bonds[i-bondstart]._geom_bond_site_symmetry_2 = double(segs[3])
      			if n_elements(segs) gt 4 then bonds[i-bondstart]._geom_bond_publ_flag = segs[4]
      		endfor;i	(bonds)
      		;endfor;i
    endif;endbonds

		return,1
	endif else begin
		return,0
	endelse
end;threeDenPro_ReadCIF2

