; $Id$



function PawConvert_convert_getHeaders,filename
  
  line = ''
  nlines = file_lines(filename)
  s = strarr(nlines)
  openr,lun,filename,/get_lun
  readf,lun,s
  free_lun,lun

  return,s

end;PawConvert

pro PawConvert_convert,buffer,xcol,ycol,zcol,davePtr=davePtr,dataPtr=dataPtr,workDir=workDir,mslice=mslice,group_leader=group_leader,davetool=daveTool

            
            if n_elements(mslice) eq 0 then mslice = 0

            ;  fn = dialog_pickfile(path='C:\Documents and Settings\kneller\Desktop\DAVECode061808\dave_devel\programs\modules\DenPro\Data\',$
            ;                       filter=['*.DAT','*.dat'])
            ;  print,fn
            
            ;  fn1 = 'C:\Documents and Settings\kneller\Desktop\DAVECode061808\dave_devel\programs\modules\DenPro\Data\Smpl2SAt.DAT'
            ;  fn2 = 'C:\Documents and Settings\kneller\Desktop\DAVECode061808\dave_devel\programs\modules\DenPro\Data\SSmpl2AtMatr.DAT'
            

;              fn = filename
;              nlines = file_lines(fn)
;              npts = nlines - 1
;
;              ;CHECK FOR A HEADER LINE
;              line = ''
;              openr,lun,fn,/get_lun
;              readf,lun,line  ;read header line
;              free_lun,lun
;
;              if stregex(line,'#',/fold_case,/boolean) eq 0 then begin
;                npts = nlines
;              endif
;
;              ;CREATE DATA ARRAYS
;              x = fltarr(npts)
;              y = fltarr(npts)
;              z = fltarr(npts)
;
;              ;READ THE FILE
;              openr,lun,fn,/get_lun
;              if npts ne nlines then begin                
;                readf,lun,line  ;read header
;              endif
;
;              ;for i=0L,nlines-2 do begin
;              for i=0L,npts-1 do begin
;                readf,lun,line
;                
;                ;print,line
;                segs = strsplit(line,/extract)
;                x[i] = float(segs[xcol])
;                y[i] = float(segs[ycol])
;                z[i] = float(segs[zcol])                
;              endfor;i
;              free_lun,lun


              ;buffer = (*(*pstate).buffer)
              x = reform(buffer[xcol,*])
              y = reform(buffer[ycol,*])
              z = reform(buffer[zcol,*])



;<<<<<<< pawconvert.pro
;                
;              ;SEND TO MSLICE IF DESIRED
;              if mslice ne 0 then begin
;                      xdata=x
;                      ydata=y
;                      zdata=z
;                      zerr=0.00001*z
;                      
;                      data=[[zdata],[zerr],[xdata],[ydata]]
;                
;                      label  = ['Intensity','Err','x','y']
;                      unit   = ['','','','']
;                      instrument = 'Pawel Convert'
;                      dataPtr = ptr_new({data:data,label:label,unit:unit,instrument:instrument})
;            
;                      dataDir = file_dirname(fn)
;                      workDir = dataDir
;                      
;                      obj_mslice = obj_new('dcs_mslice', dataPtr=dataPtr, $
;                                    group_leader=group_leader,$
;                                    workDir=workDir,dataDir=dataDir)
;
;              endif
;=======
                
              if mslice ne 0 then begin
                      xdata=x
                      ydata=y
                      zdata=z
                      zerr=sqrt(abs(z))
                      index = where(zerr le 0, count)
                      if (count gt 0) then zerr[index] = 1
                      
                      data=[[zdata],[zerr],[xdata],[ydata]]
                
                      label  = ['Int','Err','x','y']
                      unit   = ['','','','']
                      instrument = 'Pawel Convert'
                      dataPtr = ptr_new({data:data,label:label,unit:unit,instrument:instrument})
            
                      obj_mslice = obj_new('dcs_mslice', dataPtr=dataPtr, $
                                    group_leader=group_leader,$
                                    workDir=workDir,dataDir=dataDir,daveTool=daveTool)
                      return
              endif
;;>>>>>>> 1.5
;     
;; print,max(x),min(x)    
;; print,max(y),min(y)    
;              
;              
;              ;CREATE TRIANGULATED SURFACE.  NOTE:  HOW WELL DOES THIS DO FOR NON-CONVEX SHAPES?
;              triangulate,x,y,triangles
;              Result = TRIGRID( X, Y, Z,triangles)
;;              window,0,xpos=1600,ypos=200
;;              device,get_decomposed=dc
;;            ;  
;;              ct = 5
;;            ;  
;;              device,decomposed=0
;;              loadct,ct
;;              plotimage,bytscl(result,min=0,max=7);,xrange=[5,7],yrange=[5,7]
;;            ;
;;              colorbar,minrange=min(result),maxrange=max(result)
;;            ;  
;;              device,decomposed=dc
;
;            sz = size(result)
;;            xnew = findgen(sz[1])/float(sz[1]-1)##(fltarr(sz[2])+1)*(max(x)-min(x)) + min(x)
;;            ynew = (fltarr(sz[1])+1)##findgen(sz[2])/float(sz[2]-1)*(max(y)-min(y)) + min(y)
;
;            xnew = (findgen(sz[1])/float(sz[1]-1))*(max(x)-min(x)) + min(x)
;            ynew = (findgen(sz[2])/float(sz[2]-1))*(max(y)-min(y)) + min(y)
;
;;data = dblarr(n_elements(x),4)
;;data[*,2] = x
;;data[*,3] = y
;;data[*,0] = z
;;data[*,1] = sqrt(z)
;;
;;
;;dataPtr = ptr_new({data:temporary(data),label:['z','dz','x','y']});'Data'});,unit:unit,instrument:instrument})
;;;obj_mslice = obj_new('dcs_mslice',dataPtr=dataPtr)
;;;or 
;;dcs_mslice,dataPtr=dataPtr,obj_mslice=obj_mslice $
;;            ,group_leader = group_leader, workDir=workDir $
;;            ,dataDir=dataDir, _EXTRA=etc
; 
;
;
;
;              
;            ;  print,xnew,ynew
;              ;contour,result,xnew,ynew
;            ;  shade_surf,result,xnew,ynew
;            ;
;            ;  colorbar,minrange=min(result),maxrange=max(result)
;            ;  
;            ;  device,decomposed=dc
;            
;            
;            dum = create_dave_pointer(daveptr,qty=result,err=0*result,xvals=xnew,yvals=ynew)
;            
;;            fn = 'C:\Documents and Settings\kneller\Desktop\DAVECode061808\dave_devel\programs\modules\DenPro\Data\DannyData\pawelsulfur.dave'
;;            save,daveptr,filename=fn  
;            ;  isurface,result,xnew,ynew

    Catch, catchError
    if (catchError ne 0) then begin
      ;;print, 'Error handled!'
      eTitle = 'PawConvert: Error encountered'
      eMsg = 'An error or unusual condition was encountered!'
      eMsg = [eMsg,'Please, report the following to the DAVE team:']
      eMsg = [eMsg,!error_state.msg]
      print, emsg
      ;void = Dialog_message(/error,eMsg,title=eTitle,dialog_parent=Event.top)
      Catch, /cancel
      Return
    endif

    yVals =  y[uniq(y, sort(y))]
    xVals =  x[uniq(x, sort(x))]
    nx = n_elements(xVals)
    ny = n_elements(yVals)
    zVals = fltarr(nx,ny)

    if (ny lt nx) then begin
      minDiff = Min(Abs(yVals - yVals.Shift(1)))
      tol =  0.01*minDiff ; 0.001*yVals[i]
      for i=0,ny-1 do begin
        index = where(abs(y - yVals[i]) le tol, cnt)
        if (cnt le 0 || fix(cnt/nx) ne 1 || cnt mod nx ne 0) then begin
          msg = 'Something unusual about the dataset!'
          msg = [msg,'It cannot be reformed into a rectangular grid']
          msg = [msg,'Try processing it by exporting to Mslice']
          void = Dialog_message(/error,msg,title='PawConvert',dialog_parent=group_leader)
          return
        endif
        xVals = x[index]
        xIndexSort = Sort(xVals)    ; necessary to ensure x is sorted
        index = index[xIndexSort]   ; adjust index if x sorting changes
        zVals[*,i] = z[index]       ; record the values in the 1st dim of zVals array
        xVals = x[index]
      endfor
    endif else begin
      minDiff = Min(Abs(xVals - xVals.Shift(1)))
      tol =  0.01*minDiff ;0.001*xVals[i]
      for i=0,nx-1 do begin
        index = where(abs(x - xVals[i]) le tol, cnt)
        if (cnt le 0 || Fix(cnt/ny) ne 1 || cnt mod ny ne 0) then begin
          msg = 'Something unusual about the dataset!'
          msg = [msg,'It cannot be reformed into a rectangular grid']
          msg = [msg,'Try processing it by exporting to Mslice']
          void = Dialog_message(/error,msg,title='PawConvert',dialog_parent=group_leader)
          Return
        endif
        if (cnt gt 0) then begin
          yVals = y[index]
          yIndexSort = sort(yVals)    ; necessary to ensure y is sorted
          index = index[yIndexSort]   ; adjust index if y sorting changes
          zVals[i,*] = z[index]       ; record the values in the 2nd dim of zVals array
          yVals = y[index]
        endif
      endfor
    endelse
    zerr=Sqrt(Abs(zVals))
    index = Where(zerr le 0, count)
    if (count gt 0) then zerr[index] = 1

    dum = create_dave_pointer(daveptr,qty=zVals,err=zErr,xvals=xVals,yvals=yVals)


end;PawConvert_convert


function pawConvert_helpText

  s = [ $
        'Warning:  PawConvert is written for a specific task for a specific user.',$
        '          ',$
        '          ',$
        'Paw Convert creates a 2d arrray from a list of x,y,x values.',$
        'The user enters an ASCII file with 3 or more columns.  The program assumes ',$
        'that the first three columns are x,y,z values, and it calculates a 2d array',$
        'using the TRIANGULATE procedure and the TRIGRID function available in IDL.',$
        '',$
        'If everything went alright, Paw Convert prompts the user for a DAVE output file',$
        'which can be visualized using the tools in DAVE2.' $
      ]
  return,s
end;pawConvert_helpText

pro PawConvert_convert_setTextBoxes,event

    widget_control,event.handler,get_uvalue=pstate
    buffer = *(*pstate).buffer
    
;    toks = Strsplit(line,/extract,count=ntoks)
;    index = String(Lindgen(ntoks))

    xi = Nse_comboindex((*pstate).cbx)
    yi = Nse_comboindex((*pstate).cby)
    zi = Nse_comboindex((*pstate).cbz)

    Widget_control,(*pstate).textx,set_value=String(Reform(buffer[xi,0:50]))
    Widget_control,(*pstate).texty,set_value=String(Reform(buffer[yi,0:50]))
    Widget_control,(*pstate).textz,set_value=String(Reform(buffer[zi,0:50]))
    
;    xarr = strarr(n_elements(s)-1)
;    yarr = strarr(n_elements(s)-1)
;    zarr = strarr(n_elements(s)-1)
;    for i=1L,n_elements(s)-1 do begin
;      segs = strsplit(s[i],/extract)
;      xarr[i-1] = segs[xi]
;      yarr[i-1] = segs[yi]
;      zarr[i-1] = segs[zi]
;    endfor;i
;    widget_control,(*pstate).textx,set_value=xarr
;    widget_control,(*pstate).texty,set_value=yarr
;    widget_control,(*pstate).textz,set_value=zarr

end;PawConvert_convert_setTextBoxes

pro PawConvert_event,event


  catch, catchError
  if (catchError ne 0) then begin
      ;;print, 'Error handled!'
      eTitle = 'PawConvert: Error encountered'
      eMsg = 'An error or unusual condition was encountered!'
      eMsg = [eMsg,'Please, report the following to the DAVE team:']
      eMsg = [eMsg,!error_state.msg]
      void = dialog_message(/error,eMsg,title=eTitle,dialog_parent=event.top)
      catch, /cancel
      return
  endif




  widget_control,event.handler,get_uvalue=pstate
  
  case event.id of

  (*pstate).open:begin
    fn = dialog_pickfile(path=(*pstate).datadir,dialog_parent=(*pstate).tlb,title='Select data file:',$
                         /read)
    if (fn eq '') then break                     
    
;    if fn ne '' then begin
;      (*pstate).inputFile = fn
;      (*pstate).dataDir = file_dirname(fn)
;      widget_control,(*pstate).tlb,base_set_title='PawConvert: '+file_basename(fn)
;
;      s = PawConvert_convert_getHeaders(fn)
;      *(*pstate).ps = s
;      segs = strsplit(s[1],/extract)
;      widget_control,(*pstate).cbx,set_value=string(lindgen(n_elements(segs))),set_combobox_select=0
;      widget_control,(*pstate).cby,set_value=string(lindgen(n_elements(segs))),set_combobox_select=1
;      widget_control,(*pstate).cbz,set_value=string(lindgen(n_elements(segs))),set_combobox_select=2
;      PawConvert_convert_setTextBoxes,event
;    endif

tic
;    nlines = file_lines(fn)
;    openr,lun,fn,/get_lun
;    readheader=1
;    line = ''
;    npts = nlines
;    repeat begin
;      readf, lun, line
;      if stregex(line,'#',/fold_case,/boolean) then begin
;        npts--
;      endif else readheader = 0
;    endrep until (readheader eq 0)
;
;    if (npts eq nlines) then begin
;      buffer = fltarr(3,npts)
;      point_lun, lun, 0  ; rewind to the beginning
;      readf,lun,buffer
;      free_lun,lun,/force
;    endif else begin
;      buffer = fltarr(3,npts - 1)
;      readf,lun,buffer
;      free_lun,lun,/force
;      buf = float(strsplit(line,/extract))
;      buffer = transpose([transpose(buf),transpose(temporary(buffer))])
;    endelse


    nlines = File_lines(fn)
    lines = strarr(nlines)
    Openr,lun,fn,/get_lun
    readf, lun, lines
    free_lun,lun,/force
    line = ''
    start = 0
    for i = 0,nlines-1 do begin
      if (~stregex(lines[i],'#',/fold_case,/boolean)) then break
      start++
    endfor
    
    npts = nlines - start
    buffer = fltarr(3,npts)
    lines = temporary(lines[start:nlines-1])
    reads, lines, buffer
    line = lines[0]
toc

;    x = reform(buffer[xcol,*])
;    y = reform(buffer[ycol,*])
;    z = reform(buffer[zcol,*])

    toks = strsplit(line,/extract,count=ntoks)
    index = string(lindgen(ntoks))
    widget_control,(*pstate).cbx,set_value=index,set_combobox_select=0
    widget_control,(*pstate).cby,set_value=index,set_combobox_select=1
    widget_control,(*pstate).cbz,set_value=index,set_combobox_select=2
    
    widget_control,(*pstate).textx,set_value=string(reform(buffer[0,0:50]))
    widget_control,(*pstate).texty,set_value=string(reform(buffer[1,0:50]))
    widget_control,(*pstate).textz,set_value=string(reform(buffer[2,0:50]))

    if (ptr_valid((*pstate).buffer)) then ptr_free, (*pstate).buffer
    (*pstate).buffer = ptr_new(buffer)
    
    (*pstate).inputFile = fn
    
    (*pState).workDir = file_dirname(fn)

  end;open
  
  (*pstate).work:begin
    dir = dialog_pickfile(title='Select Working Directory',path=(*pstate).workdir,/directory,dialog_parent=(*pstate).tlb)    
    if dir ne '' then (*pstate).workdir = dir
  end;work
  (*pstate).data:begin
    dir = dialog_pickfile(title='Select Data Directory',path=(*pstate).datadir,/directory,dialog_parent=(*pstate).tlb)
    if dir ne '' then (*pstate).datadir = dir
  end;data
  (*pstate).cbx:begin
    PawConvert_convert_setTextBoxes,event
  end;cbx
  (*pstate).cby:begin
    PawConvert_convert_setTextBoxes,event
  end;cby
  (*pstate).cbz:begin
    PawConvert_convert_setTextBoxes,event
  end;cbz
  (*pstate).convert:begin

    xcol = nse_comboindex((*pstate).cbx)
    ycol = nse_comboindex((*pstate).cby)
    zcol = nse_comboindex((*pstate).cbz)
  
    PawConvert_convert,(*(*pstate).buffer),xcol,ycol,zcol,davePtr=daveptr,group_leader=(*pstate).tlb 
    if ptr_valid(davePtr) then begin
      if ptr_valid((*pstate).daveptr) then begin
        temp = (*pstate).daveptr
        (*pstate).daveptr = daveptr
        ptr_free,temp
      endif
      
      fn = dialog_pickfile(path=(*pstate).workDir,dialog_parent=(*pstate).tlb,title='Select DAVE output file:',$
                            /write)      
      if fn ne '' then begin
        (*pstate).outputFile = fn
        save,davePtr,filename=fn
        void = dialog_message('DAVE data saved in: '+file_basename(fn),dialog_parent=(*pstate).tlb,/info,title='PAWConvert Info:')
      endif
    endif 
  end;convert
  (*pstate).send:begin
      nameTag = file_basename((*pstate).inputFile)

    xcol = nse_comboindex((*pstate).cbx)
    ycol = nse_comboindex((*pstate).cby)
    zcol = nse_comboindex((*pstate).cbz)
  
    PawConvert_convert,(*(*pstate).buffer),xcol,ycol,zcol,davePtr=daveptr,group_leader=(*pstate).tlb 
    if ptr_valid(davePtr) then begin
      if ptr_valid((*pstate).daveptr) then begin
        ; Send data to DAVE Data Manager Folder
        if obj_valid((*pstate).davetool) then begin
          ((*pstate).DAVETool)->AddDavePtrToDataManager, davePtr, nameTag
        endif
        heap_free, davePtr
      endif
    endif 
      

  end;sendToDAVE
  (*pstate).sendToMslice:begin
      nameTag = "MSlice"

    xcol = nse_comboindex((*pstate).cbx)
    ycol = nse_comboindex((*pstate).cby)
    zcol = nse_comboindex((*pstate).cbz)
  
    ;PawConvert_convert,(*pstate).inputFile,xcol,ycol,zcol,davePtr=daveptr 
    PawConvert_convert,(*(*pstate).buffer),xcol,ycol,zcol,/mslice,group_leader=(*pstate).tlb,workDir=(*pstate).workDir, davetool=(*pstate).daveTool   

  end;sendToMslice
  (*pstate).help:begin
    void=dialog_message(pawConvert_helptext(),dialog_parent=(*pstate).tlb)
  end;help
  (*pstate).quit:begin
    widget_control,(*pstate).tlb,/destroy
  end;quit
  else:
  endcase


end;PawConvert_event

pro pawConvert_cleanup,tlb
  print,'pawConvert_cleanup'
  widget_control,tlb,get_uvalue=pstate
  if ptr_valid((*pstate).ps) then ptr_free,(*pstate).ps
  if ptr_valid((*pstate).buffer) then ptr_free,(*pstate).buffer
  if ptr_valid((*pstate).daveptr) then ptr_free,(*pstate).daveptr
  if ptr_valid(pstate) then ptr_free,pstate
  
end;pawConvert_cleanup
pro PawConvert,group_leader=group_leader,workDir=workDir,dataDir=dataDir,DAVETool=DAVETool


  if n_elements(workdir) eq 0 then workdir = '.'
  if n_elements(datadir) eq 0 then datadir = '.'
  if n_elements(DAVETool) eq 0 then DAVETool=obj_new()

  if n_elements(group_leader) eq 0 then begin
    tlb = widget_base(title='PawConvert',mbar=bar,/row)
  endif else begin
    tlb = widget_base(title='PawConvert',group_leader=group_leader,mbar=bar,/row)
  endelse

  File = widget_button(bar,value='File',/menu)
  open = widget_button(file,value='open')
  data = widget_button(file,value='Set Data Directory')
  work = widget_button(file,value='Set Working Directory')
  quit = widget_button(file,value='quit')
  
  helpmenu = widget_button(bar,value='Help',/menu)
  help     = widget_button(helpmenu,value='Help on PawConvert')
  
  llbx = widget_base(tlb,/col)
  labx = widget_label(llbx,value='X Column') 
  cbx = widget_combobox(llbx,value=['Column 1'])
  textx = widget_text(llbx,value='',ysize=10,xsize=15) 

  llby = widget_base(tlb,/col)
  laby = widget_label(llby,value='Y Column') 
  cby = widget_combobox(llby,value=['Column 2'])
  texty = widget_text(llby,value='',ysize=10,xsize=15) 

  llbz = widget_base(tlb,/col)
  labz = widget_label(llbz,value='Z Column')
  cbz = widget_combobox(llbz,value=['Column 3'])
  textz = widget_text(llbz,value='',ysize=10,xsize=15) 
  
  opbase  = widget_base(tlb,/col)
  convert = widget_button(opbase,value='Convert to DAVE',ysize=25)
  send    = widget_button(opbase,value='Send To DAVE Data Manager',ysize=25)
  sendToMslice = widget_button(opbase,value='Send To Mslice',ysize=25)

  state = {tlb:tlb,open:open,quit:quit,help:help,work:work,data:data,convert:convert,send:send,sendToMslice:sendToMslice,$
           workdir:workdir,datadir:datadir,$
           cbx:cbx,cby:cby,cbz:cbz,inputfile:'',outputfile:'',$
           textx:textx,texty:texty,textz:textz,ps:ptr_new(/allocate),buffer:ptr_new(), $
           DAVETool:DAVETool,davePtr:ptr_new(/allocate)} 

  pstate = ptr_new(state)
  
  centertlb,tlb
  widget_control,tlb,/realize,set_uvalue=pstate
  
  xmanager,'PawConvert',tlb,event_handler='PawConvert_event',/no_block,cleanup='PawConvert_cleanup'


end;PawConvert

pro launch_pawConvert,oUI,oReq,datadir=datadir,$
                                     workdir=workdir,$
                                     davetool=davetool,$
                                     group_leader=group_leader,$
                                     _extra=extra
  compile_opt idl2
  if n_elements(group_leader) eq 0 then oUI->getProperty,group_leader=group_leader
  if n_elements(DaveTool) eq 0 then davetool=getDAVETool()
  PawConvert,group_leader=group_leader,workDir=workDir,dataDir=dataDir,DAVETool=DAVETool


end;launch_pawConvert


pro test_read, opt
fn = 'S:\prog\idlwork\test\Pawel\one_file_commentlines.dat'
if n_elements(opt) eq 0 then opt=1

nlines = file_lines(fn)
openr,lun,fn,/get_lun
if (opt eq 1) then begin
  tic
  npts = nlines - 1

  ;CHECK FOR A HEADER LINE
  line = ''
  readf,lun,line  ;read header line
  free_lun,lun

  if stregex(line,'#',/fold_case,/boolean) eq 0 then begin
    npts = nlines
  endif

  ;CREATE DATA ARRAYS
  x = fltarr(npts)
  y = fltarr(npts)
  z = fltarr(npts)

  ;READ THE FILE
  openr,lun,fn,/get_lun
  if npts ne nlines then begin
    readf,lun,line  ;read header
  endif

  ;for i=0L,nlines-2 do begin
  for i=0L,npts-1 do begin
    readf,lun,line

    ;print,line
    segs = strsplit(line,/extract)
    x[i] = float(segs[0])
    y[i] = float(segs[1])
    z[i] = float(segs[2])
  endfor;i
  free_lun,lun,/force
  dm_stepgrid_bin,0,0,x,y,z,extlib=1,uniq_xval=x[uniq(x,sort(x))],uniq_yval=y[uniq(y,sort(y))],/debug;,/const

  toc

  ;help,x,y,z
  ;print,x[0:3]
  myplot=obj_new('dm_plot',x,y,z,/surfplot,title=fn,coltable=2)
  myplot->draw
endif else begin
  tic
  readheader=1
  line = ''
  npts = nlines
  repeat begin
    readf, lun, line
    if stregex(line,'#',/fold_case,/boolean) then begin
      npts--
    endif else readheader = 0
  endrep until (readheader eq 0)

  if (npts eq nlines) then begin
    buffer = fltarr(3,npts)
    point_lun, lun, 0  ; rewind to the beginning
    readf,lun,buffer
    free_lun,lun,/force
  endif else begin
    buffer = fltarr(3,npts - 1)
    readf,lun,buffer
    free_lun,lun,/force
    line = float(strsplit(line,/extract))
    buffer = transpose([transpose(line),transpose(temporary(buffer))])
  endelse

  x = reform(buffer[0,*])
  y = reform(buffer[1,*])
  z = reform(buffer[2,*])

  yVals =  y[uniq(y, sort(y))]
  xVals =  x[uniq(x, sort(x))]
  nx = n_elements(xVals)
  ny = n_elements(yVals)
  zVals = fltarr(nx,ny)
  if (ny lt nx) then begin
    for i=0,ny-1 do begin
      tol = 0.001*yVals[i]
      index = where(abs(y - yVals[i]) le tol, cnt)
      if (cnt gt 0) then begin
        xVals = x[index]
        xIndexSort = sort(xVals)    ; necessary to ensure x is sorted
        index = index[xIndexSort]   ; adjust index if x sorting changes
        zVals[*,i] = z[index]       ; record the values in the 1st dim of zVals array
        xVals = x[index]
      endif
    endfor    
  endif else begin
    for i=0,nx-1 do begin
      tol = 0.001*xVals[i]
      index = where(abs(x - xVals[i]) le tol, cnt)
      if (cnt gt 0) then begin
        yVals = y[index]
        yIndexSort = sort(yVals)    ; necessary to ensure y is sorted
        index = index[yIndexSort]   ; adjust index if y sorting changes
        zVals[i,*] = z[index]       ; record the values in the 2nd dim of zVals array
        yVals = y[index]
      endif
    endfor
    
  endelse
  toc
  s1 = surface(zVals,xVals,yVals,irregular=0,title=fn)
endelse


end
