; $Id$
; Written by J.R.D. Copley.
;************************************************************************************************
;###############################################################################
;
; LICENSE:
;  The software in this file is written by an employee of 
;  National Institute of Standards and Technology 
;  as part of the DAVE software project.
;
;  The DAVE software package is not subject to copyright protection
;  and is in the public domain. It should be considered as an
;  experimental neutron scattering data reduction, visualization, and
;  analysis system. As such, the authors assume no responsibility
;  whatsoever for its use, and make no guarantees, expressed or
;  implied, about its quality, reliability, or any other
;  characteristic. The use of certain trade names or commercial
;  products does not imply any endorsement of a particular product,
;  nor does it imply that the named product is necessarily the best
;  product for the stated purpose. We would appreciate acknowledgment
;  if the DAVE software is used or if the code in this file is
;  included in another product.
;
;###############################################################################
pro dcs_multiplechoice,dcs_base,decision,match_title,message_str,maxlen,$
	nbuttonrow=nbuttonrow,blabel=blabel,skipdefaultchoices=skipdefaultchoices,$
	visibility=visibility
;************************************************************************************************
; This routine sets things up for a call to "dcs_multichoice_modal", which displays a modal
; widget with a set of choices.
;
compile_opt strictarr
;
	mindex=where(message_str.title eq match_title)
	mindex=mindex[0]
	message=message_str.text[mindex]
	dcs_superstring_wrap,message[0],maxlen,outstring,error
	com="blabel=["+message_str.choices[mindex]+"]"
	result=execute(com)
	def_button=message_str.def[mindex]
	can_button=message_str.can[mindex]
	nbutton=n_elements(blabel)
	if (not keyword_set(nbuttonrow)) then nbuttonrow=[nbutton]
	if (not keyword_set(visibility)) then visibility=bytarr(nbutton)+1
	;
	if (skipdefaultchoices and def_button ge 0) then decision=def_button else $
		dcs_multichoice_modal,outstring,decision,blabel,def_button,can_button,$
			group_leader=dcs_base,alignment=0,nbuttonrow=nbuttonrow,$
			visibility=visibility
end