; $Id$
;###############################################################################
;
; NAME:
;  LAUNCH_
;
; PURPOSE:
;  Launcher for Mslice when used to analyse a dataset already loaded into DAVE's Data Manager.
;
; CATEGORY:
;  DAVE, Data Analysis, Mslice
;
; Richard Tumanjong Azuah
; NIST Center for Neutron Research
; azuah@nist.gov; (301) 9755604
; Mar 2014
;
; LICENSE:
;  The software in this file is written by an employee of
;  National Institute of Standards and Technology
;  as part of the DAVE software project.
;
;  The DAVE software package is not subject to copyright protection
;  and is in the public domain. It should be considered as an
;  experimental neutron scattering data reduction, visualization, and
;  analysis system. As such, the authors assume no responsibility
;  whatsoever for its use, and make no guarantees, expressed or
;  implied, about its quality, reliability, or any other
;  characteristic. The use of certain trade names or commercial
;  products does not imply any endorsement of a particular product,
;  nor does it imply that the named product is necessarily the best
;  product for the stated purpose. We would appreciate acknowledgment
;  if the DAVE software is used of if the code in this file is
;  included in another product.
;
;###############################################################################
pro launch_mslicewithdata, group_leader=group_leader, workDir=workDir, dataDir=dataDir, DAVETool=oDAVETool, _EXTRA=etc

if (~obj_valid(oDAVETool)) then return

; Retrieve selected datasets from Data Manager
DAVEPtrArr = oDaveTool->GetSelectedDataAsDAVEPtr(count=count)
DAVENamesArr = oDaveTool->GetSelectedDataNameTag()

if (count le 0) then begin
  dcs_mslice, datadir=datadir, workdir=workdir, daveTool=oDaveTool, group_leader=group_leader, obj_mslice=oMslice
endif else begin
  oMslice = obj_new()
  for i = 0,count-1 do begin
    davePtr = DAVEPtrArr[i]
    dataName = DAVENamesArr[i]
    
    dim = (size((*(*(*davePtr).dataStrPtr).commonStr.histPtr).qty))[0]
    if (dim eq 1) then begin  ; Mslice requires a minimum of 2 independent vars!
      if (~obj_valid(oMslice)) then $ ; don't launch another empty Mslice window if one already exists
        dcs_mslice, datadir=datadir, workdir=workdir, daveTool=oDaveTool, group_leader=group_leader, obj_mslice=oMslice
    endif else begin
      qty = (*(*(*davePtr).dataStrPtr).commonStr.histPtr).qty
      err = (*(*(*davePtr).dataStrPtr).commonStr.histPtr).err
      y   = (*(*(*davePtr).dataStrPtr).commonStr.histPtr).y
      x   = (*(*(*davePtr).dataStrPtr).commonStr.histPtr).x
      ;inst = (*(*davePtr).dataStrPtr).commonStr.instrument
      xlabel = (*(*davePtr).dataStrPtr).commonStr.xlabel
      xunits = (*(*davePtr).dataStrPtr).commonStr.xunits
      ylabel = (*(*davePtr).dataStrPtr).commonStr.ylabel
      yunits = (*(*davePtr).dataStrPtr).commonStr.yunits
      qtylabel = (*(*davePtr).dataStrPtr).commonStr.histlabel
      qtyunits = (*(*davePtr).dataStrPtr).commonStr.histunits
      xtype = (*(*davePtr).dataStrPtr).commonStr.xtype
      ytype = (*(*davePtr).dataStrPtr).commonStr.ytype
      
      ; if either x or y are histograms then convert to point mode
      if (strcmp(xtype,'HIST',4,/fold)) then begin
        n = n_elements(x)
        x = 0.5*(x[0:n-2]+x[1:n-1])
      endif
      if (strcmp(ytype,'HIST',4,/fold)) then begin
        n = n_elements(y)
        y = 0.5*(y[0:n-2]+y[1:n-1])
      endif
      
      xU = x*0.0 + 1.0
      yU = y*0.0 + 1.0
      x = x#yU
      y = xU#y
      
      n = n_elements(qty)
      data = fltarr(n,4)
      data[*,0] = reform(qty,n)
      data[*,1] = reform(err,n)
      data[*,2] = reform(x,n)
      data[*,3] = reform(y,n)

      labels = [qtylabel,'Error',xlabel, ylabel]
      units = [qtyunits,'',xunits,yunits]
      unique = [0,0]
      unique = strcmp(xlabel,'E',1,/fold_case)? [unique,1] : [unique,0]
      unique = strcmp(ylabel,'E',1,/fold_case)? [unique,1] : [unique,0]
      
      dataPtr = ptr_new({data:temporary(data),label:tex2idl(labels),unit:tex2idl(units),instrument:dataName,is_uniq:unique},/no_copy)
      ;Self->GetProperty, DAVETOOL=daveTool, DATA_DIRECTORY=dataDir, working_directory=workDir
      dcs_mslice, dataPtr=dataPtr, obj_mslice=oMslice, group_leader=group_leader $
        ,DAVETool=oDaveTool, workDir=workDir, dataDir=dataDir, /no_parmfile
    endelse
  endfor
  heap_free, DAVEPtrArr
endelse
  
end