; $Id$
;#######################################################################
;
; NAME:
;  dm_write_phx
;
; PURPOSE:
;  writing a detector profile file(*.phx) named as detfile, this file is used for matlab mslice
;
; CATEGORY:
;  dcs_mslice
;
; AUTHOR:
;  Yiming Qiu
;  NIST Center for Neutron Research
;  100 Bureau Drive, Gaithersburg, MD 20899-6102
;  United States
;  yiming.qiu@nist.gov
;  May, 2015
;
; LICENSE:
;  The software in this file is written by an employee of
;  National Institute of Standards and Technology
;  as part of the DAVE software project.
;
;  The DAVE software package is not subject to copyright protection
;  and is in the public domain. It should be considered as an
;  experimental neutron scattering data reduction, visualization, and
;  analysis system. As such, the authors assume no responsibility
;  whatsoever for its use, and make no guarantees, expressed or
;  implied, about its quality, reliability, or any other
;  characteristic. The use of certain trade names or commercial
;  products does not imply any endorsement of a particular product,
;  nor does it imply that the named product is necessarily the best
;  product for the stated purpose. We would appreciate acknowledgment
;  if the DAVE software is used or if the code in this file is
;  included in another product.
;
;#######################################################################

pro dm_write_phx,detfile,tt,dtt,psi,dpsi
    openw,unit,detfile,/get_lun,error=openerr
    if openerr ne 0 then begin
       ok=dialog_message("Can't write in "+detfile+'.',/error)
       return
    endif
    ndet=n_elements(tt)
    if ndet ge 1e6 then printf,unit,dm_to_string(ndet,/int) $  ;first line, # of detectors
    else printf,unit,ndet,format='(i5)' 
    for i=0L,ndet-1L do $
       printf,unit,10,0,tt[i],psi[i],dtt[i],dpsi[i],i+1,$
        format='((i10)," ",(i10),4(" ",(f10.4))," ",(i10))'
    free_lun,unit
end