; $Id$
;#######################################################################
;
; NAME:
;  dm_basis_hkl
;
; PURPOSE:
;  requires vectors (3,3) ar,br,cr of the reciprocal lattice
;  returns vectors (3,3)  A,B,C such that if Q=h*ar+k*br+l*cr (with h,k,l in rlu)
;  then h=dot(Q,A), k=dot(Q,B), l=dot(Q,C)
;
; CATEGORY:
;  dcs_mslice
;
; AUTHOR:
;  Yiming Qiu
;  NIST Center for Neutron Research
;  100 Bureau Drive, Gaithersburg, MD 20899-8562
;  United States
;  yiming.qiu@nist.gov
;  Feb, 2005
;
; LICENSE:
;  The software in this file is written by an employee of
;  National Institute of Standards and Technology
;  as part of the DAVE software project.
;
;  The DAVE software package is not subject to copyright protection
;  and is in the public domain. It should be considered as an
;  experimental neutron scattering data reduction, visualization, and
;  analysis system. As such, the authors assume no responsibility
;  whatsoever for its use, and make no guarantees, expressed or
;  implied, about its quality, reliability, or any other
;  characteristic. The use of certain trade names or commercial
;  products does not imply any endorsement of a particular product,
;  nor does it imply that the named product is necessarily the best
;  product for the stated purpose. We would appreciate acknowledgment
;  if the DAVE software is used or if the code in this file is
;  included in another product.
;
;#######################################################################

function dm_basis_hkl,abc_r
    ABC    =  fltarr(3,3)
;   old algorithm
;     t=crossp(crossp(abc_r[*,0],abc_r[*,1]),crossp(abc_r[*,2],abc_r[*,1]))
;     ABC[*,0]=crossp(abc_r[*,1],crossp(crossp(abc_r[*,2],abc_r[*,1]),t))/norm(t)^2
;     t=crossp(crossp(abc_r[*,1],abc_r[*,0]),crossp(abc_r[*,2],abc_r[*,0]))
;     ABC[*,1]=crossp(abc_r[*,0],crossp(crossp(abc_r[*,2],abc_r[*,0]),t))/norm(t)^2
;     t=crossp(crossp(abc_r[*,2],abc_r[*,0]),crossp(abc_r[*,1],abc_r[*,0]))
;     ABC[*,2]=crossp(abc_r[*,0],crossp(crossp(abc_r[*,1],abc_r[*,0]),t))/norm(t)^2
;   new one
;     A= bxc/(a.(bxc))
;     B= cxa/(a.(bxc))
;     C= axb/(a.(bxc))
    vol      = transpose(abc_r[*,0]) # crossp(abc_r[*,1],abc_r[*,2])
    ABC[*,0] = crossp(abc_r[*,1],abc_r[*,2])/vol[0]
    ABC[*,1] = crossp(abc_r[*,2],abc_r[*,0])/vol[0]
    ABC[*,2] = crossp(abc_r[*,0],abc_r[*,1])/vol[0]
    return,ABC
end