; $Id$
; Written by J.R.D. Copley.
;************************************************************************************************
;###############################################################################
;
; LICENSE:
;  The software in this file is written by an employee of 
;  National Institute of Standards and Technology 
;  as part of the DAVE software project.
;
;  The DAVE software package is not subject to copyright protection
;  and is in the public domain. It should be considered as an
;  experimental neutron scattering data reduction, visualization, and
;  analysis system. As such, the authors assume no responsibility
;  whatsoever for its use, and make no guarantees, expressed or
;  implied, about its quality, reliability, or any other
;  characteristic. The use of certain trade names or commercial
;  products does not imply any endorsement of a particular product,
;  nor does it imply that the named product is necessarily the best
;  product for the stated purpose. We would appreciate acknowledgment
;  if the DAVE software is used or if the code in this file is
;  included in another product.
;
;###############################################################################
pro dcs_defineDaveStructure,davePtr=davePtr
;************************************************************************************************
;
compile_opt strictarr
;
; Write information into the common part of the data structure.
ntchan = 1024
nhedet = 913
;
free_Ptr,(*(*davePtr).dataStrPtr).commonStr.histPtr
free_Ptr,(*(*davePtr).dataStrPtr).commonStr.treatmentPtr

(*(*davePtr).dataStrPtr).commonStr.instrument = 'DCS'
(*(*davePtr).dataStrPtr).commonStr.histPtr = $
	ptr_new({qty:fltarr(ntchan,nhedet),err:fltarr(ntchan,nhedet),$
	x:fltarr(ntchan),y:fltarr(nhedet)})
(*(*davePtr).dataStrPtr).commonStr.xlabel = 'Time channel number'
(*(*davePtr).dataStrPtr).commonStr.xunits = ''
(*(*davePtr).dataStrPtr).commonStr.xtype = 'points'
(*(*davePtr).dataStrPtr).commonStr.ylabel = 'Detector number'
(*(*davePtr).dataStrPtr).commonStr.yunits = ''
(*(*davePtr).dataStrPtr).commonStr.ytype = 'points'
(*(*davePtr).dataStrPtr).commonStr.histlabel = 'Raw counts'
(*(*davePtr).dataStrPtr).commonStr.histunits = ''
(*(*davePtr).dataStrPtr).commonStr.treatmentPtr = ptr_new("")
;
; Write the instrument-specific information
;
nchop=7
nhigh=18
nvals=500; This is the dimension of the arrays that are added to at the end of each run cycle.
;
; In the 2nd line, DO NOT put parens around "fix(...ge 0". It changes things!
; For example if helpmsg contains "UNDEFINED" fix... is 1, not fix.. is 0, not (fix..) is 254.
; On the other hand both 0 and 254 imply false so perhaps it doesn't really matter!
help,(*(*(*davePtr).dataStrPtr).specificPtr),output=helpmsg
variable_is_defined=not fix(total(float(strpos(helpmsg,"UNDEFINED")))) ge 0
if (variable_is_defined) then begin
	free_Ptr,(*(*(*davePtr).dataStrPtr).specificPtr).time_propsPtr
	free_Ptr,(*(*(*davePtr).dataStrPtr).specificPtr).energy_propsPtr
	free_Ptr,(*(*(*davePtr).dataStrPtr).specificPtr).angle_propsPtr
	free_Ptr,(*(*(*davePtr).dataStrPtr).specificPtr).Q_propsPtr
endif
;
specific = {$
	badbrd:-1.0d,$
	baddet:-1.0d,$
	ch_bid:fltarr(nchop)+1.e4,$
	ch_delay:fltarr(nchop)-1.0d,$
	ch_dis:fltarr(nchop)+1.e4,$
	ch_input:fltarr(6)-1.0d,$
	ch_ms:-1.0d,$
	ch_phase:fltarr(nchop)-1.0d,$
	ch_res:-1,$
	ch_slots:fltarr(nchop,3)-1.0d,$
	ch_srdenom:-1,$
	ch_srmode:-1,$
	ch_wl:-1.0d,$
	coll_amp:-1.0d,$
	coll_mean:-1.0d,$
	coll_osc:-1,$
	command:"xxx",$
	comments:"xxx",$
	datamax:-1.0d,$
	det_dis:+1.d4,$;
	detsum:ulonarr(nhedet+nhigh)-1,$
	duration_csum:fltarr(nvals)-1.0,$; added 5/04
	duration:-1.0d,$
	fc_dis:fltarr(3)+1.e4,$
	grandsum:ulonarr(8)-1,$
	he3_csum:fltarr(nvals)-1.0,$; added 5/04
	high_csum:fltarr(nhigh,nvals)-1.0,$; added 5/04
	highmax:-1.0d,$
	highsource:strarr(nhigh-1)+"xxx",$
	histohigh:ulonarr(ntchan,nhigh)-1,$
	motor_pos:fltarr(8)+1.e4,$
	ncycles:-1,$; added 5/04
	nframes:-1l,$
	repeats:ulonarr(2,32)-1,$
	resets:ulonarr(2,32)-1,$
	runinfo:lonarr(4)-1,$; added 10/31/03
	sample_desc:strarr(10)+"xxx",$
	shutter_stat:-1,$; added 10/31/03
	start_date:"xxx",$
	startchoice:"xxx",$
	stop_date:"xxx",$
	tchanlook:ulonarr(2,ntchan)-1,$
	temp_control:fltarr(nvals)-1.0,$
	temp_sample:fltarr(nvals)-1.0,$
	temp_setpoint:-1.0d,$
	field_setpoint:!values.d_nan,$;added 5/23/16
	field_sample:!values.d_nan,$;added 5/23/16
	timsum:ulonarr(ntchan)-1,$
	totals:ulonarr(2,32)-1,$
	tsdmin:-1.0d,$
	user:"xxx",$; added 10/31/03
  polanal:0,$;  added 5/27/2022 for polarization analysis YQ
	ntchan:ntchan,$
	nhedet:nhedet,$
	ngtchan0:0,$
	ngtchan1:0,$
	now:systime(),$
	normalization_sum:fltarr(nhedet),$
	fbnormalization_sum:fltarr(nhedet),$
	time_propsPtr:ptr_new(/allocate_heap),$
	energy_propsPtr:ptr_new(/allocate_heap),$
	angle_propsPtr:ptr_new(/allocate_heap),$
	Q_propsPtr:ptr_new(/allocate_heap)}

*(*(*davePtr).dataStrPtr).specificPtr = specific
;
end
