; $Id$
;###############################################################################
;+
; FUNCTION:
;   Vartype
;
; PURPOSE:
;   Deterimines the type name of an IDL variable. 
;   Should work with intrinsic types (integer, float, etc) and
;   user-defined types such as structure and class names.
;
; CATEGORY:
;   Miscellaneous
;
; PARAMETERS
;   variable - The variable whose data type is required
;
; KEYWORDS:
;
; RETURN VALUE:
;    If successful, the IDL data type (string)
;
; Richard Tumanjong Azuah
; NIST Center for Neutron Research
; azuah@nist.gov; (301) 9755604
; July 2002
;-
;###############################################################################

function vartype, variable

type = size(variable,/tname)
if (type eq "OBJREF") then begin
    if (obj_valid(variable) eq 1) then begin
        type = obj_class(variable)
    endif else begin
        type = 'OBJARR'
    endelse
endif
if (type eq "STRUCT") then type = tag_names(variable,/structure_name)

return, type

end
