; $Id$
;###############################################################################
;+
; FUNCTION:
;   validateCompactString
;
; PURPOSE:
;   Ensures the input string contains the following characters only:
;   '.',',','-','0','1','2','3','4','5','6','7','8','9'
;
; CATEGORY:
;   Helper function used by the plot3DOptions class
;
; PARAMETERS
;   str - The string to be validated
;
; KEYWORDS:
;
; RETURN VALUE:
;    If successful, a string with all invalid characters removed is returned
;
; Richard Tumanjong Azuah
; NIST Center for Neutron Research
; azuah@nist.gov; (301) 9755604
; May 2009
;-
;###############################################################################
function validateCompactString, str

if (n_elements(str) ne 1) then return, ''

validChar = ['.',',','-','0','1','2','3','4','5','6','7','8','9']

len = strlen(str)
newstr = ''
for i=0,len-1 do begin
   char = strmid(str,i,1)
   void = where(char eq validChar, found)
   if (found) then newStr +=  char
endfor

return, newStr
end
