; Test program that uses the Nexus API (napi) library in DAVE to _read_ an HDF/Nexus file
pro TestRead_napi

compile_opt idl2

errmsg = ''
Catch,the_error
if the_error ne 0 then begin
  Catch,/cancel
  errmsg = !error_state.msg
  !QUIET = 0
  Return
endif

; Retrieve an example file from the auxiliary folder, if it exists or select one
filename = !DAVE_AUXILIARY_DIR+'start.sample.name4.nxs.bt7'
if (~file_test(filename)) then begin
  filename = Dialog_pickfile(title="Select HDF file",multiple_files=0,/must_exist, dialog_parent=0L $
    ,filter="*.nxs.bt7");
  if (filename eq '') then Return
endif

; ensure filename is an hdf5 file before continuing
if (~H5f_is_hdf5(filename)) then begin
  errmsg = filename + " has unexpected format. It is not an HDF5 file!"
  Return
endif

; file handle must be a long integer and must be set before calling Nxopen()
handle=0L
hdlerror=0

; Open the hdf file
; The file handle will subsequently be used just like a file unit
status = Nxopen(filename,'NXACC_READ',handle)
if (~status) then begin
  errmsg = 'Could not open nexus file: '+filename
  Return
endif

; Determine the name of the first main group/entry in the file
; Required because groups are opened by name
nEntry = H5g_get_nmembers(handle.ivid, '/')
if (nEntry lt 1) then begin
  errmsg = filename + " contains no entries"
  Return
endif
entryIndex = 0
group_name = '/'
entryName = H5g_get_member_name(handle.ivid, group_name, entryIndex)

; open the main NXentry group
if (~Nxopengroup(handle,entryName,'NXentry')) then begin
  errmsg = "Cannot open " + entryName
  Return
endif

;===========================================================================
; Let's begin by reading a few entries within the DAS_logs group
; open DAS_logs group
status = Nxopengroup(handle,'DAS_logs','NXcollection')

status = Nxopengroup(handle,'trajectoryData','NXcollection')
status = Nxopendata(handle,'xAxis')
status = Nxgetdata(handle,indepVariableName)
print,' '
Print,'Independent/Scan Variable name: ',indepVariableName
status = Nxclosedata(handle)  ; xAxis
status = Nxopendata(handle,'yAxis')
status = Nxgetdata(handle,depVariableName)
Print,'Dependent/Counter Variable name: ',depVariableName
status = Nxclosedata(handle)  ; yAxis
status = Nxclosegroup(handle)     ; trajectoryData

status = Nxopengroup(handle,'Q','NXcollection')
status = Nxopendata(handle,'mag')
status = Nxgetdata(handle,Qmag)
status = Nxclosedata(handle)
status = Nxopendata(handle,'H')
status = Nxgetdata(handle,QH)
status = Nxclosedata(handle)
status = Nxopendata(handle,'K')
status = Nxgetdata(handle,QK)
status = Nxclosedata(handle)
status = Nxopendata(handle,'L')
status = Nxgetdata(handle,QL)
status = Nxclosedata(handle)
status = Nxclosegroup(handle)     ; Q
print,'Q h k l = ',[Qmag,QH,QK,QL]

status = Nxopengroup(handle,'et','NXcollection')
status = Nxopendata(handle,'deltaE')
status = Nxgetdata(handle,deltaE)
status = Nxclosedata(handle)
status = Nxopendata(handle,'fixedEnergyMode')
status = Nxgetdata(handle,fixedEMode)
status = Nxclosedata(handle)
status = Nxclosegroup(handle)     ; et
print,' '
print,'Energy transfer values: ',deltaE
print,'Fixed Energy mode: ',fixedEMode

status = Nxclosegroup(handle)     ; DAS_logs


;===========================================================================
; Reading data can be very verbose with making calls to Nxopendata(), Nxgetdata() and Nxclosedata() each time
; 
; I wrote a wrapper function called DAVENxOpenGetCloseData() to merge the 3 calls into one - it is not part of 
; napi library but I added it for convenience to open an Nxdata dataset, read its data as well as any number 
; of attributes and then close the dataset

;===========================================================================
; Sample information: lattice parameter, orientation, Quaternion,
status = Nxopengroup(handle,'sample','NXcollection')     ; Open Sample group
status = Davenxopengetclosedata(handle,'unit_cell_a',data=sampA)
status = Davenxopengetclosedata(handle,'unit_cell_b',data=sampB)
status = Davenxopengetclosedata(handle,'unit_cell_c',data=sampC)
status = Davenxopengetclosedata(handle,'unit_cell_alpha',data=sampAlpha)
status = Davenxopengetclosedata(handle,'unit_cell_beta',data=sampBeta)
status = Davenxopengetclosedata(handle,'unit_cell_gamma',data=sampGamma)
lattice = [sampA,sampB,sampC,sampAlpha,sampBeta,sampGamma]
print, ' '
print,'lattice parameters = ',lattice
status = Davenxopengetclosedata(handle,'orientation',data=sampOrientQuaternion)
status = Nxclosegroup(handle)      ; close Sample group


;===========================================================================
; Instrument Group: - monochromator/analyzer/detectors
status = Nxopengroup(handle,'instrument','NXcollection')
status = Nxopengroup(handle,'SD','NXdetector')
status = Davenxopengetclosedata(handle,'data',data=sdData,attrNames='long_name',attrData=sdAttr_label)
print,' '
print,'Single Detector Data: ',sdData
print,'Single Detector attributes: label = ',sdAttr_label
status = Nxclosegroup(handle) ; SD Detector

status = Nxopengroup(handle,'monochromator','NXcollection')
status = Davenxopengetclosedata(handle,'dspacing',data=dspaceM,attrNames='units',attrData=dspaceUnits)
status = Davenxopengetclosedata(handle,'energy',data=Ei,attrNames=['error','units'],attrData=EiAttrs)
status = Davenxopengetclosedata(handle,'material',data=monoMaterial)
status = Davenxopengetclosedata(handle,'rotation_angle',data=mono2theta)
print,' '
print,'Monochrmator:  d-spacing = ',dspaceM
print,'Monochrmator:  units = ',dspaceUnits
print,'Monochrmator:  material = ',monoMaterial
print,'Monochrmator:  angle = ',mono2theta
status = Nxclosegroup(handle) ; monochromator

status = Nxopengroup(handle,'analyzer','NXcollection')
status = Davenxopengetclosedata(handle,'dspacing',data=dspaceA)
status = Davenxopengetclosedata(handle,'energy',data=Ef)
status = Davenxopengetclosedata(handle,'material',data=anaMaterial)
status = Davenxopengetclosedata(handle,'rotation_angle',data=ana2theta)
status = Nxclosegroup(handle) ; analyzer

status = Nxclosegroup(handle) ; instrument


status = Nxclosegroup(handle)     ; NXentry
status = Nxclose(handle)          ; Nexus/hdf file

end


